/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="A request for relationship between two parties.")
@JsonPropertyOrder(value={"requestType", "ownerIdentifier", "introductoryMessage"})
public class UpsertSalesChannelRelationshipRequestRequest {
    public static final String JSON_PROPERTY_REQUEST_TYPE = "requestType";
    private RequestTypeEnum requestType;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    private UUID ownerIdentifier;
    public static final String JSON_PROPERTY_INTRODUCTORY_MESSAGE = "introductoryMessage";
    private String introductoryMessage;

    public UpsertSalesChannelRelationshipRequestRequest requestType(RequestTypeEnum requestType) {
        this.requestType = requestType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="type of relationship request")
    @JsonProperty(value="requestType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RequestTypeEnum getRequestType() {
        return this.requestType;
    }

    @JsonProperty(value="requestType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRequestType(RequestTypeEnum requestType) {
        this.requestType = requestType;
    }

    public UpsertSalesChannelRelationshipRequestRequest ownerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Specific identifier for the company / corporation / travel agency that is retrieving the rates")
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public UpsertSalesChannelRelationshipRequestRequest introductoryMessage(String introductoryMessage) {
        this.introductoryMessage = introductoryMessage;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Hi there! Please give me a discount.", required=true, value="Owner / affiliate writes an intro to request a connection.")
    @JsonProperty(value="introductoryMessage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIntroductoryMessage() {
        return this.introductoryMessage;
    }

    @JsonProperty(value="introductoryMessage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIntroductoryMessage(String introductoryMessage) {
        this.introductoryMessage = introductoryMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertSalesChannelRelationshipRequestRequest upsertSalesChannelRelationshipRequestRequest = (UpsertSalesChannelRelationshipRequestRequest)o;
        return Objects.equals((Object)this.requestType, (Object)upsertSalesChannelRelationshipRequestRequest.requestType) && Objects.equals(this.ownerIdentifier, upsertSalesChannelRelationshipRequestRequest.ownerIdentifier) && Objects.equals(this.introductoryMessage, upsertSalesChannelRelationshipRequestRequest.introductoryMessage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestType, this.ownerIdentifier, this.introductoryMessage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertSalesChannelRelationshipRequestRequest {\n");
        sb.append("    requestType: ").append(this.toIndentedString((Object)this.requestType)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    introductoryMessage: ").append(this.toIndentedString(this.introductoryMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RequestTypeEnum {
        DIRECT_CONNECTION("DIRECT_CONNECTION");

        private String value;

        private RequestTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequestTypeEnum fromValue(String value) {
            for (RequestTypeEnum b : RequestTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

