package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.AddStaticSellerListItemRequest;
import travel.wink.sdk.affiliate.model.BooleanResponse;
import travel.wink.sdk.affiliate.model.CopyMoveStaticSellerListItemRequest;
import travel.wink.sdk.affiliate.model.CreateStaticSellerListAndAddItemRequest;
import travel.wink.sdk.affiliate.model.DynamicSellerListView;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.RemoveEntryResponse;
import travel.wink.sdk.affiliate.model.SellerInventoryList;
import travel.wink.sdk.affiliate.model.SellerInventoryListView;
import travel.wink.sdk.affiliate.model.SellerInventoryRankedList;
import travel.wink.sdk.affiliate.model.SellerInventoryRankedListView;
import travel.wink.sdk.affiliate.model.ShowSellerUrl400Response;
import travel.wink.sdk.affiliate.model.SortStaticSellerListItemsRequest;
import travel.wink.sdk.affiliate.model.StaticSellerList;
import travel.wink.sdk.affiliate.model.StaticSellerListItemView;
import travel.wink.sdk.affiliate.model.StaticSellerListWrapper;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-16T13:26:57.553437+07:00[Asia/Bangkok]")
public class InventoryGridsApi {
    private ApiClient apiClient;

    public InventoryGridsApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryGridsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add Item to List
     * Add some travel inventory to your existing curated list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Add inventory to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param addStaticSellerListItemRequest The addStaticSellerListItemRequest parameter
     * @return StaticSellerListItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec addInventoryToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequest addStaticSellerListItemRequest) throws WebClientResponseException {
        Object postBody = addStaticSellerListItemRequest;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addStaticSellerListItemRequest' is set
        if (addStaticSellerListItemRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'addStaticSellerListItemRequest' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Item to List
     * Add some travel inventory to your existing curated list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Add inventory to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param addStaticSellerListItemRequest The addStaticSellerListItemRequest parameter
     * @return StaticSellerListItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListItemView> addInventoryToCuratedList(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequest addStaticSellerListItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>() {};
        return addInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListItemRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemView>> addInventoryToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequest addStaticSellerListItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>() {};
        return addInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListItemRequest).toEntity(localVarReturnType);
    }
    /**
     * Copy Item to List
     * Copy an existing list item from one list to another.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Copy inventory to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequest The copyMoveStaticSellerListItemRequest parameter
     * @return StaticSellerListItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec copyInventoryToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequest copyMoveStaticSellerListItemRequest) throws WebClientResponseException {
        Object postBody = copyMoveStaticSellerListItemRequest;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'itemIdentifier' is set
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'copyMoveStaticSellerListItemRequest' is set
        if (copyMoveStaticSellerListItemRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticSellerListItemRequest' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Copy Item to List
     * Copy an existing list item from one list to another.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Copy inventory to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequest The copyMoveStaticSellerListItemRequest parameter
     * @return StaticSellerListItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListItemView> copyInventoryToCuratedList(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequest copyMoveStaticSellerListItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>() {};
        return copyInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemView>> copyInventoryToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequest copyMoveStaticSellerListItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>() {};
        return copyInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequest).toEntity(localVarReturnType);
    }
    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create curated list owned by this owner identifier.
     * @param createStaticSellerListAndAddItemRequest The createStaticSellerListAndAddItemRequest parameter
     * @return StaticSellerListWrapper
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createCuratedListRequestCreation(String companyIdentifier, CreateStaticSellerListAndAddItemRequest createStaticSellerListAndAddItemRequest) throws WebClientResponseException {
        Object postBody = createStaticSellerListAndAddItemRequest;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createStaticSellerListAndAddItemRequest' is set
        if (createStaticSellerListAndAddItemRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStaticSellerListAndAddItemRequest' when calling createCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create curated list owned by this owner identifier.
     * @param createStaticSellerListAndAddItemRequest The createStaticSellerListAndAddItemRequest parameter
     * @return StaticSellerListWrapper
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListWrapper> createCuratedList(String companyIdentifier, CreateStaticSellerListAndAddItemRequest createStaticSellerListAndAddItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>() {};
        return createCuratedListRequestCreation(companyIdentifier, createStaticSellerListAndAddItemRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListWrapper>> createCuratedListWithHttpInfo(String companyIdentifier, CreateStaticSellerListAndAddItemRequest createStaticSellerListAndAddItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>() {};
        return createCuratedListRequestCreation(companyIdentifier, createStaticSellerListAndAddItemRequest).toEntity(localVarReturnType);
    }
    /**
     * Create Grid
     * Create a new curated / saved search list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create list owned by this owner identifier.
     * @param sellerInventoryList The sellerInventoryList parameter
     * @return SellerInventoryListView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSellerInventoryListRequestCreation(String companyIdentifier, SellerInventoryList sellerInventoryList) throws WebClientResponseException {
        Object postBody = sellerInventoryList;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerInventoryList' is set
        if (sellerInventoryList == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerInventoryList' when calling createSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Grid
     * Create a new curated / saved search list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create list owned by this owner identifier.
     * @param sellerInventoryList The sellerInventoryList parameter
     * @return SellerInventoryListView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryListView> createSellerInventoryList(String companyIdentifier, SellerInventoryList sellerInventoryList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>() {};
        return createSellerInventoryListRequestCreation(companyIdentifier, sellerInventoryList).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListView>> createSellerInventoryListWithHttpInfo(String companyIdentifier, SellerInventoryList sellerInventoryList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>() {};
        return createSellerInventoryListRequestCreation(companyIdentifier, sellerInventoryList).toEntity(localVarReturnType);
    }
    /**
     * Create Ranked Grid
     * Create a new ranked grid
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create list owned by this owner identifier.
     * @param sellerInventoryRankedList The sellerInventoryRankedList parameter
     * @return SellerInventoryRankedListView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSellerInventoryRankedListRequestCreation(String companyIdentifier, SellerInventoryRankedList sellerInventoryRankedList) throws WebClientResponseException {
        Object postBody = sellerInventoryRankedList;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerInventoryRankedList' is set
        if (sellerInventoryRankedList == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerInventoryRankedList' when calling createSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Ranked Grid
     * Create a new ranked grid
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create list owned by this owner identifier.
     * @param sellerInventoryRankedList The sellerInventoryRankedList parameter
     * @return SellerInventoryRankedListView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryRankedListView> createSellerInventoryRankedList(String companyIdentifier, SellerInventoryRankedList sellerInventoryRankedList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>() {};
        return createSellerInventoryRankedListRequestCreation(companyIdentifier, sellerInventoryRankedList).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRankedListView>> createSellerInventoryRankedListWithHttpInfo(String companyIdentifier, SellerInventoryRankedList sellerInventoryRankedList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>() {};
        return createSellerInventoryRankedListRequestCreation(companyIdentifier, sellerInventoryRankedList).toEntity(localVarReturnType);
    }
    /**
     * Move List Item
     * Move an existing list item from one list to another.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Move inventory to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequest The copyMoveStaticSellerListItemRequest parameter
     * @return StaticSellerListItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec moveInventoryToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequest copyMoveStaticSellerListItemRequest) throws WebClientResponseException {
        Object postBody = copyMoveStaticSellerListItemRequest;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'itemIdentifier' is set
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'copyMoveStaticSellerListItemRequest' is set
        if (copyMoveStaticSellerListItemRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticSellerListItemRequest' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Move List Item
     * Move an existing list item from one list to another.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Move inventory to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequest The copyMoveStaticSellerListItemRequest parameter
     * @return StaticSellerListItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListItemView> moveInventoryToCuratedList(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequest copyMoveStaticSellerListItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>() {};
        return moveInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemView>> moveInventoryToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequest copyMoveStaticSellerListItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>() {};
        return moveInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequest).toEntity(localVarReturnType);
    }
    /**
     * Remove Curated List
     * Remove curated list by list identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Curated List
     * Remove curated list by list identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeCuratedList(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeCuratedListRequestCreation(companyIdentifier, listIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeCuratedListRequestCreation(companyIdentifier, listIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Delete List Item
     * Delete a list item from a curated list by its unique identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove inventory from curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeInventoryFromCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String itemIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'itemIdentifier' is set
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete List Item
     * Delete a list item from a curated list by its unique identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove inventory from curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeInventoryFromCuratedList(String companyIdentifier, String listIdentifier, String itemIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeInventoryFromCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeInventoryFromCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String itemIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeInventoryFromCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Delete Grid
     * Remove a curated / saved search list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Update list owned by this owner identifier.
     * @param listIdentifier Delete curated list with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSellerInventoryListRequestCreation(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/{listIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Grid
     * Remove a curated / saved search list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Update list owned by this owner identifier.
     * @param listIdentifier Delete curated list with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeSellerInventoryList(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeSellerInventoryListWithHttpInfo(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Delete Ranked Grid
     * Delete a ranked grid
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove grid owned by this owner identifier.
     * @param listIdentifier Delete grid with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSellerInventoryRankedListRequestCreation(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/{listIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Ranked Grid
     * Delete a ranked grid
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove grid owned by this owner identifier.
     * @param listIdentifier Delete grid with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeSellerInventoryRankedList(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeSellerInventoryRankedListWithHttpInfo(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Curated Lists
     * Retrieve lists optionally with content.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show curated lists owned by this owner identifier.
     * @param withItems Indicate whether to include all the list items in the result
     * @param accept The accept parameter
     * @return List&lt;StaticSellerListWrapper&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCuratedListsRequestCreation(String companyIdentifier, Boolean withItems, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCuratedLists", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "withItems", withItems));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Curated Lists
     * Retrieve lists optionally with content.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show curated lists owned by this owner identifier.
     * @param withItems Indicate whether to include all the list items in the result
     * @param accept The accept parameter
     * @return List&lt;StaticSellerListWrapper&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<StaticSellerListWrapper> showCuratedLists(String companyIdentifier, Boolean withItems, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>() {};
        return showCuratedListsRequestCreation(companyIdentifier, withItems, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<StaticSellerListWrapper>>> showCuratedListsWithHttpInfo(String companyIdentifier, Boolean withItems, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>() {};
        return showCuratedListsRequestCreation(companyIdentifier, withItems, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Saved Searches
     * Retrieve all saved searches for owner
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List searches owned by this owner identifier.
     * @param accept The accept parameter
     * @return List&lt;DynamicSellerListView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSavedSearchesRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSavedSearches", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<DynamicSellerListView> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/dynamic/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Saved Searches
     * Retrieve all saved searches for owner
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List searches owned by this owner identifier.
     * @param accept The accept parameter
     * @return List&lt;DynamicSellerListView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<DynamicSellerListView> showSavedSearches(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicSellerListView> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListView>() {};
        return showSavedSearchesRequestCreation(companyIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<DynamicSellerListView>>> showSavedSearchesWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicSellerListView> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListView>() {};
        return showSavedSearchesRequestCreation(companyIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Grid
     * Retrieve a specific curated / saved search list.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show seller inventory lists owned by this owner identifier.
     * @param listIdentifier Retrieve list with this identifier.
     * @param accept The accept parameter
     * @return SellerInventoryListView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerInventoryListRequestCreation(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/{listIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Grid
     * Retrieve a specific curated / saved search list.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show seller inventory lists owned by this owner identifier.
     * @param listIdentifier Retrieve list with this identifier.
     * @param accept The accept parameter
     * @return SellerInventoryListView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryListView> showSellerInventoryList(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>() {};
        return showSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListView>> showSellerInventoryListWithHttpInfo(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>() {};
        return showSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Grids
     * Retrieve curated / saved search list lists.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show seller inventory lists owned by this owner identifier.
     * @param accept The accept parameter
     * @return List&lt;SellerInventoryListView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerInventoryListsRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryLists", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Grids
     * Retrieve curated / saved search list lists.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show seller inventory lists owned by this owner identifier.
     * @param accept The accept parameter
     * @return List&lt;SellerInventoryListView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SellerInventoryListView> showSellerInventoryLists(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>() {};
        return showSellerInventoryListsRequestCreation(companyIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellerInventoryListView>>> showSellerInventoryListsWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>() {};
        return showSellerInventoryListsRequestCreation(companyIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Ranked Grid
     * Retrieve a specific ranked grid.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve grid for owner identifier.
     * @param listIdentifier Retrieve grid with this identifier.
     * @param accept The accept parameter
     * @return SellerInventoryRankedListView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerInventoryRankedListRequestCreation(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/{listIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Ranked Grid
     * Retrieve a specific ranked grid.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve grid for owner identifier.
     * @param listIdentifier Retrieve grid with this identifier.
     * @param accept The accept parameter
     * @return SellerInventoryRankedListView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryRankedListView> showSellerInventoryRankedList(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>() {};
        return showSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRankedListView>> showSellerInventoryRankedListWithHttpInfo(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>() {};
        return showSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Ranked Grids
     * Retrieve list of ranked grids.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve list for owner identifier.
     * @param accept The accept parameter
     * @return List&lt;SellerInventoryRankedListView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerInventoryRankedListsRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryRankedLists", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Ranked Grids
     * Retrieve list of ranked grids.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve list for owner identifier.
     * @param accept The accept parameter
     * @return List&lt;SellerInventoryRankedListView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SellerInventoryRankedListView> showSellerInventoryRankedLists(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>() {};
        return showSellerInventoryRankedListsRequestCreation(companyIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellerInventoryRankedListView>>> showSellerInventoryRankedListsWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>() {};
        return showSellerInventoryRankedListsRequestCreation(companyIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Re-Order List Items
     * Re-order list items with an existing list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Sort curated list items owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param sortStaticSellerListItemsRequest The sortStaticSellerListItemsRequest parameter
     * @return BooleanResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec sortCuratedListItemsRequestCreation(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequest sortStaticSellerListItemsRequest) throws WebClientResponseException {
        Object postBody = sortStaticSellerListItemsRequest;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sortStaticSellerListItemsRequest' is set
        if (sortStaticSellerListItemsRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'sortStaticSellerListItemsRequest' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BooleanResponse> localVarReturnType = new ParameterizedTypeReference<BooleanResponse>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/sort", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Re-Order List Items
     * Re-order list items with an existing list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Sort curated list items owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param sortStaticSellerListItemsRequest The sortStaticSellerListItemsRequest parameter
     * @return BooleanResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BooleanResponse> sortCuratedListItems(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequest sortStaticSellerListItemsRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponse> localVarReturnType = new ParameterizedTypeReference<BooleanResponse>() {};
        return sortCuratedListItemsRequestCreation(companyIdentifier, listIdentifier, sortStaticSellerListItemsRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponse>> sortCuratedListItemsWithHttpInfo(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequest sortStaticSellerListItemsRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponse> localVarReturnType = new ParameterizedTypeReference<BooleanResponse>() {};
        return sortCuratedListItemsRequestCreation(companyIdentifier, listIdentifier, sortStaticSellerListItemsRequest).toEntity(localVarReturnType);
    }
    /**
     * Update Curated List
     * Update curated list by its unique identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param staticSellerList The staticSellerList parameter
     * @return StaticSellerListWrapper
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCuratedListRequestCreation(String companyIdentifier, String listIdentifier, StaticSellerList staticSellerList) throws WebClientResponseException {
        Object postBody = staticSellerList;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'staticSellerList' is set
        if (staticSellerList == null) {
            throw new WebClientResponseException("Missing the required parameter 'staticSellerList' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Curated List
     * Update curated list by its unique identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param staticSellerList The staticSellerList parameter
     * @return StaticSellerListWrapper
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListWrapper> updateCuratedList(String companyIdentifier, String listIdentifier, StaticSellerList staticSellerList) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>() {};
        return updateCuratedListRequestCreation(companyIdentifier, listIdentifier, staticSellerList).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListWrapper>> updateCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, StaticSellerList staticSellerList) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>() {};
        return updateCuratedListRequestCreation(companyIdentifier, listIdentifier, staticSellerList).toEntity(localVarReturnType);
    }
    /**
     * Update Grid
     * Update an existing curated / saved search list.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update list owned by this owner identifier.
     * @param listIdentifier Update list with this identifier.
     * @param sellerInventoryList The sellerInventoryList parameter
     * @return SellerInventoryListView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateSellerInventoryListRequestCreation(String companyIdentifier, String listIdentifier, SellerInventoryList sellerInventoryList) throws WebClientResponseException {
        Object postBody = sellerInventoryList;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerInventoryList' is set
        if (sellerInventoryList == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerInventoryList' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/{listIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Grid
     * Update an existing curated / saved search list.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update list owned by this owner identifier.
     * @param listIdentifier Update list with this identifier.
     * @param sellerInventoryList The sellerInventoryList parameter
     * @return SellerInventoryListView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryListView> updateSellerInventoryList(String companyIdentifier, String listIdentifier, SellerInventoryList sellerInventoryList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>() {};
        return updateSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, sellerInventoryList).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListView>> updateSellerInventoryListWithHttpInfo(String companyIdentifier, String listIdentifier, SellerInventoryList sellerInventoryList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>() {};
        return updateSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, sellerInventoryList).toEntity(localVarReturnType);
    }
    /**
     * Update Ranked Grid
     * Update existing ranked grid
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update list owned by this owner identifier.
     * @param listIdentifier Update list with this identifier.
     * @param sellerInventoryRankedList The sellerInventoryRankedList parameter
     * @return SellerInventoryRankedListView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateSellerInventoryRankedListRequestCreation(String companyIdentifier, String listIdentifier, SellerInventoryRankedList sellerInventoryRankedList) throws WebClientResponseException {
        Object postBody = sellerInventoryRankedList;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerInventoryRankedList' is set
        if (sellerInventoryRankedList == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerInventoryRankedList' when calling updateSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/{listIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Ranked Grid
     * Update existing ranked grid
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update list owned by this owner identifier.
     * @param listIdentifier Update list with this identifier.
     * @param sellerInventoryRankedList The sellerInventoryRankedList parameter
     * @return SellerInventoryRankedListView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryRankedListView> updateSellerInventoryRankedList(String companyIdentifier, String listIdentifier, SellerInventoryRankedList sellerInventoryRankedList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>() {};
        return updateSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, sellerInventoryRankedList).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRankedListView>> updateSellerInventoryRankedListWithHttpInfo(String companyIdentifier, String listIdentifier, SellerInventoryRankedList sellerInventoryRankedList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>() {};
        return updateSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, sellerInventoryRankedList).toEntity(localVarReturnType);
    }
}
