package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.Multimedia;
import travel.wink.sdk.affiliate.model.RemoveEntryResponse;
import travel.wink.sdk.affiliate.model.SellerUrl;
import travel.wink.sdk.affiliate.model.SellerUrlView;
import travel.wink.sdk.affiliate.model.ShowSellerUrl400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-16T13:26:57.553437+07:00[Asia/Bangkok]")
public class ShareableLinksApi {
    private ApiClient apiClient;

    public ShareableLinksApi() {
        this(new ApiClient());
    }

    @Autowired
    public ShareableLinksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Link
     * Create a new shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create link owned by this owner identifier.
     * @param sellerUrl The sellerUrl parameter
     * @return SellerUrlView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSellerUrlRequestCreation(String companyIdentifier, SellerUrl sellerUrl) throws WebClientResponseException {
        Object postBody = sellerUrl;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerUrl' is set
        if (sellerUrl == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerUrl' when calling createSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerUrlView> localVarReturnType = new ParameterizedTypeReference<SellerUrlView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/url", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Link
     * Create a new shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create link owned by this owner identifier.
     * @param sellerUrl The sellerUrl parameter
     * @return SellerUrlView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerUrlView> createSellerUrl(String companyIdentifier, SellerUrl sellerUrl) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlView> localVarReturnType = new ParameterizedTypeReference<SellerUrlView>() {};
        return createSellerUrlRequestCreation(companyIdentifier, sellerUrl).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerUrlView>> createSellerUrlWithHttpInfo(String companyIdentifier, SellerUrl sellerUrl) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlView> localVarReturnType = new ParameterizedTypeReference<SellerUrlView>() {};
        return createSellerUrlRequestCreation(companyIdentifier, sellerUrl).toEntity(localVarReturnType);
    }
    /**
     * Delete Link
     * Delete a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove link owned by this owner identifier.
     * @param sellerUrlIdentifier Remove url with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSellerUrlRequestCreation(String companyIdentifier, String sellerUrlIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerUrlIdentifier' is set
        if (sellerUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerUrlIdentifier' when calling removeSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("sellerUrlIdentifier", sellerUrlIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/url/{sellerUrlIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Link
     * Delete a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove link owned by this owner identifier.
     * @param sellerUrlIdentifier Remove url with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeSellerUrl(String companyIdentifier, String sellerUrlIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeSellerUrlWithHttpInfo(String companyIdentifier, String sellerUrlIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Inventory Media
     * Retrieve a list of media for this channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Owner identifier.
     * @param channelInventoryIdentifier Channel inventory identifier.
     * @param accept The accept parameter
     * @return List&lt;Multimedia&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showInventoryMediaRequestCreation(String companyIdentifier, String channelInventoryIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showInventoryMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'channelInventoryIdentifier' is set
        if (channelInventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'channelInventoryIdentifier' when calling showInventoryMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("channelInventoryIdentifier", channelInventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Multimedia> localVarReturnType = new ParameterizedTypeReference<Multimedia>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/url/inventory/{channelInventoryIdentifier}/media/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory Media
     * Retrieve a list of media for this channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Owner identifier.
     * @param channelInventoryIdentifier Channel inventory identifier.
     * @param accept The accept parameter
     * @return List&lt;Multimedia&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Multimedia> showInventoryMedia(String companyIdentifier, String channelInventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Multimedia> localVarReturnType = new ParameterizedTypeReference<Multimedia>() {};
        return showInventoryMediaRequestCreation(companyIdentifier, channelInventoryIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<Multimedia>>> showInventoryMediaWithHttpInfo(String companyIdentifier, String channelInventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Multimedia> localVarReturnType = new ParameterizedTypeReference<Multimedia>() {};
        return showInventoryMediaRequestCreation(companyIdentifier, channelInventoryIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Link
     * Retrieve a specific shareable url for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show link owned by this owner identifier.
     * @param sellerUrlIdentifier Show link with this identifier.
     * @param accept The accept parameter
     * @return SellerUrlView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerUrlRequestCreation(String companyIdentifier, String sellerUrlIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerUrlIdentifier' is set
        if (sellerUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerUrlIdentifier' when calling showSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("sellerUrlIdentifier", sellerUrlIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerUrlView> localVarReturnType = new ParameterizedTypeReference<SellerUrlView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/url/{sellerUrlIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Link
     * Retrieve a specific shareable url for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show link owned by this owner identifier.
     * @param sellerUrlIdentifier Show link with this identifier.
     * @param accept The accept parameter
     * @return SellerUrlView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerUrlView> showSellerUrl(String companyIdentifier, String sellerUrlIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlView> localVarReturnType = new ParameterizedTypeReference<SellerUrlView>() {};
        return showSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerUrlView>> showSellerUrlWithHttpInfo(String companyIdentifier, String sellerUrlIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlView> localVarReturnType = new ParameterizedTypeReference<SellerUrlView>() {};
        return showSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Links
     * Retrieve list of shareable urls for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show links list owned by this owner identifier.
     * @param accept The accept parameter
     * @return List&lt;SellerUrlView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerUrlsRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerUrls", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerUrlView> localVarReturnType = new ParameterizedTypeReference<SellerUrlView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/url/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Links
     * Retrieve list of shareable urls for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show links list owned by this owner identifier.
     * @param accept The accept parameter
     * @return List&lt;SellerUrlView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SellerUrlView> showSellerUrls(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlView> localVarReturnType = new ParameterizedTypeReference<SellerUrlView>() {};
        return showSellerUrlsRequestCreation(companyIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellerUrlView>>> showSellerUrlsWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlView> localVarReturnType = new ParameterizedTypeReference<SellerUrlView>() {};
        return showSellerUrlsRequestCreation(companyIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update link
     * Modify a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update link owned by this owner identifier.
     * @param sellerUrlIdentifier Update url with this identifier.
     * @param sellerUrl The sellerUrl parameter
     * @return SellerUrlView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateSellerUrlRequestCreation(String companyIdentifier, String sellerUrlIdentifier, SellerUrl sellerUrl) throws WebClientResponseException {
        Object postBody = sellerUrl;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerUrlIdentifier' is set
        if (sellerUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerUrlIdentifier' when calling updateSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerUrl' is set
        if (sellerUrl == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerUrl' when calling updateSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("sellerUrlIdentifier", sellerUrlIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerUrlView> localVarReturnType = new ParameterizedTypeReference<SellerUrlView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/url/{sellerUrlIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update link
     * Modify a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update link owned by this owner identifier.
     * @param sellerUrlIdentifier Update url with this identifier.
     * @param sellerUrl The sellerUrl parameter
     * @return SellerUrlView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerUrlView> updateSellerUrl(String companyIdentifier, String sellerUrlIdentifier, SellerUrl sellerUrl) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlView> localVarReturnType = new ParameterizedTypeReference<SellerUrlView>() {};
        return updateSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, sellerUrl).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerUrlView>> updateSellerUrlWithHttpInfo(String companyIdentifier, String sellerUrlIdentifier, SellerUrl sellerUrl) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlView> localVarReturnType = new ParameterizedTypeReference<SellerUrlView>() {};
        return updateSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, sellerUrl).toEntity(localVarReturnType);
    }
}
