/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 21.8.1-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Descriptors used for filtering the result set
 */
@ApiModel(description = "Descriptors used for filtering the result set")
@JsonPropertyOrder({
  CompositeFilterDescriptor.JSON_PROPERTY_FIELD,
  CompositeFilterDescriptor.JSON_PROPERTY_OPERATOR,
  CompositeFilterDescriptor.JSON_PROPERTY_VALUE,
  CompositeFilterDescriptor.JSON_PROPERTY_IGNORE_CASE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-16T13:26:57.553437+07:00[Asia/Bangkok]")
public class CompositeFilterDescriptor {
  public static final String JSON_PROPERTY_FIELD = "field";
  private String field;

  /**
   * Filter operator to use on field
   */
  public enum OperatorEnum {
    NEQ("neq"),
    
    EQ("eq"),
    
    CONTAINS("contains"),
    
    DOESNOTCONTAIN("doesnotcontain"),
    
    ISNULL("isnull"),
    
    ISNOTNULL("isnotnull"),
    
    ISEMPTY("isempty"),
    
    ISNOTEMPTY("isnotempty"),
    
    STARTSWITH("startsWith"),
    
    ENDSWITH("endsWith"),
    
    GTE("gte"),
    
    LTE("lte"),
    
    GT("gt"),
    
    LT("lt");

    private String value;

    OperatorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OperatorEnum fromValue(String value) {
      for (OperatorEnum b : OperatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OPERATOR = "operator";
  private OperatorEnum operator;

  public static final String JSON_PROPERTY_VALUE = "value";
  private Object value;

  public static final String JSON_PROPERTY_IGNORE_CASE = "ignoreCase";
  private Boolean ignoreCase;

  public CompositeFilterDescriptor() { 
  }

  public CompositeFilterDescriptor field(String field) {
    
    this.field = field;
    return this;
  }

   /**
   * Field name to filter on
   * @return field
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "hotel.name", value = "Field name to filter on")
  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getField() {
    return field;
  }


  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setField(String field) {
    this.field = field;
  }


  public CompositeFilterDescriptor operator(OperatorEnum operator) {
    
    this.operator = operator;
    return this;
  }

   /**
   * Filter operator to use on field
   * @return operator
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "startsWith", value = "Filter operator to use on field")
  @JsonProperty(JSON_PROPERTY_OPERATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperatorEnum getOperator() {
    return operator;
  }


  @JsonProperty(JSON_PROPERTY_OPERATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperator(OperatorEnum operator) {
    this.operator = operator;
  }


  public CompositeFilterDescriptor value(Object value) {
    
    this.value = value;
    return this;
  }

   /**
   * Value to filter dataset against
   * @return value
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Happy Res", value = "Value to filter dataset against")
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(Object value) {
    this.value = value;
  }


  public CompositeFilterDescriptor ignoreCase(Boolean ignoreCase) {
    
    this.ignoreCase = ignoreCase;
    return this;
  }

   /**
   * Make filter comparison case insensitive. Default: Case sensitive 
   * @return ignoreCase
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Make filter comparison case insensitive. Default: Case sensitive ")
  @JsonProperty(JSON_PROPERTY_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIgnoreCase() {
    return ignoreCase;
  }


  @JsonProperty(JSON_PROPERTY_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIgnoreCase(Boolean ignoreCase) {
    this.ignoreCase = ignoreCase;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompositeFilterDescriptor compositeFilterDescriptor = (CompositeFilterDescriptor) o;
    return Objects.equals(this.field, compositeFilterDescriptor.field) &&
        Objects.equals(this.operator, compositeFilterDescriptor.operator) &&
        Objects.equals(this.value, compositeFilterDescriptor.value) &&
        Objects.equals(this.ignoreCase, compositeFilterDescriptor.ignoreCase);
  }

  @Override
  public int hashCode() {
    return Objects.hash(field, operator, value, ignoreCase);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompositeFilterDescriptor {\n");
    sb.append("    field: ").append(toIndentedString(field)).append("\n");
    sb.append("    operator: ").append(toIndentedString(operator)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    ignoreCase: ").append(toIndentedString(ignoreCase)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

