/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.Invoice;
import travel.wink.sdk.affiliate.model.InvoiceCollection;
import travel.wink.sdk.affiliate.model.InvoiceLineItemCollection;

public class InvoiceApi {
    private ApiClient apiClient;

    public InvoiceApi() {
        this(new ApiClient());
    }

    @Autowired
    public InvoiceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showInvoicesForCompanyCustomerRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showInvoicesForCompanyCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/marketplace/customer/invoice/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InvoiceCollection> showInvoicesForCompanyCustomer(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>(){};
        return this.showInvoicesForCompanyCustomerRequestCreation(companyIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceCollection>> showInvoicesForCompanyCustomerWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>(){};
        return this.showInvoicesForCompanyCustomerRequestCreation(companyIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showUpcomingInvoiceForCompanyCustomerRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUpcomingInvoiceForCompanyCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Invoice> localVarReturnType = new ParameterizedTypeReference<Invoice>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/marketplace/customer/invoice/upcoming", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Invoice> showUpcomingInvoiceForCompanyCustomer(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Invoice> localVarReturnType = new ParameterizedTypeReference<Invoice>(){};
        return this.showUpcomingInvoiceForCompanyCustomerRequestCreation(companyIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Invoice>> showUpcomingInvoiceForCompanyCustomerWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Invoice> localVarReturnType = new ParameterizedTypeReference<Invoice>(){};
        return this.showUpcomingInvoiceForCompanyCustomerRequestCreation(companyIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showUpcomingInvoiceLineItemsForCompanyCustomerRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUpcomingInvoiceLineItemsForCompanyCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<InvoiceLineItemCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceLineItemCollection>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/marketplace/customer/invoice/upcoming/items", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InvoiceLineItemCollection> showUpcomingInvoiceLineItemsForCompanyCustomer(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceLineItemCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceLineItemCollection>(){};
        return this.showUpcomingInvoiceLineItemsForCompanyCustomerRequestCreation(companyIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceLineItemCollection>> showUpcomingInvoiceLineItemsForCompanyCustomerWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceLineItemCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceLineItemCollection>(){};
        return this.showUpcomingInvoiceLineItemsForCompanyCustomerRequestCreation(companyIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

