/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.affiliate.model.AutoBaseUnitSteps;
import travel.wink.sdk.affiliate.model.AxisLine;
import travel.wink.sdk.affiliate.model.AxisTicks;
import travel.wink.sdk.affiliate.model.CategoryAxisCrosshair;
import travel.wink.sdk.affiliate.model.CategoryAxisNotes;
import travel.wink.sdk.affiliate.model.CategoryAxisSelect;
import travel.wink.sdk.affiliate.model.CategoryAxisTitle;
import travel.wink.sdk.affiliate.model.ChartCategoryAxisLabels;
import travel.wink.sdk.affiliate.model.ChartCategoryAxisMajorGridLines;
import travel.wink.sdk.affiliate.model.GridLines;
import travel.wink.sdk.affiliate.model.PlotBand;

@ApiModel(description="The configuration options of the category axis.")
@JsonPropertyOrder(value={"autoBaseUnitSteps", "axisCrossingValue", "background", "baseUnit", "baseUnitStep", "categories", "color", "justified", "line", "majorGridLines", "majorTicks", "max", "maxDateGroups", "maxDivisions", "min", "minorGridLines", "minorTicks", "name", "pane", "plotBands", "reverse", "roundToBaseUnit", "startAngle", "type", "visible", "weekStartDay", "crosshair", "labels", "notes", "select", "title"})
public class ChartCategoryAxis {
    public static final String JSON_PROPERTY_AUTO_BASE_UNIT_STEPS = "autoBaseUnitSteps";
    private AutoBaseUnitSteps autoBaseUnitSteps;
    public static final String JSON_PROPERTY_AXIS_CROSSING_VALUE = "axisCrossingValue";
    private List<Object> axisCrossingValue = null;
    public static final String JSON_PROPERTY_BACKGROUND = "background";
    private String background;
    public static final String JSON_PROPERTY_BASE_UNIT = "baseUnit";
    private BaseUnitEnum baseUnit;
    public static final String JSON_PROPERTY_BASE_UNIT_STEP = "baseUnitStep";
    private BigDecimal baseUnitStep;
    public static final String JSON_PROPERTY_CATEGORIES = "categories";
    private List<String> categories = null;
    public static final String JSON_PROPERTY_COLOR = "color";
    private String color;
    public static final String JSON_PROPERTY_JUSTIFIED = "justified";
    private Boolean justified;
    public static final String JSON_PROPERTY_LINE = "line";
    private AxisLine line;
    public static final String JSON_PROPERTY_MAJOR_GRID_LINES = "majorGridLines";
    private ChartCategoryAxisMajorGridLines majorGridLines;
    public static final String JSON_PROPERTY_MAJOR_TICKS = "majorTicks";
    private AxisTicks majorTicks;
    public static final String JSON_PROPERTY_MAX = "max";
    private OffsetDateTime max;
    public static final String JSON_PROPERTY_MAX_DATE_GROUPS = "maxDateGroups";
    private BigDecimal maxDateGroups;
    public static final String JSON_PROPERTY_MAX_DIVISIONS = "maxDivisions";
    private BigDecimal maxDivisions;
    public static final String JSON_PROPERTY_MIN = "min";
    private OffsetDateTime min;
    public static final String JSON_PROPERTY_MINOR_GRID_LINES = "minorGridLines";
    private GridLines minorGridLines;
    public static final String JSON_PROPERTY_MINOR_TICKS = "minorTicks";
    private AxisTicks minorTicks;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PANE = "pane";
    private String pane;
    public static final String JSON_PROPERTY_PLOT_BANDS = "plotBands";
    private List<PlotBand> plotBands = null;
    public static final String JSON_PROPERTY_REVERSE = "reverse";
    private Boolean reverse;
    public static final String JSON_PROPERTY_ROUND_TO_BASE_UNIT = "roundToBaseUnit";
    private Boolean roundToBaseUnit;
    public static final String JSON_PROPERTY_START_ANGLE = "startAngle";
    private BigDecimal startAngle;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_VISIBLE = "visible";
    private Boolean visible;
    public static final String JSON_PROPERTY_WEEK_START_DAY = "weekStartDay";
    private WeekStartDayEnum weekStartDay;
    public static final String JSON_PROPERTY_CROSSHAIR = "crosshair";
    private CategoryAxisCrosshair crosshair;
    public static final String JSON_PROPERTY_LABELS = "labels";
    private ChartCategoryAxisLabels labels;
    public static final String JSON_PROPERTY_NOTES = "notes";
    private CategoryAxisNotes notes;
    public static final String JSON_PROPERTY_SELECT = "select";
    private CategoryAxisSelect select;
    public static final String JSON_PROPERTY_TITLE = "title";
    private CategoryAxisTitle title;

    public ChartCategoryAxis autoBaseUnitSteps(AutoBaseUnitSteps autoBaseUnitSteps) {
        this.autoBaseUnitSteps = autoBaseUnitSteps;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="autoBaseUnitSteps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AutoBaseUnitSteps getAutoBaseUnitSteps() {
        return this.autoBaseUnitSteps;
    }

    @JsonProperty(value="autoBaseUnitSteps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoBaseUnitSteps(AutoBaseUnitSteps autoBaseUnitSteps) {
        this.autoBaseUnitSteps = autoBaseUnitSteps;
    }

    public ChartCategoryAxis axisCrossingValue(List<Object> axisCrossingValue) {
        this.axisCrossingValue = axisCrossingValue;
        return this;
    }

    public ChartCategoryAxis addAxisCrossingValueItem(Object axisCrossingValueItem) {
        if (this.axisCrossingValue == null) {
            this.axisCrossingValue = new ArrayList<Object>();
        }
        this.axisCrossingValue.add(axisCrossingValueItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The category index or the date (for date category axis) at which the first value axis crosses this axis. The category indices or the date (for date category axis) at which the value axes cross the category axis (when set as an array). To denote the far end of the axis, set an index greater than or equal to the Number of categories.")
    @JsonProperty(value="axisCrossingValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getAxisCrossingValue() {
        return this.axisCrossingValue;
    }

    @JsonProperty(value="axisCrossingValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAxisCrossingValue(List<Object> axisCrossingValue) {
        this.axisCrossingValue = axisCrossingValue;
    }

    public ChartCategoryAxis background(String background) {
        this.background = background;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The background color of the axis.")
    @JsonProperty(value="background")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBackground() {
        return this.background;
    }

    @JsonProperty(value="background")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBackground(String background) {
        this.background = background;
    }

    public ChartCategoryAxis baseUnit(BaseUnitEnum baseUnit) {
        this.baseUnit = baseUnit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The base time interval for the date axis. The default base unit is automatically determined by the minimum difference between subsequent categories. The supported values are:   - `fit` - `milliseconds` - `seconds` - `minutes` - `hours` - `days` - `weeks` - `months` - `years` Setting `baseUnit` to `fit` sets such a base unit and `categoryAxis.baseUnitStep` that the total Number of categories does not exceed `categoryAxis.maxDateGroups`. Series data is aggregated for the specified base unit by using the `series.aggregate` function.")
    @JsonProperty(value="baseUnit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BaseUnitEnum getBaseUnit() {
        return this.baseUnit;
    }

    @JsonProperty(value="baseUnit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBaseUnit(BaseUnitEnum baseUnit) {
        this.baseUnit = baseUnit;
    }

    public ChartCategoryAxis baseUnitStep(BigDecimal baseUnitStep) {
        this.baseUnitStep = baseUnitStep;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The step (interval) between the categories in base units. Setting it to `auto` sets the step to such a value that the total Number of categories does not exceed `categoryAxis.maxDateGroups`. The option is ignored if `categoryAxis.baseUnit` is set to `fit`.")
    @JsonProperty(value="baseUnitStep")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getBaseUnitStep() {
        return this.baseUnitStep;
    }

    @JsonProperty(value="baseUnitStep")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBaseUnitStep(BigDecimal baseUnitStep) {
        this.baseUnitStep = baseUnitStep;
    }

    public ChartCategoryAxis categories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    public ChartCategoryAxis addCategoriesItem(String categoriesItem) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        this.categories.add(categoriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The category names. The Chart creates a category for every item of the array.")
    @JsonProperty(value="categories")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCategories() {
        return this.categories;
    }

    @JsonProperty(value="categories")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public ChartCategoryAxis color(String color) {
        this.color = color;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The color to apply to all axis elements. Accepts a valid CSS color String, including hex and rgb. Can be overridden by `categoryAxis.labels.color` and `categoryAxis.line.color`.")
    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColor(String color) {
        this.color = color;
    }

    public ChartCategoryAxis justified(Boolean justified) {
        this.justified = justified;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, the Chart positions categories and series points on major ticks. This removes the empty space before and after the series. The default value is `false` except for `area`, `verticalArea`, `rangeArea`, and `verticalRangeArea`. The option is ignored if the `series.type` option is set to `bar`, `column`, `boxPlot`, `ohlc`, `candlestick`, or `waterfall`.")
    @JsonProperty(value="justified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getJustified() {
        return this.justified;
    }

    @JsonProperty(value="justified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJustified(Boolean justified) {
        this.justified = justified;
    }

    public ChartCategoryAxis line(AxisLine line) {
        this.line = line;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="line")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AxisLine getLine() {
        return this.line;
    }

    @JsonProperty(value="line")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLine(AxisLine line) {
        this.line = line;
    }

    public ChartCategoryAxis majorGridLines(ChartCategoryAxisMajorGridLines majorGridLines) {
        this.majorGridLines = majorGridLines;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="majorGridLines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChartCategoryAxisMajorGridLines getMajorGridLines() {
        return this.majorGridLines;
    }

    @JsonProperty(value="majorGridLines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMajorGridLines(ChartCategoryAxisMajorGridLines majorGridLines) {
        this.majorGridLines = majorGridLines;
    }

    public ChartCategoryAxis majorTicks(AxisTicks majorTicks) {
        this.majorTicks = majorTicks;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="majorTicks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AxisTicks getMajorTicks() {
        return this.majorTicks;
    }

    @JsonProperty(value="majorTicks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMajorTicks(AxisTicks majorTicks) {
        this.majorTicks = majorTicks;
    }

    public ChartCategoryAxis max(OffsetDateTime max) {
        this.max = max;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The last date displayed on a date category axis or the index of the last category displayed on a category axis. By default, the max value is the same as the last category. This is often used in combination with the `categoryAxis.min` and `categoryAxis.roundToBaseUnit` options to set up a fixed date range.")
    @JsonProperty(value="max")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getMax() {
        return this.max;
    }

    @JsonProperty(value="max")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMax(OffsetDateTime max) {
        this.max = max;
    }

    public ChartCategoryAxis maxDateGroups(BigDecimal maxDateGroups) {
        this.maxDateGroups = maxDateGroups;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The maximum Number of groups (categories) to display when `categoryAxis.baseUnit` is set to `fit` or `categoryAxis.baseUnitStep` is set to `auto`.")
    @JsonProperty(value="maxDateGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getMaxDateGroups() {
        return this.maxDateGroups;
    }

    @JsonProperty(value="maxDateGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxDateGroups(BigDecimal maxDateGroups) {
        this.maxDateGroups = maxDateGroups;
    }

    public ChartCategoryAxis maxDivisions(BigDecimal maxDivisions) {
        this.maxDivisions = maxDivisions;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The maximum Number of ticks and labels to display. Applicabable for date category axis.")
    @JsonProperty(value="maxDivisions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getMaxDivisions() {
        return this.maxDivisions;
    }

    @JsonProperty(value="maxDivisions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxDivisions(BigDecimal maxDivisions) {
        this.maxDivisions = maxDivisions;
    }

    public ChartCategoryAxis min(OffsetDateTime min) {
        this.min = min;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The first date which is displayed on a date category axis or the index of the first category whcih is displayed on a category axis. By default, the min value is the same as the first category. This is often used in combination with the `categoryAxis.max` and `categoryAxis.roundToBaseUnit` options to set up a fixed date range.")
    @JsonProperty(value="min")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getMin() {
        return this.min;
    }

    @JsonProperty(value="min")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMin(OffsetDateTime min) {
        this.min = min;
    }

    public ChartCategoryAxis minorGridLines(GridLines minorGridLines) {
        this.minorGridLines = minorGridLines;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="minorGridLines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GridLines getMinorGridLines() {
        return this.minorGridLines;
    }

    @JsonProperty(value="minorGridLines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinorGridLines(GridLines minorGridLines) {
        this.minorGridLines = minorGridLines;
    }

    public ChartCategoryAxis minorTicks(AxisTicks minorTicks) {
        this.minorTicks = minorTicks;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="minorTicks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AxisTicks getMinorTicks() {
        return this.minorTicks;
    }

    @JsonProperty(value="minorTicks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinorTicks(AxisTicks minorTicks) {
        this.minorTicks = minorTicks;
    }

    public ChartCategoryAxis name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique axis name. Used to associate a series with a category axis, which utilizes the `series.categoryAxis` option.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ChartCategoryAxis pane(String pane) {
        this.pane = pane;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the pane in which the category axis has to be rendered. If not set, the axis will be rendered in the first (default) pane.")
    @JsonProperty(value="pane")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPane() {
        return this.pane;
    }

    @JsonProperty(value="pane")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPane(String pane) {
        this.pane = pane;
    }

    public ChartCategoryAxis plotBands(List<PlotBand> plotBands) {
        this.plotBands = plotBands;
        return this;
    }

    public ChartCategoryAxis addPlotBandsItem(PlotBand plotBandsItem) {
        if (this.plotBands == null) {
            this.plotBands = new ArrayList<PlotBand>();
        }
        this.plotBands.add(plotBandsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The plot bands of the category axis.")
    @JsonProperty(value="plotBands")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PlotBand> getPlotBands() {
        return this.plotBands;
    }

    @JsonProperty(value="plotBands")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlotBands(List<PlotBand> plotBands) {
        this.plotBands = plotBands;
    }

    public ChartCategoryAxis reverse(Boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, the category axis direction is reversed. By default, categories are listed from left to right and from bottom to top.")
    @JsonProperty(value="reverse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReverse() {
        return this.reverse;
    }

    @JsonProperty(value="reverse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReverse(Boolean reverse) {
        this.reverse = reverse;
    }

    public ChartCategoryAxis roundToBaseUnit(Boolean roundToBaseUnit) {
        this.roundToBaseUnit = roundToBaseUnit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, the Chart rounds the first and last date to the nearest base unit.")
    @JsonProperty(value="roundToBaseUnit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRoundToBaseUnit() {
        return this.roundToBaseUnit;
    }

    @JsonProperty(value="roundToBaseUnit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoundToBaseUnit(Boolean roundToBaseUnit) {
        this.roundToBaseUnit = roundToBaseUnit;
    }

    public ChartCategoryAxis startAngle(BigDecimal startAngle) {
        this.startAngle = startAngle;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The angle (degrees) of the first category on the axis. Angles increase clockwise with zero to the left. Negative values are acceptable.")
    @JsonProperty(value="startAngle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getStartAngle() {
        return this.startAngle;
    }

    @JsonProperty(value="startAngle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartAngle(BigDecimal startAngle) {
        this.startAngle = startAngle;
    }

    public ChartCategoryAxis type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The category axis type. The supported values are:  - `category` Discrete category axis.- `date`  Specialized axis for displaying chronological data.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ChartCategoryAxis visible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, the Chart displays the category axis. By default, the category axis is visible.")
    @JsonProperty(value="visible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getVisible() {
        return this.visible;
    }

    @JsonProperty(value="visible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public ChartCategoryAxis weekStartDay(WeekStartDayEnum weekStartDay) {
        this.weekStartDay = weekStartDay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The week start day when the `baseUnit` is set to `weeks`.")
    @JsonProperty(value="weekStartDay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WeekStartDayEnum getWeekStartDay() {
        return this.weekStartDay;
    }

    @JsonProperty(value="weekStartDay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWeekStartDay(WeekStartDayEnum weekStartDay) {
        this.weekStartDay = weekStartDay;
    }

    public ChartCategoryAxis crosshair(CategoryAxisCrosshair crosshair) {
        this.crosshair = crosshair;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="crosshair")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryAxisCrosshair getCrosshair() {
        return this.crosshair;
    }

    @JsonProperty(value="crosshair")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCrosshair(CategoryAxisCrosshair crosshair) {
        this.crosshair = crosshair;
    }

    public ChartCategoryAxis labels(ChartCategoryAxisLabels labels) {
        this.labels = labels;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChartCategoryAxisLabels getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabels(ChartCategoryAxisLabels labels) {
        this.labels = labels;
    }

    public ChartCategoryAxis notes(CategoryAxisNotes notes) {
        this.notes = notes;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="notes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryAxisNotes getNotes() {
        return this.notes;
    }

    @JsonProperty(value="notes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotes(CategoryAxisNotes notes) {
        this.notes = notes;
    }

    public ChartCategoryAxis select(CategoryAxisSelect select) {
        this.select = select;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="select")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryAxisSelect getSelect() {
        return this.select;
    }

    @JsonProperty(value="select")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelect(CategoryAxisSelect select) {
        this.select = select;
    }

    public ChartCategoryAxis title(CategoryAxisTitle title) {
        this.title = title;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryAxisTitle getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(CategoryAxisTitle title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChartCategoryAxis chartCategoryAxis = (ChartCategoryAxis)o;
        return Objects.equals(this.autoBaseUnitSteps, chartCategoryAxis.autoBaseUnitSteps) && Objects.equals(this.axisCrossingValue, chartCategoryAxis.axisCrossingValue) && Objects.equals(this.background, chartCategoryAxis.background) && Objects.equals((Object)this.baseUnit, (Object)chartCategoryAxis.baseUnit) && Objects.equals(this.baseUnitStep, chartCategoryAxis.baseUnitStep) && Objects.equals(this.categories, chartCategoryAxis.categories) && Objects.equals(this.color, chartCategoryAxis.color) && Objects.equals(this.justified, chartCategoryAxis.justified) && Objects.equals(this.line, chartCategoryAxis.line) && Objects.equals(this.majorGridLines, chartCategoryAxis.majorGridLines) && Objects.equals(this.majorTicks, chartCategoryAxis.majorTicks) && Objects.equals(this.max, chartCategoryAxis.max) && Objects.equals(this.maxDateGroups, chartCategoryAxis.maxDateGroups) && Objects.equals(this.maxDivisions, chartCategoryAxis.maxDivisions) && Objects.equals(this.min, chartCategoryAxis.min) && Objects.equals(this.minorGridLines, chartCategoryAxis.minorGridLines) && Objects.equals(this.minorTicks, chartCategoryAxis.minorTicks) && Objects.equals(this.name, chartCategoryAxis.name) && Objects.equals(this.pane, chartCategoryAxis.pane) && Objects.equals(this.plotBands, chartCategoryAxis.plotBands) && Objects.equals(this.reverse, chartCategoryAxis.reverse) && Objects.equals(this.roundToBaseUnit, chartCategoryAxis.roundToBaseUnit) && Objects.equals(this.startAngle, chartCategoryAxis.startAngle) && Objects.equals((Object)this.type, (Object)chartCategoryAxis.type) && Objects.equals(this.visible, chartCategoryAxis.visible) && Objects.equals((Object)this.weekStartDay, (Object)chartCategoryAxis.weekStartDay) && Objects.equals(this.crosshair, chartCategoryAxis.crosshair) && Objects.equals(this.labels, chartCategoryAxis.labels) && Objects.equals(this.notes, chartCategoryAxis.notes) && Objects.equals(this.select, chartCategoryAxis.select) && Objects.equals(this.title, chartCategoryAxis.title);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoBaseUnitSteps, this.axisCrossingValue, this.background, this.baseUnit, this.baseUnitStep, this.categories, this.color, this.justified, this.line, this.majorGridLines, this.majorTicks, this.max, this.maxDateGroups, this.maxDivisions, this.min, this.minorGridLines, this.minorTicks, this.name, this.pane, this.plotBands, this.reverse, this.roundToBaseUnit, this.startAngle, this.type, this.visible, this.weekStartDay, this.crosshair, this.labels, this.notes, this.select, this.title});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChartCategoryAxis {\n");
        sb.append("    autoBaseUnitSteps: ").append(this.toIndentedString(this.autoBaseUnitSteps)).append("\n");
        sb.append("    axisCrossingValue: ").append(this.toIndentedString(this.axisCrossingValue)).append("\n");
        sb.append("    background: ").append(this.toIndentedString(this.background)).append("\n");
        sb.append("    baseUnit: ").append(this.toIndentedString((Object)this.baseUnit)).append("\n");
        sb.append("    baseUnitStep: ").append(this.toIndentedString(this.baseUnitStep)).append("\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    justified: ").append(this.toIndentedString(this.justified)).append("\n");
        sb.append("    line: ").append(this.toIndentedString(this.line)).append("\n");
        sb.append("    majorGridLines: ").append(this.toIndentedString(this.majorGridLines)).append("\n");
        sb.append("    majorTicks: ").append(this.toIndentedString(this.majorTicks)).append("\n");
        sb.append("    max: ").append(this.toIndentedString(this.max)).append("\n");
        sb.append("    maxDateGroups: ").append(this.toIndentedString(this.maxDateGroups)).append("\n");
        sb.append("    maxDivisions: ").append(this.toIndentedString(this.maxDivisions)).append("\n");
        sb.append("    min: ").append(this.toIndentedString(this.min)).append("\n");
        sb.append("    minorGridLines: ").append(this.toIndentedString(this.minorGridLines)).append("\n");
        sb.append("    minorTicks: ").append(this.toIndentedString(this.minorTicks)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    pane: ").append(this.toIndentedString(this.pane)).append("\n");
        sb.append("    plotBands: ").append(this.toIndentedString(this.plotBands)).append("\n");
        sb.append("    reverse: ").append(this.toIndentedString(this.reverse)).append("\n");
        sb.append("    roundToBaseUnit: ").append(this.toIndentedString(this.roundToBaseUnit)).append("\n");
        sb.append("    startAngle: ").append(this.toIndentedString(this.startAngle)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    visible: ").append(this.toIndentedString(this.visible)).append("\n");
        sb.append("    weekStartDay: ").append(this.toIndentedString((Object)this.weekStartDay)).append("\n");
        sb.append("    crosshair: ").append(this.toIndentedString(this.crosshair)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    select: ").append(this.toIndentedString(this.select)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum BaseUnitEnum {
        MILLISECONDS("milliseconds"),
        SECONDS("seconds"),
        MINUTES("minutes"),
        HOURS("hours"),
        DAYS("days"),
        WEEKS("weeks"),
        MONTHS("months"),
        YEARS("years"),
        AUTO("auto"),
        FIT("fit");

        private String value;

        private BaseUnitEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BaseUnitEnum fromValue(String value) {
            for (BaseUnitEnum b : BaseUnitEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        CATEGORY("category"),
        DATE("date");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum WeekStartDayEnum {
        SUNDAY("Sunday"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday");

        private String value;

        private WeekStartDayEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static WeekStartDayEnum fromValue(String value) {
            for (WeekStartDayEnum b : WeekStartDayEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

