/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.affiliate.model.ChartCategoryAxis;
import travel.wink.sdk.affiliate.model.ChartLegend;
import travel.wink.sdk.affiliate.model.ChartSeries;
import travel.wink.sdk.affiliate.model.ChartSeriesDefaults;
import travel.wink.sdk.affiliate.model.ChartTitle;
import travel.wink.sdk.affiliate.model.ChartTooltip;
import travel.wink.sdk.affiliate.model.ChartValueAxis;

@JsonPropertyOrder(value={"identifier", "title", "legend", "seriesDefaults", "series", "valueAxis", "categoryAxis", "tooltip", "renderAs", "transitions"})
public class LineChart {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_TITLE = "title";
    private ChartTitle title;
    public static final String JSON_PROPERTY_LEGEND = "legend";
    private ChartLegend legend;
    public static final String JSON_PROPERTY_SERIES_DEFAULTS = "seriesDefaults";
    private ChartSeriesDefaults seriesDefaults;
    public static final String JSON_PROPERTY_SERIES = "series";
    private List<ChartSeries> series = null;
    public static final String JSON_PROPERTY_VALUE_AXIS = "valueAxis";
    private ChartValueAxis valueAxis;
    public static final String JSON_PROPERTY_CATEGORY_AXIS = "categoryAxis";
    private ChartCategoryAxis categoryAxis;
    public static final String JSON_PROPERTY_TOOLTIP = "tooltip";
    private ChartTooltip tooltip;
    public static final String JSON_PROPERTY_RENDER_AS = "renderAs";
    private String renderAs;
    public static final String JSON_PROPERTY_TRANSITIONS = "transitions";
    private Boolean transitions;

    public LineChart identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique line chart identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public LineChart title(ChartTitle title) {
        this.title = title;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChartTitle getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(ChartTitle title) {
        this.title = title;
    }

    public LineChart legend(ChartLegend legend) {
        this.legend = legend;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="legend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChartLegend getLegend() {
        return this.legend;
    }

    @JsonProperty(value="legend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegend(ChartLegend legend) {
        this.legend = legend;
    }

    public LineChart seriesDefaults(ChartSeriesDefaults seriesDefaults) {
        this.seriesDefaults = seriesDefaults;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="seriesDefaults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChartSeriesDefaults getSeriesDefaults() {
        return this.seriesDefaults;
    }

    @JsonProperty(value="seriesDefaults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSeriesDefaults(ChartSeriesDefaults seriesDefaults) {
        this.seriesDefaults = seriesDefaults;
    }

    public LineChart series(List<ChartSeries> series) {
        this.series = series;
        return this;
    }

    public LineChart addSeriesItem(ChartSeries seriesItem) {
        if (this.series == null) {
            this.series = new ArrayList<ChartSeries>();
        }
        this.series.add(seriesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The configuration of the chart series. The series type is determined by the value of the type field. If a type value is missing, the chart renders the type that is specified in `seriesDefaults`. Some options accept functions as arguments. These arguments are evaluated for each point which is supplied as a parameter. If no value is returned, the chart uses the `theme` or `seriesDefaults` values.")
    @JsonProperty(value="series")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ChartSeries> getSeries() {
        return this.series;
    }

    @JsonProperty(value="series")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSeries(List<ChartSeries> series) {
        this.series = series;
    }

    public LineChart valueAxis(ChartValueAxis valueAxis) {
        this.valueAxis = valueAxis;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="valueAxis")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChartValueAxis getValueAxis() {
        return this.valueAxis;
    }

    @JsonProperty(value="valueAxis")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValueAxis(ChartValueAxis valueAxis) {
        this.valueAxis = valueAxis;
    }

    public LineChart categoryAxis(ChartCategoryAxis categoryAxis) {
        this.categoryAxis = categoryAxis;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="categoryAxis")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChartCategoryAxis getCategoryAxis() {
        return this.categoryAxis;
    }

    @JsonProperty(value="categoryAxis")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategoryAxis(ChartCategoryAxis categoryAxis) {
        this.categoryAxis = categoryAxis;
    }

    public LineChart tooltip(ChartTooltip tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="tooltip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChartTooltip getTooltip() {
        return this.tooltip;
    }

    @JsonProperty(value="tooltip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTooltip(ChartTooltip tooltip) {
        this.tooltip = tooltip;
    }

    public LineChart renderAs(String renderAs) {
        this.renderAs = renderAs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sets the preferred rendering engine. If not supported by the browser, the Chart switches to the first available mode.  The supported values are:  - svg (If available, renders the component as an inline .svg file.)- canvas (If available, renders the component as a canvas element.)")
    @JsonProperty(value="renderAs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRenderAs() {
        return this.renderAs;
    }

    @JsonProperty(value="renderAs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRenderAs(String renderAs) {
        this.renderAs = renderAs;
    }

    public LineChart transitions(Boolean transitions) {
        this.transitions = transitions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, the Chart plays animations when it displays the series. By default, animations are enabled.")
    @JsonProperty(value="transitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTransitions() {
        return this.transitions;
    }

    @JsonProperty(value="transitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransitions(Boolean transitions) {
        this.transitions = transitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineChart lineChart = (LineChart)o;
        return Objects.equals(this.identifier, lineChart.identifier) && Objects.equals(this.title, lineChart.title) && Objects.equals(this.legend, lineChart.legend) && Objects.equals(this.seriesDefaults, lineChart.seriesDefaults) && Objects.equals(this.series, lineChart.series) && Objects.equals(this.valueAxis, lineChart.valueAxis) && Objects.equals(this.categoryAxis, lineChart.categoryAxis) && Objects.equals(this.tooltip, lineChart.tooltip) && Objects.equals(this.renderAs, lineChart.renderAs) && Objects.equals(this.transitions, lineChart.transitions);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.title, this.legend, this.seriesDefaults, this.series, this.valueAxis, this.categoryAxis, this.tooltip, this.renderAs, this.transitions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LineChart {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    legend: ").append(this.toIndentedString(this.legend)).append("\n");
        sb.append("    seriesDefaults: ").append(this.toIndentedString(this.seriesDefaults)).append("\n");
        sb.append("    series: ").append(this.toIndentedString(this.series)).append("\n");
        sb.append("    valueAxis: ").append(this.toIndentedString(this.valueAxis)).append("\n");
        sb.append("    categoryAxis: ").append(this.toIndentedString(this.categoryAxis)).append("\n");
        sb.append("    tooltip: ").append(this.toIndentedString(this.tooltip)).append("\n");
        sb.append("    renderAs: ").append(this.toIndentedString(this.renderAs)).append("\n");
        sb.append("    transitions: ").append(this.toIndentedString(this.transitions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

