/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [TripPay Acquiring](/payment-acquiring): All APIs related to how our Web Components work. - [TripPay](/payment): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 21.14.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import travel.wink.sdk.affiliate.model.Moneys;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * In case of LODGING, include daily rates
 */
@ApiModel(description = "In case of LODGING, include daily rates")
@JsonPropertyOrder({
  DailyRate.JSON_PROPERTY_DATE,
  DailyRate.JSON_PROPERTY_PRICE,
  DailyRate.JSON_PROPERTY_DISPLAY_PRICE,
  DailyRate.JSON_PROPERTY_SUPPLIER_PRICE,
  DailyRate.JSON_PROPERTY_INTERNAL_PRICE,
  DailyRate.JSON_PROPERTY_CAPTURE_PRICE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-06T15:30:11.123803+07:00[Asia/Bangkok]")
public class DailyRate {
  public static final String JSON_PROPERTY_DATE = "date";
  private OffsetDateTime date;

  public static final String JSON_PROPERTY_PRICE = "price";
  private Moneys price;

  public static final String JSON_PROPERTY_DISPLAY_PRICE = "displayPrice";
  private Moneys displayPrice;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE = "supplierPrice";
  private Moneys supplierPrice;

  public static final String JSON_PROPERTY_INTERNAL_PRICE = "internalPrice";
  private Moneys internalPrice;

  public static final String JSON_PROPERTY_CAPTURE_PRICE = "capturePrice";
  private Moneys capturePrice;

  public DailyRate() { 
  }

  public DailyRate date(OffsetDateTime date) {
    
    this.date = date;
    return this;
  }

   /**
   * The date this rate is applicable for.
   * @return date
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The date this rate is applicable for.")
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDate(OffsetDateTime date) {
    this.date = date;
  }


  public DailyRate price(Moneys price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(Moneys price) {
    this.price = price;
  }


  public DailyRate displayPrice(Moneys displayPrice) {
    
    this.displayPrice = displayPrice;
    return this;
  }

   /**
   * Get displayPrice
   * @return displayPrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getDisplayPrice() {
    return displayPrice;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayPrice(Moneys displayPrice) {
    this.displayPrice = displayPrice;
  }


  public DailyRate supplierPrice(Moneys supplierPrice) {
    
    this.supplierPrice = supplierPrice;
    return this;
  }

   /**
   * Get supplierPrice
   * @return supplierPrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getSupplierPrice() {
    return supplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierPrice(Moneys supplierPrice) {
    this.supplierPrice = supplierPrice;
  }


  public DailyRate internalPrice(Moneys internalPrice) {
    
    this.internalPrice = internalPrice;
    return this;
  }

   /**
   * Get internalPrice
   * @return internalPrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getInternalPrice() {
    return internalPrice;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalPrice(Moneys internalPrice) {
    this.internalPrice = internalPrice;
  }


  public DailyRate capturePrice(Moneys capturePrice) {
    
    this.capturePrice = capturePrice;
    return this;
  }

   /**
   * Get capturePrice
   * @return capturePrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getCapturePrice() {
    return capturePrice;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCapturePrice(Moneys capturePrice) {
    this.capturePrice = capturePrice;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DailyRate dailyRate = (DailyRate) o;
    return Objects.equals(this.date, dailyRate.date) &&
        Objects.equals(this.price, dailyRate.price) &&
        Objects.equals(this.displayPrice, dailyRate.displayPrice) &&
        Objects.equals(this.supplierPrice, dailyRate.supplierPrice) &&
        Objects.equals(this.internalPrice, dailyRate.internalPrice) &&
        Objects.equals(this.capturePrice, dailyRate.capturePrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(date, price, displayPrice, supplierPrice, internalPrice, capturePrice);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DailyRate {\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    displayPrice: ").append(toIndentedString(displayPrice)).append("\n");
    sb.append("    supplierPrice: ").append(toIndentedString(supplierPrice)).append("\n");
    sb.append("    internalPrice: ").append(toIndentedString(internalPrice)).append("\n");
    sb.append("    capturePrice: ").append(toIndentedString(capturePrice)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

