/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [TripPay Acquiring](/payment-acquiring): All APIs related to how our Web Components work. - [TripPay](/payment): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 21.14.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.EngineConfigurationTheme;
import travel.wink.sdk.affiliate.model.Multimedia;
import travel.wink.sdk.affiliate.model.RoomConfiguration;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Which engine configuration record did the entity application used to facilitate in making this booking happen.
 */
@ApiModel(description = "Which engine configuration record did the entity application used to facilitate in making this booking happen.")
@JsonPropertyOrder({
  EngineConfigurationBookingReport.JSON_PROPERTY_IDENTIFIER,
  EngineConfigurationBookingReport.JSON_PROPERTY_NAME,
  EngineConfigurationBookingReport.JSON_PROPERTY_OWNER_IDENTIFIER,
  EngineConfigurationBookingReport.JSON_PROPERTY_OWNER_NAME,
  EngineConfigurationBookingReport.JSON_PROPERTY_SUB_TYPE,
  EngineConfigurationBookingReport.JSON_PROPERTY_DEFAULT_CURRENCY,
  EngineConfigurationBookingReport.JSON_PROPERTY_DEFAULT_LANGUAGE,
  EngineConfigurationBookingReport.JSON_PROPERTY_LOGOS,
  EngineConfigurationBookingReport.JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL,
  EngineConfigurationBookingReport.JSON_PROPERTY_SELF_HOSTED,
  EngineConfigurationBookingReport.JSON_PROPERTY_THEME_COLORS,
  EngineConfigurationBookingReport.JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS,
  EngineConfigurationBookingReport.JSON_PROPERTY_NUMBER_OF_STAY_DAYS,
  EngineConfigurationBookingReport.JSON_PROPERTY_START_DATE,
  EngineConfigurationBookingReport.JSON_PROPERTY_END_DATE,
  EngineConfigurationBookingReport.JSON_PROPERTY_ROOM_CONFIGURATIONS,
  EngineConfigurationBookingReport.JSON_PROPERTY_USE_DAYS,
  EngineConfigurationBookingReport.JSON_PROPERTY_PROMOTIONAL_CODES,
  EngineConfigurationBookingReport.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY,
  EngineConfigurationBookingReport.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER,
  EngineConfigurationBookingReport.JSON_PROPERTY_WC_BOOK_CLICK_ACTION
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-06T15:30:11.123803+07:00[Asia/Bangkok]")
public class EngineConfigurationBookingReport {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  /**
   * Sales channel sub-type.
   */
  public enum SubTypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION");

    private String value;

    SubTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SubTypeEnum fromValue(String value) {
      for (SubTypeEnum b : SubTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUB_TYPE = "subType";
  private SubTypeEnum subType;

  public static final String JSON_PROPERTY_DEFAULT_CURRENCY = "defaultCurrency";
  private String defaultCurrency = "USD";

  public static final String JSON_PROPERTY_DEFAULT_LANGUAGE = "defaultLanguage";
  private String defaultLanguage = "en";

  public static final String JSON_PROPERTY_LOGOS = "logos";
  private List<Multimedia> logos = null;

  public static final String JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL = "hostedBookingEngineUrl";
  private String hostedBookingEngineUrl = "https://ota.wink.travel";

  public static final String JSON_PROPERTY_SELF_HOSTED = "selfHosted";
  private Boolean selfHosted = false;

  public static final String JSON_PROPERTY_THEME_COLORS = "themeColors";
  private EngineConfigurationTheme themeColors;

  public static final String JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS = "numberOfAdvanceDays";
  private Integer numberOfAdvanceDays;

  public static final String JSON_PROPERTY_NUMBER_OF_STAY_DAYS = "numberOfStayDays";
  private Integer numberOfStayDays;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_ROOM_CONFIGURATIONS = "roomConfigurations";
  private List<RoomConfiguration> roomConfigurations = null;

  public static final String JSON_PROPERTY_USE_DAYS = "useDays";
  private Boolean useDays;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes = null;

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY = "sendBookingNotificationEmailsToProperty";
  private Boolean sendBookingNotificationEmailsToProperty = true;

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER = "sendBookingNotificationEmailsToBooker";
  private Boolean sendBookingNotificationEmailsToBooker = true;

  /**
   * Action to complete once a user clicks on the CTA button on inventory.
   */
  public enum WcBookClickActionEnum {
    FORWARD_TO_IBE("FORWARD_TO_IBE"),
    
    IBE_MODAL("IBE_MODAL");

    private String value;

    WcBookClickActionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static WcBookClickActionEnum fromValue(String value) {
      for (WcBookClickActionEnum b : WcBookClickActionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_WC_BOOK_CLICK_ACTION = "wcBookClickAction";
  private WcBookClickActionEnum wcBookClickAction;

  public EngineConfigurationBookingReport() { 
  }

  public EngineConfigurationBookingReport identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique engine configuration identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Unique engine configuration identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public EngineConfigurationBookingReport name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Engine configuration name
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Engine Configuration 1", required = true, value = "Engine configuration name")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public EngineConfigurationBookingReport ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * Engine configuration record creator identifier
   * @return ownerIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Engine configuration record creator identifier")
  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public EngineConfigurationBookingReport ownerName(String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

   /**
   * Name of company owner.
   * @return ownerName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Travel Tech 1", value = "Name of company owner.")
  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public EngineConfigurationBookingReport subType(SubTypeEnum subType) {
    
    this.subType = subType;
    return this;
  }

   /**
   * Sales channel sub-type.
   * @return subType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "APPLICATION", value = "Sales channel sub-type.")
  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubTypeEnum getSubType() {
    return subType;
  }


  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubType(SubTypeEnum subType) {
    this.subType = subType;
  }


  public EngineConfigurationBookingReport defaultCurrency(String defaultCurrency) {
    
    this.defaultCurrency = defaultCurrency;
    return this;
  }

   /**
   * Control which currency your users see prices in initially.
   * @return defaultCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "USD", value = "Control which currency your users see prices in initially.")
  @JsonProperty(JSON_PROPERTY_DEFAULT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultCurrency() {
    return defaultCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultCurrency(String defaultCurrency) {
    this.defaultCurrency = defaultCurrency;
  }


  public EngineConfigurationBookingReport defaultLanguage(String defaultLanguage) {
    
    this.defaultLanguage = defaultLanguage;
    return this;
  }

   /**
   * Control which language your users see text in initially.
   * @return defaultLanguage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "en", value = "Control which language your users see text in initially.")
  @JsonProperty(JSON_PROPERTY_DEFAULT_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultLanguage() {
    return defaultLanguage;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultLanguage(String defaultLanguage) {
    this.defaultLanguage = defaultLanguage;
  }


  public EngineConfigurationBookingReport logos(List<Multimedia> logos) {
    
    this.logos = logos;
    return this;
  }

  public EngineConfigurationBookingReport addLogosItem(Multimedia logosItem) {
    if (this.logos == null) {
      this.logos = new ArrayList<>();
    }
    this.logos.add(logosItem);
    return this;
  }

   /**
   * Customize booking confirmation emails by adding a custom logo to your configuration.
   * @return logos
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Customize booking confirmation emails by adding a custom logo to your configuration.")
  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Multimedia> getLogos() {
    return logos;
  }


  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogos(List<Multimedia> logos) {
    this.logos = logos;
  }


  public EngineConfigurationBookingReport hostedBookingEngineUrl(String hostedBookingEngineUrl) {
    
    this.hostedBookingEngineUrl = hostedBookingEngineUrl;
    return this;
  }

   /**
   * If you are self-hosting our booking engine, let us know where it is hosted. Note: This url needs to be secured with SSL.
   * @return hostedBookingEngineUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "https://my.customtravelsite.com/book", value = "If you are self-hosting our booking engine, let us know where it is hosted. Note: This url needs to be secured with SSL.")
  @JsonProperty(JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHostedBookingEngineUrl() {
    return hostedBookingEngineUrl;
  }


  @JsonProperty(JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHostedBookingEngineUrl(String hostedBookingEngineUrl) {
    this.hostedBookingEngineUrl = hostedBookingEngineUrl;
  }


  public EngineConfigurationBookingReport selfHosted(Boolean selfHosted) {
    
    this.selfHosted = selfHosted;
    return this;
  }

   /**
   * Flag to indicate you are self-hosting our booking engine and not using our default booking engine url.
   * @return selfHosted
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate you are self-hosting our booking engine and not using our default booking engine url.")
  @JsonProperty(JSON_PROPERTY_SELF_HOSTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSelfHosted() {
    return selfHosted;
  }


  @JsonProperty(JSON_PROPERTY_SELF_HOSTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelfHosted(Boolean selfHosted) {
    this.selfHosted = selfHosted;
  }


  public EngineConfigurationBookingReport themeColors(EngineConfigurationTheme themeColors) {
    
    this.themeColors = themeColors;
    return this;
  }

   /**
   * Get themeColors
   * @return themeColors
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_THEME_COLORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EngineConfigurationTheme getThemeColors() {
    return themeColors;
  }


  @JsonProperty(JSON_PROPERTY_THEME_COLORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThemeColors(EngineConfigurationTheme themeColors) {
    this.themeColors = themeColors;
  }


  public EngineConfigurationBookingReport numberOfAdvanceDays(Integer numberOfAdvanceDays) {
    
    this.numberOfAdvanceDays = numberOfAdvanceDays;
    return this;
  }

   /**
   * You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long and how many days in advance (this field), of today&#39;s date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don&#39;t use either of these options, the itinerary will default to today&#39;s date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave &#x60;startDate&#x60; and &#x60;endDate&#x60; empty.
   * @return numberOfAdvanceDays
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10", value = "You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long and how many days in advance (this field), of today's date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don't use either of these options, the itinerary will default to today's date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave `startDate` and `endDate` empty.")
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfAdvanceDays() {
    return numberOfAdvanceDays;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfAdvanceDays(Integer numberOfAdvanceDays) {
    this.numberOfAdvanceDays = numberOfAdvanceDays;
  }


  public EngineConfigurationBookingReport numberOfStayDays(Integer numberOfStayDays) {
    
    this.numberOfStayDays = numberOfStayDays;
    return this;
  }

   /**
   * You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long (this field) and how many days in advance, of today&#39;s date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don&#39;t use either of these options, the itinerary will default to today&#39;s date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave &#x60;startDate&#x60; and &#x60;endDate&#x60; empty.
   * @return numberOfStayDays
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2", value = "You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long (this field) and how many days in advance, of today's date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don't use either of these options, the itinerary will default to today's date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave `startDate` and `endDate` empty.")
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_STAY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfStayDays() {
    return numberOfStayDays;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_STAY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfStayDays(Integer numberOfStayDays) {
    this.numberOfStayDays = numberOfStayDays;
  }


  public EngineConfigurationBookingReport startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Set a fixed itinerary start date. ONLY populate this field if you want to fix the itinerary date. Also, leave &#x60;numberOfAdvanceDays&#x60; and &#x60;numberOfStayDays&#x60; empty.
   * @return startDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "Fri Dec 24 07:00:00 ICT 2021", value = "Set a fixed itinerary start date. ONLY populate this field if you want to fix the itinerary date. Also, leave `numberOfAdvanceDays` and `numberOfStayDays` empty.")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public EngineConfigurationBookingReport endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Set a fixed itinerary end date ONLY populate this field if you want to fix the itinerary date. Also, leave &#x60;numberOfAdvanceDays&#x60; and &#x60;numberOfStayDays&#x60; empty.
   * @return endDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "Fri Dec 31 07:00:00 ICT 2021", value = "Set a fixed itinerary end date ONLY populate this field if you want to fix the itinerary date. Also, leave `numberOfAdvanceDays` and `numberOfStayDays` empty.")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public EngineConfigurationBookingReport roomConfigurations(List<RoomConfiguration> roomConfigurations) {
    
    this.roomConfigurations = roomConfigurations;
    return this;
  }

  public EngineConfigurationBookingReport addRoomConfigurationsItem(RoomConfiguration roomConfigurationsItem) {
    if (this.roomConfigurations == null) {
      this.roomConfigurations = new ArrayList<>();
    }
    this.roomConfigurations.add(roomConfigurationsItem);
    return this;
  }

   /**
   * Control how many adults / children will be staying and how many rooms. Defaults to: One room, two adults.
   * @return roomConfigurations
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Control how many adults / children will be staying and how many rooms. Defaults to: One room, two adults.")
  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RoomConfiguration> getRoomConfigurations() {
    return roomConfigurations;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomConfigurations(List<RoomConfiguration> roomConfigurations) {
    this.roomConfigurations = roomConfigurations;
  }


  public EngineConfigurationBookingReport useDays(Boolean useDays) {
    
    this.useDays = useDays;
    return this;
  }

   /**
   * if true, we use numberOfAdvanceDays / numberOfStayDays properties - false, we use startDate / endDate
   * @return useDays
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "if true, we use numberOfAdvanceDays / numberOfStayDays properties - false, we use startDate / endDate")
  @JsonProperty(JSON_PROPERTY_USE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseDays() {
    return useDays;
  }


  @JsonProperty(JSON_PROPERTY_USE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseDays(Boolean useDays) {
    this.useDays = useDays;
  }


  public EngineConfigurationBookingReport promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public EngineConfigurationBookingReport addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * If you&#39;ve received special promotional codes from suppliers to give to your audience, you can choose to bake these code directly into the price by entering them here.
   * @return promotionalCodes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"promo-1\"]", value = "If you've received special promotional codes from suppliers to give to your audience, you can choose to bake these code directly into the price by entering them here.")
  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public EngineConfigurationBookingReport sendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
    
    this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
    return this;
  }

   /**
   * An integrator can choose to disable outgoing emails to properties because they want to do that themselves.
   * @return sendBookingNotificationEmailsToProperty
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "An integrator can choose to disable outgoing emails to properties because they want to do that themselves.")
  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToProperty() {
    return sendBookingNotificationEmailsToProperty;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
    this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
  }


  public EngineConfigurationBookingReport sendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
    
    this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
    return this;
  }

   /**
   * An integrator can choose to disable outgoing emails to users because they want to do that themselves.
   * @return sendBookingNotificationEmailsToBooker
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "An integrator can choose to disable outgoing emails to users because they want to do that themselves.")
  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToBooker() {
    return sendBookingNotificationEmailsToBooker;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
    this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
  }


  public EngineConfigurationBookingReport wcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
    
    this.wcBookClickAction = wcBookClickAction;
    return this;
  }

   /**
   * Action to complete once a user clicks on the CTA button on inventory.
   * @return wcBookClickAction
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "IBE_MODAL", value = "Action to complete once a user clicks on the CTA button on inventory.")
  @JsonProperty(JSON_PROPERTY_WC_BOOK_CLICK_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WcBookClickActionEnum getWcBookClickAction() {
    return wcBookClickAction;
  }


  @JsonProperty(JSON_PROPERTY_WC_BOOK_CLICK_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
    this.wcBookClickAction = wcBookClickAction;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EngineConfigurationBookingReport engineConfigurationBookingReport = (EngineConfigurationBookingReport) o;
    return Objects.equals(this.identifier, engineConfigurationBookingReport.identifier) &&
        Objects.equals(this.name, engineConfigurationBookingReport.name) &&
        Objects.equals(this.ownerIdentifier, engineConfigurationBookingReport.ownerIdentifier) &&
        Objects.equals(this.ownerName, engineConfigurationBookingReport.ownerName) &&
        Objects.equals(this.subType, engineConfigurationBookingReport.subType) &&
        Objects.equals(this.defaultCurrency, engineConfigurationBookingReport.defaultCurrency) &&
        Objects.equals(this.defaultLanguage, engineConfigurationBookingReport.defaultLanguage) &&
        Objects.equals(this.logos, engineConfigurationBookingReport.logos) &&
        Objects.equals(this.hostedBookingEngineUrl, engineConfigurationBookingReport.hostedBookingEngineUrl) &&
        Objects.equals(this.selfHosted, engineConfigurationBookingReport.selfHosted) &&
        Objects.equals(this.themeColors, engineConfigurationBookingReport.themeColors) &&
        Objects.equals(this.numberOfAdvanceDays, engineConfigurationBookingReport.numberOfAdvanceDays) &&
        Objects.equals(this.numberOfStayDays, engineConfigurationBookingReport.numberOfStayDays) &&
        Objects.equals(this.startDate, engineConfigurationBookingReport.startDate) &&
        Objects.equals(this.endDate, engineConfigurationBookingReport.endDate) &&
        Objects.equals(this.roomConfigurations, engineConfigurationBookingReport.roomConfigurations) &&
        Objects.equals(this.useDays, engineConfigurationBookingReport.useDays) &&
        Objects.equals(this.promotionalCodes, engineConfigurationBookingReport.promotionalCodes) &&
        Objects.equals(this.sendBookingNotificationEmailsToProperty, engineConfigurationBookingReport.sendBookingNotificationEmailsToProperty) &&
        Objects.equals(this.sendBookingNotificationEmailsToBooker, engineConfigurationBookingReport.sendBookingNotificationEmailsToBooker) &&
        Objects.equals(this.wcBookClickAction, engineConfigurationBookingReport.wcBookClickAction);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, name, ownerIdentifier, ownerName, subType, defaultCurrency, defaultLanguage, logos, hostedBookingEngineUrl, selfHosted, themeColors, numberOfAdvanceDays, numberOfStayDays, startDate, endDate, roomConfigurations, useDays, promotionalCodes, sendBookingNotificationEmailsToProperty, sendBookingNotificationEmailsToBooker, wcBookClickAction);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EngineConfigurationBookingReport {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    subType: ").append(toIndentedString(subType)).append("\n");
    sb.append("    defaultCurrency: ").append(toIndentedString(defaultCurrency)).append("\n");
    sb.append("    defaultLanguage: ").append(toIndentedString(defaultLanguage)).append("\n");
    sb.append("    logos: ").append(toIndentedString(logos)).append("\n");
    sb.append("    hostedBookingEngineUrl: ").append(toIndentedString(hostedBookingEngineUrl)).append("\n");
    sb.append("    selfHosted: ").append(toIndentedString(selfHosted)).append("\n");
    sb.append("    themeColors: ").append(toIndentedString(themeColors)).append("\n");
    sb.append("    numberOfAdvanceDays: ").append(toIndentedString(numberOfAdvanceDays)).append("\n");
    sb.append("    numberOfStayDays: ").append(toIndentedString(numberOfStayDays)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    roomConfigurations: ").append(toIndentedString(roomConfigurations)).append("\n");
    sb.append("    useDays: ").append(toIndentedString(useDays)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    sendBookingNotificationEmailsToProperty: ").append(toIndentedString(sendBookingNotificationEmailsToProperty)).append("\n");
    sb.append("    sendBookingNotificationEmailsToBooker: ").append(toIndentedString(sendBookingNotificationEmailsToBooker)).append("\n");
    sb.append("    wcBookClickAction: ").append(toIndentedString(wcBookClickAction)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

