/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [TripPay Acquiring](/payment-acquiring): All APIs related to how our Web Components work. - [TripPay](/payment): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 21.14.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.SimpleDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SellerInventoryItem
 */
@JsonPropertyOrder({
  SellerInventoryItem.JSON_PROPERTY_IDENTIFIER,
  SellerInventoryItem.JSON_PROPERTY_SELLER_IDENTIFIER,
  SellerInventoryItem.JSON_PROPERTY_SELLER_INVENTORY_ITEM_NAME,
  SellerInventoryItem.JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER,
  SellerInventoryItem.JSON_PROPERTY_DESCRIPTIONS,
  SellerInventoryItem.JSON_PROPERTY_KEYWORDS,
  SellerInventoryItem.JSON_PROPERTY_STATUS,
  SellerInventoryItem.JSON_PROPERTY_INVENTORY_TYPE,
  SellerInventoryItem.JSON_PROPERTY_CHANNEL_INVENTORY_TYPE,
  SellerInventoryItem.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  SellerInventoryItem.JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER,
  SellerInventoryItem.JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS,
  SellerInventoryItem.JSON_PROPERTY_ANIMATE,
  SellerInventoryItem.JSON_PROPERTY_ANIMATE_DELAY,
  SellerInventoryItem.JSON_PROPERTY_SORT,
  SellerInventoryItem.JSON_PROPERTY_DISPLAY_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-06T15:30:11.123803+07:00[Asia/Bangkok]")
public class SellerInventoryItem {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_SELLER_IDENTIFIER = "sellerIdentifier";
  private UUID sellerIdentifier;

  public static final String JSON_PROPERTY_SELLER_INVENTORY_ITEM_NAME = "sellerInventoryItemName";
  private String sellerInventoryItemName;

  public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
  private UUID engineConfigurationIdentifier;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescription> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_KEYWORDS = "keywords";
  private List<String> keywords = new ArrayList<>();

  /**
   * Availability status
   */
  public enum StatusEnum {
    ACTIVE("ACTIVE"),
    
    INACTIVE("INACTIVE"),
    
    REMOVED("REMOVED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status = StatusEnum.ACTIVE;

  /**
   * The type of inventory being offer up for sale
   */
  public enum InventoryTypeEnum {
    HOTEL("HOTEL"),
    
    GUEST_ROOM("GUEST_ROOM"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    PACKAGE("PACKAGE"),
    
    ADD_ON("ADD_ON"),
    
    ATTRACTION("ATTRACTION"),
    
    ACTIVITY("ACTIVITY"),
    
    PLACE("PLACE");

    private String value;

    InventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryTypeEnum fromValue(String value) {
      for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
  private InventoryTypeEnum inventoryType;

  /**
   * Channel inventory type is a subset of inventory type in that it does not include the &#x60;HOTEL&#x60; type. THe way it works is, as a seller you might want to sell a guest room but instead of showing the price of that guest room, you would like to display the best room type price for the property.
   */
  public enum ChannelInventoryTypeEnum {
    GUEST_ROOM("GUEST_ROOM"),
    
    PACKAGE("PACKAGE"),
    
    ADD_ON("ADD_ON"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE"),
    
    ACTIVITY("ACTIVITY");

    private String value;

    ChannelInventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChannelInventoryTypeEnum fromValue(String value) {
      for (ChannelInventoryTypeEnum b : ChannelInventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_TYPE = "channelInventoryType";
  private ChannelInventoryTypeEnum channelInventoryType;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
  private UUID channelInventoryIdentifier;

  public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS = "multimediaIdentifiers";
  private List<String> multimediaIdentifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_ANIMATE = "animate";
  private Boolean animate = false;

  public static final String JSON_PROPERTY_ANIMATE_DELAY = "animateDelay";
  private Integer animateDelay;

  /**
   * The specific badge to display over the image on the Web Component.
   */
  public enum SortEnum {
    MEMBER("MEMBER"),
    
    PRICE_LOW_TO_HIGH("PRICE_LOW_TO_HIGH"),
    
    PRICE_HIGH_TO_LOW("PRICE_HIGH_TO_LOW"),
    
    PRICE("PRICE"),
    
    POPULARITY("POPULARITY"),
    
    ECO("ECO"),
    
    EXPERIENCE("EXPERIENCE"),
    
    PERK("PERK"),
    
    LOYALTY("LOYALTY"),
    
    PACKAGE("PACKAGE");

    private String value;

    SortEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SortEnum fromValue(String value) {
      for (SortEnum b : SortEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SORT = "sort";
  private SortEnum sort;

  /**
   * Indicate which initial values to display first on the front-facing card
   */
  public enum DisplayTypeEnum {
    NATIVE("NATIVE"),
    
    HOTEL("HOTEL"),
    
    ROOM("ROOM");

    private String value;

    DisplayTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DisplayTypeEnum fromValue(String value) {
      for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DISPLAY_TYPE = "displayType";
  private DisplayTypeEnum displayType = DisplayTypeEnum.NATIVE;

  public SellerInventoryItem() { 
  }

  public SellerInventoryItem identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Unique identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public SellerInventoryItem sellerIdentifier(UUID sellerIdentifier) {
    
    this.sellerIdentifier = sellerIdentifier;
    return this;
  }

   /**
   * Company / Owner identifier
   * @return sellerIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Company / Owner identifier")
  @JsonProperty(JSON_PROPERTY_SELLER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getSellerIdentifier() {
    return sellerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SELLER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellerIdentifier(UUID sellerIdentifier) {
    this.sellerIdentifier = sellerIdentifier;
  }


  public SellerInventoryItem sellerInventoryItemName(String sellerInventoryItemName) {
    
    this.sellerInventoryItemName = sellerInventoryItemName;
    return this;
  }

   /**
   * Descriptive name of this item for seller use
   * @return sellerInventoryItemName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "My fave travel inventory", required = true, value = "Descriptive name of this item for seller use")
  @JsonProperty(JSON_PROPERTY_SELLER_INVENTORY_ITEM_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSellerInventoryItemName() {
    return sellerInventoryItemName;
  }


  @JsonProperty(JSON_PROPERTY_SELLER_INVENTORY_ITEM_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSellerInventoryItemName(String sellerInventoryItemName) {
    this.sellerInventoryItemName = sellerInventoryItemName;
  }


  public SellerInventoryItem engineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    return this;
  }

   /**
   * Which configuration to use with this item
   * @return engineConfigurationIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Which configuration to use with this item")
  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getEngineConfigurationIdentifier() {
    return engineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEngineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
  }


  public SellerInventoryItem descriptions(List<SimpleDescription> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public SellerInventoryItem addDescriptionsItem(SimpleDescription descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Title and description of inventory.
   * @return descriptions
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)  @ApiModelProperty(required = true, value = "Title and description of inventory.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescription> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescription> descriptions) {
    this.descriptions = descriptions;
  }


  public SellerInventoryItem keywords(List<String> keywords) {
    
    this.keywords = keywords;
    return this;
  }

  public SellerInventoryItem addKeywordsItem(String keywordsItem) {
    this.keywords.add(keywordsItem);
    return this;
  }

   /**
   * Keywords
   * @return keywords
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Size(min=1,max=2147483647)  @ApiModelProperty(example = "[\"keyword-1\",\"keyword-2\"]", required = true, value = "Keywords")
  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getKeywords() {
    return keywords;
  }


  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setKeywords(List<String> keywords) {
    this.keywords = keywords;
  }


  public SellerInventoryItem status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Availability status
   * @return status
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "ACTIVE", required = true, value = "Availability status")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public SellerInventoryItem inventoryType(InventoryTypeEnum inventoryType) {
    
    this.inventoryType = inventoryType;
    return this;
  }

   /**
   * The type of inventory being offer up for sale
   * @return inventoryType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "HOTEL", required = true, value = "The type of inventory being offer up for sale")
  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InventoryTypeEnum getInventoryType() {
    return inventoryType;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryType(InventoryTypeEnum inventoryType) {
    this.inventoryType = inventoryType;
  }


  public SellerInventoryItem channelInventoryType(ChannelInventoryTypeEnum channelInventoryType) {
    
    this.channelInventoryType = channelInventoryType;
    return this;
  }

   /**
   * Channel inventory type is a subset of inventory type in that it does not include the &#x60;HOTEL&#x60; type. THe way it works is, as a seller you might want to sell a guest room but instead of showing the price of that guest room, you would like to display the best room type price for the property.
   * @return channelInventoryType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "GUEST_ROOM", required = true, value = "Channel inventory type is a subset of inventory type in that it does not include the `HOTEL` type. THe way it works is, as a seller you might want to sell a guest room but instead of showing the price of that guest room, you would like to display the best room type price for the property.")
  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ChannelInventoryTypeEnum getChannelInventoryType() {
    return channelInventoryType;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannelInventoryType(ChannelInventoryTypeEnum channelInventoryType) {
    this.channelInventoryType = channelInventoryType;
  }


  public SellerInventoryItem supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Supplier / Hotel identifier that owns this inventory.
   * @return supplierIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Supplier / Hotel identifier that owns this inventory.")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public SellerInventoryItem channelInventoryIdentifier(UUID channelInventoryIdentifier) {
    
    this.channelInventoryIdentifier = channelInventoryIdentifier;
    return this;
  }

   /**
   * The channel inventory record identifier describing the relationship between supplier and seller.
   * @return channelInventoryIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The channel inventory record identifier describing the relationship between supplier and seller.")
  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getChannelInventoryIdentifier() {
    return channelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannelInventoryIdentifier(UUID channelInventoryIdentifier) {
    this.channelInventoryIdentifier = channelInventoryIdentifier;
  }


  public SellerInventoryItem multimediaIdentifiers(List<String> multimediaIdentifiers) {
    
    this.multimediaIdentifiers = multimediaIdentifiers;
    return this;
  }

  public SellerInventoryItem addMultimediaIdentifiersItem(String multimediaIdentifiersItem) {
    this.multimediaIdentifiers.add(multimediaIdentifiersItem);
    return this;
  }

   /**
   * Reference identifiers to Cloudinary media assets
   * @return multimediaIdentifiers
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Size(min=1,max=2147483647)  @ApiModelProperty(example = "[\"cloudinary-image-1\",\"cloudinary-image-2\"]", required = true, value = "Reference identifiers to Cloudinary media assets")
  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getMultimediaIdentifiers() {
    return multimediaIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimediaIdentifiers(List<String> multimediaIdentifiers) {
    this.multimediaIdentifiers = multimediaIdentifiers;
  }


  public SellerInventoryItem animate(Boolean animate) {
    
    this.animate = animate;
    return this;
  }

   /**
   * Create an animated gif instead of a list of images. Feature currently not available. Feel free to enable and it will become available at a later date.
   * @return animate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Create an animated gif instead of a list of images. Feature currently not available. Feel free to enable and it will become available at a later date.")
  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAnimate() {
    return animate;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimate(Boolean animate) {
    this.animate = animate;
  }


  public SellerInventoryItem animateDelay(Integer animateDelay) {
    
    this.animateDelay = animateDelay;
    return this;
  }

   /**
   * Controls animation delay in milliseconds.
   * @return animateDelay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "500", value = "Controls animation delay in milliseconds.")
  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAnimateDelay() {
    return animateDelay;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimateDelay(Integer animateDelay) {
    this.animateDelay = animateDelay;
  }


  public SellerInventoryItem sort(SortEnum sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * The specific badge to display over the image on the Web Component.
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "POPULARITY", value = "The specific badge to display over the image on the Web Component.")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SortEnum getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(SortEnum sort) {
    this.sort = sort;
  }


  public SellerInventoryItem displayType(DisplayTypeEnum displayType) {
    
    this.displayType = displayType;
    return this;
  }

   /**
   * Indicate which initial values to display first on the front-facing card
   * @return displayType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "NATIVE", required = true, value = "Indicate which initial values to display first on the front-facing card")
  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public DisplayTypeEnum getDisplayType() {
    return displayType;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayType(DisplayTypeEnum displayType) {
    this.displayType = displayType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SellerInventoryItem sellerInventoryItem = (SellerInventoryItem) o;
    return Objects.equals(this.identifier, sellerInventoryItem.identifier) &&
        Objects.equals(this.sellerIdentifier, sellerInventoryItem.sellerIdentifier) &&
        Objects.equals(this.sellerInventoryItemName, sellerInventoryItem.sellerInventoryItemName) &&
        Objects.equals(this.engineConfigurationIdentifier, sellerInventoryItem.engineConfigurationIdentifier) &&
        Objects.equals(this.descriptions, sellerInventoryItem.descriptions) &&
        Objects.equals(this.keywords, sellerInventoryItem.keywords) &&
        Objects.equals(this.status, sellerInventoryItem.status) &&
        Objects.equals(this.inventoryType, sellerInventoryItem.inventoryType) &&
        Objects.equals(this.channelInventoryType, sellerInventoryItem.channelInventoryType) &&
        Objects.equals(this.supplierIdentifier, sellerInventoryItem.supplierIdentifier) &&
        Objects.equals(this.channelInventoryIdentifier, sellerInventoryItem.channelInventoryIdentifier) &&
        Objects.equals(this.multimediaIdentifiers, sellerInventoryItem.multimediaIdentifiers) &&
        Objects.equals(this.animate, sellerInventoryItem.animate) &&
        Objects.equals(this.animateDelay, sellerInventoryItem.animateDelay) &&
        Objects.equals(this.sort, sellerInventoryItem.sort) &&
        Objects.equals(this.displayType, sellerInventoryItem.displayType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, sellerIdentifier, sellerInventoryItemName, engineConfigurationIdentifier, descriptions, keywords, status, inventoryType, channelInventoryType, supplierIdentifier, channelInventoryIdentifier, multimediaIdentifiers, animate, animateDelay, sort, displayType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SellerInventoryItem {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    sellerIdentifier: ").append(toIndentedString(sellerIdentifier)).append("\n");
    sb.append("    sellerInventoryItemName: ").append(toIndentedString(sellerInventoryItemName)).append("\n");
    sb.append("    engineConfigurationIdentifier: ").append(toIndentedString(engineConfigurationIdentifier)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    inventoryType: ").append(toIndentedString(inventoryType)).append("\n");
    sb.append("    channelInventoryType: ").append(toIndentedString(channelInventoryType)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    channelInventoryIdentifier: ").append(toIndentedString(channelInventoryIdentifier)).append("\n");
    sb.append("    multimediaIdentifiers: ").append(toIndentedString(multimediaIdentifiers)).append("\n");
    sb.append("    animate: ").append(toIndentedString(animate)).append("\n");
    sb.append("    animateDelay: ").append(toIndentedString(animateDelay)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    displayType: ").append(toIndentedString(displayType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

