/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.AdvancedMapConfiguration;
import travel.wink.sdk.affiliate.model.AdvancedMapConfigurationView;
import travel.wink.sdk.affiliate.model.InventoryMapMarker;
import travel.wink.sdk.affiliate.model.RemoveEntryResponse;

public class MapsApi {
    private ApiClient apiClient;

    public MapsApi() {
        this(new ApiClient());
    }

    @Autowired
    public MapsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createAdvancedMapConfigurationRequestCreation(String companyIdentifier, AdvancedMapConfiguration advancedMapConfiguration) throws WebClientResponseException {
        AdvancedMapConfiguration postBody = advancedMapConfiguration;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (advancedMapConfiguration == null) {
            throw new WebClientResponseException("Missing the required parameter 'advancedMapConfiguration' when calling createAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/map", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AdvancedMapConfigurationView> createAdvancedMapConfiguration(String companyIdentifier, AdvancedMapConfiguration advancedMapConfiguration) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>(){};
        return this.createAdvancedMapConfigurationRequestCreation(companyIdentifier, advancedMapConfiguration).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationView>> createAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, AdvancedMapConfiguration advancedMapConfiguration) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>(){};
        return this.createAdvancedMapConfigurationRequestCreation(companyIdentifier, advancedMapConfiguration).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeAdvancedMapConfigurationRequestCreation(String companyIdentifier, String mapIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling removeAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("mapIdentifier", mapIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/map/{mapIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeAdvancedMapConfiguration(String companyIdentifier, String mapIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, String mapIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showAdvancedMapConfigurationRequestCreation(String companyIdentifier, String mapIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling showAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("mapIdentifier", mapIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/map/{mapIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AdvancedMapConfigurationView> showAdvancedMapConfiguration(String companyIdentifier, String mapIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>(){};
        return this.showAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationView>> showAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, String mapIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>(){};
        return this.showAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showAdvancedMapConfigurationMapMarkerRequestCreation(String companyIdentifier, String channelInventoryIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfigurationMapMarker", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (channelInventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'channelInventoryIdentifier' when calling showAdvancedMapConfigurationMapMarker", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("channelInventoryIdentifier", channelInventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<InventoryMapMarker> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarker>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/map/marker/{channelInventoryIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryMapMarker> showAdvancedMapConfigurationMapMarker(String companyIdentifier, String channelInventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarker> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarker>(){};
        return this.showAdvancedMapConfigurationMapMarkerRequestCreation(companyIdentifier, channelInventoryIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryMapMarker>> showAdvancedMapConfigurationMapMarkerWithHttpInfo(String companyIdentifier, String channelInventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarker> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarker>(){};
        return this.showAdvancedMapConfigurationMapMarkerRequestCreation(companyIdentifier, channelInventoryIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showAdvancedMapConfigurationMapMarkersRequestCreation(String companyIdentifier, String listIdentifier, String listType, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfigurationMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showAdvancedMapConfigurationMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listType == null) {
            throw new WebClientResponseException("Missing the required parameter 'listType' when calling showAdvancedMapConfigurationMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("listType", listType);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<InventoryMapMarker> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarker>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/map/markers/{listType}/{listIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InventoryMapMarker> showAdvancedMapConfigurationMapMarkers(String companyIdentifier, String listIdentifier, String listType, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarker> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarker>(){};
        return this.showAdvancedMapConfigurationMapMarkersRequestCreation(companyIdentifier, listIdentifier, listType, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventoryMapMarker>>> showAdvancedMapConfigurationMapMarkersWithHttpInfo(String companyIdentifier, String listIdentifier, String listType, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarker> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarker>(){};
        return this.showAdvancedMapConfigurationMapMarkersRequestCreation(companyIdentifier, listIdentifier, listType, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showAdvancedMapConfigurationsRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfigurations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/map", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<AdvancedMapConfigurationView> showAdvancedMapConfigurations(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>(){};
        return this.showAdvancedMapConfigurationsRequestCreation(companyIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<AdvancedMapConfigurationView>>> showAdvancedMapConfigurationsWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>(){};
        return this.showAdvancedMapConfigurationsRequestCreation(companyIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateAdvancedMapConfigurationRequestCreation(String companyIdentifier, String mapIdentifier, AdvancedMapConfiguration advancedMapConfiguration) throws WebClientResponseException {
        AdvancedMapConfiguration postBody = advancedMapConfiguration;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling updateAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (advancedMapConfiguration == null) {
            throw new WebClientResponseException("Missing the required parameter 'advancedMapConfiguration' when calling updateAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("mapIdentifier", mapIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/map/{mapIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AdvancedMapConfigurationView> updateAdvancedMapConfiguration(String companyIdentifier, String mapIdentifier, AdvancedMapConfiguration advancedMapConfiguration) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>(){};
        return this.updateAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, advancedMapConfiguration).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationView>> updateAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, String mapIdentifier, AdvancedMapConfiguration advancedMapConfiguration) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>(){};
        return this.updateAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, advancedMapConfiguration).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

