/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="Exclude this promotion from specific date ranges.")
@JsonPropertyOrder(value={"effectiveDate", "expireDate"})
public class BlackoutDate {
    public static final String JSON_PROPERTY_EFFECTIVE_DATE = "effectiveDate";
    private LocalDate effectiveDate;
    public static final String JSON_PROPERTY_EXPIRE_DATE = "expireDate";
    private LocalDate expireDate;

    public BlackoutDate effectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="Wed Jan 01 07:00:00 ICT 2020", required=true, value="Blackout start date.")
    @JsonProperty(value="effectiveDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @JsonProperty(value="effectiveDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public BlackoutDate expireDate(LocalDate expireDate) {
        this.expireDate = expireDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="Fri Jan 31 07:00:00 ICT 2020", required=true, value="Blackout end date.")
    @JsonProperty(value="expireDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getExpireDate() {
        return this.expireDate;
    }

    @JsonProperty(value="expireDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExpireDate(LocalDate expireDate) {
        this.expireDate = expireDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlackoutDate blackoutDate = (BlackoutDate)o;
        return Objects.equals(this.effectiveDate, blackoutDate.effectiveDate) && Objects.equals(this.expireDate, blackoutDate.expireDate);
    }

    public int hashCode() {
        return Objects.hash(this.effectiveDate, this.expireDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BlackoutDate {\n");
        sb.append("    effectiveDate: ").append(this.toIndentedString(this.effectiveDate)).append("\n");
        sb.append("    expireDate: ").append(this.toIndentedString(this.expireDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

