/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 22.0.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.CancellationPolicy;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CancellationPolicyException
 */
@JsonPropertyOrder({
  CancellationPolicyException.JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER,
  CancellationPolicyException.JSON_PROPERTY_CANCELLATION_POLICY,
  CancellationPolicyException.JSON_PROPERTY_START_DATE,
  CancellationPolicyException.JSON_PROPERTY_END_DATE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-18T16:39:06.144766291+07:00[Asia/Bangkok]")
public class CancellationPolicyException {
  public static final String JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER = "cancellationPolicyIdentifier";
  private UUID cancellationPolicyIdentifier;

  public static final String JSON_PROPERTY_CANCELLATION_POLICY = "cancellationPolicy";
  private CancellationPolicy cancellationPolicy;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public CancellationPolicyException() { 
  }

  public CancellationPolicyException cancellationPolicyIdentifier(UUID cancellationPolicyIdentifier) {
    
    this.cancellationPolicyIdentifier = cancellationPolicyIdentifier;
    return this;
  }

   /**
   * Cancellation policy
   * @return cancellationPolicyIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Cancellation policy")
  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getCancellationPolicyIdentifier() {
    return cancellationPolicyIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancellationPolicyIdentifier(UUID cancellationPolicyIdentifier) {
    this.cancellationPolicyIdentifier = cancellationPolicyIdentifier;
  }


  public CancellationPolicyException cancellationPolicy(CancellationPolicy cancellationPolicy) {
    
    this.cancellationPolicy = cancellationPolicy;
    return this;
  }

   /**
   * Get cancellationPolicy
   * @return cancellationPolicy
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationPolicy getCancellationPolicy() {
    return cancellationPolicy;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationPolicy(CancellationPolicy cancellationPolicy) {
    this.cancellationPolicy = cancellationPolicy;
  }


  public CancellationPolicyException startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Start date for when this cancellation policy should start to override the default cancellation policy.
   * @return startDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Start date for when this cancellation policy should start to override the default cancellation policy.")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public CancellationPolicyException endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * End date for when this cancellation policy should end overriding the default cancellation policy.
   * @return endDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "End date for when this cancellation policy should end overriding the default cancellation policy.")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CancellationPolicyException cancellationPolicyException = (CancellationPolicyException) o;
    return Objects.equals(this.cancellationPolicyIdentifier, cancellationPolicyException.cancellationPolicyIdentifier) &&
        Objects.equals(this.cancellationPolicy, cancellationPolicyException.cancellationPolicy) &&
        Objects.equals(this.startDate, cancellationPolicyException.startDate) &&
        Objects.equals(this.endDate, cancellationPolicyException.endDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cancellationPolicyIdentifier, cancellationPolicy, startDate, endDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CancellationPolicyException {\n");
    sb.append("    cancellationPolicyIdentifier: ").append(toIndentedString(cancellationPolicyIdentifier)).append("\n");
    sb.append("    cancellationPolicy: ").append(toIndentedString(cancellationPolicy)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

