/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 22.0.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Multimedia that contains less information than Multimedia object
 */
@ApiModel(description = "Multimedia that contains less information than Multimedia object")
@JsonPropertyOrder({
  SimpleMultimedia.JSON_PROPERTY_IDENTIFIER,
  SimpleMultimedia.JSON_PROPERTY_TYPE,
  SimpleMultimedia.JSON_PROPERTY_SOURCE,
  SimpleMultimedia.JSON_PROPERTY_SORT,
  SimpleMultimedia.JSON_PROPERTY_ANGLE,
  SimpleMultimedia.JSON_PROPERTY_WIDTH,
  SimpleMultimedia.JSON_PROPERTY_HEIGHT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-18T16:39:06.144766291+07:00[Asia/Bangkok]")
public class SimpleMultimedia {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  /**
   * Whether Cloudinary media is a VIDEO or IMAGE.
   */
  public enum TypeEnum {
    IMAGE("IMAGE"),
    
    VIDEO("VIDEO");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  /**
   * Currently ONLY using Cloudinary to store all image / video assets.
   */
  public enum SourceEnum {
    YOUTUBE("YOUTUBE"),
    
    CLOUDINARY("CLOUDINARY");

    private String value;

    SourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SourceEnum fromValue(String value) {
      for (SourceEnum b : SourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SOURCE = "source";
  private SourceEnum source = SourceEnum.CLOUDINARY;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort = 999;

  public static final String JSON_PROPERTY_ANGLE = "angle";
  private String angle;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Integer width;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Integer height;

  public SimpleMultimedia() { 
  }

  public SimpleMultimedia identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Use this identifier to communicate with Cloudinary.
   * @return identifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "cloudinary-image-1", required = true, value = "Use this identifier to communicate with Cloudinary.")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public SimpleMultimedia type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Whether Cloudinary media is a VIDEO or IMAGE.
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "IMAGE", required = true, value = "Whether Cloudinary media is a VIDEO or IMAGE.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public SimpleMultimedia source(SourceEnum source) {
    
    this.source = source;
    return this;
  }

   /**
   * Currently ONLY using Cloudinary to store all image / video assets.
   * @return source
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "CLOUDINARY", required = true, value = "Currently ONLY using Cloudinary to store all image / video assets.")
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SourceEnum getSource() {
    return source;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSource(SourceEnum source) {
    this.source = source;
  }


  public SimpleMultimedia sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Sort allows you to control how you want to sort this record in a list of media records.
   * @return sort
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "10", required = true, value = "Sort allows you to control how you want to sort this record in a list of media records.")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public SimpleMultimedia angle(String angle) {
    
    this.angle = angle;
    return this;
  }

   /**
   * Media angle
   * @return angle
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "-90", required = true, value = "Media angle")
  @JsonProperty(JSON_PROPERTY_ANGLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAngle() {
    return angle;
  }


  @JsonProperty(JSON_PROPERTY_ANGLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAngle(String angle) {
    this.angle = angle;
  }


  public SimpleMultimedia width(Integer width) {
    
    this.width = width;
    return this;
  }

   /**
   * Media width in pixels.
   * @return width
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "2560", required = true, value = "Media width in pixels.")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setWidth(Integer width) {
    this.width = width;
  }


  public SimpleMultimedia height(Integer height) {
    
    this.height = height;
    return this;
  }

   /**
   * Media height in pixels.
   * @return height
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "1600", required = true, value = "Media height in pixels.")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHeight(Integer height) {
    this.height = height;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SimpleMultimedia simpleMultimedia = (SimpleMultimedia) o;
    return Objects.equals(this.identifier, simpleMultimedia.identifier) &&
        Objects.equals(this.type, simpleMultimedia.type) &&
        Objects.equals(this.source, simpleMultimedia.source) &&
        Objects.equals(this.sort, simpleMultimedia.sort) &&
        Objects.equals(this.angle, simpleMultimedia.angle) &&
        Objects.equals(this.width, simpleMultimedia.width) &&
        Objects.equals(this.height, simpleMultimedia.height);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, type, source, sort, angle, width, height);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SimpleMultimedia {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    angle: ").append(toIndentedString(angle)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

