/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 22.0.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.SimpleDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Upserts a SellerUrl entity
 */
@ApiModel(description = "Upserts a SellerUrl entity")
@JsonPropertyOrder({
  UpsertSellerUrlRequest.JSON_PROPERTY_SELLER_URL_NAME,
  UpsertSellerUrlRequest.JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER,
  UpsertSellerUrlRequest.JSON_PROPERTY_DESCRIPTIONS,
  UpsertSellerUrlRequest.JSON_PROPERTY_KEYWORDS,
  UpsertSellerUrlRequest.JSON_PROPERTY_TWITTER_ACCOUNT,
  UpsertSellerUrlRequest.JSON_PROPERTY_FACEBOOK_APP_ID,
  UpsertSellerUrlRequest.JSON_PROPERTY_THEME,
  UpsertSellerUrlRequest.JSON_PROPERTY_STATUS,
  UpsertSellerUrlRequest.JSON_PROPERTY_INVENTORY_TYPE,
  UpsertSellerUrlRequest.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  UpsertSellerUrlRequest.JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER,
  UpsertSellerUrlRequest.JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS,
  UpsertSellerUrlRequest.JSON_PROPERTY_ANIMATE,
  UpsertSellerUrlRequest.JSON_PROPERTY_ANIMATE_DELAY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-18T16:39:06.144766291+07:00[Asia/Bangkok]")
public class UpsertSellerUrlRequest {
  public static final String JSON_PROPERTY_SELLER_URL_NAME = "sellerUrlName";
  private String sellerUrlName;

  public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
  private UUID engineConfigurationIdentifier;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescription> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_KEYWORDS = "keywords";
  private List<String> keywords = new ArrayList<>();

  public static final String JSON_PROPERTY_TWITTER_ACCOUNT = "twitterAccount";
  private String twitterAccount;

  public static final String JSON_PROPERTY_FACEBOOK_APP_ID = "facebookAppId";
  private String facebookAppId;

  /**
   * Url theme controls the look and feel of the ad banner.
   */
  public enum ThemeEnum {
    THEME_1("THEME_1");

    private String value;

    ThemeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ThemeEnum fromValue(String value) {
      for (ThemeEnum b : ThemeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_THEME = "theme";
  private ThemeEnum theme;

  /**
   * Url sell status
   */
  public enum StatusEnum {
    ACTIVE("ACTIVE"),
    
    INACTIVE("INACTIVE"),
    
    REMOVED("REMOVED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  /**
   * Inventory type
   */
  public enum InventoryTypeEnum {
    HOTEL("HOTEL"),
    
    GUEST_ROOM("GUEST_ROOM"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    PACKAGE("PACKAGE"),
    
    ADD_ON("ADD_ON"),
    
    ATTRACTION("ATTRACTION"),
    
    ACTIVITY("ACTIVITY"),
    
    PLACE("PLACE");

    private String value;

    InventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryTypeEnum fromValue(String value) {
      for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
  private InventoryTypeEnum inventoryType;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private String supplierIdentifier;

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
  private String channelInventoryIdentifier;

  public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS = "multimediaIdentifiers";
  private List<String> multimediaIdentifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_ANIMATE = "animate";
  private Boolean animate = false;

  public static final String JSON_PROPERTY_ANIMATE_DELAY = "animateDelay";
  private Integer animateDelay = -1;

  public UpsertSellerUrlRequest() { 
  }

  public UpsertSellerUrlRequest sellerUrlName(String sellerUrlName) {
    
    this.sellerUrlName = sellerUrlName;
    return this;
  }

   /**
   * Descriptive name of this url for seller use only
   * @return sellerUrlName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "My Bali Villa", required = true, value = "Descriptive name of this url for seller use only")
  @JsonProperty(JSON_PROPERTY_SELLER_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSellerUrlName() {
    return sellerUrlName;
  }


  @JsonProperty(JSON_PROPERTY_SELLER_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSellerUrlName(String sellerUrlName) {
    this.sellerUrlName = sellerUrlName;
  }


  public UpsertSellerUrlRequest engineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    return this;
  }

   /**
   * Customization identifier
   * @return engineConfigurationIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Customization identifier")
  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getEngineConfigurationIdentifier() {
    return engineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEngineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
  }


  public UpsertSellerUrlRequest descriptions(List<SimpleDescription> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public UpsertSellerUrlRequest addDescriptionsItem(SimpleDescription descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized link descriptions
   * @return descriptions
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)  @ApiModelProperty(required = true, value = "Localized link descriptions")
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescription> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescription> descriptions) {
    this.descriptions = descriptions;
  }


  public UpsertSellerUrlRequest keywords(List<String> keywords) {
    
    this.keywords = keywords;
    return this;
  }

  public UpsertSellerUrlRequest addKeywordsItem(String keywordsItem) {
    this.keywords.add(keywordsItem);
    return this;
  }

   /**
   * Keywords
   * @return keywords
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Size(min=1,max=2147483647)  @ApiModelProperty(example = "[\"bali\"]", required = true, value = "Keywords")
  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getKeywords() {
    return keywords;
  }


  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setKeywords(List<String> keywords) {
    this.keywords = keywords;
  }


  public UpsertSellerUrlRequest twitterAccount(String twitterAccount) {
    
    this.twitterAccount = twitterAccount;
    return this;
  }

   /**
   * Twitter account is used with OpenGraph data
   * @return twitterAccount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "@travelikoworld", value = "Twitter account is used with OpenGraph data")
  @JsonProperty(JSON_PROPERTY_TWITTER_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTwitterAccount() {
    return twitterAccount;
  }


  @JsonProperty(JSON_PROPERTY_TWITTER_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTwitterAccount(String twitterAccount) {
    this.twitterAccount = twitterAccount;
  }


  public UpsertSellerUrlRequest facebookAppId(String facebookAppId) {
    
    this.facebookAppId = facebookAppId;
    return this;
  }

   /**
   * Facebook APP ID is used with OpenGraph data
   * @return facebookAppId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "19827398721938798237", value = "Facebook APP ID is used with OpenGraph data")
  @JsonProperty(JSON_PROPERTY_FACEBOOK_APP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFacebookAppId() {
    return facebookAppId;
  }


  @JsonProperty(JSON_PROPERTY_FACEBOOK_APP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFacebookAppId(String facebookAppId) {
    this.facebookAppId = facebookAppId;
  }


  public UpsertSellerUrlRequest theme(ThemeEnum theme) {
    
    this.theme = theme;
    return this;
  }

   /**
   * Url theme controls the look and feel of the ad banner.
   * @return theme
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "THEME_1", required = true, value = "Url theme controls the look and feel of the ad banner.")
  @JsonProperty(JSON_PROPERTY_THEME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ThemeEnum getTheme() {
    return theme;
  }


  @JsonProperty(JSON_PROPERTY_THEME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTheme(ThemeEnum theme) {
    this.theme = theme;
  }


  public UpsertSellerUrlRequest status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Url sell status
   * @return status
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "ACTIVE", required = true, value = "Url sell status")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public UpsertSellerUrlRequest inventoryType(InventoryTypeEnum inventoryType) {
    
    this.inventoryType = inventoryType;
    return this;
  }

   /**
   * Inventory type
   * @return inventoryType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "GUEST_ROOM", required = true, value = "Inventory type")
  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InventoryTypeEnum getInventoryType() {
    return inventoryType;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryType(InventoryTypeEnum inventoryType) {
    this.inventoryType = inventoryType;
  }


  public UpsertSellerUrlRequest supplierIdentifier(String supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * The entity supplying the inventory. Usually a hotel.
   * @return supplierIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "hotel-1", required = true, value = "The entity supplying the inventory. Usually a hotel.")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(String supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public UpsertSellerUrlRequest channelInventoryIdentifier(String channelInventoryIdentifier) {
    
    this.channelInventoryIdentifier = channelInventoryIdentifier;
    return this;
  }

   /**
   * Selected inventory record
   * @return channelInventoryIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "channel-inventory-1", required = true, value = "Selected inventory record")
  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getChannelInventoryIdentifier() {
    return channelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannelInventoryIdentifier(String channelInventoryIdentifier) {
    this.channelInventoryIdentifier = channelInventoryIdentifier;
  }


  public UpsertSellerUrlRequest multimediaIdentifiers(List<String> multimediaIdentifiers) {
    
    this.multimediaIdentifiers = multimediaIdentifiers;
    return this;
  }

  public UpsertSellerUrlRequest addMultimediaIdentifiersItem(String multimediaIdentifiersItem) {
    this.multimediaIdentifiers.add(multimediaIdentifiersItem);
    return this;
  }

   /**
   * Cloudinary identifiers
   * @return multimediaIdentifiers
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Size(min=1,max=2147483647)  @ApiModelProperty(example = "[\"cloudinary-image-1\"]", required = true, value = "Cloudinary identifiers")
  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getMultimediaIdentifiers() {
    return multimediaIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimediaIdentifiers(List<String> multimediaIdentifiers) {
    this.multimediaIdentifiers = multimediaIdentifiers;
  }


  public UpsertSellerUrlRequest animate(Boolean animate) {
    
    this.animate = animate;
    return this;
  }

   /**
   * Create an animated gif instead of a list of images
   * @return animate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Create an animated gif instead of a list of images")
  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAnimate() {
    return animate;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimate(Boolean animate) {
    this.animate = animate;
  }


  public UpsertSellerUrlRequest animateDelay(Integer animateDelay) {
    
    this.animateDelay = animateDelay;
    return this;
  }

   /**
   * Animation delay in milliseconds
   * @return animateDelay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1000", value = "Animation delay in milliseconds")
  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAnimateDelay() {
    return animateDelay;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimateDelay(Integer animateDelay) {
    this.animateDelay = animateDelay;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertSellerUrlRequest upsertSellerUrlRequest = (UpsertSellerUrlRequest) o;
    return Objects.equals(this.sellerUrlName, upsertSellerUrlRequest.sellerUrlName) &&
        Objects.equals(this.engineConfigurationIdentifier, upsertSellerUrlRequest.engineConfigurationIdentifier) &&
        Objects.equals(this.descriptions, upsertSellerUrlRequest.descriptions) &&
        Objects.equals(this.keywords, upsertSellerUrlRequest.keywords) &&
        Objects.equals(this.twitterAccount, upsertSellerUrlRequest.twitterAccount) &&
        Objects.equals(this.facebookAppId, upsertSellerUrlRequest.facebookAppId) &&
        Objects.equals(this.theme, upsertSellerUrlRequest.theme) &&
        Objects.equals(this.status, upsertSellerUrlRequest.status) &&
        Objects.equals(this.inventoryType, upsertSellerUrlRequest.inventoryType) &&
        Objects.equals(this.supplierIdentifier, upsertSellerUrlRequest.supplierIdentifier) &&
        Objects.equals(this.channelInventoryIdentifier, upsertSellerUrlRequest.channelInventoryIdentifier) &&
        Objects.equals(this.multimediaIdentifiers, upsertSellerUrlRequest.multimediaIdentifiers) &&
        Objects.equals(this.animate, upsertSellerUrlRequest.animate) &&
        Objects.equals(this.animateDelay, upsertSellerUrlRequest.animateDelay);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sellerUrlName, engineConfigurationIdentifier, descriptions, keywords, twitterAccount, facebookAppId, theme, status, inventoryType, supplierIdentifier, channelInventoryIdentifier, multimediaIdentifiers, animate, animateDelay);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertSellerUrlRequest {\n");
    sb.append("    sellerUrlName: ").append(toIndentedString(sellerUrlName)).append("\n");
    sb.append("    engineConfigurationIdentifier: ").append(toIndentedString(engineConfigurationIdentifier)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    twitterAccount: ").append(toIndentedString(twitterAccount)).append("\n");
    sb.append("    facebookAppId: ").append(toIndentedString(facebookAppId)).append("\n");
    sb.append("    theme: ").append(toIndentedString(theme)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    inventoryType: ").append(toIndentedString(inventoryType)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    channelInventoryIdentifier: ").append(toIndentedString(channelInventoryIdentifier)).append("\n");
    sb.append("    multimediaIdentifiers: ").append(toIndentedString(multimediaIdentifiers)).append("\n");
    sb.append("    animate: ").append(toIndentedString(animate)).append("\n");
    sb.append("    animateDelay: ").append(toIndentedString(animateDelay)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

