package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.EngineView;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.RemoveEntryResponse;
import travel.wink.sdk.affiliate.model.SaveEngineRequest;
import travel.wink.sdk.affiliate.model.ShowSellerUrl400Response;
import travel.wink.sdk.affiliate.model.UniqueRequest;
import travel.wink.sdk.affiliate.model.UniqueResult;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-11-08T09:35:16.430198433+07:00[Asia/Bangkok]")
public class ApplicationApi {
    private ApiClient apiClient;

    public ApplicationApi() {
        this(new ApiClient());
    }

    @Autowired
    public ApplicationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Application
     * Creates a new application for company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create new application and associate with this company
     * @param saveEngineRequest The saveEngineRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return EngineView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createApplicationRequestCreation(String companyIdentifier, SaveEngineRequest saveEngineRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = saveEngineRequest;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'saveEngineRequest' is set
        if (saveEngineRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'saveEngineRequest' when calling createApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/application", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Application
     * Creates a new application for company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create new application and associate with this company
     * @param saveEngineRequest The saveEngineRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return EngineView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<EngineView> createApplication(String companyIdentifier, SaveEngineRequest saveEngineRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>() {};
        return createApplicationRequestCreation(companyIdentifier, saveEngineRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<EngineView>> createApplicationWithHttpInfo(String companyIdentifier, SaveEngineRequest saveEngineRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>() {};
        return createApplicationRequestCreation(companyIdentifier, saveEngineRequest, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Application Name Uniqueness
     * Checks to see if the name for the application you want to use is unique.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param uniqueRequest The uniqueRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UniqueResult
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isEngineNameUniqueRequestCreation(UniqueRequest uniqueRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = uniqueRequest;
        // verify the required parameter 'uniqueRequest' is set
        if (uniqueRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'uniqueRequest' when calling isEngineNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return apiClient.invokeAPI("/api/application/unique", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Application Name Uniqueness
     * Checks to see if the name for the application you want to use is unique.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param uniqueRequest The uniqueRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UniqueResult
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UniqueResult> isEngineNameUnique(UniqueRequest uniqueRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return isEngineNameUniqueRequestCreation(uniqueRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResult>> isEngineNameUniqueWithHttpInfo(UniqueRequest uniqueRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return isEngineNameUniqueRequestCreation(uniqueRequest, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Delete Application
     * Deletes an application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove application owned by this company
     * @param engineIdentifier Remove application with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeApplicationRequestCreation(String companyIdentifier, String engineIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'engineIdentifier' is set
        if (engineIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineIdentifier' when calling removeApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineIdentifier", engineIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/application/{engineIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Application
     * Deletes an application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove application owned by this company
     * @param engineIdentifier Remove application with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeApplication(String companyIdentifier, String engineIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeApplicationRequestCreation(companyIdentifier, engineIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeApplicationWithHttpInfo(String companyIdentifier, String engineIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeApplicationRequestCreation(companyIdentifier, engineIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Applications by Owner
     * Retrieve a list of applications for all companies the caller has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;EngineView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAllApplicationsForUserRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>() {};
        return apiClient.invokeAPI("/api/application/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Applications by Owner
     * Retrieve a list of applications for all companies the caller has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;EngineView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<EngineView> showAllApplicationsForUser(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>() {};
        return showAllApplicationsForUserRequestCreation(winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<EngineView>>> showAllApplicationsForUserWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>() {};
        return showAllApplicationsForUserRequestCreation(winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Show Application
     * Retrieve a specific application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show application for company with this identifier
     * @param engineIdentifier Show application with this identifier
     * @param winkVersion The winkVersion parameter
     * @return EngineView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showApplicationRequestCreation(String companyIdentifier, String engineIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'engineIdentifier' is set
        if (engineIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineIdentifier' when calling showApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineIdentifier", engineIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/application/{engineIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Application
     * Retrieve a specific application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show application for company with this identifier
     * @param engineIdentifier Show application with this identifier
     * @param winkVersion The winkVersion parameter
     * @return EngineView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<EngineView> showApplication(String companyIdentifier, String engineIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>() {};
        return showApplicationRequestCreation(companyIdentifier, engineIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<EngineView>> showApplicationWithHttpInfo(String companyIdentifier, String engineIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>() {};
        return showApplicationRequestCreation(companyIdentifier, engineIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Applications
     * Retrieve a list of applications for a specific company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show applications for company with this identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;EngineView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showApplicationsRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showApplications", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/application/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Applications
     * Retrieve a list of applications for a specific company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show applications for company with this identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;EngineView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<EngineView> showApplications(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>() {};
        return showApplicationsRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<EngineView>>> showApplicationsWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>() {};
        return showApplicationsRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Update Application
     * Updates an existing application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update existing application and associate with this company
     * @param engineIdentifier Update application with this identifier
     * @param saveEngineRequest The saveEngineRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return EngineView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateApplicationRequestCreation(String companyIdentifier, String engineIdentifier, SaveEngineRequest saveEngineRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = saveEngineRequest;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'engineIdentifier' is set
        if (engineIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineIdentifier' when calling updateApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'saveEngineRequest' is set
        if (saveEngineRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'saveEngineRequest' when calling updateApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineIdentifier", engineIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/application/{engineIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Application
     * Updates an existing application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update existing application and associate with this company
     * @param engineIdentifier Update application with this identifier
     * @param saveEngineRequest The saveEngineRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return EngineView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<EngineView> updateApplication(String companyIdentifier, String engineIdentifier, SaveEngineRequest saveEngineRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>() {};
        return updateApplicationRequestCreation(companyIdentifier, engineIdentifier, saveEngineRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<EngineView>> updateApplicationWithHttpInfo(String companyIdentifier, String engineIdentifier, SaveEngineRequest saveEngineRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>() {};
        return updateApplicationRequestCreation(companyIdentifier, engineIdentifier, saveEngineRequest, winkVersion).toEntity(localVarReturnType);
    }
}
