package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.AddManagerRequest;
import travel.wink.sdk.affiliate.model.CompanyView;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.RemoveEntryResponse;
import travel.wink.sdk.affiliate.model.ShowSellerUrl400Response;
import travel.wink.sdk.affiliate.model.UniqueRequest;
import travel.wink.sdk.affiliate.model.UniqueResult;
import travel.wink.sdk.affiliate.model.UpsertCompanyRequest;
import travel.wink.sdk.affiliate.model.UpsertCompanyStatusRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-11-08T09:35:16.430198433+07:00[Asia/Bangkok]")
public class CompanyApi {
    private ApiClient apiClient;

    public CompanyApi() {
        this(new ApiClient());
    }

    @Autowired
    public CompanyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add Manager
     * Associate an existing payment user with this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param addManagerRequest The addManagerRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec addCompanyUserRequestCreation(String companyIdentifier, AddManagerRequest addManagerRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = addManagerRequest;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling addCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addManagerRequest' is set
        if (addManagerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'addManagerRequest' when calling addCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/manager", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Manager
     * Associate an existing payment user with this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param addManagerRequest The addManagerRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyView> addCompanyUser(String companyIdentifier, AddManagerRequest addManagerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return addCompanyUserRequestCreation(companyIdentifier, addManagerRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyView>> addCompanyUserWithHttpInfo(String companyIdentifier, AddManagerRequest addManagerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return addCompanyUserRequestCreation(companyIdentifier, addManagerRequest, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Create company
     * Create a new company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param upsertCompanyRequest The upsertCompanyRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createCompanyRequestCreation(UpsertCompanyRequest upsertCompanyRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCompanyRequest;
        // verify the required parameter 'upsertCompanyRequest' is set
        if (upsertCompanyRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyRequest' when calling createCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return apiClient.invokeAPI("/api/company", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create company
     * Create a new company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param upsertCompanyRequest The upsertCompanyRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyView> createCompany(UpsertCompanyRequest upsertCompanyRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return createCompanyRequestCreation(upsertCompanyRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyView>> createCompanyWithHttpInfo(UpsertCompanyRequest upsertCompanyRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return createCompanyRequestCreation(upsertCompanyRequest, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Verify company name
     * Check if company name is unique
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param uniqueRequest The uniqueRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UniqueResult
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isCompanyNameUniqueRequestCreation(UniqueRequest uniqueRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = uniqueRequest;
        // verify the required parameter 'uniqueRequest' is set
        if (uniqueRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'uniqueRequest' when calling isCompanyNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return apiClient.invokeAPI("/api/company/unique", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify company name
     * Check if company name is unique
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param uniqueRequest The uniqueRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UniqueResult
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UniqueResult> isCompanyNameUnique(UniqueRequest uniqueRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return isCompanyNameUniqueRequestCreation(uniqueRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResult>> isCompanyNameUniqueWithHttpInfo(UniqueRequest uniqueRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return isCompanyNameUniqueRequestCreation(uniqueRequest, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Delete Company
     * Delete a company by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeCompanyRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Company
     * Delete a company by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeCompany(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeCompanyRequestCreation(companyIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeCompanyWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeCompanyRequestCreation(companyIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Remove Manager
     * Disassociate user from this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param userIdentifier The userIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeCompanyUserRequestCreation(String companyIdentifier, String userIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'userIdentifier' is set
        if (userIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'userIdentifier' when calling removeCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("userIdentifier", userIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/manager/{userIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Manager
     * Disassociate user from this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param userIdentifier The userIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyView> removeCompanyUser(String companyIdentifier, String userIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return removeCompanyUserRequestCreation(companyIdentifier, userIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyView>> removeCompanyUserWithHttpInfo(String companyIdentifier, String userIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return removeCompanyUserRequestCreation(companyIdentifier, userIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Companies
     * List all companies owned by caller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;CompanyView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCompaniesRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return apiClient.invokeAPI("/api/company/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Companies
     * List all companies owned by caller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;CompanyView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<CompanyView> showCompanies(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return showCompaniesRequestCreation(winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<CompanyView>>> showCompaniesWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return showCompaniesRequestCreation(winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Show Company
     * Retrieve company by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCompanyRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Company
     * Retrieve company by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyView> showCompany(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return showCompanyRequestCreation(companyIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyView>> showCompanyWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return showCompanyRequestCreation(companyIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Update Company
     * Update an existing company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyRequest The upsertCompanyRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCompanyRequestCreation(String companyIdentifier, UpsertCompanyRequest upsertCompanyRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCompanyRequest;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertCompanyRequest' is set
        if (upsertCompanyRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyRequest' when calling updateCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Company
     * Update an existing company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyRequest The upsertCompanyRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyView> updateCompany(String companyIdentifier, UpsertCompanyRequest upsertCompanyRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyView>> updateCompanyWithHttpInfo(String companyIdentifier, UpsertCompanyRequest upsertCompanyRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequest, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Toggle Company Status
     * Update company status
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyStatusRequest The upsertCompanyStatusRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCompany1RequestCreation(String companyIdentifier, UpsertCompanyStatusRequest upsertCompanyStatusRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCompanyStatusRequest;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompany1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertCompanyStatusRequest' is set
        if (upsertCompanyStatusRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyStatusRequest' when calling updateCompany1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/status", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Toggle Company Status
     * Update company status
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyStatusRequest The upsertCompanyStatusRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyView> updateCompany1(String companyIdentifier, UpsertCompanyStatusRequest upsertCompanyStatusRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyView>> updateCompany1WithHttpInfo(String companyIdentifier, UpsertCompanyStatusRequest upsertCompanyStatusRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>() {};
        return updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequest, winkVersion).toEntity(localVarReturnType);
    }
}
