/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 23.1.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Coupon
 */
@JsonPropertyOrder({
  Coupon.JSON_PROPERTY_AMOUNT_OFF,
  Coupon.JSON_PROPERTY_CREATED,
  Coupon.JSON_PROPERTY_CURRENCY,
  Coupon.JSON_PROPERTY_DELETED,
  Coupon.JSON_PROPERTY_DURATION,
  Coupon.JSON_PROPERTY_DURATION_IN_MONTHS,
  Coupon.JSON_PROPERTY_ID,
  Coupon.JSON_PROPERTY_LIVEMODE,
  Coupon.JSON_PROPERTY_MAX_REDEMPTIONS,
  Coupon.JSON_PROPERTY_METADATA,
  Coupon.JSON_PROPERTY_NAME,
  Coupon.JSON_PROPERTY_OBJECT,
  Coupon.JSON_PROPERTY_PERCENT_OFF,
  Coupon.JSON_PROPERTY_REDEEM_BY,
  Coupon.JSON_PROPERTY_TIMES_REDEEMED,
  Coupon.JSON_PROPERTY_VALID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-11-08T09:35:16.430198433+07:00[Asia/Bangkok]")
public class Coupon {
  public static final String JSON_PROPERTY_AMOUNT_OFF = "amountOff";
  private Long amountOff;

  public static final String JSON_PROPERTY_CREATED = "created";
  private Long created;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_DELETED = "deleted";
  private Boolean deleted;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private String duration;

  public static final String JSON_PROPERTY_DURATION_IN_MONTHS = "durationInMonths";
  private Long durationInMonths;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVEMODE = "livemode";
  private Boolean livemode;

  public static final String JSON_PROPERTY_MAX_REDEMPTIONS = "maxRedemptions";
  private Long maxRedemptions;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = null;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OBJECT = "object";
  private String _object;

  public static final String JSON_PROPERTY_PERCENT_OFF = "percentOff";
  private BigDecimal percentOff;

  public static final String JSON_PROPERTY_REDEEM_BY = "redeemBy";
  private Long redeemBy;

  public static final String JSON_PROPERTY_TIMES_REDEEMED = "timesRedeemed";
  private Long timesRedeemed;

  public static final String JSON_PROPERTY_VALID = "valid";
  private Boolean valid;

  public Coupon() { 
  }

  public Coupon amountOff(Long amountOff) {
    
    this.amountOff = amountOff;
    return this;
  }

   /**
   * Get amountOff
   * @return amountOff
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_OFF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAmountOff() {
    return amountOff;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_OFF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmountOff(Long amountOff) {
    this.amountOff = amountOff;
  }


  public Coupon created(Long created) {
    
    this.created = created;
    return this;
  }

   /**
   * Get created
   * @return created
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreated(Long created) {
    this.created = created;
  }


  public Coupon currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public Coupon deleted(Boolean deleted) {
    
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeleted() {
    return deleted;
  }


  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }


  public Coupon duration(String duration) {
    
    this.duration = duration;
    return this;
  }

   /**
   * Get duration
   * @return duration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDuration() {
    return duration;
  }


  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDuration(String duration) {
    this.duration = duration;
  }


  public Coupon durationInMonths(Long durationInMonths) {
    
    this.durationInMonths = durationInMonths;
    return this;
  }

   /**
   * Get durationInMonths
   * @return durationInMonths
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DURATION_IN_MONTHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDurationInMonths() {
    return durationInMonths;
  }


  @JsonProperty(JSON_PROPERTY_DURATION_IN_MONTHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDurationInMonths(Long durationInMonths) {
    this.durationInMonths = durationInMonths;
  }


  public Coupon id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Coupon livemode(Boolean livemode) {
    
    this.livemode = livemode;
    return this;
  }

   /**
   * Get livemode
   * @return livemode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLivemode() {
    return livemode;
  }


  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLivemode(Boolean livemode) {
    this.livemode = livemode;
  }


  public Coupon maxRedemptions(Long maxRedemptions) {
    
    this.maxRedemptions = maxRedemptions;
    return this;
  }

   /**
   * Get maxRedemptions
   * @return maxRedemptions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAX_REDEMPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMaxRedemptions() {
    return maxRedemptions;
  }


  @JsonProperty(JSON_PROPERTY_MAX_REDEMPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxRedemptions(Long maxRedemptions) {
    this.maxRedemptions = maxRedemptions;
  }


  public Coupon metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public Coupon putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public Coupon name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public Coupon _object(String _object) {
    
    this._object = _object;
    return this;
  }

   /**
   * Get _object
   * @return _object
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObject() {
    return _object;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObject(String _object) {
    this._object = _object;
  }


  public Coupon percentOff(BigDecimal percentOff) {
    
    this.percentOff = percentOff;
    return this;
  }

   /**
   * Get percentOff
   * @return percentOff
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PERCENT_OFF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getPercentOff() {
    return percentOff;
  }


  @JsonProperty(JSON_PROPERTY_PERCENT_OFF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPercentOff(BigDecimal percentOff) {
    this.percentOff = percentOff;
  }


  public Coupon redeemBy(Long redeemBy) {
    
    this.redeemBy = redeemBy;
    return this;
  }

   /**
   * Get redeemBy
   * @return redeemBy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REDEEM_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRedeemBy() {
    return redeemBy;
  }


  @JsonProperty(JSON_PROPERTY_REDEEM_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedeemBy(Long redeemBy) {
    this.redeemBy = redeemBy;
  }


  public Coupon timesRedeemed(Long timesRedeemed) {
    
    this.timesRedeemed = timesRedeemed;
    return this;
  }

   /**
   * Get timesRedeemed
   * @return timesRedeemed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TIMES_REDEEMED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTimesRedeemed() {
    return timesRedeemed;
  }


  @JsonProperty(JSON_PROPERTY_TIMES_REDEEMED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimesRedeemed(Long timesRedeemed) {
    this.timesRedeemed = timesRedeemed;
  }


  public Coupon valid(Boolean valid) {
    
    this.valid = valid;
    return this;
  }

   /**
   * Get valid
   * @return valid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VALID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getValid() {
    return valid;
  }


  @JsonProperty(JSON_PROPERTY_VALID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValid(Boolean valid) {
    this.valid = valid;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Coupon coupon = (Coupon) o;
    return Objects.equals(this.amountOff, coupon.amountOff) &&
        Objects.equals(this.created, coupon.created) &&
        Objects.equals(this.currency, coupon.currency) &&
        Objects.equals(this.deleted, coupon.deleted) &&
        Objects.equals(this.duration, coupon.duration) &&
        Objects.equals(this.durationInMonths, coupon.durationInMonths) &&
        Objects.equals(this.id, coupon.id) &&
        Objects.equals(this.livemode, coupon.livemode) &&
        Objects.equals(this.maxRedemptions, coupon.maxRedemptions) &&
        Objects.equals(this.metadata, coupon.metadata) &&
        Objects.equals(this.name, coupon.name) &&
        Objects.equals(this._object, coupon._object) &&
        Objects.equals(this.percentOff, coupon.percentOff) &&
        Objects.equals(this.redeemBy, coupon.redeemBy) &&
        Objects.equals(this.timesRedeemed, coupon.timesRedeemed) &&
        Objects.equals(this.valid, coupon.valid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amountOff, created, currency, deleted, duration, durationInMonths, id, livemode, maxRedemptions, metadata, name, _object, percentOff, redeemBy, timesRedeemed, valid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Coupon {\n");
    sb.append("    amountOff: ").append(toIndentedString(amountOff)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    durationInMonths: ").append(toIndentedString(durationInMonths)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    livemode: ").append(toIndentedString(livemode)).append("\n");
    sb.append("    maxRedemptions: ").append(toIndentedString(maxRedemptions)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    _object: ").append(toIndentedString(_object)).append("\n");
    sb.append("    percentOff: ").append(toIndentedString(percentOff)).append("\n");
    sb.append("    redeemBy: ").append(toIndentedString(redeemBy)).append("\n");
    sb.append("    timesRedeemed: ").append(toIndentedString(timesRedeemed)).append("\n");
    sb.append("    valid: ").append(toIndentedString(valid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

