/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.AddManagerRequest;
import travel.wink.sdk.affiliate.model.CompanyView;
import travel.wink.sdk.affiliate.model.RemoveEntryResponse;
import travel.wink.sdk.affiliate.model.UniqueRequest;
import travel.wink.sdk.affiliate.model.UniqueResult;
import travel.wink.sdk.affiliate.model.UpsertCompanyRequest;
import travel.wink.sdk.affiliate.model.UpsertCompanyStatusRequest;

public class CompanyApi {
    private ApiClient apiClient;

    public CompanyApi() {
        this(new ApiClient());
    }

    @Autowired
    public CompanyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec addCompanyUserRequestCreation(String companyIdentifier, AddManagerRequest addManagerRequest, String winkVersion) throws WebClientResponseException {
        AddManagerRequest postBody = addManagerRequest;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling addCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addManagerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'addManagerRequest' when calling addCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/manager", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyView> addCompanyUser(String companyIdentifier, AddManagerRequest addManagerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.addCompanyUserRequestCreation(companyIdentifier, addManagerRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyView>> addCompanyUserWithHttpInfo(String companyIdentifier, AddManagerRequest addManagerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.addCompanyUserRequestCreation(companyIdentifier, addManagerRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec createCompanyRequestCreation(UpsertCompanyRequest upsertCompanyRequest, String winkVersion) throws WebClientResponseException {
        UpsertCompanyRequest postBody = upsertCompanyRequest;
        if (upsertCompanyRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyRequest' when calling createCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.apiClient.invokeAPI("/api/company", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyView> createCompany(UpsertCompanyRequest upsertCompanyRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.createCompanyRequestCreation(upsertCompanyRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyView>> createCompanyWithHttpInfo(UpsertCompanyRequest upsertCompanyRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.createCompanyRequestCreation(upsertCompanyRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec isCompanyNameUniqueRequestCreation(UniqueRequest uniqueRequest, String winkVersion) throws WebClientResponseException {
        UniqueRequest postBody = uniqueRequest;
        if (uniqueRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'uniqueRequest' when calling isCompanyNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>(){};
        return this.apiClient.invokeAPI("/api/company/unique", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UniqueResult> isCompanyNameUnique(UniqueRequest uniqueRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>(){};
        return this.isCompanyNameUniqueRequestCreation(uniqueRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResult>> isCompanyNameUniqueWithHttpInfo(UniqueRequest uniqueRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>(){};
        return this.isCompanyNameUniqueRequestCreation(uniqueRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeCompanyRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeCompany(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeCompanyRequestCreation(companyIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeCompanyWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeCompanyRequestCreation(companyIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeCompanyUserRequestCreation(String companyIdentifier, String userIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (userIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'userIdentifier' when calling removeCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("userIdentifier", userIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/manager/{userIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyView> removeCompanyUser(String companyIdentifier, String userIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.removeCompanyUserRequestCreation(companyIdentifier, userIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyView>> removeCompanyUserWithHttpInfo(String companyIdentifier, String userIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.removeCompanyUserRequestCreation(companyIdentifier, userIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showCompaniesRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.apiClient.invokeAPI("/api/company/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<CompanyView> showCompanies(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.showCompaniesRequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<CompanyView>>> showCompaniesWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.showCompaniesRequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showCompanyRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyView> showCompany(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.showCompanyRequestCreation(companyIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyView>> showCompanyWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.showCompanyRequestCreation(companyIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateCompanyRequestCreation(String companyIdentifier, UpsertCompanyRequest upsertCompanyRequest, String winkVersion) throws WebClientResponseException {
        UpsertCompanyRequest postBody = upsertCompanyRequest;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCompanyRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyRequest' when calling updateCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyView> updateCompany(String companyIdentifier, UpsertCompanyRequest upsertCompanyRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyView>> updateCompanyWithHttpInfo(String companyIdentifier, UpsertCompanyRequest upsertCompanyRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateCompany1RequestCreation(String companyIdentifier, UpsertCompanyStatusRequest upsertCompanyStatusRequest, String winkVersion) throws WebClientResponseException {
        UpsertCompanyStatusRequest postBody = upsertCompanyStatusRequest;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompany1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCompanyStatusRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyStatusRequest' when calling updateCompany1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/status", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyView> updateCompany1(String companyIdentifier, UpsertCompanyStatusRequest upsertCompanyStatusRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyView>> updateCompany1WithHttpInfo(String companyIdentifier, UpsertCompanyStatusRequest upsertCompanyStatusRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyView> localVarReturnType = new ParameterizedTypeReference<CompanyView>(){};
        return this.updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

