/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.PageSalesChannelView;
import travel.wink.sdk.affiliate.model.SalesChannelView;
import travel.wink.sdk.affiliate.model.State;

public class SalesChannelApi {
    private ApiClient apiClient;

    public SalesChannelApi() {
        this(new ApiClient());
    }

    @Autowired
    public SalesChannelApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec browseSalesChannelsRequestCreation(String companyIdentifier, State state, String winkVersion) throws WebClientResponseException {
        State postBody = state;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling browseSalesChannels", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling browseSalesChannels", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageSalesChannelView> localVarReturnType = new ParameterizedTypeReference<PageSalesChannelView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/sales/channel/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageSalesChannelView> browseSalesChannels(String companyIdentifier, State state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageSalesChannelView> localVarReturnType = new ParameterizedTypeReference<PageSalesChannelView>(){};
        return this.browseSalesChannelsRequestCreation(companyIdentifier, state, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageSalesChannelView>> browseSalesChannelsWithHttpInfo(String companyIdentifier, State state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageSalesChannelView> localVarReturnType = new ParameterizedTypeReference<PageSalesChannelView>(){};
        return this.browseSalesChannelsRequestCreation(companyIdentifier, state, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showSalesChannelRequestCreation(String companyIdentifier, String supplierIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (supplierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierIdentifier' when calling showSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("supplierIdentifier", supplierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelView> localVarReturnType = new ParameterizedTypeReference<SalesChannelView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/sales/channel/supplier/{supplierIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelView> showSalesChannel(String companyIdentifier, String supplierIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelView> localVarReturnType = new ParameterizedTypeReference<SalesChannelView>(){};
        return this.showSalesChannelRequestCreation(companyIdentifier, supplierIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelView>> showSalesChannelWithHttpInfo(String companyIdentifier, String supplierIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelView> localVarReturnType = new ParameterizedTypeReference<SalesChannelView>(){};
        return this.showSalesChannelRequestCreation(companyIdentifier, supplierIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

