/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.affiliate.model.HotelOnMap;
import travel.wink.sdk.affiliate.model.Social;

@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "hotel", "socials"})
public class HotelOnMapView {
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Long version;
    public static final String JSON_PROPERTY_HOTEL = "hotel";
    private HotelOnMap hotel;
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    private List<Social> socials = null;

    public HotelOnMapView() {
    }

    @JsonCreator
    public HotelOnMapView(@JsonProperty(value="id") UUID id, @JsonProperty(value="createdDate") LocalDateTime createdDate, @JsonProperty(value="lastUpdate") LocalDateTime lastUpdate, @JsonProperty(value="version") Long version) {
        this();
        this.id = id;
        this.createdDate = createdDate;
        this.lastUpdate = lastUpdate;
        this.version = version;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique document identifier")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was first created")
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was last updated")
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @Nullable
    @ApiModelProperty(example="12", value="Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    public HotelOnMapView hotel(HotelOnMap hotel) {
        this.hotel = hotel;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="hotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HotelOnMap getHotel() {
        return this.hotel;
    }

    @JsonProperty(value="hotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotel(HotelOnMap hotel) {
        this.hotel = hotel;
    }

    public HotelOnMapView socials(List<Social> socials) {
        this.socials = socials;
        return this;
    }

    public HotelOnMapView addSocialsItem(Social socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<Social>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Social> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(List<Social> socials) {
        this.socials = socials;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotelOnMapView hotelOnMapView = (HotelOnMapView)o;
        return Objects.equals(this.id, hotelOnMapView.id) && Objects.equals(this.createdDate, hotelOnMapView.createdDate) && Objects.equals(this.lastUpdate, hotelOnMapView.lastUpdate) && Objects.equals(this.version, hotelOnMapView.version) && Objects.equals(this.hotel, hotelOnMapView.hotel) && Objects.equals(this.socials, hotelOnMapView.socials);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdDate, this.lastUpdate, this.version, this.hotel, this.socials);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HotelOnMapView {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    hotel: ").append(this.toIndentedString(this.hotel)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

