/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.affiliate.model.SimpleDescription;

@ApiModel(description="Seller URL")
@JsonPropertyOrder(value={"identifier", "sellerIdentifier", "sellerUrlName", "engineConfigurationIdentifier", "descriptions", "keywords", "uniqueId", "twitterAccount", "facebookAppId", "theme", "status", "inventoryType", "channelInventoryType", "supplierIdentifier", "channelInventoryIdentifier", "multimediaIdentifiers", "animate", "animateDelay"})
public class SellerUrl {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_SELLER_IDENTIFIER = "sellerIdentifier";
    private UUID sellerIdentifier;
    public static final String JSON_PROPERTY_SELLER_URL_NAME = "sellerUrlName";
    private String sellerUrlName;
    public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
    private UUID engineConfigurationIdentifier;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescription> descriptions = new ArrayList<SimpleDescription>();
    public static final String JSON_PROPERTY_KEYWORDS = "keywords";
    private List<String> keywords = new ArrayList<String>();
    public static final String JSON_PROPERTY_UNIQUE_ID = "uniqueId";
    private String uniqueId;
    public static final String JSON_PROPERTY_TWITTER_ACCOUNT = "twitterAccount";
    private String twitterAccount;
    public static final String JSON_PROPERTY_FACEBOOK_APP_ID = "facebookAppId";
    private String facebookAppId;
    public static final String JSON_PROPERTY_THEME = "theme";
    private ThemeEnum theme;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
    private InventoryTypeEnum inventoryType;
    public static final String JSON_PROPERTY_CHANNEL_INVENTORY_TYPE = "channelInventoryType";
    private ChannelInventoryTypeEnum channelInventoryType;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private String supplierIdentifier;
    public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
    private String channelInventoryIdentifier;
    public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS = "multimediaIdentifiers";
    private List<String> multimediaIdentifiers = new ArrayList<String>();
    public static final String JSON_PROPERTY_ANIMATE = "animate";
    private Boolean animate = false;
    public static final String JSON_PROPERTY_ANIMATE_DELAY = "animateDelay";
    private Integer animateDelay = -1;

    public SellerUrl identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public SellerUrl sellerIdentifier(UUID sellerIdentifier) {
        this.sellerIdentifier = sellerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Company identifier")
    @JsonProperty(value="sellerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getSellerIdentifier() {
        return this.sellerIdentifier;
    }

    @JsonProperty(value="sellerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSellerIdentifier(UUID sellerIdentifier) {
        this.sellerIdentifier = sellerIdentifier;
    }

    public SellerUrl sellerUrlName(String sellerUrlName) {
        this.sellerUrlName = sellerUrlName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="My Bali Villa", required=true, value="Descriptive name of this url for seller use only")
    @JsonProperty(value="sellerUrlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSellerUrlName() {
        return this.sellerUrlName;
    }

    @JsonProperty(value="sellerUrlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSellerUrlName(String sellerUrlName) {
        this.sellerUrlName = sellerUrlName;
    }

    public SellerUrl engineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Customization identifier")
    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getEngineConfigurationIdentifier() {
        return this.engineConfigurationIdentifier;
    }

    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEngineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    }

    public SellerUrl descriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public SellerUrl addDescriptionsItem(SimpleDescription descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="Localized link descriptions")
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<SimpleDescription> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
    }

    public SellerUrl keywords(List<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    public SellerUrl addKeywordsItem(String keywordsItem) {
        this.keywords.add(keywordsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(example="[\"bali\"]", required=true, value="Keywords")
    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=0x7FFFFFFF) List<String> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public SellerUrl uniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="HBDG87f2", value="Unique link id")
    @JsonProperty(value="uniqueId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUniqueId() {
        return this.uniqueId;
    }

    @JsonProperty(value="uniqueId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public SellerUrl twitterAccount(String twitterAccount) {
        this.twitterAccount = twitterAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="@travelikoworld", value="Twitter account is used with OpenGraph data")
    @JsonProperty(value="twitterAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTwitterAccount() {
        return this.twitterAccount;
    }

    @JsonProperty(value="twitterAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTwitterAccount(String twitterAccount) {
        this.twitterAccount = twitterAccount;
    }

    public SellerUrl facebookAppId(String facebookAppId) {
        this.facebookAppId = facebookAppId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="19827398721938798237", value="Facebook APP ID is used with OpenGraph data")
    @JsonProperty(value="facebookAppId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFacebookAppId() {
        return this.facebookAppId;
    }

    @JsonProperty(value="facebookAppId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFacebookAppId(String facebookAppId) {
        this.facebookAppId = facebookAppId;
    }

    public SellerUrl theme(ThemeEnum theme) {
        this.theme = theme;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="THEME_1", required=true, value="Url theme controls the look and feel of the ad banner.")
    @JsonProperty(value="theme")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ThemeEnum getTheme() {
        return this.theme;
    }

    @JsonProperty(value="theme")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTheme(ThemeEnum theme) {
        this.theme = theme;
    }

    public SellerUrl status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="ACTIVE", required=true, value="Url sell status")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public SellerUrl inventoryType(InventoryTypeEnum inventoryType) {
        this.inventoryType = inventoryType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="GUEST_ROOM", required=true, value="Inventory type")
    @JsonProperty(value="inventoryType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public InventoryTypeEnum getInventoryType() {
        return this.inventoryType;
    }

    @JsonProperty(value="inventoryType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInventoryType(InventoryTypeEnum inventoryType) {
        this.inventoryType = inventoryType;
    }

    public SellerUrl channelInventoryType(ChannelInventoryTypeEnum channelInventoryType) {
        this.channelInventoryType = channelInventoryType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="GUEST_ROOM", required=true, value="Channel inventory type is a subset of inventory type in that it does not include the `HOTEL` type. THe way it works is, as a seller you might want to sell a guest room but instead of showing the price of that guest room, you would like to display the best room type price for the property.")
    @JsonProperty(value="channelInventoryType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ChannelInventoryTypeEnum getChannelInventoryType() {
        return this.channelInventoryType;
    }

    @JsonProperty(value="channelInventoryType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChannelInventoryType(ChannelInventoryTypeEnum channelInventoryType) {
        this.channelInventoryType = channelInventoryType;
    }

    public SellerUrl supplierIdentifier(String supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="hotel-1", required=true, value="The entity supplying the inventory. Usually a hotel.")
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierIdentifier(String supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
    }

    public SellerUrl channelInventoryIdentifier(String channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="channel-inventory-1", required=true, value="Selected inventory record")
    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getChannelInventoryIdentifier() {
        return this.channelInventoryIdentifier;
    }

    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChannelInventoryIdentifier(String channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
    }

    public SellerUrl multimediaIdentifiers(List<String> multimediaIdentifiers) {
        this.multimediaIdentifiers = multimediaIdentifiers;
        return this;
    }

    public SellerUrl addMultimediaIdentifiersItem(String multimediaIdentifiersItem) {
        this.multimediaIdentifiers.add(multimediaIdentifiersItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(example="[\"cloudinary-image-1\"]", required=true, value="Cloudinary identifiers")
    @JsonProperty(value="multimediaIdentifiers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=0x7FFFFFFF) List<String> getMultimediaIdentifiers() {
        return this.multimediaIdentifiers;
    }

    @JsonProperty(value="multimediaIdentifiers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimediaIdentifiers(List<String> multimediaIdentifiers) {
        this.multimediaIdentifiers = multimediaIdentifiers;
    }

    public SellerUrl animate(Boolean animate) {
        this.animate = animate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Create an animated gif instead of a list of images")
    @JsonProperty(value="animate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAnimate() {
        return this.animate;
    }

    @JsonProperty(value="animate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnimate(Boolean animate) {
        this.animate = animate;
    }

    public SellerUrl animateDelay(Integer animateDelay) {
        this.animateDelay = animateDelay;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1000", value="Animation delay in milliseconds")
    @JsonProperty(value="animateDelay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAnimateDelay() {
        return this.animateDelay;
    }

    @JsonProperty(value="animateDelay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnimateDelay(Integer animateDelay) {
        this.animateDelay = animateDelay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SellerUrl sellerUrl = (SellerUrl)o;
        return Objects.equals(this.identifier, sellerUrl.identifier) && Objects.equals(this.sellerIdentifier, sellerUrl.sellerIdentifier) && Objects.equals(this.sellerUrlName, sellerUrl.sellerUrlName) && Objects.equals(this.engineConfigurationIdentifier, sellerUrl.engineConfigurationIdentifier) && Objects.equals(this.descriptions, sellerUrl.descriptions) && Objects.equals(this.keywords, sellerUrl.keywords) && Objects.equals(this.uniqueId, sellerUrl.uniqueId) && Objects.equals(this.twitterAccount, sellerUrl.twitterAccount) && Objects.equals(this.facebookAppId, sellerUrl.facebookAppId) && Objects.equals((Object)this.theme, (Object)sellerUrl.theme) && Objects.equals((Object)this.status, (Object)sellerUrl.status) && Objects.equals((Object)this.inventoryType, (Object)sellerUrl.inventoryType) && Objects.equals((Object)this.channelInventoryType, (Object)sellerUrl.channelInventoryType) && Objects.equals(this.supplierIdentifier, sellerUrl.supplierIdentifier) && Objects.equals(this.channelInventoryIdentifier, sellerUrl.channelInventoryIdentifier) && Objects.equals(this.multimediaIdentifiers, sellerUrl.multimediaIdentifiers) && Objects.equals(this.animate, sellerUrl.animate) && Objects.equals(this.animateDelay, sellerUrl.animateDelay);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.sellerIdentifier, this.sellerUrlName, this.engineConfigurationIdentifier, this.descriptions, this.keywords, this.uniqueId, this.twitterAccount, this.facebookAppId, this.theme, this.status, this.inventoryType, this.channelInventoryType, this.supplierIdentifier, this.channelInventoryIdentifier, this.multimediaIdentifiers, this.animate, this.animateDelay});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SellerUrl {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    sellerIdentifier: ").append(this.toIndentedString(this.sellerIdentifier)).append("\n");
        sb.append("    sellerUrlName: ").append(this.toIndentedString(this.sellerUrlName)).append("\n");
        sb.append("    engineConfigurationIdentifier: ").append(this.toIndentedString(this.engineConfigurationIdentifier)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    uniqueId: ").append(this.toIndentedString(this.uniqueId)).append("\n");
        sb.append("    twitterAccount: ").append(this.toIndentedString(this.twitterAccount)).append("\n");
        sb.append("    facebookAppId: ").append(this.toIndentedString(this.facebookAppId)).append("\n");
        sb.append("    theme: ").append(this.toIndentedString((Object)this.theme)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    inventoryType: ").append(this.toIndentedString((Object)this.inventoryType)).append("\n");
        sb.append("    channelInventoryType: ").append(this.toIndentedString((Object)this.channelInventoryType)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    channelInventoryIdentifier: ").append(this.toIndentedString(this.channelInventoryIdentifier)).append("\n");
        sb.append("    multimediaIdentifiers: ").append(this.toIndentedString(this.multimediaIdentifiers)).append("\n");
        sb.append("    animate: ").append(this.toIndentedString(this.animate)).append("\n");
        sb.append("    animateDelay: ").append(this.toIndentedString(this.animateDelay)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ThemeEnum {
        THEME_1("THEME_1");

        private String value;

        private ThemeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ThemeEnum fromValue(String value) {
            for (ThemeEnum b : ThemeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE"),
        REMOVED("REMOVED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum InventoryTypeEnum {
        HOTEL("HOTEL"),
        GUEST_ROOM("GUEST_ROOM"),
        MEETING_ROOM("MEETING_ROOM"),
        RESTAURANT("RESTAURANT"),
        SPA("SPA"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        ATTRACTION("ATTRACTION"),
        ACTIVITY("ACTIVITY"),
        PLACE("PLACE");

        private String value;

        private InventoryTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InventoryTypeEnum fromValue(String value) {
            for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChannelInventoryTypeEnum {
        GUEST_ROOM("GUEST_ROOM"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        MEETING_ROOM("MEETING_ROOM"),
        RESTAURANT("RESTAURANT"),
        SPA("SPA"),
        ATTRACTION("ATTRACTION"),
        PLACE("PLACE"),
        ACTIVITY("ACTIVITY");

        private String value;

        private ChannelInventoryTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChannelInventoryTypeEnum fromValue(String value) {
            for (ChannelInventoryTypeEnum b : ChannelInventoryTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

