/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.affiliate.model.Moneys;
import travel.wink.sdk.affiliate.model.SimpleDescription;
import travel.wink.sdk.affiliate.model.SimpleMultimedia;

@ApiModel(description="This is one bookable unit that can stand alongside a restaurant / meeting room etc.")
@JsonPropertyOrder(value={"identifier", "name", "descriptions", "pricingType", "basePrice", "discountedPrice", "multimedias", "minPax", "maxPax"})
public class TransactionalTravelInventory {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescription> descriptions = new ArrayList<SimpleDescription>();
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_BASE_PRICE = "basePrice";
    private Moneys basePrice;
    public static final String JSON_PROPERTY_DISCOUNTED_PRICE = "discountedPrice";
    private Moneys discountedPrice;
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    private List<SimpleMultimedia> multimedias = new ArrayList<SimpleMultimedia>();
    public static final String JSON_PROPERTY_MIN_PAX = "minPax";
    private Integer minPax;
    public static final String JSON_PROPERTY_MAX_PAX = "maxPax";
    private Integer maxPax;

    public TransactionalTravelInventory identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Unique transactional identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public TransactionalTravelInventory name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="1 hour session", required=true, value="Internal name of transactional inventory.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public TransactionalTravelInventory descriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public TransactionalTravelInventory addDescriptionsItem(SimpleDescription descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="Localized descriptions describing inventory.")
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<SimpleDescription> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
    }

    public TransactionalTravelInventory pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="How this inventory item should be priced.")
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public TransactionalTravelInventory basePrice(Moneys basePrice) {
        this.basePrice = basePrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="basePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getBasePrice() {
        return this.basePrice;
    }

    @JsonProperty(value="basePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBasePrice(Moneys basePrice) {
        this.basePrice = basePrice;
    }

    public TransactionalTravelInventory discountedPrice(Moneys discountedPrice) {
        this.discountedPrice = discountedPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="discountedPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getDiscountedPrice() {
        return this.discountedPrice;
    }

    @JsonProperty(value="discountedPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDiscountedPrice(Moneys discountedPrice) {
        this.discountedPrice = discountedPrice;
    }

    public TransactionalTravelInventory multimedias(List<SimpleMultimedia> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public TransactionalTravelInventory addMultimediasItem(SimpleMultimedia multimediasItem) {
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="List of images / videos of item.")
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleMultimedia> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimedias(List<SimpleMultimedia> multimedias) {
        this.multimedias = multimedias;
    }

    public TransactionalTravelInventory minPax(Integer minPax) {
        this.minPax = minPax;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="Whether there is a limit to minimum group size.")
    @JsonProperty(value="minPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinPax() {
        return this.minPax;
    }

    @JsonProperty(value="minPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinPax(Integer minPax) {
        this.minPax = minPax;
    }

    public TransactionalTravelInventory maxPax(Integer maxPax) {
        this.maxPax = maxPax;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Whether there is a limit to maximum group size.")
    @JsonProperty(value="maxPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxPax() {
        return this.maxPax;
    }

    @JsonProperty(value="maxPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxPax(Integer maxPax) {
        this.maxPax = maxPax;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionalTravelInventory transactionalTravelInventory = (TransactionalTravelInventory)o;
        return Objects.equals(this.identifier, transactionalTravelInventory.identifier) && Objects.equals(this.name, transactionalTravelInventory.name) && Objects.equals(this.descriptions, transactionalTravelInventory.descriptions) && Objects.equals((Object)this.pricingType, (Object)transactionalTravelInventory.pricingType) && Objects.equals(this.basePrice, transactionalTravelInventory.basePrice) && Objects.equals(this.discountedPrice, transactionalTravelInventory.discountedPrice) && Objects.equals(this.multimedias, transactionalTravelInventory.multimedias) && Objects.equals(this.minPax, transactionalTravelInventory.minPax) && Objects.equals(this.maxPax, transactionalTravelInventory.maxPax);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.name, this.descriptions, this.pricingType, this.basePrice, this.discountedPrice, this.multimedias, this.minPax, this.maxPax});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionalTravelInventory {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    basePrice: ").append(this.toIndentedString(this.basePrice)).append("\n");
        sb.append("    discountedPrice: ").append(this.toIndentedString(this.discountedPrice)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    minPax: ").append(this.toIndentedString(this.minPax)).append("\n");
        sb.append("    maxPax: ").append(this.toIndentedString(this.maxPax)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        PERSON_PER_USE("PER_PERSON_PER_USE"),
        USE("PER_USE"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        HOUR("PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

