package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.AddStaticSellerListItemRequestAffiliate;
import travel.wink.sdk.affiliate.model.BooleanResponseAffiliate;
import travel.wink.sdk.affiliate.model.CopyMoveStaticSellerListItemRequestAffiliate;
import travel.wink.sdk.affiliate.model.CreateStaticSellerListAndAddItemRequestAffiliate;
import travel.wink.sdk.affiliate.model.DynamicSellerListViewAffiliate;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.SellerInventoryListAffiliate;
import travel.wink.sdk.affiliate.model.SellerInventoryListViewAffiliate;
import travel.wink.sdk.affiliate.model.SellerInventoryRankedListAffiliate;
import travel.wink.sdk.affiliate.model.SellerInventoryRankedListViewAffiliate;
import travel.wink.sdk.affiliate.model.ShowSellerUrl400Response;
import travel.wink.sdk.affiliate.model.SortStaticSellerListItemsRequestAffiliate;
import travel.wink.sdk.affiliate.model.StaticSellerListAffiliate;
import travel.wink.sdk.affiliate.model.StaticSellerListItemViewAffiliate;
import travel.wink.sdk.affiliate.model.StaticSellerListWrapperAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-06T16:56:30.815925180+07:00[Asia/Bangkok]")
public class InventoryGridsApi {
    private ApiClient apiClient;

    public InventoryGridsApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryGridsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add Item to List
     * Add some travel inventory to your existing curated list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Add inventory to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param addStaticSellerListItemRequestAffiliate The addStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec addInventoryToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequestAffiliate addStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = addStaticSellerListItemRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addStaticSellerListItemRequestAffiliate' is set
        if (addStaticSellerListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'addStaticSellerListItemRequestAffiliate' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Item to List
     * Add some travel inventory to your existing curated list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Add inventory to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param addStaticSellerListItemRequestAffiliate The addStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListItemViewAffiliate> addInventoryToCuratedList(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequestAffiliate addStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return addInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListItemRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> addInventoryToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequestAffiliate addStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return addInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListItemRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Copy Item to List
     * Copy an existing list item from one list to another.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Copy inventory to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequestAffiliate The copyMoveStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec copyInventoryToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = copyMoveStaticSellerListItemRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'itemIdentifier' is set
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'copyMoveStaticSellerListItemRequestAffiliate' is set
        if (copyMoveStaticSellerListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticSellerListItemRequestAffiliate' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Copy Item to List
     * Copy an existing list item from one list to another.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Copy inventory to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequestAffiliate The copyMoveStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListItemViewAffiliate> copyInventoryToCuratedList(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return copyInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> copyInventoryToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return copyInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create curated list owned by this owner identifier.
     * @param createStaticSellerListAndAddItemRequestAffiliate The createStaticSellerListAndAddItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createCuratedListRequestCreation(String companyIdentifier, CreateStaticSellerListAndAddItemRequestAffiliate createStaticSellerListAndAddItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = createStaticSellerListAndAddItemRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createStaticSellerListAndAddItemRequestAffiliate' is set
        if (createStaticSellerListAndAddItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStaticSellerListAndAddItemRequestAffiliate' when calling createCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create curated list owned by this owner identifier.
     * @param createStaticSellerListAndAddItemRequestAffiliate The createStaticSellerListAndAddItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListWrapperAffiliate> createCuratedList(String companyIdentifier, CreateStaticSellerListAndAddItemRequestAffiliate createStaticSellerListAndAddItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return createCuratedListRequestCreation(companyIdentifier, createStaticSellerListAndAddItemRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListWrapperAffiliate>> createCuratedListWithHttpInfo(String companyIdentifier, CreateStaticSellerListAndAddItemRequestAffiliate createStaticSellerListAndAddItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return createCuratedListRequestCreation(companyIdentifier, createStaticSellerListAndAddItemRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Create Grid
     * Create a new curated / saved search list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create list owned by this owner identifier.
     * @param sellerInventoryListAffiliate The sellerInventoryListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSellerInventoryListRequestCreation(String companyIdentifier, SellerInventoryListAffiliate sellerInventoryListAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = sellerInventoryListAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerInventoryListAffiliate' is set
        if (sellerInventoryListAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerInventoryListAffiliate' when calling createSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Grid
     * Create a new curated / saved search list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create list owned by this owner identifier.
     * @param sellerInventoryListAffiliate The sellerInventoryListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryListViewAffiliate> createSellerInventoryList(String companyIdentifier, SellerInventoryListAffiliate sellerInventoryListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>() {};
        return createSellerInventoryListRequestCreation(companyIdentifier, sellerInventoryListAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListViewAffiliate>> createSellerInventoryListWithHttpInfo(String companyIdentifier, SellerInventoryListAffiliate sellerInventoryListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>() {};
        return createSellerInventoryListRequestCreation(companyIdentifier, sellerInventoryListAffiliate, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Create Ranked Grid
     * Create a new ranked grid
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create list owned by this owner identifier.
     * @param sellerInventoryRankedListAffiliate The sellerInventoryRankedListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryRankedListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSellerInventoryRankedListRequestCreation(String companyIdentifier, SellerInventoryRankedListAffiliate sellerInventoryRankedListAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = sellerInventoryRankedListAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerInventoryRankedListAffiliate' is set
        if (sellerInventoryRankedListAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerInventoryRankedListAffiliate' when calling createSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Ranked Grid
     * Create a new ranked grid
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create list owned by this owner identifier.
     * @param sellerInventoryRankedListAffiliate The sellerInventoryRankedListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryRankedListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryRankedListViewAffiliate> createSellerInventoryRankedList(String companyIdentifier, SellerInventoryRankedListAffiliate sellerInventoryRankedListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>() {};
        return createSellerInventoryRankedListRequestCreation(companyIdentifier, sellerInventoryRankedListAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRankedListViewAffiliate>> createSellerInventoryRankedListWithHttpInfo(String companyIdentifier, SellerInventoryRankedListAffiliate sellerInventoryRankedListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>() {};
        return createSellerInventoryRankedListRequestCreation(companyIdentifier, sellerInventoryRankedListAffiliate, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Move List Item
     * Move an existing list item from one list to another.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Move inventory to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequestAffiliate The copyMoveStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec moveInventoryToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = copyMoveStaticSellerListItemRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'itemIdentifier' is set
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'copyMoveStaticSellerListItemRequestAffiliate' is set
        if (copyMoveStaticSellerListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticSellerListItemRequestAffiliate' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Move List Item
     * Move an existing list item from one list to another.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Move inventory to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequestAffiliate The copyMoveStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListItemViewAffiliate> moveInventoryToCuratedList(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return moveInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> moveInventoryToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return moveInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Remove Curated List
     * Remove curated list by list identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Curated List
     * Remove curated list by list identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeCuratedList(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeCuratedListRequestCreation(companyIdentifier, listIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeCuratedListRequestCreation(companyIdentifier, listIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Delete List Item
     * Delete a list item from a curated list by its unique identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove inventory from curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeInventoryFromCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String itemIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'itemIdentifier' is set
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete List Item
     * Delete a list item from a curated list by its unique identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove inventory from curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeInventoryFromCuratedList(String companyIdentifier, String listIdentifier, String itemIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeInventoryFromCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeInventoryFromCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String itemIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeInventoryFromCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Delete Grid
     * Remove a curated / saved search list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Update list owned by this owner identifier.
     * @param listIdentifier Delete curated list with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSellerInventoryListRequestCreation(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/{listIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Grid
     * Remove a curated / saved search list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Update list owned by this owner identifier.
     * @param listIdentifier Delete curated list with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeSellerInventoryList(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeSellerInventoryListWithHttpInfo(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Delete Ranked Grid
     * Delete a ranked grid
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove grid owned by this owner identifier.
     * @param listIdentifier Delete grid with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSellerInventoryRankedListRequestCreation(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/{listIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Ranked Grid
     * Delete a ranked grid
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove grid owned by this owner identifier.
     * @param listIdentifier Delete grid with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeSellerInventoryRankedList(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeSellerInventoryRankedListWithHttpInfo(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Curated Lists
     * Retrieve lists optionally with content.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show curated lists owned by this owner identifier.
     * @param withItems Indicate whether to include all the list items in the result
     * @param winkVersion The winkVersion parameter
     * @return List&lt;StaticSellerListWrapperAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCuratedListsRequestCreation(String companyIdentifier, Boolean withItems, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCuratedLists", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "withItems", withItems));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Curated Lists
     * Retrieve lists optionally with content.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show curated lists owned by this owner identifier.
     * @param withItems Indicate whether to include all the list items in the result
     * @param winkVersion The winkVersion parameter
     * @return List&lt;StaticSellerListWrapperAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<StaticSellerListWrapperAffiliate> showCuratedLists(String companyIdentifier, Boolean withItems, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return showCuratedListsRequestCreation(companyIdentifier, withItems, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<StaticSellerListWrapperAffiliate>>> showCuratedListsWithHttpInfo(String companyIdentifier, Boolean withItems, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return showCuratedListsRequestCreation(companyIdentifier, withItems, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Show Saved Searches
     * Retrieve all saved searches for owner
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List searches owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;DynamicSellerListViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSavedSearchesRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSavedSearches", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<DynamicSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/dynamic/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Saved Searches
     * Retrieve all saved searches for owner
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List searches owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;DynamicSellerListViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<DynamicSellerListViewAffiliate> showSavedSearches(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListViewAffiliate>() {};
        return showSavedSearchesRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<DynamicSellerListViewAffiliate>>> showSavedSearchesWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListViewAffiliate>() {};
        return showSavedSearchesRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Show Grid
     * Retrieve a specific curated / saved search list.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show seller inventory lists owned by this owner identifier.
     * @param listIdentifier Retrieve list with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerInventoryListRequestCreation(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/{listIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Grid
     * Retrieve a specific curated / saved search list.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show seller inventory lists owned by this owner identifier.
     * @param listIdentifier Retrieve list with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryListViewAffiliate> showSellerInventoryList(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>() {};
        return showSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListViewAffiliate>> showSellerInventoryListWithHttpInfo(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>() {};
        return showSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Grids
     * Retrieve curated / saved search list lists.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show seller inventory lists owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SellerInventoryListViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerInventoryListsRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryLists", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Grids
     * Retrieve curated / saved search list lists.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show seller inventory lists owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SellerInventoryListViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SellerInventoryListViewAffiliate> showSellerInventoryLists(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>() {};
        return showSellerInventoryListsRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellerInventoryListViewAffiliate>>> showSellerInventoryListsWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>() {};
        return showSellerInventoryListsRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Show Ranked Grid
     * Retrieve a specific ranked grid.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve grid for owner identifier.
     * @param listIdentifier Retrieve grid with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryRankedListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerInventoryRankedListRequestCreation(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/{listIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Ranked Grid
     * Retrieve a specific ranked grid.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve grid for owner identifier.
     * @param listIdentifier Retrieve grid with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryRankedListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryRankedListViewAffiliate> showSellerInventoryRankedList(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>() {};
        return showSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRankedListViewAffiliate>> showSellerInventoryRankedListWithHttpInfo(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>() {};
        return showSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Ranked Grids
     * Retrieve list of ranked grids.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve list for owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SellerInventoryRankedListViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerInventoryRankedListsRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryRankedLists", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Ranked Grids
     * Retrieve list of ranked grids.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve list for owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SellerInventoryRankedListViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SellerInventoryRankedListViewAffiliate> showSellerInventoryRankedLists(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>() {};
        return showSellerInventoryRankedListsRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellerInventoryRankedListViewAffiliate>>> showSellerInventoryRankedListsWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>() {};
        return showSellerInventoryRankedListsRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Re-Order List Items
     * Re-order list items with an existing list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Sort curated list items owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param sortStaticSellerListItemsRequestAffiliate The sortStaticSellerListItemsRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec sortCuratedListItemsRequestCreation(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequestAffiliate sortStaticSellerListItemsRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = sortStaticSellerListItemsRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sortStaticSellerListItemsRequestAffiliate' is set
        if (sortStaticSellerListItemsRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'sortStaticSellerListItemsRequestAffiliate' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/sort", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Re-Order List Items
     * Re-order list items with an existing list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Sort curated list items owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param sortStaticSellerListItemsRequestAffiliate The sortStaticSellerListItemsRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BooleanResponseAffiliate> sortCuratedListItems(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequestAffiliate sortStaticSellerListItemsRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>() {};
        return sortCuratedListItemsRequestCreation(companyIdentifier, listIdentifier, sortStaticSellerListItemsRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseAffiliate>> sortCuratedListItemsWithHttpInfo(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequestAffiliate sortStaticSellerListItemsRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>() {};
        return sortCuratedListItemsRequestCreation(companyIdentifier, listIdentifier, sortStaticSellerListItemsRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Update Curated List
     * Update curated list by its unique identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param staticSellerListAffiliate The staticSellerListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCuratedListRequestCreation(String companyIdentifier, String listIdentifier, StaticSellerListAffiliate staticSellerListAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = staticSellerListAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'staticSellerListAffiliate' is set
        if (staticSellerListAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'staticSellerListAffiliate' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Curated List
     * Update curated list by its unique identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param staticSellerListAffiliate The staticSellerListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListWrapperAffiliate> updateCuratedList(String companyIdentifier, String listIdentifier, StaticSellerListAffiliate staticSellerListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return updateCuratedListRequestCreation(companyIdentifier, listIdentifier, staticSellerListAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListWrapperAffiliate>> updateCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, StaticSellerListAffiliate staticSellerListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return updateCuratedListRequestCreation(companyIdentifier, listIdentifier, staticSellerListAffiliate, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Update Grid
     * Update an existing curated / saved search list.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update list owned by this owner identifier.
     * @param listIdentifier Update list with this identifier.
     * @param sellerInventoryListAffiliate The sellerInventoryListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateSellerInventoryListRequestCreation(String companyIdentifier, String listIdentifier, SellerInventoryListAffiliate sellerInventoryListAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = sellerInventoryListAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerInventoryListAffiliate' is set
        if (sellerInventoryListAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerInventoryListAffiliate' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/{listIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Grid
     * Update an existing curated / saved search list.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update list owned by this owner identifier.
     * @param listIdentifier Update list with this identifier.
     * @param sellerInventoryListAffiliate The sellerInventoryListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryListViewAffiliate> updateSellerInventoryList(String companyIdentifier, String listIdentifier, SellerInventoryListAffiliate sellerInventoryListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>() {};
        return updateSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, sellerInventoryListAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListViewAffiliate>> updateSellerInventoryListWithHttpInfo(String companyIdentifier, String listIdentifier, SellerInventoryListAffiliate sellerInventoryListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>() {};
        return updateSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, sellerInventoryListAffiliate, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Update Ranked Grid
     * Update existing ranked grid
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update list owned by this owner identifier.
     * @param listIdentifier Update list with this identifier.
     * @param sellerInventoryRankedListAffiliate The sellerInventoryRankedListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryRankedListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateSellerInventoryRankedListRequestCreation(String companyIdentifier, String listIdentifier, SellerInventoryRankedListAffiliate sellerInventoryRankedListAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = sellerInventoryRankedListAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerInventoryRankedListAffiliate' is set
        if (sellerInventoryRankedListAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerInventoryRankedListAffiliate' when calling updateSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/{listIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Ranked Grid
     * Update existing ranked grid
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update list owned by this owner identifier.
     * @param listIdentifier Update list with this identifier.
     * @param sellerInventoryRankedListAffiliate The sellerInventoryRankedListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryRankedListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryRankedListViewAffiliate> updateSellerInventoryRankedList(String companyIdentifier, String listIdentifier, SellerInventoryRankedListAffiliate sellerInventoryRankedListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>() {};
        return updateSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, sellerInventoryRankedListAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRankedListViewAffiliate>> updateSellerInventoryRankedListWithHttpInfo(String companyIdentifier, String listIdentifier, SellerInventoryRankedListAffiliate sellerInventoryRankedListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>() {};
        return updateSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, sellerInventoryRankedListAffiliate, winkVersion).toEntity(localVarReturnType);
    }
}
