/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.CountryAffiliate;
import travel.wink.sdk.affiliate.model.DynamicSellerListRequestAffiliate;
import travel.wink.sdk.affiliate.model.GeoNameAffiliate;
import travel.wink.sdk.affiliate.model.InventoryViewAffiliate;
import travel.wink.sdk.affiliate.model.PageInventoryViewAffiliate;

public class DiscoverApi {
    private ApiClient apiClient;

    public DiscoverApi() {
        this(new ApiClient());
    }

    @Autowired
    public DiscoverApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showCitiesForInventoryRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCitiesForInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/city/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GeoNameAffiliate> showCitiesForInventory(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>(){};
        return this.showCitiesForInventoryRequestCreation(companyIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoNameAffiliate>>> showCitiesForInventoryWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>(){};
        return this.showCitiesForInventoryRequestCreation(companyIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showCountriesForInventoryRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCountriesForInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<CountryAffiliate> showCountriesForInventory(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>(){};
        return this.showCountriesForInventoryRequestCreation(companyIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<CountryAffiliate>>> showCountriesForInventoryWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>(){};
        return this.showCountriesForInventoryRequestCreation(companyIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showDynamicSellerInventoryRequestCreation(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        DynamicSellerListRequestAffiliate postBody = dynamicSellerListRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dynamicSellerListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicSellerListRequestAffiliate' when calling showDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventoryViewAffiliate> showDynamicSellerInventory(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(){};
        return this.showDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventoryViewAffiliate>> showDynamicSellerInventoryWithHttpInfo(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(){};
        return this.showDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showDynamicSellerInventoryByIdRequestCreation(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showDynamicSellerInventoryById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dynamicListIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicListIdentifier' when calling showDynamicSellerInventoryById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("dynamicListIdentifier", dynamicListIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/grid/{dynamicListIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventoryViewAffiliate> showDynamicSellerInventoryById(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(){};
        return this.showDynamicSellerInventoryByIdRequestCreation(companyIdentifier, dynamicListIdentifier, page, size, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventoryViewAffiliate>> showDynamicSellerInventoryByIdWithHttpInfo(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(){};
        return this.showDynamicSellerInventoryByIdRequestCreation(companyIdentifier, dynamicListIdentifier, page, size, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showLatestInventoryRequestCreation(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showLatestInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InventoryViewAffiliate> showLatestInventory(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryViewAffiliate>(){};
        return this.showLatestInventoryRequestCreation(companyIdentifier, page, size, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventoryViewAffiliate>>> showLatestInventoryWithHttpInfo(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryViewAffiliate>(){};
        return this.showLatestInventoryRequestCreation(companyIdentifier, page, size, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }
}

