/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.affiliate.model.AddressAffiliate;
import travel.wink.sdk.affiliate.model.BookingAncillaryAffiliate;
import travel.wink.sdk.affiliate.model.BookingContractAffiliate;
import travel.wink.sdk.affiliate.model.BookingUserAffiliate;
import travel.wink.sdk.affiliate.model.CommissionableEntryAffiliate;
import travel.wink.sdk.affiliate.model.ContactAffiliate;
import travel.wink.sdk.affiliate.model.EngineConfigurationBookingReportAffiliate;
import travel.wink.sdk.affiliate.model.HotelOnMapAffiliate;
import travel.wink.sdk.affiliate.model.MoneysAffiliate;
import travel.wink.sdk.affiliate.model.ReviewAffiliate;
import travel.wink.sdk.affiliate.model.RoomStayAffiliate;
import travel.wink.sdk.affiliate.model.SocialAffiliate;
import travel.wink.sdk.affiliate.model.UserSessionAffiliate;

@ApiModel(description="Booking data object")
@JsonPropertyOrder(value={"test", "date", "groupIdentifier", "identifier", "engineConfiguration", "bookingCode", "user", "userSession", "serverUrl", "contactInfo", "address", "socials", "review", "emailHeaderLogoUrl", "logoIdentifier", "hotel", "roomStay", "specialRequests", "comment", "earlyCheckInCharge", "lateCheckOutCharge", "earlyCheckInChargePercent", "lateCheckOutChargePercent", "hotelImageUrl", "roomImageUrl", "commissionList", "ancillaryList", "bookingContract", "status", "meetingRooms", "restaurants", "spas", "activities", "attractions", "fullAddress", "places", "roomTypeAncillaries", "addOns", "hasBreakfast", "hasBrunch", "hasLunch", "hasDinner", "hasAllInclusive", "hasAllInclusivePlusAlcohol", "rateSource", "hasAddOns", "hasRoomTypeAncillaries", "hasFood", "hasRestaurants", "hasMeetingRooms", "hasSpas", "hasActivities", "hasAttractions", "hasPlaces"})
@JsonTypeName(value="Booking_Affiliate")
public class BookingAffiliate {
    public static final String JSON_PROPERTY_TEST = "test";
    private Boolean test = false;
    public static final String JSON_PROPERTY_DATE = "date";
    private LocalDateTime date;
    public static final String JSON_PROPERTY_GROUP_IDENTIFIER = "groupIdentifier";
    private UUID groupIdentifier;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_ENGINE_CONFIGURATION = "engineConfiguration";
    private EngineConfigurationBookingReportAffiliate engineConfiguration;
    public static final String JSON_PROPERTY_BOOKING_CODE = "bookingCode";
    private String bookingCode;
    public static final String JSON_PROPERTY_USER = "user";
    private BookingUserAffiliate user;
    public static final String JSON_PROPERTY_USER_SESSION = "userSession";
    private UserSessionAffiliate userSession;
    public static final String JSON_PROPERTY_SERVER_URL = "serverUrl";
    private String serverUrl;
    public static final String JSON_PROPERTY_CONTACT_INFO = "contactInfo";
    private ContactAffiliate contactInfo;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private AddressAffiliate address;
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    private List<SocialAffiliate> socials = null;
    public static final String JSON_PROPERTY_REVIEW = "review";
    private ReviewAffiliate review;
    public static final String JSON_PROPERTY_EMAIL_HEADER_LOGO_URL = "emailHeaderLogoUrl";
    private String emailHeaderLogoUrl;
    public static final String JSON_PROPERTY_LOGO_IDENTIFIER = "logoIdentifier";
    private String logoIdentifier;
    public static final String JSON_PROPERTY_HOTEL = "hotel";
    private HotelOnMapAffiliate hotel;
    public static final String JSON_PROPERTY_ROOM_STAY = "roomStay";
    private RoomStayAffiliate roomStay;
    public static final String JSON_PROPERTY_SPECIAL_REQUESTS = "specialRequests";
    private String specialRequests;
    public static final String JSON_PROPERTY_COMMENT = "comment";
    private String comment;
    public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE = "earlyCheckInCharge";
    private MoneysAffiliate earlyCheckInCharge;
    public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE = "lateCheckOutCharge";
    private MoneysAffiliate lateCheckOutCharge;
    public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT = "earlyCheckInChargePercent";
    private Float earlyCheckInChargePercent;
    public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT = "lateCheckOutChargePercent";
    private Float lateCheckOutChargePercent;
    public static final String JSON_PROPERTY_HOTEL_IMAGE_URL = "hotelImageUrl";
    private String hotelImageUrl;
    public static final String JSON_PROPERTY_ROOM_IMAGE_URL = "roomImageUrl";
    private String roomImageUrl;
    public static final String JSON_PROPERTY_COMMISSION_LIST = "commissionList";
    private List<CommissionableEntryAffiliate> commissionList = null;
    public static final String JSON_PROPERTY_ANCILLARY_LIST = "ancillaryList";
    private List<BookingAncillaryAffiliate> ancillaryList = null;
    public static final String JSON_PROPERTY_BOOKING_CONTRACT = "bookingContract";
    private BookingContractAffiliate bookingContract;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_MEETING_ROOMS = "meetingRooms";
    private List<BookingAncillaryAffiliate> meetingRooms = null;
    public static final String JSON_PROPERTY_RESTAURANTS = "restaurants";
    private List<BookingAncillaryAffiliate> restaurants = null;
    public static final String JSON_PROPERTY_SPAS = "spas";
    private List<BookingAncillaryAffiliate> spas = null;
    public static final String JSON_PROPERTY_ACTIVITIES = "activities";
    private List<BookingAncillaryAffiliate> activities = null;
    public static final String JSON_PROPERTY_ATTRACTIONS = "attractions";
    private List<BookingAncillaryAffiliate> attractions = null;
    public static final String JSON_PROPERTY_FULL_ADDRESS = "fullAddress";
    private String fullAddress;
    public static final String JSON_PROPERTY_PLACES = "places";
    private List<BookingAncillaryAffiliate> places = null;
    public static final String JSON_PROPERTY_ROOM_TYPE_ANCILLARIES = "roomTypeAncillaries";
    private List<BookingAncillaryAffiliate> roomTypeAncillaries = null;
    public static final String JSON_PROPERTY_ADD_ONS = "addOns";
    private List<BookingAncillaryAffiliate> addOns = null;
    public static final String JSON_PROPERTY_HAS_BREAKFAST = "hasBreakfast";
    private Boolean hasBreakfast;
    public static final String JSON_PROPERTY_HAS_BRUNCH = "hasBrunch";
    private Boolean hasBrunch;
    public static final String JSON_PROPERTY_HAS_LUNCH = "hasLunch";
    private Boolean hasLunch;
    public static final String JSON_PROPERTY_HAS_DINNER = "hasDinner";
    private Boolean hasDinner;
    public static final String JSON_PROPERTY_HAS_ALL_INCLUSIVE = "hasAllInclusive";
    private Boolean hasAllInclusive;
    public static final String JSON_PROPERTY_HAS_ALL_INCLUSIVE_PLUS_ALCOHOL = "hasAllInclusivePlusAlcohol";
    private Boolean hasAllInclusivePlusAlcohol;
    public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
    private String rateSource;
    public static final String JSON_PROPERTY_HAS_ADD_ONS = "hasAddOns";
    private Boolean hasAddOns;
    public static final String JSON_PROPERTY_HAS_ROOM_TYPE_ANCILLARIES = "hasRoomTypeAncillaries";
    private Boolean hasRoomTypeAncillaries;
    public static final String JSON_PROPERTY_HAS_FOOD = "hasFood";
    private Boolean hasFood;
    public static final String JSON_PROPERTY_HAS_RESTAURANTS = "hasRestaurants";
    private Boolean hasRestaurants;
    public static final String JSON_PROPERTY_HAS_MEETING_ROOMS = "hasMeetingRooms";
    private Boolean hasMeetingRooms;
    public static final String JSON_PROPERTY_HAS_SPAS = "hasSpas";
    private Boolean hasSpas;
    public static final String JSON_PROPERTY_HAS_ACTIVITIES = "hasActivities";
    private Boolean hasActivities;
    public static final String JSON_PROPERTY_HAS_ATTRACTIONS = "hasAttractions";
    private Boolean hasAttractions;
    public static final String JSON_PROPERTY_HAS_PLACES = "hasPlaces";
    private Boolean hasPlaces;

    public BookingAffiliate test(Boolean test) {
        this.test = test;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Whether this was a test booking by the property than can safely be deleted again")
    @JsonProperty(value="test")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getTest() {
        return this.test;
    }

    @JsonProperty(value="test")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTest(Boolean test) {
        this.test = test;
    }

    public BookingAffiliate date(LocalDateTime date) {
        this.date = date;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time the booking was made.")
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDate(LocalDateTime date) {
        this.date = date;
    }

    public BookingAffiliate groupIdentifier(UUID groupIdentifier) {
        this.groupIdentifier = groupIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Unique record identifier for the collection of bookings that were made at the same time.")
    @JsonProperty(value="groupIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getGroupIdentifier() {
        return this.groupIdentifier;
    }

    @JsonProperty(value="groupIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGroupIdentifier(UUID groupIdentifier) {
        this.groupIdentifier = groupIdentifier;
    }

    public BookingAffiliate identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Unique record identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public BookingAffiliate engineConfiguration(EngineConfigurationBookingReportAffiliate engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="engineConfiguration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EngineConfigurationBookingReportAffiliate getEngineConfiguration() {
        return this.engineConfiguration;
    }

    @JsonProperty(value="engineConfiguration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEngineConfiguration(EngineConfigurationBookingReportAffiliate engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
    }

    public BookingAffiliate bookingCode(String bookingCode) {
        this.bookingCode = bookingCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="ABC1234", required=true, value="Unique user-friendly booking geoname. This code should be used when corresponding with travelers.")
    @JsonProperty(value="bookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBookingCode() {
        return this.bookingCode;
    }

    @JsonProperty(value="bookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookingCode(String bookingCode) {
        this.bookingCode = bookingCode;
    }

    public BookingAffiliate user(BookingUserAffiliate user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookingUserAffiliate getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(BookingUserAffiliate user) {
        this.user = user;
    }

    public BookingAffiliate userSession(UserSessionAffiliate userSession) {
        this.userSession = userSession;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UserSessionAffiliate getUserSession() {
        return this.userSession;
    }

    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserSession(UserSessionAffiliate userSession) {
        this.userSession = userSession;
    }

    public BookingAffiliate serverUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="The URL the booking occurred")
    @JsonProperty(value="serverUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getServerUrl() {
        return this.serverUrl;
    }

    @JsonProperty(value="serverUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public BookingAffiliate contactInfo(ContactAffiliate contactInfo) {
        this.contactInfo = contactInfo;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="contactInfo")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactAffiliate getContactInfo() {
        return this.contactInfo;
    }

    @JsonProperty(value="contactInfo")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContactInfo(ContactAffiliate contactInfo) {
        this.contactInfo = contactInfo;
    }

    public BookingAffiliate address(AddressAffiliate address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AddressAffiliate getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(AddressAffiliate address) {
        this.address = address;
    }

    public BookingAffiliate socials(List<SocialAffiliate> socials) {
        this.socials = socials;
        return this;
    }

    public BookingAffiliate addSocialsItem(SocialAffiliate socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<SocialAffiliate>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="List of all social network account property has for the traveler to get in touch.")
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SocialAffiliate> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(List<SocialAffiliate> socials) {
        this.socials = socials;
    }

    public BookingAffiliate review(ReviewAffiliate review) {
        this.review = review;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="review")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReviewAffiliate getReview() {
        return this.review;
    }

    @JsonProperty(value="review")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReview(ReviewAffiliate review) {
        this.review = review;
    }

    public BookingAffiliate emailHeaderLogoUrl(String emailHeaderLogoUrl) {
        this.emailHeaderLogoUrl = emailHeaderLogoUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Full url of the image logo optimized for emails")
    @JsonProperty(value="emailHeaderLogoUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmailHeaderLogoUrl() {
        return this.emailHeaderLogoUrl;
    }

    @JsonProperty(value="emailHeaderLogoUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmailHeaderLogoUrl(String emailHeaderLogoUrl) {
        this.emailHeaderLogoUrl = emailHeaderLogoUrl;
    }

    public BookingAffiliate logoIdentifier(String logoIdentifier) {
        this.logoIdentifier = logoIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Logo cloudinary identifier for potential reuse")
    @JsonProperty(value="logoIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogoIdentifier() {
        return this.logoIdentifier;
    }

    @JsonProperty(value="logoIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogoIdentifier(String logoIdentifier) {
        this.logoIdentifier = logoIdentifier;
    }

    public BookingAffiliate hotel(HotelOnMapAffiliate hotel) {
        this.hotel = hotel;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="hotel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public HotelOnMapAffiliate getHotel() {
        return this.hotel;
    }

    @JsonProperty(value="hotel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotel(HotelOnMapAffiliate hotel) {
        this.hotel = hotel;
    }

    public BookingAffiliate roomStay(RoomStayAffiliate roomStay) {
        this.roomStay = roomStay;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="roomStay")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RoomStayAffiliate getRoomStay() {
        return this.roomStay;
    }

    @JsonProperty(value="roomStay")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomStay(RoomStayAffiliate roomStay) {
        this.roomStay = roomStay;
    }

    public BookingAffiliate specialRequests(String specialRequests) {
        this.specialRequests = specialRequests;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Free text where the traveler can add a message to the property.")
    @JsonProperty(value="specialRequests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSpecialRequests() {
        return this.specialRequests;
    }

    @JsonProperty(value="specialRequests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpecialRequests(String specialRequests) {
        this.specialRequests = specialRequests;
    }

    public BookingAffiliate comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Internal comment field the payment can add and make available to channel manager partners.")
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComment(String comment) {
        this.comment = comment;
    }

    public BookingAffiliate earlyCheckInCharge(MoneysAffiliate earlyCheckInCharge) {
        this.earlyCheckInCharge = earlyCheckInCharge;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="earlyCheckInCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysAffiliate getEarlyCheckInCharge() {
        return this.earlyCheckInCharge;
    }

    @JsonProperty(value="earlyCheckInCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEarlyCheckInCharge(MoneysAffiliate earlyCheckInCharge) {
        this.earlyCheckInCharge = earlyCheckInCharge;
    }

    public BookingAffiliate lateCheckOutCharge(MoneysAffiliate lateCheckOutCharge) {
        this.lateCheckOutCharge = lateCheckOutCharge;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="lateCheckOutCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysAffiliate getLateCheckOutCharge() {
        return this.lateCheckOutCharge;
    }

    @JsonProperty(value="lateCheckOutCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLateCheckOutCharge(MoneysAffiliate lateCheckOutCharge) {
        this.lateCheckOutCharge = lateCheckOutCharge;
    }

    public BookingAffiliate earlyCheckInChargePercent(Float earlyCheckInChargePercent) {
        this.earlyCheckInChargePercent = earlyCheckInChargePercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.05", value="Early check-in charge calculated in percent of first room night price.")
    @JsonProperty(value="earlyCheckInChargePercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getEarlyCheckInChargePercent() {
        return this.earlyCheckInChargePercent;
    }

    @JsonProperty(value="earlyCheckInChargePercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEarlyCheckInChargePercent(Float earlyCheckInChargePercent) {
        this.earlyCheckInChargePercent = earlyCheckInChargePercent;
    }

    public BookingAffiliate lateCheckOutChargePercent(Float lateCheckOutChargePercent) {
        this.lateCheckOutChargePercent = lateCheckOutChargePercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.05", value="Early check-in charge calculated in percent of first room night price.")
    @JsonProperty(value="lateCheckOutChargePercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getLateCheckOutChargePercent() {
        return this.lateCheckOutChargePercent;
    }

    @JsonProperty(value="lateCheckOutChargePercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLateCheckOutChargePercent(Float lateCheckOutChargePercent) {
        this.lateCheckOutChargePercent = lateCheckOutChargePercent;
    }

    public BookingAffiliate hotelImageUrl(String hotelImageUrl) {
        this.hotelImageUrl = hotelImageUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://path.to/property-image.jpg", required=true, value="Absolute URL of hotel image that can be used as-is")
    @JsonProperty(value="hotelImageUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHotelImageUrl() {
        return this.hotelImageUrl;
    }

    @JsonProperty(value="hotelImageUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelImageUrl(String hotelImageUrl) {
        this.hotelImageUrl = hotelImageUrl;
    }

    public BookingAffiliate roomImageUrl(String roomImageUrl) {
        this.roomImageUrl = roomImageUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://path.to/room-image.jpg", required=true, value="Absolute URL of room image that can be used as-is")
    @JsonProperty(value="roomImageUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoomImageUrl() {
        return this.roomImageUrl;
    }

    @JsonProperty(value="roomImageUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomImageUrl(String roomImageUrl) {
        this.roomImageUrl = roomImageUrl;
    }

    public BookingAffiliate commissionList(List<CommissionableEntryAffiliate> commissionList) {
        this.commissionList = commissionList;
        return this;
    }

    public BookingAffiliate addCommissionListItem(CommissionableEntryAffiliate commissionListItem) {
        if (this.commissionList == null) {
            this.commissionList = new ArrayList<CommissionableEntryAffiliate>();
        }
        this.commissionList.add(commissionListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="List of all travel inventory entries that are due a commission to the affiliate.")
    @JsonProperty(value="commissionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CommissionableEntryAffiliate> getCommissionList() {
        return this.commissionList;
    }

    @JsonProperty(value="commissionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionList(List<CommissionableEntryAffiliate> commissionList) {
        this.commissionList = commissionList;
    }

    public BookingAffiliate ancillaryList(List<BookingAncillaryAffiliate> ancillaryList) {
        this.ancillaryList = ancillaryList;
        return this;
    }

    public BookingAffiliate addAncillaryListItem(BookingAncillaryAffiliate ancillaryListItem) {
        if (this.ancillaryList == null) {
            this.ancillaryList = new ArrayList<BookingAncillaryAffiliate>();
        }
        this.ancillaryList.add(ancillaryListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="ancillaryList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BookingAncillaryAffiliate> getAncillaryList() {
        return this.ancillaryList;
    }

    @JsonProperty(value="ancillaryList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAncillaryList(List<BookingAncillaryAffiliate> ancillaryList) {
        this.ancillaryList = ancillaryList;
    }

    public BookingAffiliate bookingContract(BookingContractAffiliate bookingContract) {
        this.bookingContract = bookingContract;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="bookingContract")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookingContractAffiliate getBookingContract() {
        return this.bookingContract;
    }

    @JsonProperty(value="bookingContract")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookingContract(BookingContractAffiliate bookingContract) {
        this.bookingContract = bookingContract;
    }

    public BookingAffiliate status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ACTIVE", value="Convenience data point to show which status the booking currently has.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public BookingAffiliate meetingRooms(List<BookingAncillaryAffiliate> meetingRooms) {
        this.meetingRooms = meetingRooms;
        return this;
    }

    public BookingAffiliate addMeetingRoomsItem(BookingAncillaryAffiliate meetingRoomsItem) {
        if (this.meetingRooms == null) {
            this.meetingRooms = new ArrayList<BookingAncillaryAffiliate>();
        }
        this.meetingRooms.add(meetingRoomsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Meeting room reservation records.")
    @JsonProperty(value="meetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BookingAncillaryAffiliate> getMeetingRooms() {
        return this.meetingRooms;
    }

    @JsonProperty(value="meetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeetingRooms(List<BookingAncillaryAffiliate> meetingRooms) {
        this.meetingRooms = meetingRooms;
    }

    public BookingAffiliate restaurants(List<BookingAncillaryAffiliate> restaurants) {
        this.restaurants = restaurants;
        return this;
    }

    public BookingAffiliate addRestaurantsItem(BookingAncillaryAffiliate restaurantsItem) {
        if (this.restaurants == null) {
            this.restaurants = new ArrayList<BookingAncillaryAffiliate>();
        }
        this.restaurants.add(restaurantsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Restaurant reservation records.")
    @JsonProperty(value="restaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BookingAncillaryAffiliate> getRestaurants() {
        return this.restaurants;
    }

    @JsonProperty(value="restaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRestaurants(List<BookingAncillaryAffiliate> restaurants) {
        this.restaurants = restaurants;
    }

    public BookingAffiliate spas(List<BookingAncillaryAffiliate> spas) {
        this.spas = spas;
        return this;
    }

    public BookingAffiliate addSpasItem(BookingAncillaryAffiliate spasItem) {
        if (this.spas == null) {
            this.spas = new ArrayList<BookingAncillaryAffiliate>();
        }
        this.spas.add(spasItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Spa reservation records.")
    @JsonProperty(value="spas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BookingAncillaryAffiliate> getSpas() {
        return this.spas;
    }

    @JsonProperty(value="spas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpas(List<BookingAncillaryAffiliate> spas) {
        this.spas = spas;
    }

    public BookingAffiliate activities(List<BookingAncillaryAffiliate> activities) {
        this.activities = activities;
        return this;
    }

    public BookingAffiliate addActivitiesItem(BookingAncillaryAffiliate activitiesItem) {
        if (this.activities == null) {
            this.activities = new ArrayList<BookingAncillaryAffiliate>();
        }
        this.activities.add(activitiesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Activity reservation records.")
    @JsonProperty(value="activities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BookingAncillaryAffiliate> getActivities() {
        return this.activities;
    }

    @JsonProperty(value="activities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActivities(List<BookingAncillaryAffiliate> activities) {
        this.activities = activities;
    }

    public BookingAffiliate attractions(List<BookingAncillaryAffiliate> attractions) {
        this.attractions = attractions;
        return this;
    }

    public BookingAffiliate addAttractionsItem(BookingAncillaryAffiliate attractionsItem) {
        if (this.attractions == null) {
            this.attractions = new ArrayList<BookingAncillaryAffiliate>();
        }
        this.attractions.add(attractionsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Attraction reservation records.")
    @JsonProperty(value="attractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BookingAncillaryAffiliate> getAttractions() {
        return this.attractions;
    }

    @JsonProperty(value="attractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttractions(List<BookingAncillaryAffiliate> attractions) {
        this.attractions = attractions;
    }

    public BookingAffiliate fullAddress(String fullAddress) {
        this.fullAddress = fullAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="204 At home lane, Singapore, Singapore 224333", value="Convenience data point to return the full hotel address.")
    @JsonProperty(value="fullAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullAddress() {
        return this.fullAddress;
    }

    @JsonProperty(value="fullAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullAddress(String fullAddress) {
        this.fullAddress = fullAddress;
    }

    public BookingAffiliate places(List<BookingAncillaryAffiliate> places) {
        this.places = places;
        return this;
    }

    public BookingAffiliate addPlacesItem(BookingAncillaryAffiliate placesItem) {
        if (this.places == null) {
            this.places = new ArrayList<BookingAncillaryAffiliate>();
        }
        this.places.add(placesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Place reservation records.")
    @JsonProperty(value="places")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BookingAncillaryAffiliate> getPlaces() {
        return this.places;
    }

    @JsonProperty(value="places")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlaces(List<BookingAncillaryAffiliate> places) {
        this.places = places;
    }

    public BookingAffiliate roomTypeAncillaries(List<BookingAncillaryAffiliate> roomTypeAncillaries) {
        this.roomTypeAncillaries = roomTypeAncillaries;
        return this;
    }

    public BookingAffiliate addRoomTypeAncillariesItem(BookingAncillaryAffiliate roomTypeAncillariesItem) {
        if (this.roomTypeAncillaries == null) {
            this.roomTypeAncillaries = new ArrayList<BookingAncillaryAffiliate>();
        }
        this.roomTypeAncillaries.add(roomTypeAncillariesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Room type ancillary records.")
    @JsonProperty(value="roomTypeAncillaries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BookingAncillaryAffiliate> getRoomTypeAncillaries() {
        return this.roomTypeAncillaries;
    }

    @JsonProperty(value="roomTypeAncillaries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomTypeAncillaries(List<BookingAncillaryAffiliate> roomTypeAncillaries) {
        this.roomTypeAncillaries = roomTypeAncillaries;
    }

    public BookingAffiliate addOns(List<BookingAncillaryAffiliate> addOns) {
        this.addOns = addOns;
        return this;
    }

    public BookingAffiliate addAddOnsItem(BookingAncillaryAffiliate addOnsItem) {
        if (this.addOns == null) {
            this.addOns = new ArrayList<BookingAncillaryAffiliate>();
        }
        this.addOns.add(addOnsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Add-on records.")
    @JsonProperty(value="addOns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BookingAncillaryAffiliate> getAddOns() {
        return this.addOns;
    }

    @JsonProperty(value="addOns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddOns(List<BookingAncillaryAffiliate> addOns) {
        this.addOns = addOns;
    }

    public BookingAffiliate hasBreakfast(Boolean hasBreakfast) {
        this.hasBreakfast = hasBreakfast;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Convenience data point to get to breakfast quickly.")
    @JsonProperty(value="hasBreakfast")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasBreakfast() {
        return this.hasBreakfast;
    }

    @JsonProperty(value="hasBreakfast")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasBreakfast(Boolean hasBreakfast) {
        this.hasBreakfast = hasBreakfast;
    }

    public BookingAffiliate hasBrunch(Boolean hasBrunch) {
        this.hasBrunch = hasBrunch;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Convenience data point to get to brunch quickly.")
    @JsonProperty(value="hasBrunch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasBrunch() {
        return this.hasBrunch;
    }

    @JsonProperty(value="hasBrunch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasBrunch(Boolean hasBrunch) {
        this.hasBrunch = hasBrunch;
    }

    public BookingAffiliate hasLunch(Boolean hasLunch) {
        this.hasLunch = hasLunch;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Convenience data point to get to lunch quickly.")
    @JsonProperty(value="hasLunch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasLunch() {
        return this.hasLunch;
    }

    @JsonProperty(value="hasLunch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasLunch(Boolean hasLunch) {
        this.hasLunch = hasLunch;
    }

    public BookingAffiliate hasDinner(Boolean hasDinner) {
        this.hasDinner = hasDinner;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Convenience data point to get to dinner quickly.")
    @JsonProperty(value="hasDinner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasDinner() {
        return this.hasDinner;
    }

    @JsonProperty(value="hasDinner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasDinner(Boolean hasDinner) {
        this.hasDinner = hasDinner;
    }

    public BookingAffiliate hasAllInclusive(Boolean hasAllInclusive) {
        this.hasAllInclusive = hasAllInclusive;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Convenience data point to get to all-inclusive quickly.")
    @JsonProperty(value="hasAllInclusive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasAllInclusive() {
        return this.hasAllInclusive;
    }

    @JsonProperty(value="hasAllInclusive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasAllInclusive(Boolean hasAllInclusive) {
        this.hasAllInclusive = hasAllInclusive;
    }

    public BookingAffiliate hasAllInclusivePlusAlcohol(Boolean hasAllInclusivePlusAlcohol) {
        this.hasAllInclusivePlusAlcohol = hasAllInclusivePlusAlcohol;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Convenience data point to get to all-inclusive with alcohol quickly.")
    @JsonProperty(value="hasAllInclusivePlusAlcohol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasAllInclusivePlusAlcohol() {
        return this.hasAllInclusivePlusAlcohol;
    }

    @JsonProperty(value="hasAllInclusivePlusAlcohol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasAllInclusivePlusAlcohol(Boolean hasAllInclusivePlusAlcohol) {
        this.hasAllInclusivePlusAlcohol = hasAllInclusivePlusAlcohol;
    }

    public BookingAffiliate rateSource(String rateSource) {
        this.rateSource = rateSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="SITEMINDER", value="Rate origin. This is usually the property channel manager.")
    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRateSource() {
        return this.rateSource;
    }

    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRateSource(String rateSource) {
        this.rateSource = rateSource;
    }

    public BookingAffiliate hasAddOns(Boolean hasAddOns) {
        this.hasAddOns = hasAddOns;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Convenience data point to check if any add-on offers are in this booking.")
    @JsonProperty(value="hasAddOns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasAddOns() {
        return this.hasAddOns;
    }

    @JsonProperty(value="hasAddOns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasAddOns(Boolean hasAddOns) {
        this.hasAddOns = hasAddOns;
    }

    public BookingAffiliate hasRoomTypeAncillaries(Boolean hasRoomTypeAncillaries) {
        this.hasRoomTypeAncillaries = hasRoomTypeAncillaries;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Convenience data point to check if any room type ancillaries are in this booking.")
    @JsonProperty(value="hasRoomTypeAncillaries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasRoomTypeAncillaries() {
        return this.hasRoomTypeAncillaries;
    }

    @JsonProperty(value="hasRoomTypeAncillaries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasRoomTypeAncillaries(Boolean hasRoomTypeAncillaries) {
        this.hasRoomTypeAncillaries = hasRoomTypeAncillaries;
    }

    public BookingAffiliate hasFood(Boolean hasFood) {
        this.hasFood = hasFood;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Convenience data point to check if any food is included in this booking.")
    @JsonProperty(value="hasFood")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasFood() {
        return this.hasFood;
    }

    @JsonProperty(value="hasFood")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasFood(Boolean hasFood) {
        this.hasFood = hasFood;
    }

    public BookingAffiliate hasRestaurants(Boolean hasRestaurants) {
        this.hasRestaurants = hasRestaurants;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Convenience data point to check if any restaurant reservations are included in this booking.")
    @JsonProperty(value="hasRestaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasRestaurants() {
        return this.hasRestaurants;
    }

    @JsonProperty(value="hasRestaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasRestaurants(Boolean hasRestaurants) {
        this.hasRestaurants = hasRestaurants;
    }

    public BookingAffiliate hasMeetingRooms(Boolean hasMeetingRooms) {
        this.hasMeetingRooms = hasMeetingRooms;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Convenience data point to check if any meeting room reservations are included in this booking.")
    @JsonProperty(value="hasMeetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasMeetingRooms() {
        return this.hasMeetingRooms;
    }

    @JsonProperty(value="hasMeetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasMeetingRooms(Boolean hasMeetingRooms) {
        this.hasMeetingRooms = hasMeetingRooms;
    }

    public BookingAffiliate hasSpas(Boolean hasSpas) {
        this.hasSpas = hasSpas;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Convenience data point to check if any spa reservations are included in this booking.")
    @JsonProperty(value="hasSpas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasSpas() {
        return this.hasSpas;
    }

    @JsonProperty(value="hasSpas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasSpas(Boolean hasSpas) {
        this.hasSpas = hasSpas;
    }

    public BookingAffiliate hasActivities(Boolean hasActivities) {
        this.hasActivities = hasActivities;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Convenience data point to check if any activity reservations are included in this booking.")
    @JsonProperty(value="hasActivities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasActivities() {
        return this.hasActivities;
    }

    @JsonProperty(value="hasActivities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasActivities(Boolean hasActivities) {
        this.hasActivities = hasActivities;
    }

    public BookingAffiliate hasAttractions(Boolean hasAttractions) {
        this.hasAttractions = hasAttractions;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Convenience data point to check if any attractions reservations are included in this booking.")
    @JsonProperty(value="hasAttractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasAttractions() {
        return this.hasAttractions;
    }

    @JsonProperty(value="hasAttractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasAttractions(Boolean hasAttractions) {
        this.hasAttractions = hasAttractions;
    }

    public BookingAffiliate hasPlaces(Boolean hasPlaces) {
        this.hasPlaces = hasPlaces;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Convenience data point to check if any place reservations are included in this booking.")
    @JsonProperty(value="hasPlaces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasPlaces() {
        return this.hasPlaces;
    }

    @JsonProperty(value="hasPlaces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasPlaces(Boolean hasPlaces) {
        this.hasPlaces = hasPlaces;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingAffiliate bookingAffiliate = (BookingAffiliate)o;
        return Objects.equals(this.test, bookingAffiliate.test) && Objects.equals(this.date, bookingAffiliate.date) && Objects.equals(this.groupIdentifier, bookingAffiliate.groupIdentifier) && Objects.equals(this.identifier, bookingAffiliate.identifier) && Objects.equals(this.engineConfiguration, bookingAffiliate.engineConfiguration) && Objects.equals(this.bookingCode, bookingAffiliate.bookingCode) && Objects.equals(this.user, bookingAffiliate.user) && Objects.equals(this.userSession, bookingAffiliate.userSession) && Objects.equals(this.serverUrl, bookingAffiliate.serverUrl) && Objects.equals(this.contactInfo, bookingAffiliate.contactInfo) && Objects.equals(this.address, bookingAffiliate.address) && Objects.equals(this.socials, bookingAffiliate.socials) && Objects.equals(this.review, bookingAffiliate.review) && Objects.equals(this.emailHeaderLogoUrl, bookingAffiliate.emailHeaderLogoUrl) && Objects.equals(this.logoIdentifier, bookingAffiliate.logoIdentifier) && Objects.equals(this.hotel, bookingAffiliate.hotel) && Objects.equals(this.roomStay, bookingAffiliate.roomStay) && Objects.equals(this.specialRequests, bookingAffiliate.specialRequests) && Objects.equals(this.comment, bookingAffiliate.comment) && Objects.equals(this.earlyCheckInCharge, bookingAffiliate.earlyCheckInCharge) && Objects.equals(this.lateCheckOutCharge, bookingAffiliate.lateCheckOutCharge) && Objects.equals(this.earlyCheckInChargePercent, bookingAffiliate.earlyCheckInChargePercent) && Objects.equals(this.lateCheckOutChargePercent, bookingAffiliate.lateCheckOutChargePercent) && Objects.equals(this.hotelImageUrl, bookingAffiliate.hotelImageUrl) && Objects.equals(this.roomImageUrl, bookingAffiliate.roomImageUrl) && Objects.equals(this.commissionList, bookingAffiliate.commissionList) && Objects.equals(this.ancillaryList, bookingAffiliate.ancillaryList) && Objects.equals(this.bookingContract, bookingAffiliate.bookingContract) && Objects.equals((Object)this.status, (Object)bookingAffiliate.status) && Objects.equals(this.meetingRooms, bookingAffiliate.meetingRooms) && Objects.equals(this.restaurants, bookingAffiliate.restaurants) && Objects.equals(this.spas, bookingAffiliate.spas) && Objects.equals(this.activities, bookingAffiliate.activities) && Objects.equals(this.attractions, bookingAffiliate.attractions) && Objects.equals(this.fullAddress, bookingAffiliate.fullAddress) && Objects.equals(this.places, bookingAffiliate.places) && Objects.equals(this.roomTypeAncillaries, bookingAffiliate.roomTypeAncillaries) && Objects.equals(this.addOns, bookingAffiliate.addOns) && Objects.equals(this.hasBreakfast, bookingAffiliate.hasBreakfast) && Objects.equals(this.hasBrunch, bookingAffiliate.hasBrunch) && Objects.equals(this.hasLunch, bookingAffiliate.hasLunch) && Objects.equals(this.hasDinner, bookingAffiliate.hasDinner) && Objects.equals(this.hasAllInclusive, bookingAffiliate.hasAllInclusive) && Objects.equals(this.hasAllInclusivePlusAlcohol, bookingAffiliate.hasAllInclusivePlusAlcohol) && Objects.equals(this.rateSource, bookingAffiliate.rateSource) && Objects.equals(this.hasAddOns, bookingAffiliate.hasAddOns) && Objects.equals(this.hasRoomTypeAncillaries, bookingAffiliate.hasRoomTypeAncillaries) && Objects.equals(this.hasFood, bookingAffiliate.hasFood) && Objects.equals(this.hasRestaurants, bookingAffiliate.hasRestaurants) && Objects.equals(this.hasMeetingRooms, bookingAffiliate.hasMeetingRooms) && Objects.equals(this.hasSpas, bookingAffiliate.hasSpas) && Objects.equals(this.hasActivities, bookingAffiliate.hasActivities) && Objects.equals(this.hasAttractions, bookingAffiliate.hasAttractions) && Objects.equals(this.hasPlaces, bookingAffiliate.hasPlaces);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.test, this.date, this.groupIdentifier, this.identifier, this.engineConfiguration, this.bookingCode, this.user, this.userSession, this.serverUrl, this.contactInfo, this.address, this.socials, this.review, this.emailHeaderLogoUrl, this.logoIdentifier, this.hotel, this.roomStay, this.specialRequests, this.comment, this.earlyCheckInCharge, this.lateCheckOutCharge, this.earlyCheckInChargePercent, this.lateCheckOutChargePercent, this.hotelImageUrl, this.roomImageUrl, this.commissionList, this.ancillaryList, this.bookingContract, this.status, this.meetingRooms, this.restaurants, this.spas, this.activities, this.attractions, this.fullAddress, this.places, this.roomTypeAncillaries, this.addOns, this.hasBreakfast, this.hasBrunch, this.hasLunch, this.hasDinner, this.hasAllInclusive, this.hasAllInclusivePlusAlcohol, this.rateSource, this.hasAddOns, this.hasRoomTypeAncillaries, this.hasFood, this.hasRestaurants, this.hasMeetingRooms, this.hasSpas, this.hasActivities, this.hasAttractions, this.hasPlaces});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingAffiliate {\n");
        sb.append("    test: ").append(this.toIndentedString(this.test)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    groupIdentifier: ").append(this.toIndentedString(this.groupIdentifier)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    engineConfiguration: ").append(this.toIndentedString(this.engineConfiguration)).append("\n");
        sb.append("    bookingCode: ").append(this.toIndentedString(this.bookingCode)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    userSession: ").append(this.toIndentedString(this.userSession)).append("\n");
        sb.append("    serverUrl: ").append(this.toIndentedString(this.serverUrl)).append("\n");
        sb.append("    contactInfo: ").append(this.toIndentedString(this.contactInfo)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    review: ").append(this.toIndentedString(this.review)).append("\n");
        sb.append("    emailHeaderLogoUrl: ").append(this.toIndentedString(this.emailHeaderLogoUrl)).append("\n");
        sb.append("    logoIdentifier: ").append(this.toIndentedString(this.logoIdentifier)).append("\n");
        sb.append("    hotel: ").append(this.toIndentedString(this.hotel)).append("\n");
        sb.append("    roomStay: ").append(this.toIndentedString(this.roomStay)).append("\n");
        sb.append("    specialRequests: ").append(this.toIndentedString(this.specialRequests)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    earlyCheckInCharge: ").append(this.toIndentedString(this.earlyCheckInCharge)).append("\n");
        sb.append("    lateCheckOutCharge: ").append(this.toIndentedString(this.lateCheckOutCharge)).append("\n");
        sb.append("    earlyCheckInChargePercent: ").append(this.toIndentedString(this.earlyCheckInChargePercent)).append("\n");
        sb.append("    lateCheckOutChargePercent: ").append(this.toIndentedString(this.lateCheckOutChargePercent)).append("\n");
        sb.append("    hotelImageUrl: ").append(this.toIndentedString(this.hotelImageUrl)).append("\n");
        sb.append("    roomImageUrl: ").append(this.toIndentedString(this.roomImageUrl)).append("\n");
        sb.append("    commissionList: ").append(this.toIndentedString(this.commissionList)).append("\n");
        sb.append("    ancillaryList: ").append(this.toIndentedString(this.ancillaryList)).append("\n");
        sb.append("    bookingContract: ").append(this.toIndentedString(this.bookingContract)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    meetingRooms: ").append(this.toIndentedString(this.meetingRooms)).append("\n");
        sb.append("    restaurants: ").append(this.toIndentedString(this.restaurants)).append("\n");
        sb.append("    spas: ").append(this.toIndentedString(this.spas)).append("\n");
        sb.append("    activities: ").append(this.toIndentedString(this.activities)).append("\n");
        sb.append("    attractions: ").append(this.toIndentedString(this.attractions)).append("\n");
        sb.append("    fullAddress: ").append(this.toIndentedString(this.fullAddress)).append("\n");
        sb.append("    places: ").append(this.toIndentedString(this.places)).append("\n");
        sb.append("    roomTypeAncillaries: ").append(this.toIndentedString(this.roomTypeAncillaries)).append("\n");
        sb.append("    addOns: ").append(this.toIndentedString(this.addOns)).append("\n");
        sb.append("    hasBreakfast: ").append(this.toIndentedString(this.hasBreakfast)).append("\n");
        sb.append("    hasBrunch: ").append(this.toIndentedString(this.hasBrunch)).append("\n");
        sb.append("    hasLunch: ").append(this.toIndentedString(this.hasLunch)).append("\n");
        sb.append("    hasDinner: ").append(this.toIndentedString(this.hasDinner)).append("\n");
        sb.append("    hasAllInclusive: ").append(this.toIndentedString(this.hasAllInclusive)).append("\n");
        sb.append("    hasAllInclusivePlusAlcohol: ").append(this.toIndentedString(this.hasAllInclusivePlusAlcohol)).append("\n");
        sb.append("    rateSource: ").append(this.toIndentedString(this.rateSource)).append("\n");
        sb.append("    hasAddOns: ").append(this.toIndentedString(this.hasAddOns)).append("\n");
        sb.append("    hasRoomTypeAncillaries: ").append(this.toIndentedString(this.hasRoomTypeAncillaries)).append("\n");
        sb.append("    hasFood: ").append(this.toIndentedString(this.hasFood)).append("\n");
        sb.append("    hasRestaurants: ").append(this.toIndentedString(this.hasRestaurants)).append("\n");
        sb.append("    hasMeetingRooms: ").append(this.toIndentedString(this.hasMeetingRooms)).append("\n");
        sb.append("    hasSpas: ").append(this.toIndentedString(this.hasSpas)).append("\n");
        sb.append("    hasActivities: ").append(this.toIndentedString(this.hasActivities)).append("\n");
        sb.append("    hasAttractions: ").append(this.toIndentedString(this.hasAttractions)).append("\n");
        sb.append("    hasPlaces: ").append(this.toIndentedString(this.hasPlaces)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        CANCELLED_BY_HOTEL("CANCELLED_BY_HOTEL"),
        CANCELLED_BY_GUEST("CANCELLED_BY_GUEST"),
        CANCELLED_BY_ADMIN("CANCELLED_BY_ADMIN"),
        CANCELLED_BY_SALES_CHANNEL("CANCELLED_BY_SALES_CHANNEL"),
        PAST("PAST"),
        CANCELLED_BY_ACQUIRER("CANCELLED_BY_ACQUIRER"),
        ACTIVE("ACTIVE");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

