/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.affiliate.model.BeneficiaryAffiliate;
import travel.wink.sdk.affiliate.model.BookingUserAffiliate;
import travel.wink.sdk.affiliate.model.DailyRateAffiliate;
import travel.wink.sdk.affiliate.model.ItineraryAffiliate;
import travel.wink.sdk.affiliate.model.MoneysAffiliate;
import travel.wink.sdk.affiliate.model.SupplierContractItemPolicyAffiliate;

@ApiModel(description="Holds one booking line item for a specific supplier.")
@JsonPropertyOrder(value={"supplierItemBookingCode", "user", "nameInEnglish", "descriptionInEnglish", "totalSourcePrice", "totalDisplayPrice", "totalSupplierPrice", "totalInternalPrice", "totalCapturePrice", "itinerary", "pricingType", "type", "beneficiaryList", "payable", "policy", "externalIdentifier", "tokensEarned", "dailyRateList", "cancelled", "totalSourcePriceAfterRefund", "totalDisplayPriceAfterRefund", "totalSupplierPriceAfterRefund", "totalInternalPriceAfterRefund", "totalCapturePriceAfterRefund", "cancellableBySupplier", "isCancellableBySupplier", "cancellableByTraveler", "isCancellableByTraveler", "cancellableWithNoCharges", "cancellableWithPotentialCharges"})
@JsonTypeName(value="BookingContractItem_Affiliate")
public class BookingContractItemAffiliate {
    public static final String JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE = "supplierItemBookingCode";
    private String supplierItemBookingCode;
    public static final String JSON_PROPERTY_USER = "user";
    private BookingUserAffiliate user;
    public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
    private String nameInEnglish;
    public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
    private String descriptionInEnglish;
    public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE = "totalSourcePrice";
    private MoneysAffiliate totalSourcePrice;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
    private MoneysAffiliate totalDisplayPrice;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
    private MoneysAffiliate totalSupplierPrice;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
    private MoneysAffiliate totalInternalPrice;
    public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE = "totalCapturePrice";
    private MoneysAffiliate totalCapturePrice;
    public static final String JSON_PROPERTY_ITINERARY = "itinerary";
    private ItineraryAffiliate itinerary;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
    private List<BeneficiaryAffiliate> beneficiaryList = new ArrayList<BeneficiaryAffiliate>();
    public static final String JSON_PROPERTY_PAYABLE = "payable";
    private PayableEnum payable;
    public static final String JSON_PROPERTY_POLICY = "policy";
    private SupplierContractItemPolicyAffiliate policy;
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    private String externalIdentifier;
    public static final String JSON_PROPERTY_TOKENS_EARNED = "tokensEarned";
    private Long tokensEarned;
    public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
    private List<DailyRateAffiliate> dailyRateList = null;
    public static final String JSON_PROPERTY_CANCELLED = "cancelled";
    private Boolean cancelled;
    public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND = "totalSourcePriceAfterRefund";
    private MoneysAffiliate totalSourcePriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND = "totalDisplayPriceAfterRefund";
    private MoneysAffiliate totalDisplayPriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND = "totalSupplierPriceAfterRefund";
    private MoneysAffiliate totalSupplierPriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND = "totalInternalPriceAfterRefund";
    private MoneysAffiliate totalInternalPriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND = "totalCapturePriceAfterRefund";
    private MoneysAffiliate totalCapturePriceAfterRefund;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
    private Boolean cancellableBySupplier;
    public static final String JSON_PROPERTY_IS_CANCELLABLE_BY_SUPPLIER = "isCancellableBySupplier";
    private Boolean isCancellableBySupplier;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
    private Boolean cancellableByTraveler;
    public static final String JSON_PROPERTY_IS_CANCELLABLE_BY_TRAVELER = "isCancellableByTraveler";
    private Boolean isCancellableByTraveler;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
    private Boolean cancellableWithNoCharges;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES = "cancellableWithPotentialCharges";
    private Boolean cancellableWithPotentialCharges;

    public BookingContractItemAffiliate supplierItemBookingCode(String supplierItemBookingCode) {
        this.supplierItemBookingCode = supplierItemBookingCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="TP-ASDFG1234", required=true, value="Booking code identifying the supplier line item.")
    @JsonProperty(value="supplierItemBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierItemBookingCode() {
        return this.supplierItemBookingCode;
    }

    @JsonProperty(value="supplierItemBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierItemBookingCode(String supplierItemBookingCode) {
        this.supplierItemBookingCode = supplierItemBookingCode;
    }

    public BookingContractItemAffiliate user(BookingUserAffiliate user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookingUserAffiliate getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(BookingUserAffiliate user) {
        this.user = user;
    }

    public BookingContractItemAffiliate nameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Deluxe King", required=true, value="Name of item in English included in booking.")
    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNameInEnglish() {
        return this.nameInEnglish;
    }

    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
    }

    public BookingContractItemAffiliate descriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="This is the best deluxe king that money can buy.", required=true, value="Short description in English of item included in booking.")
    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescriptionInEnglish() {
        return this.descriptionInEnglish;
    }

    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
    }

    public BookingContractItemAffiliate totalSourcePrice(MoneysAffiliate totalSourcePrice) {
        this.totalSourcePrice = totalSourcePrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="totalSourcePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysAffiliate getTotalSourcePrice() {
        return this.totalSourcePrice;
    }

    @JsonProperty(value="totalSourcePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalSourcePrice(MoneysAffiliate totalSourcePrice) {
        this.totalSourcePrice = totalSourcePrice;
    }

    public BookingContractItemAffiliate totalDisplayPrice(MoneysAffiliate totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysAffiliate getTotalDisplayPrice() {
        return this.totalDisplayPrice;
    }

    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalDisplayPrice(MoneysAffiliate totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
    }

    public BookingContractItemAffiliate totalSupplierPrice(MoneysAffiliate totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysAffiliate getTotalSupplierPrice() {
        return this.totalSupplierPrice;
    }

    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalSupplierPrice(MoneysAffiliate totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
    }

    public BookingContractItemAffiliate totalInternalPrice(MoneysAffiliate totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysAffiliate getTotalInternalPrice() {
        return this.totalInternalPrice;
    }

    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalInternalPrice(MoneysAffiliate totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
    }

    public BookingContractItemAffiliate totalCapturePrice(MoneysAffiliate totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysAffiliate getTotalCapturePrice() {
        return this.totalCapturePrice;
    }

    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalCapturePrice(MoneysAffiliate totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
    }

    public BookingContractItemAffiliate itinerary(ItineraryAffiliate itinerary) {
        this.itinerary = itinerary;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ItineraryAffiliate getItinerary() {
        return this.itinerary;
    }

    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItinerary(ItineraryAffiliate itinerary) {
        this.itinerary = itinerary;
    }

    public BookingContractItemAffiliate pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="How to calculate the total amount.")
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public BookingContractItemAffiliate type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="LODGING", required=true, value="Type of item this is.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BookingContractItemAffiliate beneficiaryList(List<BeneficiaryAffiliate> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
        return this;
    }

    public BookingContractItemAffiliate addBeneficiaryListItem(BeneficiaryAffiliate beneficiaryListItem) {
        this.beneficiaryList.add(beneficiaryListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<BeneficiaryAffiliate> getBeneficiaryList() {
        return this.beneficiaryList;
    }

    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBeneficiaryList(List<BeneficiaryAffiliate> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
    }

    public BookingContractItemAffiliate payable(PayableEnum payable) {
        this.payable = payable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="PREPAY", required=true, value="When to charge for this item.")
    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayableEnum getPayable() {
        return this.payable;
    }

    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayable(PayableEnum payable) {
        this.payable = payable;
    }

    public BookingContractItemAffiliate policy(SupplierContractItemPolicyAffiliate policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SupplierContractItemPolicyAffiliate getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(SupplierContractItemPolicyAffiliate policy) {
        this.policy = policy;
    }

    public BookingContractItemAffiliate externalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="room-type-1", value="Optional geoname externalIdentifier to remote inventory.")
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public BookingContractItemAffiliate tokensEarned(Long tokensEarned) {
        this.tokensEarned = tokensEarned;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12", value="Tokens earned for this item")
    @JsonProperty(value="tokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTokensEarned() {
        return this.tokensEarned;
    }

    @JsonProperty(value="tokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokensEarned(Long tokensEarned) {
        this.tokensEarned = tokensEarned;
    }

    public BookingContractItemAffiliate dailyRateList(List<DailyRateAffiliate> dailyRateList) {
        this.dailyRateList = dailyRateList;
        return this;
    }

    public BookingContractItemAffiliate addDailyRateListItem(DailyRateAffiliate dailyRateListItem) {
        if (this.dailyRateList == null) {
            this.dailyRateList = new ArrayList<DailyRateAffiliate>();
        }
        this.dailyRateList.add(dailyRateListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DailyRateAffiliate> getDailyRateList() {
        return this.dailyRateList;
    }

    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDailyRateList(List<DailyRateAffiliate> dailyRateList) {
        this.dailyRateList = dailyRateList;
    }

    public BookingContractItemAffiliate cancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional geoname externalIdentifier to remote inventory.")
    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancelled() {
        return this.cancelled;
    }

    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    public BookingContractItemAffiliate totalSourcePriceAfterRefund(MoneysAffiliate totalSourcePriceAfterRefund) {
        this.totalSourcePriceAfterRefund = totalSourcePriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSourcePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysAffiliate getTotalSourcePriceAfterRefund() {
        return this.totalSourcePriceAfterRefund;
    }

    @JsonProperty(value="totalSourcePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSourcePriceAfterRefund(MoneysAffiliate totalSourcePriceAfterRefund) {
        this.totalSourcePriceAfterRefund = totalSourcePriceAfterRefund;
    }

    public BookingContractItemAffiliate totalDisplayPriceAfterRefund(MoneysAffiliate totalDisplayPriceAfterRefund) {
        this.totalDisplayPriceAfterRefund = totalDisplayPriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalDisplayPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysAffiliate getTotalDisplayPriceAfterRefund() {
        return this.totalDisplayPriceAfterRefund;
    }

    @JsonProperty(value="totalDisplayPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPriceAfterRefund(MoneysAffiliate totalDisplayPriceAfterRefund) {
        this.totalDisplayPriceAfterRefund = totalDisplayPriceAfterRefund;
    }

    public BookingContractItemAffiliate totalSupplierPriceAfterRefund(MoneysAffiliate totalSupplierPriceAfterRefund) {
        this.totalSupplierPriceAfterRefund = totalSupplierPriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSupplierPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysAffiliate getTotalSupplierPriceAfterRefund() {
        return this.totalSupplierPriceAfterRefund;
    }

    @JsonProperty(value="totalSupplierPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSupplierPriceAfterRefund(MoneysAffiliate totalSupplierPriceAfterRefund) {
        this.totalSupplierPriceAfterRefund = totalSupplierPriceAfterRefund;
    }

    public BookingContractItemAffiliate totalInternalPriceAfterRefund(MoneysAffiliate totalInternalPriceAfterRefund) {
        this.totalInternalPriceAfterRefund = totalInternalPriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalInternalPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysAffiliate getTotalInternalPriceAfterRefund() {
        return this.totalInternalPriceAfterRefund;
    }

    @JsonProperty(value="totalInternalPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalInternalPriceAfterRefund(MoneysAffiliate totalInternalPriceAfterRefund) {
        this.totalInternalPriceAfterRefund = totalInternalPriceAfterRefund;
    }

    public BookingContractItemAffiliate totalCapturePriceAfterRefund(MoneysAffiliate totalCapturePriceAfterRefund) {
        this.totalCapturePriceAfterRefund = totalCapturePriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalCapturePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysAffiliate getTotalCapturePriceAfterRefund() {
        return this.totalCapturePriceAfterRefund;
    }

    @JsonProperty(value="totalCapturePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCapturePriceAfterRefund(MoneysAffiliate totalCapturePriceAfterRefund) {
        this.totalCapturePriceAfterRefund = totalCapturePriceAfterRefund;
    }

    public BookingContractItemAffiliate cancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled by the supplier. A supplier cancellation overrides the refundable")
    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableBySupplier() {
        return this.cancellableBySupplier;
    }

    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
    }

    public BookingContractItemAffiliate isCancellableBySupplier(Boolean isCancellableBySupplier) {
        this.isCancellableBySupplier = isCancellableBySupplier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="isCancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsCancellableBySupplier() {
        return this.isCancellableBySupplier;
    }

    @JsonProperty(value="isCancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsCancellableBySupplier(Boolean isCancellableBySupplier) {
        this.isCancellableBySupplier = isCancellableBySupplier;
    }

    public BookingContractItemAffiliate cancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled by the traveller.")
    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableByTraveler() {
        return this.cancellableByTraveler;
    }

    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
    }

    public BookingContractItemAffiliate isCancellableByTraveler(Boolean isCancellableByTraveler) {
        this.isCancellableByTraveler = isCancellableByTraveler;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="isCancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsCancellableByTraveler() {
        return this.isCancellableByTraveler;
    }

    @JsonProperty(value="isCancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsCancellableByTraveler(Boolean isCancellableByTraveler) {
        this.isCancellableByTraveler = isCancellableByTraveler;
    }

    public BookingContractItemAffiliate cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled and whether cancellation charges might still occur.")
    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithNoCharges() {
        return this.cancellableWithNoCharges;
    }

    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
    }

    public BookingContractItemAffiliate cancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
        this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled and whether cancellation charges might still occur.")
    @JsonProperty(value="cancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithPotentialCharges() {
        return this.cancellableWithPotentialCharges;
    }

    @JsonProperty(value="cancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
        this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingContractItemAffiliate bookingContractItemAffiliate = (BookingContractItemAffiliate)o;
        return Objects.equals(this.supplierItemBookingCode, bookingContractItemAffiliate.supplierItemBookingCode) && Objects.equals(this.user, bookingContractItemAffiliate.user) && Objects.equals(this.nameInEnglish, bookingContractItemAffiliate.nameInEnglish) && Objects.equals(this.descriptionInEnglish, bookingContractItemAffiliate.descriptionInEnglish) && Objects.equals(this.totalSourcePrice, bookingContractItemAffiliate.totalSourcePrice) && Objects.equals(this.totalDisplayPrice, bookingContractItemAffiliate.totalDisplayPrice) && Objects.equals(this.totalSupplierPrice, bookingContractItemAffiliate.totalSupplierPrice) && Objects.equals(this.totalInternalPrice, bookingContractItemAffiliate.totalInternalPrice) && Objects.equals(this.totalCapturePrice, bookingContractItemAffiliate.totalCapturePrice) && Objects.equals(this.itinerary, bookingContractItemAffiliate.itinerary) && Objects.equals((Object)this.pricingType, (Object)bookingContractItemAffiliate.pricingType) && Objects.equals((Object)this.type, (Object)bookingContractItemAffiliate.type) && Objects.equals(this.beneficiaryList, bookingContractItemAffiliate.beneficiaryList) && Objects.equals((Object)this.payable, (Object)bookingContractItemAffiliate.payable) && Objects.equals(this.policy, bookingContractItemAffiliate.policy) && Objects.equals(this.externalIdentifier, bookingContractItemAffiliate.externalIdentifier) && Objects.equals(this.tokensEarned, bookingContractItemAffiliate.tokensEarned) && Objects.equals(this.dailyRateList, bookingContractItemAffiliate.dailyRateList) && Objects.equals(this.cancelled, bookingContractItemAffiliate.cancelled) && Objects.equals(this.totalSourcePriceAfterRefund, bookingContractItemAffiliate.totalSourcePriceAfterRefund) && Objects.equals(this.totalDisplayPriceAfterRefund, bookingContractItemAffiliate.totalDisplayPriceAfterRefund) && Objects.equals(this.totalSupplierPriceAfterRefund, bookingContractItemAffiliate.totalSupplierPriceAfterRefund) && Objects.equals(this.totalInternalPriceAfterRefund, bookingContractItemAffiliate.totalInternalPriceAfterRefund) && Objects.equals(this.totalCapturePriceAfterRefund, bookingContractItemAffiliate.totalCapturePriceAfterRefund) && Objects.equals(this.cancellableBySupplier, bookingContractItemAffiliate.cancellableBySupplier) && Objects.equals(this.isCancellableBySupplier, bookingContractItemAffiliate.isCancellableBySupplier) && Objects.equals(this.cancellableByTraveler, bookingContractItemAffiliate.cancellableByTraveler) && Objects.equals(this.isCancellableByTraveler, bookingContractItemAffiliate.isCancellableByTraveler) && Objects.equals(this.cancellableWithNoCharges, bookingContractItemAffiliate.cancellableWithNoCharges) && Objects.equals(this.cancellableWithPotentialCharges, bookingContractItemAffiliate.cancellableWithPotentialCharges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.supplierItemBookingCode, this.user, this.nameInEnglish, this.descriptionInEnglish, this.totalSourcePrice, this.totalDisplayPrice, this.totalSupplierPrice, this.totalInternalPrice, this.totalCapturePrice, this.itinerary, this.pricingType, this.type, this.beneficiaryList, this.payable, this.policy, this.externalIdentifier, this.tokensEarned, this.dailyRateList, this.cancelled, this.totalSourcePriceAfterRefund, this.totalDisplayPriceAfterRefund, this.totalSupplierPriceAfterRefund, this.totalInternalPriceAfterRefund, this.totalCapturePriceAfterRefund, this.cancellableBySupplier, this.isCancellableBySupplier, this.cancellableByTraveler, this.isCancellableByTraveler, this.cancellableWithNoCharges, this.cancellableWithPotentialCharges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingContractItemAffiliate {\n");
        sb.append("    supplierItemBookingCode: ").append(this.toIndentedString(this.supplierItemBookingCode)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    nameInEnglish: ").append(this.toIndentedString(this.nameInEnglish)).append("\n");
        sb.append("    descriptionInEnglish: ").append(this.toIndentedString(this.descriptionInEnglish)).append("\n");
        sb.append("    totalSourcePrice: ").append(this.toIndentedString(this.totalSourcePrice)).append("\n");
        sb.append("    totalDisplayPrice: ").append(this.toIndentedString(this.totalDisplayPrice)).append("\n");
        sb.append("    totalSupplierPrice: ").append(this.toIndentedString(this.totalSupplierPrice)).append("\n");
        sb.append("    totalInternalPrice: ").append(this.toIndentedString(this.totalInternalPrice)).append("\n");
        sb.append("    totalCapturePrice: ").append(this.toIndentedString(this.totalCapturePrice)).append("\n");
        sb.append("    itinerary: ").append(this.toIndentedString(this.itinerary)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    beneficiaryList: ").append(this.toIndentedString(this.beneficiaryList)).append("\n");
        sb.append("    payable: ").append(this.toIndentedString((Object)this.payable)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    tokensEarned: ").append(this.toIndentedString(this.tokensEarned)).append("\n");
        sb.append("    dailyRateList: ").append(this.toIndentedString(this.dailyRateList)).append("\n");
        sb.append("    cancelled: ").append(this.toIndentedString(this.cancelled)).append("\n");
        sb.append("    totalSourcePriceAfterRefund: ").append(this.toIndentedString(this.totalSourcePriceAfterRefund)).append("\n");
        sb.append("    totalDisplayPriceAfterRefund: ").append(this.toIndentedString(this.totalDisplayPriceAfterRefund)).append("\n");
        sb.append("    totalSupplierPriceAfterRefund: ").append(this.toIndentedString(this.totalSupplierPriceAfterRefund)).append("\n");
        sb.append("    totalInternalPriceAfterRefund: ").append(this.toIndentedString(this.totalInternalPriceAfterRefund)).append("\n");
        sb.append("    totalCapturePriceAfterRefund: ").append(this.toIndentedString(this.totalCapturePriceAfterRefund)).append("\n");
        sb.append("    cancellableBySupplier: ").append(this.toIndentedString(this.cancellableBySupplier)).append("\n");
        sb.append("    isCancellableBySupplier: ").append(this.toIndentedString(this.isCancellableBySupplier)).append("\n");
        sb.append("    cancellableByTraveler: ").append(this.toIndentedString(this.cancellableByTraveler)).append("\n");
        sb.append("    isCancellableByTraveler: ").append(this.toIndentedString(this.isCancellableByTraveler)).append("\n");
        sb.append("    cancellableWithNoCharges: ").append(this.toIndentedString(this.cancellableWithNoCharges)).append("\n");
        sb.append("    cancellableWithPotentialCharges: ").append(this.toIndentedString(this.cancellableWithPotentialCharges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        DAY("PER_DAY"),
        NIGHT("PER_NIGHT"),
        USE("PER_USE"),
        HOUR("PER_HOUR"),
        PERSON("PER_PERSON"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        ADULT("PER_ADULT"),
        ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
        ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
        CHILD("PER_CHILD"),
        CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
        CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        LODGING("LODGING"),
        RAIL("RAIL"),
        AIR("AIR"),
        CAR("CAR"),
        CRUISE("CRUISE"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        RENTAL("RENTAL"),
        EXPERIENCE("EXPERIENCE"),
        ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
        ANCILLARY_FEE("ANCILLARY_FEE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PayableEnum {
        IMMEDIATE("IMMEDIATE"),
        ARRIVAL("ARRIVAL"),
        DEPARTURE("DEPARTURE"),
        AGENT("AGENT");

        private String value;

        private PayableEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayableEnum fromValue(String value) {
            for (PayableEnum b : PayableEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

