/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.affiliate.model.CancellationPolicyAffiliate;
import travel.wink.sdk.affiliate.model.CancellationPolicyExceptionsAffiliate;
import travel.wink.sdk.affiliate.model.DowPatternGroupAffiliate;

@ApiModel(description="Rate plan used for this stay")
@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "name", "prepaid", "breakfast", "brunch", "lunch", "dinner", "allInclusive", "allInclusivePlusAlcohol", "sellStartDate", "sellEndDate", "stayStartDate", "stayEndDate", "loyaltyPointsAccrue", "maxAdvanceBookingOffset", "minAdvanceBookingOffset", "minTotalOccupancy", "maxTotalOccupancy", "minLOS", "maxLOS", "minAge", "maxAge", "availableDaysOfWeek", "arrivalDaysOfWeek", "departureDaysOfWeek", "requiredDaysOfWeek", "earlyCheckInCharge", "lateCheckOutCharge", "cancellationPolicyIdentifier", "cancellationPolicy", "cancellationPolicyExceptions"})
@JsonTypeName(value="RatePlan_Affiliate")
public class RatePlanAffiliate {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PREPAID = "prepaid";
    private Boolean prepaid = false;
    public static final String JSON_PROPERTY_BREAKFAST = "breakfast";
    private Boolean breakfast = false;
    public static final String JSON_PROPERTY_BRUNCH = "brunch";
    private Boolean brunch = false;
    public static final String JSON_PROPERTY_LUNCH = "lunch";
    private Boolean lunch = false;
    public static final String JSON_PROPERTY_DINNER = "dinner";
    private Boolean dinner = false;
    public static final String JSON_PROPERTY_ALL_INCLUSIVE = "allInclusive";
    private Boolean allInclusive = false;
    public static final String JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL = "allInclusivePlusAlcohol";
    private Boolean allInclusivePlusAlcohol = false;
    public static final String JSON_PROPERTY_SELL_START_DATE = "sellStartDate";
    private LocalDate sellStartDate;
    public static final String JSON_PROPERTY_SELL_END_DATE = "sellEndDate";
    private LocalDate sellEndDate;
    public static final String JSON_PROPERTY_STAY_START_DATE = "stayStartDate";
    private LocalDate stayStartDate;
    public static final String JSON_PROPERTY_STAY_END_DATE = "stayEndDate";
    private LocalDate stayEndDate;
    public static final String JSON_PROPERTY_LOYALTY_POINTS_ACCRUE = "loyaltyPointsAccrue";
    private Boolean loyaltyPointsAccrue = false;
    public static final String JSON_PROPERTY_MAX_ADVANCE_BOOKING_OFFSET = "maxAdvanceBookingOffset";
    private Integer maxAdvanceBookingOffset;
    public static final String JSON_PROPERTY_MIN_ADVANCE_BOOKING_OFFSET = "minAdvanceBookingOffset";
    private Integer minAdvanceBookingOffset;
    public static final String JSON_PROPERTY_MIN_TOTAL_OCCUPANCY = "minTotalOccupancy";
    private Integer minTotalOccupancy;
    public static final String JSON_PROPERTY_MAX_TOTAL_OCCUPANCY = "maxTotalOccupancy";
    private Integer maxTotalOccupancy;
    public static final String JSON_PROPERTY_MIN_L_O_S = "minLOS";
    private Integer minLOS;
    public static final String JSON_PROPERTY_MAX_L_O_S = "maxLOS";
    private Integer maxLOS;
    public static final String JSON_PROPERTY_MIN_AGE = "minAge";
    private Integer minAge;
    public static final String JSON_PROPERTY_MAX_AGE = "maxAge";
    private Integer maxAge;
    public static final String JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK = "availableDaysOfWeek";
    private DowPatternGroupAffiliate availableDaysOfWeek;
    public static final String JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK = "arrivalDaysOfWeek";
    private DowPatternGroupAffiliate arrivalDaysOfWeek;
    public static final String JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK = "departureDaysOfWeek";
    private DowPatternGroupAffiliate departureDaysOfWeek;
    public static final String JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK = "requiredDaysOfWeek";
    private DowPatternGroupAffiliate requiredDaysOfWeek;
    public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE = "earlyCheckInCharge";
    private Object earlyCheckInCharge;
    public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE = "lateCheckOutCharge";
    private Object lateCheckOutCharge;
    public static final String JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER = "cancellationPolicyIdentifier";
    private String cancellationPolicyIdentifier;
    public static final String JSON_PROPERTY_CANCELLATION_POLICY = "cancellationPolicy";
    private CancellationPolicyAffiliate cancellationPolicy;
    public static final String JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS = "cancellationPolicyExceptions";
    private CancellationPolicyExceptionsAffiliate cancellationPolicyExceptions;

    public RatePlanAffiliate identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Rate plan identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public RatePlanAffiliate hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Hotel Identifier")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public RatePlanAffiliate name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="BAR 1", required=true, value="Provides the name of the rate plan.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public RatePlanAffiliate prepaid(Boolean prepaid) {
        this.prepaid = prepaid;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="When true, indicates if the rate is a prepaid rate.")
    @JsonProperty(value="prepaid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getPrepaid() {
        return this.prepaid;
    }

    @JsonProperty(value="prepaid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrepaid(Boolean prepaid) {
        this.prepaid = prepaid;
    }

    public RatePlanAffiliate breakfast(Boolean breakfast) {
        this.breakfast = breakfast;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="When true, indicates breakfast is included.")
    @JsonProperty(value="breakfast")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBreakfast() {
        return this.breakfast;
    }

    @JsonProperty(value="breakfast")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBreakfast(Boolean breakfast) {
        this.breakfast = breakfast;
    }

    public RatePlanAffiliate brunch(Boolean brunch) {
        this.brunch = brunch;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="When true, indicates brunch is included.")
    @JsonProperty(value="brunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBrunch() {
        return this.brunch;
    }

    @JsonProperty(value="brunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBrunch(Boolean brunch) {
        this.brunch = brunch;
    }

    public RatePlanAffiliate lunch(Boolean lunch) {
        this.lunch = lunch;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="When true, indicates lunch is included.")
    @JsonProperty(value="lunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getLunch() {
        return this.lunch;
    }

    @JsonProperty(value="lunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLunch(Boolean lunch) {
        this.lunch = lunch;
    }

    public RatePlanAffiliate dinner(Boolean dinner) {
        this.dinner = dinner;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="When true, indicates dinner is included.")
    @JsonProperty(value="dinner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getDinner() {
        return this.dinner;
    }

    @JsonProperty(value="dinner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDinner(Boolean dinner) {
        this.dinner = dinner;
    }

    public RatePlanAffiliate allInclusive(Boolean allInclusive) {
        this.allInclusive = allInclusive;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="Everything included except alcohol")
    @JsonProperty(value="allInclusive")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getAllInclusive() {
        return this.allInclusive;
    }

    @JsonProperty(value="allInclusive")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAllInclusive(Boolean allInclusive) {
        this.allInclusive = allInclusive;
    }

    public RatePlanAffiliate allInclusivePlusAlcohol(Boolean allInclusivePlusAlcohol) {
        this.allInclusivePlusAlcohol = allInclusivePlusAlcohol;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="Everything included with alcohol")
    @JsonProperty(value="allInclusivePlusAlcohol")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getAllInclusivePlusAlcohol() {
        return this.allInclusivePlusAlcohol;
    }

    @JsonProperty(value="allInclusivePlusAlcohol")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAllInclusivePlusAlcohol(Boolean allInclusivePlusAlcohol) {
        this.allInclusivePlusAlcohol = allInclusivePlusAlcohol;
    }

    public RatePlanAffiliate sellStartDate(LocalDate sellStartDate) {
        this.sellStartDate = sellStartDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Set a start date for when to start selling this rate. When sellStartDate and sellEndDate are set, this rate is only available for sale within that date range.")
    @JsonProperty(value="sellStartDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getSellStartDate() {
        return this.sellStartDate;
    }

    @JsonProperty(value="sellStartDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSellStartDate(LocalDate sellStartDate) {
        this.sellStartDate = sellStartDate;
    }

    public RatePlanAffiliate sellEndDate(LocalDate sellEndDate) {
        this.sellEndDate = sellEndDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Set an end date for when to finish selling this rate. When sellStartDate and sellEndDate are set, this rate is only available for sale within that date range.")
    @JsonProperty(value="sellEndDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getSellEndDate() {
        return this.sellEndDate;
    }

    @JsonProperty(value="sellEndDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSellEndDate(LocalDate sellEndDate) {
        this.sellEndDate = sellEndDate;
    }

    public RatePlanAffiliate stayStartDate(LocalDate stayStartDate) {
        this.stayStartDate = stayStartDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Set a start date for when the guest can visit. When stayStartDate and stayEndDate are set, this rate is only available for stay within that date range.")
    @JsonProperty(value="stayStartDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStayStartDate() {
        return this.stayStartDate;
    }

    @JsonProperty(value="stayStartDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStayStartDate(LocalDate stayStartDate) {
        this.stayStartDate = stayStartDate;
    }

    public RatePlanAffiliate stayEndDate(LocalDate stayEndDate) {
        this.stayEndDate = stayEndDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Set an end date for when the guest can visit. When stayStartDate and stayEndDate are set, this rate is only available for stay within that date range.")
    @JsonProperty(value="stayEndDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStayEndDate() {
        return this.stayEndDate;
    }

    @JsonProperty(value="stayEndDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStayEndDate(LocalDate stayEndDate) {
        this.stayEndDate = stayEndDate;
    }

    public RatePlanAffiliate loyaltyPointsAccrue(Boolean loyaltyPointsAccrue) {
        this.loyaltyPointsAccrue = loyaltyPointsAccrue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Property honors loyalty points with this rate plan.")
    @JsonProperty(value="loyaltyPointsAccrue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLoyaltyPointsAccrue() {
        return this.loyaltyPointsAccrue;
    }

    @JsonProperty(value="loyaltyPointsAccrue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLoyaltyPointsAccrue(Boolean loyaltyPointsAccrue) {
        this.loyaltyPointsAccrue = loyaltyPointsAccrue;
    }

    public RatePlanAffiliate maxAdvanceBookingOffset(Integer maxAdvanceBookingOffset) {
        this.maxAdvanceBookingOffset = maxAdvanceBookingOffset;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Maximum days before the arrival date for which this rate plan may be booked.")
    @JsonProperty(value="maxAdvanceBookingOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxAdvanceBookingOffset() {
        return this.maxAdvanceBookingOffset;
    }

    @JsonProperty(value="maxAdvanceBookingOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxAdvanceBookingOffset(Integer maxAdvanceBookingOffset) {
        this.maxAdvanceBookingOffset = maxAdvanceBookingOffset;
    }

    public RatePlanAffiliate minAdvanceBookingOffset(Integer minAdvanceBookingOffset) {
        this.minAdvanceBookingOffset = minAdvanceBookingOffset;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3", value="Minimum days before the arrival date for which this rate plan may be booked.")
    @JsonProperty(value="minAdvanceBookingOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinAdvanceBookingOffset() {
        return this.minAdvanceBookingOffset;
    }

    @JsonProperty(value="minAdvanceBookingOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinAdvanceBookingOffset(Integer minAdvanceBookingOffset) {
        this.minAdvanceBookingOffset = minAdvanceBookingOffset;
    }

    public RatePlanAffiliate minTotalOccupancy(Integer minTotalOccupancy) {
        this.minTotalOccupancy = minTotalOccupancy;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4", value="Defines the minimum number of total occupants required for this rate plan.")
    @JsonProperty(value="minTotalOccupancy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinTotalOccupancy() {
        return this.minTotalOccupancy;
    }

    @JsonProperty(value="minTotalOccupancy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinTotalOccupancy(Integer minTotalOccupancy) {
        this.minTotalOccupancy = minTotalOccupancy;
    }

    public RatePlanAffiliate maxTotalOccupancy(Integer maxTotalOccupancy) {
        this.maxTotalOccupancy = maxTotalOccupancy;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4", value="Defines the maximum number of total occupants required for this rate plan.")
    @JsonProperty(value="maxTotalOccupancy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxTotalOccupancy() {
        return this.maxTotalOccupancy;
    }

    @JsonProperty(value="maxTotalOccupancy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxTotalOccupancy(Integer maxTotalOccupancy) {
        this.maxTotalOccupancy = maxTotalOccupancy;
    }

    public RatePlanAffiliate minLOS(Integer minLOS) {
        this.minLOS = minLOS;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3", value="Indicates the minimum length of stay required for this rate plan.")
    @JsonProperty(value="minLOS")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinLOS() {
        return this.minLOS;
    }

    @JsonProperty(value="minLOS")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinLOS(Integer minLOS) {
        this.minLOS = minLOS;
    }

    public RatePlanAffiliate maxLOS(Integer maxLOS) {
        this.maxLOS = maxLOS;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5", value="Indicates the maximum length of stay.")
    @JsonProperty(value="maxLOS")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxLOS() {
        return this.maxLOS;
    }

    @JsonProperty(value="maxLOS")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxLOS(Integer maxLOS) {
        this.maxLOS = maxLOS;
    }

    public RatePlanAffiliate minAge(Integer minAge) {
        this.minAge = minAge;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="26", value="The minimum age to qualify for this rate plan.")
    @JsonProperty(value="minAge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinAge() {
        return this.minAge;
    }

    @JsonProperty(value="minAge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinAge(Integer minAge) {
        this.minAge = minAge;
    }

    public RatePlanAffiliate maxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="50", value="The maximum age to qualify for this rate plan.")
    @JsonProperty(value="maxAge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxAge() {
        return this.maxAge;
    }

    @JsonProperty(value="maxAge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public RatePlanAffiliate availableDaysOfWeek(DowPatternGroupAffiliate availableDaysOfWeek) {
        this.availableDaysOfWeek = availableDaysOfWeek;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="availableDaysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowPatternGroupAffiliate getAvailableDaysOfWeek() {
        return this.availableDaysOfWeek;
    }

    @JsonProperty(value="availableDaysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailableDaysOfWeek(DowPatternGroupAffiliate availableDaysOfWeek) {
        this.availableDaysOfWeek = availableDaysOfWeek;
    }

    public RatePlanAffiliate arrivalDaysOfWeek(DowPatternGroupAffiliate arrivalDaysOfWeek) {
        this.arrivalDaysOfWeek = arrivalDaysOfWeek;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="arrivalDaysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowPatternGroupAffiliate getArrivalDaysOfWeek() {
        return this.arrivalDaysOfWeek;
    }

    @JsonProperty(value="arrivalDaysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArrivalDaysOfWeek(DowPatternGroupAffiliate arrivalDaysOfWeek) {
        this.arrivalDaysOfWeek = arrivalDaysOfWeek;
    }

    public RatePlanAffiliate departureDaysOfWeek(DowPatternGroupAffiliate departureDaysOfWeek) {
        this.departureDaysOfWeek = departureDaysOfWeek;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="departureDaysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowPatternGroupAffiliate getDepartureDaysOfWeek() {
        return this.departureDaysOfWeek;
    }

    @JsonProperty(value="departureDaysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDepartureDaysOfWeek(DowPatternGroupAffiliate departureDaysOfWeek) {
        this.departureDaysOfWeek = departureDaysOfWeek;
    }

    public RatePlanAffiliate requiredDaysOfWeek(DowPatternGroupAffiliate requiredDaysOfWeek) {
        this.requiredDaysOfWeek = requiredDaysOfWeek;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="requiredDaysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowPatternGroupAffiliate getRequiredDaysOfWeek() {
        return this.requiredDaysOfWeek;
    }

    @JsonProperty(value="requiredDaysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequiredDaysOfWeek(DowPatternGroupAffiliate requiredDaysOfWeek) {
        this.requiredDaysOfWeek = requiredDaysOfWeek;
    }

    public RatePlanAffiliate earlyCheckInCharge(Object earlyCheckInCharge) {
        this.earlyCheckInCharge = earlyCheckInCharge;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="earlyCheckInCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getEarlyCheckInCharge() {
        return this.earlyCheckInCharge;
    }

    @JsonProperty(value="earlyCheckInCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEarlyCheckInCharge(Object earlyCheckInCharge) {
        this.earlyCheckInCharge = earlyCheckInCharge;
    }

    public RatePlanAffiliate lateCheckOutCharge(Object lateCheckOutCharge) {
        this.lateCheckOutCharge = lateCheckOutCharge;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="lateCheckOutCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getLateCheckOutCharge() {
        return this.lateCheckOutCharge;
    }

    @JsonProperty(value="lateCheckOutCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLateCheckOutCharge(Object lateCheckOutCharge) {
        this.lateCheckOutCharge = lateCheckOutCharge;
    }

    public RatePlanAffiliate cancellationPolicyIdentifier(String cancellationPolicyIdentifier) {
        this.cancellationPolicyIdentifier = cancellationPolicyIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="cancellation-policy-1", required=true, value="The cancellation policy for this rate plan.")
    @JsonProperty(value="cancellationPolicyIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCancellationPolicyIdentifier() {
        return this.cancellationPolicyIdentifier;
    }

    @JsonProperty(value="cancellationPolicyIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCancellationPolicyIdentifier(String cancellationPolicyIdentifier) {
        this.cancellationPolicyIdentifier = cancellationPolicyIdentifier;
    }

    public RatePlanAffiliate cancellationPolicy(CancellationPolicyAffiliate cancellationPolicy) {
        this.cancellationPolicy = cancellationPolicy;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="cancellationPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellationPolicyAffiliate getCancellationPolicy() {
        return this.cancellationPolicy;
    }

    @JsonProperty(value="cancellationPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellationPolicy(CancellationPolicyAffiliate cancellationPolicy) {
        this.cancellationPolicy = cancellationPolicy;
    }

    public RatePlanAffiliate cancellationPolicyExceptions(CancellationPolicyExceptionsAffiliate cancellationPolicyExceptions) {
        this.cancellationPolicyExceptions = cancellationPolicyExceptions;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="cancellationPolicyExceptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellationPolicyExceptionsAffiliate getCancellationPolicyExceptions() {
        return this.cancellationPolicyExceptions;
    }

    @JsonProperty(value="cancellationPolicyExceptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellationPolicyExceptions(CancellationPolicyExceptionsAffiliate cancellationPolicyExceptions) {
        this.cancellationPolicyExceptions = cancellationPolicyExceptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RatePlanAffiliate ratePlanAffiliate = (RatePlanAffiliate)o;
        return Objects.equals(this.identifier, ratePlanAffiliate.identifier) && Objects.equals(this.hotelIdentifier, ratePlanAffiliate.hotelIdentifier) && Objects.equals(this.name, ratePlanAffiliate.name) && Objects.equals(this.prepaid, ratePlanAffiliate.prepaid) && Objects.equals(this.breakfast, ratePlanAffiliate.breakfast) && Objects.equals(this.brunch, ratePlanAffiliate.brunch) && Objects.equals(this.lunch, ratePlanAffiliate.lunch) && Objects.equals(this.dinner, ratePlanAffiliate.dinner) && Objects.equals(this.allInclusive, ratePlanAffiliate.allInclusive) && Objects.equals(this.allInclusivePlusAlcohol, ratePlanAffiliate.allInclusivePlusAlcohol) && Objects.equals(this.sellStartDate, ratePlanAffiliate.sellStartDate) && Objects.equals(this.sellEndDate, ratePlanAffiliate.sellEndDate) && Objects.equals(this.stayStartDate, ratePlanAffiliate.stayStartDate) && Objects.equals(this.stayEndDate, ratePlanAffiliate.stayEndDate) && Objects.equals(this.loyaltyPointsAccrue, ratePlanAffiliate.loyaltyPointsAccrue) && Objects.equals(this.maxAdvanceBookingOffset, ratePlanAffiliate.maxAdvanceBookingOffset) && Objects.equals(this.minAdvanceBookingOffset, ratePlanAffiliate.minAdvanceBookingOffset) && Objects.equals(this.minTotalOccupancy, ratePlanAffiliate.minTotalOccupancy) && Objects.equals(this.maxTotalOccupancy, ratePlanAffiliate.maxTotalOccupancy) && Objects.equals(this.minLOS, ratePlanAffiliate.minLOS) && Objects.equals(this.maxLOS, ratePlanAffiliate.maxLOS) && Objects.equals(this.minAge, ratePlanAffiliate.minAge) && Objects.equals(this.maxAge, ratePlanAffiliate.maxAge) && Objects.equals(this.availableDaysOfWeek, ratePlanAffiliate.availableDaysOfWeek) && Objects.equals(this.arrivalDaysOfWeek, ratePlanAffiliate.arrivalDaysOfWeek) && Objects.equals(this.departureDaysOfWeek, ratePlanAffiliate.departureDaysOfWeek) && Objects.equals(this.requiredDaysOfWeek, ratePlanAffiliate.requiredDaysOfWeek) && Objects.equals(this.earlyCheckInCharge, ratePlanAffiliate.earlyCheckInCharge) && Objects.equals(this.lateCheckOutCharge, ratePlanAffiliate.lateCheckOutCharge) && Objects.equals(this.cancellationPolicyIdentifier, ratePlanAffiliate.cancellationPolicyIdentifier) && Objects.equals(this.cancellationPolicy, ratePlanAffiliate.cancellationPolicy) && Objects.equals(this.cancellationPolicyExceptions, ratePlanAffiliate.cancellationPolicyExceptions);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.hotelIdentifier, this.name, this.prepaid, this.breakfast, this.brunch, this.lunch, this.dinner, this.allInclusive, this.allInclusivePlusAlcohol, this.sellStartDate, this.sellEndDate, this.stayStartDate, this.stayEndDate, this.loyaltyPointsAccrue, this.maxAdvanceBookingOffset, this.minAdvanceBookingOffset, this.minTotalOccupancy, this.maxTotalOccupancy, this.minLOS, this.maxLOS, this.minAge, this.maxAge, this.availableDaysOfWeek, this.arrivalDaysOfWeek, this.departureDaysOfWeek, this.requiredDaysOfWeek, this.earlyCheckInCharge, this.lateCheckOutCharge, this.cancellationPolicyIdentifier, this.cancellationPolicy, this.cancellationPolicyExceptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RatePlanAffiliate {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    prepaid: ").append(this.toIndentedString(this.prepaid)).append("\n");
        sb.append("    breakfast: ").append(this.toIndentedString(this.breakfast)).append("\n");
        sb.append("    brunch: ").append(this.toIndentedString(this.brunch)).append("\n");
        sb.append("    lunch: ").append(this.toIndentedString(this.lunch)).append("\n");
        sb.append("    dinner: ").append(this.toIndentedString(this.dinner)).append("\n");
        sb.append("    allInclusive: ").append(this.toIndentedString(this.allInclusive)).append("\n");
        sb.append("    allInclusivePlusAlcohol: ").append(this.toIndentedString(this.allInclusivePlusAlcohol)).append("\n");
        sb.append("    sellStartDate: ").append(this.toIndentedString(this.sellStartDate)).append("\n");
        sb.append("    sellEndDate: ").append(this.toIndentedString(this.sellEndDate)).append("\n");
        sb.append("    stayStartDate: ").append(this.toIndentedString(this.stayStartDate)).append("\n");
        sb.append("    stayEndDate: ").append(this.toIndentedString(this.stayEndDate)).append("\n");
        sb.append("    loyaltyPointsAccrue: ").append(this.toIndentedString(this.loyaltyPointsAccrue)).append("\n");
        sb.append("    maxAdvanceBookingOffset: ").append(this.toIndentedString(this.maxAdvanceBookingOffset)).append("\n");
        sb.append("    minAdvanceBookingOffset: ").append(this.toIndentedString(this.minAdvanceBookingOffset)).append("\n");
        sb.append("    minTotalOccupancy: ").append(this.toIndentedString(this.minTotalOccupancy)).append("\n");
        sb.append("    maxTotalOccupancy: ").append(this.toIndentedString(this.maxTotalOccupancy)).append("\n");
        sb.append("    minLOS: ").append(this.toIndentedString(this.minLOS)).append("\n");
        sb.append("    maxLOS: ").append(this.toIndentedString(this.maxLOS)).append("\n");
        sb.append("    minAge: ").append(this.toIndentedString(this.minAge)).append("\n");
        sb.append("    maxAge: ").append(this.toIndentedString(this.maxAge)).append("\n");
        sb.append("    availableDaysOfWeek: ").append(this.toIndentedString(this.availableDaysOfWeek)).append("\n");
        sb.append("    arrivalDaysOfWeek: ").append(this.toIndentedString(this.arrivalDaysOfWeek)).append("\n");
        sb.append("    departureDaysOfWeek: ").append(this.toIndentedString(this.departureDaysOfWeek)).append("\n");
        sb.append("    requiredDaysOfWeek: ").append(this.toIndentedString(this.requiredDaysOfWeek)).append("\n");
        sb.append("    earlyCheckInCharge: ").append(this.toIndentedString(this.earlyCheckInCharge)).append("\n");
        sb.append("    lateCheckOutCharge: ").append(this.toIndentedString(this.lateCheckOutCharge)).append("\n");
        sb.append("    cancellationPolicyIdentifier: ").append(this.toIndentedString(this.cancellationPolicyIdentifier)).append("\n");
        sb.append("    cancellationPolicy: ").append(this.toIndentedString(this.cancellationPolicy)).append("\n");
        sb.append("    cancellationPolicyExceptions: ").append(this.toIndentedString(this.cancellationPolicyExceptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

