package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.AdvancedMapConfigurationAffiliate;
import travel.wink.sdk.affiliate.model.AdvancedMapConfigurationViewAffiliate;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.InventoryMapMarkerAffiliate;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.ShowSellerUrl400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-10T10:47:30.893146041+07:00[Asia/Bangkok]")
public class MapsApi {
    private ApiClient apiClient;

    public MapsApi() {
        this(new ApiClient());
    }

    @Autowired
    public MapsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Map
     * Create a new advanced map configuration
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create map owned by this owner identifier.
     * @param advancedMapConfigurationAffiliate The advancedMapConfigurationAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AdvancedMapConfigurationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAdvancedMapConfigurationRequestCreation(String companyIdentifier, AdvancedMapConfigurationAffiliate advancedMapConfigurationAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = advancedMapConfigurationAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'advancedMapConfigurationAffiliate' is set
        if (advancedMapConfigurationAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'advancedMapConfigurationAffiliate' when calling createAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/map", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Map
     * Create a new advanced map configuration
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create map owned by this owner identifier.
     * @param advancedMapConfigurationAffiliate The advancedMapConfigurationAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AdvancedMapConfigurationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AdvancedMapConfigurationViewAffiliate> createAdvancedMapConfiguration(String companyIdentifier, AdvancedMapConfigurationAffiliate advancedMapConfigurationAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>() {};
        return createAdvancedMapConfigurationRequestCreation(companyIdentifier, advancedMapConfigurationAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationViewAffiliate>> createAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, AdvancedMapConfigurationAffiliate advancedMapConfigurationAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>() {};
        return createAdvancedMapConfigurationRequestCreation(companyIdentifier, advancedMapConfigurationAffiliate, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Delete Map
     * Remove an advanced map configuration
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove map owned by this owner identifier.
     * @param mapIdentifier Remove map record with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAdvancedMapConfigurationRequestCreation(String companyIdentifier, String mapIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'mapIdentifier' is set
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling removeAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("mapIdentifier", mapIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/map/{mapIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Map
     * Remove an advanced map configuration
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove map owned by this owner identifier.
     * @param mapIdentifier Remove map record with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeAdvancedMapConfiguration(String companyIdentifier, String mapIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, String mapIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Map
     * Retrieve a specific map record
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show map record owned by this owner identifier.
     * @param mapIdentifier Show map record with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return AdvancedMapConfigurationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAdvancedMapConfigurationRequestCreation(String companyIdentifier, String mapIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'mapIdentifier' is set
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling showAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("mapIdentifier", mapIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/map/{mapIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Map
     * Retrieve a specific map record
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show map record owned by this owner identifier.
     * @param mapIdentifier Show map record with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return AdvancedMapConfigurationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AdvancedMapConfigurationViewAffiliate> showAdvancedMapConfiguration(String companyIdentifier, String mapIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>() {};
        return showAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationViewAffiliate>> showAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, String mapIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>() {};
        return showAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Map Marker
     * Retrieve map marker for individual channel inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show map markers for map owned by this owner identifier.
     * @param channelInventoryIdentifier Show map marker for specific inventory.
     * @param winkVersion The winkVersion parameter
     * @return InventoryMapMarkerAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAdvancedMapConfigurationMapMarkerRequestCreation(String companyIdentifier, String channelInventoryIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfigurationMapMarker", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'channelInventoryIdentifier' is set
        if (channelInventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'channelInventoryIdentifier' when calling showAdvancedMapConfigurationMapMarker", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("channelInventoryIdentifier", channelInventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/map/marker/{channelInventoryIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Map Marker
     * Retrieve map marker for individual channel inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show map markers for map owned by this owner identifier.
     * @param channelInventoryIdentifier Show map marker for specific inventory.
     * @param winkVersion The winkVersion parameter
     * @return InventoryMapMarkerAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryMapMarkerAffiliate> showAdvancedMapConfigurationMapMarker(String companyIdentifier, String channelInventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>() {};
        return showAdvancedMapConfigurationMapMarkerRequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryMapMarkerAffiliate>> showAdvancedMapConfigurationMapMarkerWithHttpInfo(String companyIdentifier, String channelInventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>() {};
        return showAdvancedMapConfigurationMapMarkerRequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Map Markers
     * Retrieve a list of advanced map configuration inventory markers by type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show map markers for list owned by this owner identifier.
     * @param listIdentifier Show map markers for list.
     * @param listType Indicate whether this list is a curated or dynamic list.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;InventoryMapMarkerAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAdvancedMapConfigurationMapMarkersRequestCreation(String companyIdentifier, String listIdentifier, String listType, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfigurationMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showAdvancedMapConfigurationMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listType' is set
        if (listType == null) {
            throw new WebClientResponseException("Missing the required parameter 'listType' when calling showAdvancedMapConfigurationMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("listType", listType);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/map/markers/{listType}/{listIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Map Markers
     * Retrieve a list of advanced map configuration inventory markers by type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show map markers for list owned by this owner identifier.
     * @param listIdentifier Show map markers for list.
     * @param listType Indicate whether this list is a curated or dynamic list.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;InventoryMapMarkerAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<InventoryMapMarkerAffiliate> showAdvancedMapConfigurationMapMarkers(String companyIdentifier, String listIdentifier, String listType, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>() {};
        return showAdvancedMapConfigurationMapMarkersRequestCreation(companyIdentifier, listIdentifier, listType, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventoryMapMarkerAffiliate>>> showAdvancedMapConfigurationMapMarkersWithHttpInfo(String companyIdentifier, String listIdentifier, String listType, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>() {};
        return showAdvancedMapConfigurationMapMarkersRequestCreation(companyIdentifier, listIdentifier, listType, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Show Maps
     * Retrieve list of existing maps.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List maps owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;AdvancedMapConfigurationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAdvancedMapConfigurationsRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfigurations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/map", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Maps
     * Retrieve list of existing maps.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List maps owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;AdvancedMapConfigurationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<AdvancedMapConfigurationViewAffiliate> showAdvancedMapConfigurations(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>() {};
        return showAdvancedMapConfigurationsRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<AdvancedMapConfigurationViewAffiliate>>> showAdvancedMapConfigurationsWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>() {};
        return showAdvancedMapConfigurationsRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Update Map
     * Update an advanced map configuration
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update map owned by this owner identifier.
     * @param mapIdentifier update map record with this identifier.
     * @param advancedMapConfigurationAffiliate The advancedMapConfigurationAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AdvancedMapConfigurationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAdvancedMapConfigurationRequestCreation(String companyIdentifier, String mapIdentifier, AdvancedMapConfigurationAffiliate advancedMapConfigurationAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = advancedMapConfigurationAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'mapIdentifier' is set
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling updateAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'advancedMapConfigurationAffiliate' is set
        if (advancedMapConfigurationAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'advancedMapConfigurationAffiliate' when calling updateAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("mapIdentifier", mapIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/map/{mapIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Map
     * Update an advanced map configuration
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update map owned by this owner identifier.
     * @param mapIdentifier update map record with this identifier.
     * @param advancedMapConfigurationAffiliate The advancedMapConfigurationAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AdvancedMapConfigurationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AdvancedMapConfigurationViewAffiliate> updateAdvancedMapConfiguration(String companyIdentifier, String mapIdentifier, AdvancedMapConfigurationAffiliate advancedMapConfigurationAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>() {};
        return updateAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, advancedMapConfigurationAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationViewAffiliate>> updateAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, String mapIdentifier, AdvancedMapConfigurationAffiliate advancedMapConfigurationAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>() {};
        return updateAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, advancedMapConfigurationAffiliate, winkVersion).toEntity(localVarReturnType);
    }
}
