/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 24.3.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.ReviewAnswerAffiliate;
import travel.wink.sdk.affiliate.model.ReviewUserAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * User review created by the traveler after the booking completed.
 */
@ApiModel(description = "User review created by the traveler after the booking completed.")
@JsonPropertyOrder({
  ReviewAffiliate.JSON_PROPERTY_IDENTIFIER,
  ReviewAffiliate.JSON_PROPERTY_BOOKING_IDENTIFIER,
  ReviewAffiliate.JSON_PROPERTY_HOTEL_IDENTIFIER,
  ReviewAffiliate.JSON_PROPERTY_USER,
  ReviewAffiliate.JSON_PROPERTY_REVIEW_DATE,
  ReviewAffiliate.JSON_PROPERTY_AVERAGE_SCORE,
  ReviewAffiliate.JSON_PROPERTY_ANSWERS,
  ReviewAffiliate.JSON_PROPERTY_MESSAGE_FROM_GUEST,
  ReviewAffiliate.JSON_PROPERTY_RESPONSE_FROM_HOTEL,
  ReviewAffiliate.JSON_PROPERTY_IMAGE_IDENTIFIER,
  ReviewAffiliate.JSON_PROPERTY_TEXT,
  ReviewAffiliate.JSON_PROPERTY_APPROVED_TEXT,
  ReviewAffiliate.JSON_PROPERTY_APPROVED_IMAGE,
  ReviewAffiliate.JSON_PROPERTY_LIKES,
  ReviewAffiliate.JSON_PROPERTY_ROOM_NUMBER,
  ReviewAffiliate.JSON_PROPERTY_ROOM_RATING,
  ReviewAffiliate.JSON_PROPERTY_COMPLETED,
  ReviewAffiliate.JSON_PROPERTY_RESPONDED,
  ReviewAffiliate.JSON_PROPERTY_EARNED_TRAVELKOINS,
  ReviewAffiliate.JSON_PROPERTY_EARNED_EXTRA_TRAVELKOINS,
  ReviewAffiliate.JSON_PROPERTY_AWARDED_TRAVELKOINS
})
@JsonTypeName("Review_Affiliate")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-10T10:47:30.893146041+07:00[Asia/Bangkok]")
public class ReviewAffiliate {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_BOOKING_IDENTIFIER = "bookingIdentifier";
  private UUID bookingIdentifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_USER = "user";
  private ReviewUserAffiliate user;

  public static final String JSON_PROPERTY_REVIEW_DATE = "reviewDate";
  private java.time.LocalDateTime reviewDate;

  public static final String JSON_PROPERTY_AVERAGE_SCORE = "averageScore";
  private Double averageScore;

  public static final String JSON_PROPERTY_ANSWERS = "answers";
  private List<ReviewAnswerAffiliate> answers = null;

  public static final String JSON_PROPERTY_MESSAGE_FROM_GUEST = "messageFromGuest";
  private String messageFromGuest;

  public static final String JSON_PROPERTY_RESPONSE_FROM_HOTEL = "responseFromHotel";
  private String responseFromHotel;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  public static final String JSON_PROPERTY_TEXT = "text";
  private String text;

  public static final String JSON_PROPERTY_APPROVED_TEXT = "approvedText";
  private Boolean approvedText;

  public static final String JSON_PROPERTY_APPROVED_IMAGE = "approvedImage";
  private Boolean approvedImage;

  public static final String JSON_PROPERTY_LIKES = "likes";
  private List<String> likes = null;

  public static final String JSON_PROPERTY_ROOM_NUMBER = "roomNumber";
  private String roomNumber;

  public static final String JSON_PROPERTY_ROOM_RATING = "roomRating";
  private Integer roomRating;

  public static final String JSON_PROPERTY_COMPLETED = "completed";
  private Boolean completed = false;

  public static final String JSON_PROPERTY_RESPONDED = "responded";
  private Boolean responded = false;

  public static final String JSON_PROPERTY_EARNED_TRAVELKOINS = "earnedTravelkoins";
  private Double earnedTravelkoins;

  public static final String JSON_PROPERTY_EARNED_EXTRA_TRAVELKOINS = "earnedExtraTravelkoins";
  private Double earnedExtraTravelkoins;

  public static final String JSON_PROPERTY_AWARDED_TRAVELKOINS = "awardedTravelkoins";
  private Double awardedTravelkoins;

  public ReviewAffiliate() { 
  }

  public ReviewAffiliate identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique review identifier identifying this record.
   * @return identifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Unique review identifier identifying this record.")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public ReviewAffiliate bookingIdentifier(UUID bookingIdentifier) {
    
    this.bookingIdentifier = bookingIdentifier;
    return this;
  }

   /**
   * Booking identifier identifier booking this review is associated with.
   * @return bookingIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Booking identifier identifier booking this review is associated with.")
  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getBookingIdentifier() {
    return bookingIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingIdentifier(UUID bookingIdentifier) {
    this.bookingIdentifier = bookingIdentifier;
  }


  public ReviewAffiliate hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier this booking is associated with.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Hotel identifier this booking is associated with.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public ReviewAffiliate user(ReviewUserAffiliate user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ReviewUserAffiliate getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUser(ReviewUserAffiliate user) {
    this.user = user;
  }


  public ReviewAffiliate reviewDate(java.time.LocalDateTime reviewDate) {
    
    this.reviewDate = reviewDate;
    return this;
  }

   /**
   * Date of review.
   * @return reviewDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Date of review.")
  @JsonProperty(JSON_PROPERTY_REVIEW_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getReviewDate() {
    return reviewDate;
  }


  @JsonProperty(JSON_PROPERTY_REVIEW_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviewDate(java.time.LocalDateTime reviewDate) {
    this.reviewDate = reviewDate;
  }


  public ReviewAffiliate averageScore(Double averageScore) {
    
    this.averageScore = averageScore;
    return this;
  }

   /**
   * Total points divided by number of questions.
   * @return averageScore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "8.7", value = "Total points divided by number of questions.")
  @JsonProperty(JSON_PROPERTY_AVERAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getAverageScore() {
    return averageScore;
  }


  @JsonProperty(JSON_PROPERTY_AVERAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAverageScore(Double averageScore) {
    this.averageScore = averageScore;
  }


  public ReviewAffiliate answers(List<ReviewAnswerAffiliate> answers) {
    
    this.answers = answers;
    return this;
  }

  public ReviewAffiliate addAnswersItem(ReviewAnswerAffiliate answersItem) {
    if (this.answers == null) {
      this.answers = new ArrayList<>();
    }
    this.answers.add(answersItem);
    return this;
  }

   /**
   * List of user review answers.
   * @return answers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "List of user review answers.")
  @JsonProperty(JSON_PROPERTY_ANSWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ReviewAnswerAffiliate> getAnswers() {
    return answers;
  }


  @JsonProperty(JSON_PROPERTY_ANSWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnswers(List<ReviewAnswerAffiliate> answers) {
    this.answers = answers;
  }


  public ReviewAffiliate messageFromGuest(String messageFromGuest) {
    
    this.messageFromGuest = messageFromGuest;
    return this;
  }

   /**
   * Private message from guest to the hotel. Is not displayed on property profile.
   * @return messageFromGuest
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Dear GM, I would like to say thank you so much for taking the time to show my husband and I around the premises and the secret cave behind the property.", value = "Private message from guest to the hotel. Is not displayed on property profile.")
  @JsonProperty(JSON_PROPERTY_MESSAGE_FROM_GUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessageFromGuest() {
    return messageFromGuest;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_FROM_GUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageFromGuest(String messageFromGuest) {
    this.messageFromGuest = messageFromGuest;
  }


  public ReviewAffiliate responseFromHotel(String responseFromHotel) {
    
    this.responseFromHotel = responseFromHotel;
    return this;
  }

   /**
   * Property can response to traveler review. Response goes on public review profile and can be seen by others.
   * @return responseFromHotel
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "It was so great to have you at our hotel. Please recommend your friends and come again soon.", value = "Property can response to traveler review. Response goes on public review profile and can be seen by others.")
  @JsonProperty(JSON_PROPERTY_RESPONSE_FROM_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResponseFromHotel() {
    return responseFromHotel;
  }


  @JsonProperty(JSON_PROPERTY_RESPONSE_FROM_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResponseFromHotel(String responseFromHotel) {
    this.responseFromHotel = responseFromHotel;
  }


  public ReviewAffiliate imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Reviewer can upload her best picture from the property. Cloudinary image identifier.
   * @return imageIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "cloudinary-image-1", value = "Reviewer can upload her best picture from the property. Cloudinary image identifier.")
  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public ReviewAffiliate text(String text) {
    
    this.text = text;
    return this;
  }

   /**
   * Free text record created by traveler
   * @return text
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Our stay was amazing! Can recommend highly to all. Felt like home.", value = "Free text record created by traveler")
  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setText(String text) {
    this.text = text;
  }


  public ReviewAffiliate approvedText(Boolean approvedText) {
    
    this.approvedText = approvedText;
    return this;
  }

   /**
   * Hotel allows the review text to be displayed as part of their profile.
   * @return approvedText
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Hotel allows the review text to be displayed as part of their profile.")
  @JsonProperty(JSON_PROPERTY_APPROVED_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getApprovedText() {
    return approvedText;
  }


  @JsonProperty(JSON_PROPERTY_APPROVED_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApprovedText(Boolean approvedText) {
    this.approvedText = approvedText;
  }


  public ReviewAffiliate approvedImage(Boolean approvedImage) {
    
    this.approvedImage = approvedImage;
    return this;
  }

   /**
   * Hotel allows the user-generated image to be displayed as part of their profile.
   * @return approvedImage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Hotel allows the user-generated image to be displayed as part of their profile.")
  @JsonProperty(JSON_PROPERTY_APPROVED_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getApprovedImage() {
    return approvedImage;
  }


  @JsonProperty(JSON_PROPERTY_APPROVED_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApprovedImage(Boolean approvedImage) {
    this.approvedImage = approvedImage;
  }


  public ReviewAffiliate likes(List<String> likes) {
    
    this.likes = likes;
    return this;
  }

  public ReviewAffiliate addLikesItem(String likesItem) {
    if (this.likes == null) {
      this.likes = new ArrayList<>();
    }
    this.likes.add(likesItem);
    return this;
  }

   /**
   * List of member identifiers who liked the textual review
   * @return likes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "user-1", value = "List of member identifiers who liked the textual review")
  @JsonProperty(JSON_PROPERTY_LIKES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getLikes() {
    return likes;
  }


  @JsonProperty(JSON_PROPERTY_LIKES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLikes(List<String> likes) {
    this.likes = likes;
  }


  public ReviewAffiliate roomNumber(String roomNumber) {
    
    this.roomNumber = roomNumber;
    return this;
  }

   /**
   * Guest&#39;s room number during their stay.
   * @return roomNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "501", value = "Guest's room number during their stay.")
  @JsonProperty(JSON_PROPERTY_ROOM_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomNumber() {
    return roomNumber;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomNumber(String roomNumber) {
    this.roomNumber = roomNumber;
  }


  public ReviewAffiliate roomRating(Integer roomRating) {
    
    this.roomRating = roomRating;
    return this;
  }

   /**
   * Guest&#39;s room rating
   * @return roomRating
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "7", value = "Guest's room rating")
  @JsonProperty(JSON_PROPERTY_ROOM_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRoomRating() {
    return roomRating;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRating(Integer roomRating) {
    this.roomRating = roomRating;
  }


  public ReviewAffiliate completed(Boolean completed) {
    
    this.completed = completed;
    return this;
  }

   /**
   * When the guest has completed the first and second part of the review.
   * @return completed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "When the guest has completed the first and second part of the review.")
  @JsonProperty(JSON_PROPERTY_COMPLETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCompleted() {
    return completed;
  }


  @JsonProperty(JSON_PROPERTY_COMPLETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompleted(Boolean completed) {
    this.completed = completed;
  }


  public ReviewAffiliate responded(Boolean responded) {
    
    this.responded = responded;
    return this;
  }

   /**
   * Returns true if property has responded to the review given gy the guest.
   * @return responded
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Returns true if property has responded to the review given gy the guest.")
  @JsonProperty(JSON_PROPERTY_RESPONDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getResponded() {
    return responded;
  }


  @JsonProperty(JSON_PROPERTY_RESPONDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResponded(Boolean responded) {
    this.responded = responded;
  }


  public ReviewAffiliate earnedTravelkoins(Double earnedTravelkoins) {
    
    this.earnedTravelkoins = earnedTravelkoins;
    return this;
  }

   /**
   * Get earnedTravelkoins
   * @return earnedTravelkoins
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EARNED_TRAVELKOINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getEarnedTravelkoins() {
    return earnedTravelkoins;
  }


  @JsonProperty(JSON_PROPERTY_EARNED_TRAVELKOINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEarnedTravelkoins(Double earnedTravelkoins) {
    this.earnedTravelkoins = earnedTravelkoins;
  }


  public ReviewAffiliate earnedExtraTravelkoins(Double earnedExtraTravelkoins) {
    
    this.earnedExtraTravelkoins = earnedExtraTravelkoins;
    return this;
  }

   /**
   * Get earnedExtraTravelkoins
   * @return earnedExtraTravelkoins
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EARNED_EXTRA_TRAVELKOINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getEarnedExtraTravelkoins() {
    return earnedExtraTravelkoins;
  }


  @JsonProperty(JSON_PROPERTY_EARNED_EXTRA_TRAVELKOINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEarnedExtraTravelkoins(Double earnedExtraTravelkoins) {
    this.earnedExtraTravelkoins = earnedExtraTravelkoins;
  }


  public ReviewAffiliate awardedTravelkoins(Double awardedTravelkoins) {
    
    this.awardedTravelkoins = awardedTravelkoins;
    return this;
  }

   /**
   * Get awardedTravelkoins
   * @return awardedTravelkoins
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AWARDED_TRAVELKOINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getAwardedTravelkoins() {
    return awardedTravelkoins;
  }


  @JsonProperty(JSON_PROPERTY_AWARDED_TRAVELKOINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAwardedTravelkoins(Double awardedTravelkoins) {
    this.awardedTravelkoins = awardedTravelkoins;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReviewAffiliate reviewAffiliate = (ReviewAffiliate) o;
    return Objects.equals(this.identifier, reviewAffiliate.identifier) &&
        Objects.equals(this.bookingIdentifier, reviewAffiliate.bookingIdentifier) &&
        Objects.equals(this.hotelIdentifier, reviewAffiliate.hotelIdentifier) &&
        Objects.equals(this.user, reviewAffiliate.user) &&
        Objects.equals(this.reviewDate, reviewAffiliate.reviewDate) &&
        Objects.equals(this.averageScore, reviewAffiliate.averageScore) &&
        Objects.equals(this.answers, reviewAffiliate.answers) &&
        Objects.equals(this.messageFromGuest, reviewAffiliate.messageFromGuest) &&
        Objects.equals(this.responseFromHotel, reviewAffiliate.responseFromHotel) &&
        Objects.equals(this.imageIdentifier, reviewAffiliate.imageIdentifier) &&
        Objects.equals(this.text, reviewAffiliate.text) &&
        Objects.equals(this.approvedText, reviewAffiliate.approvedText) &&
        Objects.equals(this.approvedImage, reviewAffiliate.approvedImage) &&
        Objects.equals(this.likes, reviewAffiliate.likes) &&
        Objects.equals(this.roomNumber, reviewAffiliate.roomNumber) &&
        Objects.equals(this.roomRating, reviewAffiliate.roomRating) &&
        Objects.equals(this.completed, reviewAffiliate.completed) &&
        Objects.equals(this.responded, reviewAffiliate.responded) &&
        Objects.equals(this.earnedTravelkoins, reviewAffiliate.earnedTravelkoins) &&
        Objects.equals(this.earnedExtraTravelkoins, reviewAffiliate.earnedExtraTravelkoins) &&
        Objects.equals(this.awardedTravelkoins, reviewAffiliate.awardedTravelkoins);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, bookingIdentifier, hotelIdentifier, user, reviewDate, averageScore, answers, messageFromGuest, responseFromHotel, imageIdentifier, text, approvedText, approvedImage, likes, roomNumber, roomRating, completed, responded, earnedTravelkoins, earnedExtraTravelkoins, awardedTravelkoins);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReviewAffiliate {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    bookingIdentifier: ").append(toIndentedString(bookingIdentifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    reviewDate: ").append(toIndentedString(reviewDate)).append("\n");
    sb.append("    averageScore: ").append(toIndentedString(averageScore)).append("\n");
    sb.append("    answers: ").append(toIndentedString(answers)).append("\n");
    sb.append("    messageFromGuest: ").append(toIndentedString(messageFromGuest)).append("\n");
    sb.append("    responseFromHotel: ").append(toIndentedString(responseFromHotel)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    approvedText: ").append(toIndentedString(approvedText)).append("\n");
    sb.append("    approvedImage: ").append(toIndentedString(approvedImage)).append("\n");
    sb.append("    likes: ").append(toIndentedString(likes)).append("\n");
    sb.append("    roomNumber: ").append(toIndentedString(roomNumber)).append("\n");
    sb.append("    roomRating: ").append(toIndentedString(roomRating)).append("\n");
    sb.append("    completed: ").append(toIndentedString(completed)).append("\n");
    sb.append("    responded: ").append(toIndentedString(responded)).append("\n");
    sb.append("    earnedTravelkoins: ").append(toIndentedString(earnedTravelkoins)).append("\n");
    sb.append("    earnedExtraTravelkoins: ").append(toIndentedString(earnedExtraTravelkoins)).append("\n");
    sb.append("    awardedTravelkoins: ").append(toIndentedString(awardedTravelkoins)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

