/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.affiliate.model.AddressAffiliate;
import travel.wink.sdk.affiliate.model.BedroomConfigurationAffiliate;
import travel.wink.sdk.affiliate.model.ContactAffiliate;
import travel.wink.sdk.affiliate.model.GeoJsonPointAffiliate;
import travel.wink.sdk.affiliate.model.SimpleDescriptionAffiliate;
import travel.wink.sdk.affiliate.model.SimpleMultimediaAffiliate;
import travel.wink.sdk.affiliate.model.SocialAffiliate;
import travel.wink.sdk.affiliate.model.TravelInventoryRecognitionAffiliate;

@ApiModel(description="Guest room details.")
@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "featuredInd", "lifestyleType", "location", "descriptions", "multimedias", "contact", "address", "commissionable", "name", "proximityCode", "sort", "minAgeAppropriateCode", "bookable", "active", "disabilityFeatures", "securityFeatures", "socials", "pricePoint", "recognitionList", "maxOccupancy", "minOccupancy", "quantity", "nonSmoking", "bedroomConfigurationList", "size", "maxAdultOccupancy", "maxChildOccupancy", "bathroomCount", "livingRoomCount", "maxRollaways", "roomCategory", "floor", "roomLocationCode", "roomViewCode", "composite", "compositeCount", "roomClassificationCode", "roomArchitectureCode", "roomGender", "sharedRoomInd", "maxCribs", "amenities", "includedAdultOccupancy", "includedChildOccupancy"})
@JsonTypeName(value="GuestRoom_Affiliate")
public class GuestRoomAffiliate {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
    private Boolean featuredInd;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private GeoJsonPointAffiliate location;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescriptionAffiliate> descriptions = new ArrayList<SimpleDescriptionAffiliate>();
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    private List<SimpleMultimediaAffiliate> multimedias = new ArrayList<SimpleMultimediaAffiliate>();
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private ContactAffiliate contact;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private AddressAffiliate address;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    private Boolean commissionable = true;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
    private String proximityCode;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort;
    public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
    private String minAgeAppropriateCode;
    public static final String JSON_PROPERTY_BOOKABLE = "bookable";
    private Boolean bookable = true;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active = true;
    public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
    private List<String> disabilityFeatures = null;
    public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
    private List<String> securityFeatures = null;
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    private List<SocialAffiliate> socials = null;
    public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
    private PricePointEnum pricePoint = PricePointEnum.THREE;
    public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
    private List<TravelInventoryRecognitionAffiliate> recognitionList = null;
    public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
    private Integer maxOccupancy = 2;
    public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
    private Integer minOccupancy = 1;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    private Integer quantity;
    public static final String JSON_PROPERTY_NON_SMOKING = "nonSmoking";
    private Boolean nonSmoking;
    public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST = "bedroomConfigurationList";
    private List<BedroomConfigurationAffiliate> bedroomConfigurationList = new ArrayList<BedroomConfigurationAffiliate>();
    public static final String JSON_PROPERTY_SIZE = "size";
    private Float size;
    public static final String JSON_PROPERTY_MAX_ADULT_OCCUPANCY = "maxAdultOccupancy";
    private Integer maxAdultOccupancy = 2;
    public static final String JSON_PROPERTY_MAX_CHILD_OCCUPANCY = "maxChildOccupancy";
    private Integer maxChildOccupancy = 0;
    public static final String JSON_PROPERTY_BATHROOM_COUNT = "bathroomCount";
    private Integer bathroomCount = 1;
    public static final String JSON_PROPERTY_LIVING_ROOM_COUNT = "livingRoomCount";
    private Integer livingRoomCount = 1;
    public static final String JSON_PROPERTY_MAX_ROLLAWAYS = "maxRollaways";
    private Integer maxRollaways = 0;
    public static final String JSON_PROPERTY_ROOM_CATEGORY = "roomCategory";
    private String roomCategory;
    public static final String JSON_PROPERTY_FLOOR = "floor";
    private String floor;
    public static final String JSON_PROPERTY_ROOM_LOCATION_CODE = "roomLocationCode";
    private String roomLocationCode;
    public static final String JSON_PROPERTY_ROOM_VIEW_CODE = "roomViewCode";
    private String roomViewCode;
    public static final String JSON_PROPERTY_COMPOSITE = "composite";
    private Boolean composite = false;
    public static final String JSON_PROPERTY_COMPOSITE_COUNT = "compositeCount";
    private Integer compositeCount = 0;
    public static final String JSON_PROPERTY_ROOM_CLASSIFICATION_CODE = "roomClassificationCode";
    private String roomClassificationCode;
    public static final String JSON_PROPERTY_ROOM_ARCHITECTURE_CODE = "roomArchitectureCode";
    private String roomArchitectureCode;
    public static final String JSON_PROPERTY_ROOM_GENDER = "roomGender";
    private RoomGenderEnum roomGender = RoomGenderEnum.UNKNOWN;
    public static final String JSON_PROPERTY_SHARED_ROOM_IND = "sharedRoomInd";
    private Boolean sharedRoomInd = false;
    public static final String JSON_PROPERTY_MAX_CRIBS = "maxCribs";
    private Integer maxCribs = 0;
    public static final String JSON_PROPERTY_AMENITIES = "amenities";
    private List<String> amenities = null;
    public static final String JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY = "includedAdultOccupancy";
    private Integer includedAdultOccupancy = 2;
    public static final String JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY = "includedChildOccupancy";
    private Integer includedChildOccupancy = 0;

    public GuestRoomAffiliate identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Unique record identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public GuestRoomAffiliate hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Hotel identifier.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public GuestRoomAffiliate featuredInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.")
    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getFeaturedInd() {
        return this.featuredInd;
    }

    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeaturedInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
    }

    public GuestRoomAffiliate lifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="LIFESTYLE_HEALTH_FITNESS", value="Indicate the type of lifestyle this inventory should be associated with.")
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public GuestRoomAffiliate location(GeoJsonPointAffiliate location) {
        this.location = location;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeoJsonPointAffiliate getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocation(GeoJsonPointAffiliate location) {
        this.location = location;
    }

    public GuestRoomAffiliate descriptions(List<SimpleDescriptionAffiliate> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public GuestRoomAffiliate addDescriptionsItem(SimpleDescriptionAffiliate descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Localized descriptions describing inventory.")
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleDescriptionAffiliate> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescriptionAffiliate> descriptions) {
        this.descriptions = descriptions;
    }

    public GuestRoomAffiliate multimedias(List<SimpleMultimediaAffiliate> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public GuestRoomAffiliate addMultimediasItem(SimpleMultimediaAffiliate multimediasItem) {
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="List of images / videos of inventory.")
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleMultimediaAffiliate> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimedias(List<SimpleMultimediaAffiliate> multimedias) {
        this.multimedias = multimedias;
    }

    public GuestRoomAffiliate contact(ContactAffiliate contact) {
        this.contact = contact;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactAffiliate getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContact(ContactAffiliate contact) {
        this.contact = contact;
    }

    public GuestRoomAffiliate address(AddressAffiliate address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AddressAffiliate getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(AddressAffiliate address) {
        this.address = address;
    }

    public GuestRoomAffiliate commissionable(Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Indicate whether sales channels receive commission for selling this inventory.")
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public GuestRoomAffiliate name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Archery lesson", required=true, value="Internal name of inventory.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public GuestRoomAffiliate proximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="1", required=true, value="Supported OTA specification `PRX` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProximityCode() {
        return this.proximityCode;
    }

    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
    }

    public GuestRoomAffiliate sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Use this property to sort an inventory in a list of activities.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public GuestRoomAffiliate minAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Supported OTA specification `AQC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMinAgeAppropriateCode() {
        return this.minAgeAppropriateCode;
    }

    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
    }

    public GuestRoomAffiliate bookable(Boolean bookable) {
        this.bookable = bookable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Indicates if this inventory can be added to a booking or if it is read-only marketing material only.")
    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBookable() {
        return this.bookable;
    }

    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookable(Boolean bookable) {
        this.bookable = bookable;
    }

    public GuestRoomAffiliate active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Modify inventory availability with this flag.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public GuestRoomAffiliate disabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
        return this;
    }

    public GuestRoomAffiliate addDisabilityFeaturesItem(String disabilityFeaturesItem) {
        if (this.disabilityFeatures == null) {
            this.disabilityFeatures = new ArrayList<String>();
        }
        this.disabilityFeatures.add(disabilityFeaturesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `PHY` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDisabilityFeatures() {
        return this.disabilityFeatures;
    }

    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
    }

    public GuestRoomAffiliate securityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
        return this;
    }

    public GuestRoomAffiliate addSecurityFeaturesItem(String securityFeaturesItem) {
        if (this.securityFeatures == null) {
            this.securityFeatures = new ArrayList<String>();
        }
        this.securityFeatures.add(securityFeaturesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `SEC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSecurityFeatures() {
        return this.securityFeatures;
    }

    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
    }

    public GuestRoomAffiliate socials(List<SocialAffiliate> socials) {
        this.socials = socials;
        return this;
    }

    public GuestRoomAffiliate addSocialsItem(SocialAffiliate socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<SocialAffiliate>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Social network accounts for inventory (if applicable).")
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SocialAffiliate> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(List<SocialAffiliate> socials) {
        this.socials = socials;
    }

    public GuestRoomAffiliate pricePoint(PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="THREE", required=true, value="Level of expensiveness.")
    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricePointEnum getPricePoint() {
        return this.pricePoint;
    }

    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricePoint(PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
    }

    public GuestRoomAffiliate recognitionList(List<TravelInventoryRecognitionAffiliate> recognitionList) {
        this.recognitionList = recognitionList;
        return this;
    }

    public GuestRoomAffiliate addRecognitionListItem(TravelInventoryRecognitionAffiliate recognitionListItem) {
        if (this.recognitionList == null) {
            this.recognitionList = new ArrayList<TravelInventoryRecognitionAffiliate>();
        }
        this.recognitionList.add(recognitionListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Inventory-level recognition.")
    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TravelInventoryRecognitionAffiliate> getRecognitionList() {
        return this.recognitionList;
    }

    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecognitionList(List<TravelInventoryRecognitionAffiliate> recognitionList) {
        this.recognitionList = recognitionList;
    }

    public GuestRoomAffiliate maxOccupancy(Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="2", required=true, value="Maximum number of guest allowed in a room type.")
    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxOccupancy() {
        return this.maxOccupancy;
    }

    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxOccupancy(Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
    }

    public GuestRoomAffiliate minOccupancy(Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="1", required=true, value="Minimum number of guests allowed in a room type.")
    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMinOccupancy() {
        return this.minOccupancy;
    }

    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMinOccupancy(Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
    }

    public GuestRoomAffiliate quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="40", required=true, value="Defines the number of rooms of this type")
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public GuestRoomAffiliate nonSmoking(Boolean nonSmoking) {
        this.nonSmoking = nonSmoking;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Non-smoking indicator")
    @JsonProperty(value="nonSmoking")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getNonSmoking() {
        return this.nonSmoking;
    }

    @JsonProperty(value="nonSmoking")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNonSmoking(Boolean nonSmoking) {
        this.nonSmoking = nonSmoking;
    }

    public GuestRoomAffiliate bedroomConfigurationList(List<BedroomConfigurationAffiliate> bedroomConfigurationList) {
        this.bedroomConfigurationList = bedroomConfigurationList;
        return this;
    }

    public GuestRoomAffiliate addBedroomConfigurationListItem(BedroomConfigurationAffiliate bedroomConfigurationListItem) {
        this.bedroomConfigurationList.add(bedroomConfigurationListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="A room type can have more than one bed configuration.")
    @JsonProperty(value="bedroomConfigurationList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<BedroomConfigurationAffiliate> getBedroomConfigurationList() {
        return this.bedroomConfigurationList;
    }

    @JsonProperty(value="bedroomConfigurationList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBedroomConfigurationList(List<BedroomConfigurationAffiliate> bedroomConfigurationList) {
        this.bedroomConfigurationList = bedroomConfigurationList;
    }

    public GuestRoomAffiliate size(Float size) {
        this.size = size;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="1")
    @ApiModelProperty(example="55", required=true, value="Number of square meters that defines the size of this room type.")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="1") Float getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSize(Float size) {
        this.size = size;
    }

    public GuestRoomAffiliate maxAdultOccupancy(Integer maxAdultOccupancy) {
        this.maxAdultOccupancy = maxAdultOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="1", required=true, value="Maximum number of adults allowed in a room type.")
    @JsonProperty(value="maxAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxAdultOccupancy() {
        return this.maxAdultOccupancy;
    }

    @JsonProperty(value="maxAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxAdultOccupancy(Integer maxAdultOccupancy) {
        this.maxAdultOccupancy = maxAdultOccupancy;
    }

    public GuestRoomAffiliate maxChildOccupancy(Integer maxChildOccupancy) {
        this.maxChildOccupancy = maxChildOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="0", required=true, value="Maximum number of children allowed in a room type.")
    @JsonProperty(value="maxChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxChildOccupancy() {
        return this.maxChildOccupancy;
    }

    @JsonProperty(value="maxChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxChildOccupancy(Integer maxChildOccupancy) {
        this.maxChildOccupancy = maxChildOccupancy;
    }

    public GuestRoomAffiliate bathroomCount(Integer bathroomCount) {
        this.bathroomCount = bathroomCount;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="0", required=true, value="Number of bathrooms")
    @JsonProperty(value="bathroomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getBathroomCount() {
        return this.bathroomCount;
    }

    @JsonProperty(value="bathroomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBathroomCount(Integer bathroomCount) {
        this.bathroomCount = bathroomCount;
    }

    public GuestRoomAffiliate livingRoomCount(Integer livingRoomCount) {
        this.livingRoomCount = livingRoomCount;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="0", required=true, value="Number of living rooms")
    @JsonProperty(value="livingRoomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getLivingRoomCount() {
        return this.livingRoomCount;
    }

    @JsonProperty(value="livingRoomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLivingRoomCount(Integer livingRoomCount) {
        this.livingRoomCount = livingRoomCount;
    }

    public GuestRoomAffiliate maxRollaways(Integer maxRollaways) {
        this.maxRollaways = maxRollaways;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="0", required=true, value="Maximum number of rollaway beds allowed in this room type.")
    @JsonProperty(value="maxRollaways")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxRollaways() {
        return this.maxRollaways;
    }

    @JsonProperty(value="maxRollaways")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxRollaways(Integer maxRollaways) {
        this.maxRollaways = maxRollaways;
    }

    public GuestRoomAffiliate roomCategory(String roomCategory) {
        this.roomCategory = roomCategory;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="1", required=true, value="Indicates the category of the room. Typical values would be Moderate, Standard, or Deluxe. Supported OTA specification `SEG` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="roomCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoomCategory() {
        return this.roomCategory;
    }

    @JsonProperty(value="roomCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomCategory(String roomCategory) {
        this.roomCategory = roomCategory;
    }

    public GuestRoomAffiliate floor(String floor) {
        this.floor = floor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Floor an which a room is located")
    @JsonProperty(value="floor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFloor() {
        return this.floor;
    }

    @JsonProperty(value="floor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFloor(String floor) {
        this.floor = floor;
    }

    public GuestRoomAffiliate roomLocationCode(String roomLocationCode) {
        this.roomLocationCode = roomLocationCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="1", required=true, value="Indicates the location of the room within the hotel structure. Typical values would be \"Near Exit\",\"Close to elevator\", \"Low Floor\" or \"High Floor\". Supported OTA specification `RLT` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="roomLocationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoomLocationCode() {
        return this.roomLocationCode;
    }

    @JsonProperty(value="roomLocationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomLocationCode(String roomLocationCode) {
        this.roomLocationCode = roomLocationCode;
    }

    public GuestRoomAffiliate roomViewCode(String roomViewCode) {
        this.roomViewCode = roomViewCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="1", required=true, value="Indicates the view of the room. Typical values would be \"Ocean view\", \"Pool view\" or \"Garden View\". Supported OTA specification `RVT` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="roomViewCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoomViewCode() {
        return this.roomViewCode;
    }

    @JsonProperty(value="roomViewCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomViewCode(String roomViewCode) {
        this.roomViewCode = roomViewCode;
    }

    public GuestRoomAffiliate composite(Boolean composite) {
        this.composite = composite;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="Indicates that the room (suite) is a composite of smaller units.")
    @JsonProperty(value="composite")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getComposite() {
        return this.composite;
    }

    @JsonProperty(value="composite")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setComposite(Boolean composite) {
        this.composite = composite;
    }

    public GuestRoomAffiliate compositeCount(Integer compositeCount) {
        this.compositeCount = compositeCount;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="2", required=true, value="Number of rooms of this room type that makes up a larger unit (composite) such as a two bedroom suite could be comprised of two king rooms plus other room types. A 0 means disabled.")
    @JsonProperty(value="compositeCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getCompositeCount() {
        return this.compositeCount;
    }

    @JsonProperty(value="compositeCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCompositeCount(Integer compositeCount) {
        this.compositeCount = compositeCount;
    }

    public GuestRoomAffiliate roomClassificationCode(String roomClassificationCode) {
        this.roomClassificationCode = roomClassificationCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="1", required=true, value="Specifies the room classification (e.g., cabin, apartment). Supported OTA specification `GRI` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="roomClassificationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoomClassificationCode() {
        return this.roomClassificationCode;
    }

    @JsonProperty(value="roomClassificationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomClassificationCode(String roomClassificationCode) {
        this.roomClassificationCode = roomClassificationCode;
    }

    public GuestRoomAffiliate roomArchitectureCode(String roomArchitectureCode) {
        this.roomArchitectureCode = roomArchitectureCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="1", required=true, value="Specifies the architectural style of a room. Supported OTA specification `ARC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="roomArchitectureCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoomArchitectureCode() {
        return this.roomArchitectureCode;
    }

    @JsonProperty(value="roomArchitectureCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomArchitectureCode(String roomArchitectureCode) {
        this.roomArchitectureCode = roomArchitectureCode;
    }

    public GuestRoomAffiliate roomGender(RoomGenderEnum roomGender) {
        this.roomGender = roomGender;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Female", value="Used to request or specify a gender assignment for a room. Note: Typically used by Hosteliers.")
    @JsonProperty(value="roomGender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoomGenderEnum getRoomGender() {
        return this.roomGender;
    }

    @JsonProperty(value="roomGender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomGender(RoomGenderEnum roomGender) {
        this.roomGender = roomGender;
    }

    public GuestRoomAffiliate sharedRoomInd(Boolean sharedRoomInd) {
        this.sharedRoomInd = sharedRoomInd;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="If TRUE, the room requires or has sharing available. Note: Typically used by Hosteliers.")
    @JsonProperty(value="sharedRoomInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getSharedRoomInd() {
        return this.sharedRoomInd;
    }

    @JsonProperty(value="sharedRoomInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSharedRoomInd(Boolean sharedRoomInd) {
        this.sharedRoomInd = sharedRoomInd;
    }

    public GuestRoomAffiliate maxCribs(Integer maxCribs) {
        this.maxCribs = maxCribs;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="1", required=true, value="Maximum number of cribs allowed in a room type.")
    @JsonProperty(value="maxCribs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxCribs() {
        return this.maxCribs;
    }

    @JsonProperty(value="maxCribs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxCribs(Integer maxCribs) {
        this.maxCribs = maxCribs;
    }

    public GuestRoomAffiliate amenities(List<String> amenities) {
        this.amenities = amenities;
        return this;
    }

    public GuestRoomAffiliate addAmenitiesItem(String amenitiesItem) {
        if (this.amenities == null) {
            this.amenities = new ArrayList<String>();
        }
        this.amenities.add(amenitiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\",\"7\"]", value="Collection of room amenity items available to the guest. Supported OTA specification `RMA` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAmenities() {
        return this.amenities;
    }

    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmenities(List<String> amenities) {
        this.amenities = amenities;
    }

    public GuestRoomAffiliate includedAdultOccupancy(Integer includedAdultOccupancy) {
        this.includedAdultOccupancy = includedAdultOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="2", required=true, value="The number of pax the room price was meant for")
    @JsonProperty(value="includedAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getIncludedAdultOccupancy() {
        return this.includedAdultOccupancy;
    }

    @JsonProperty(value="includedAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIncludedAdultOccupancy(Integer includedAdultOccupancy) {
        this.includedAdultOccupancy = includedAdultOccupancy;
    }

    public GuestRoomAffiliate includedChildOccupancy(Integer includedChildOccupancy) {
        this.includedChildOccupancy = includedChildOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="0", required=true, value="The number of children the room price was meant for")
    @JsonProperty(value="includedChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getIncludedChildOccupancy() {
        return this.includedChildOccupancy;
    }

    @JsonProperty(value="includedChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIncludedChildOccupancy(Integer includedChildOccupancy) {
        this.includedChildOccupancy = includedChildOccupancy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuestRoomAffiliate guestRoomAffiliate = (GuestRoomAffiliate)o;
        return Objects.equals(this.identifier, guestRoomAffiliate.identifier) && Objects.equals(this.hotelIdentifier, guestRoomAffiliate.hotelIdentifier) && Objects.equals(this.featuredInd, guestRoomAffiliate.featuredInd) && Objects.equals((Object)this.lifestyleType, (Object)guestRoomAffiliate.lifestyleType) && Objects.equals(this.location, guestRoomAffiliate.location) && Objects.equals(this.descriptions, guestRoomAffiliate.descriptions) && Objects.equals(this.multimedias, guestRoomAffiliate.multimedias) && Objects.equals(this.contact, guestRoomAffiliate.contact) && Objects.equals(this.address, guestRoomAffiliate.address) && Objects.equals(this.commissionable, guestRoomAffiliate.commissionable) && Objects.equals(this.name, guestRoomAffiliate.name) && Objects.equals(this.proximityCode, guestRoomAffiliate.proximityCode) && Objects.equals(this.sort, guestRoomAffiliate.sort) && Objects.equals(this.minAgeAppropriateCode, guestRoomAffiliate.minAgeAppropriateCode) && Objects.equals(this.bookable, guestRoomAffiliate.bookable) && Objects.equals(this.active, guestRoomAffiliate.active) && Objects.equals(this.disabilityFeatures, guestRoomAffiliate.disabilityFeatures) && Objects.equals(this.securityFeatures, guestRoomAffiliate.securityFeatures) && Objects.equals(this.socials, guestRoomAffiliate.socials) && Objects.equals((Object)this.pricePoint, (Object)guestRoomAffiliate.pricePoint) && Objects.equals(this.recognitionList, guestRoomAffiliate.recognitionList) && Objects.equals(this.maxOccupancy, guestRoomAffiliate.maxOccupancy) && Objects.equals(this.minOccupancy, guestRoomAffiliate.minOccupancy) && Objects.equals(this.quantity, guestRoomAffiliate.quantity) && Objects.equals(this.nonSmoking, guestRoomAffiliate.nonSmoking) && Objects.equals(this.bedroomConfigurationList, guestRoomAffiliate.bedroomConfigurationList) && Objects.equals(this.size, guestRoomAffiliate.size) && Objects.equals(this.maxAdultOccupancy, guestRoomAffiliate.maxAdultOccupancy) && Objects.equals(this.maxChildOccupancy, guestRoomAffiliate.maxChildOccupancy) && Objects.equals(this.bathroomCount, guestRoomAffiliate.bathroomCount) && Objects.equals(this.livingRoomCount, guestRoomAffiliate.livingRoomCount) && Objects.equals(this.maxRollaways, guestRoomAffiliate.maxRollaways) && Objects.equals(this.roomCategory, guestRoomAffiliate.roomCategory) && Objects.equals(this.floor, guestRoomAffiliate.floor) && Objects.equals(this.roomLocationCode, guestRoomAffiliate.roomLocationCode) && Objects.equals(this.roomViewCode, guestRoomAffiliate.roomViewCode) && Objects.equals(this.composite, guestRoomAffiliate.composite) && Objects.equals(this.compositeCount, guestRoomAffiliate.compositeCount) && Objects.equals(this.roomClassificationCode, guestRoomAffiliate.roomClassificationCode) && Objects.equals(this.roomArchitectureCode, guestRoomAffiliate.roomArchitectureCode) && Objects.equals((Object)this.roomGender, (Object)guestRoomAffiliate.roomGender) && Objects.equals(this.sharedRoomInd, guestRoomAffiliate.sharedRoomInd) && Objects.equals(this.maxCribs, guestRoomAffiliate.maxCribs) && Objects.equals(this.amenities, guestRoomAffiliate.amenities) && Objects.equals(this.includedAdultOccupancy, guestRoomAffiliate.includedAdultOccupancy) && Objects.equals(this.includedChildOccupancy, guestRoomAffiliate.includedChildOccupancy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.featuredInd, this.lifestyleType, this.location, this.descriptions, this.multimedias, this.contact, this.address, this.commissionable, this.name, this.proximityCode, this.sort, this.minAgeAppropriateCode, this.bookable, this.active, this.disabilityFeatures, this.securityFeatures, this.socials, this.pricePoint, this.recognitionList, this.maxOccupancy, this.minOccupancy, this.quantity, this.nonSmoking, this.bedroomConfigurationList, this.size, this.maxAdultOccupancy, this.maxChildOccupancy, this.bathroomCount, this.livingRoomCount, this.maxRollaways, this.roomCategory, this.floor, this.roomLocationCode, this.roomViewCode, this.composite, this.compositeCount, this.roomClassificationCode, this.roomArchitectureCode, this.roomGender, this.sharedRoomInd, this.maxCribs, this.amenities, this.includedAdultOccupancy, this.includedChildOccupancy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GuestRoomAffiliate {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    featuredInd: ").append(this.toIndentedString(this.featuredInd)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    proximityCode: ").append(this.toIndentedString(this.proximityCode)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    minAgeAppropriateCode: ").append(this.toIndentedString(this.minAgeAppropriateCode)).append("\n");
        sb.append("    bookable: ").append(this.toIndentedString(this.bookable)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    disabilityFeatures: ").append(this.toIndentedString(this.disabilityFeatures)).append("\n");
        sb.append("    securityFeatures: ").append(this.toIndentedString(this.securityFeatures)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    pricePoint: ").append(this.toIndentedString((Object)this.pricePoint)).append("\n");
        sb.append("    recognitionList: ").append(this.toIndentedString(this.recognitionList)).append("\n");
        sb.append("    maxOccupancy: ").append(this.toIndentedString(this.maxOccupancy)).append("\n");
        sb.append("    minOccupancy: ").append(this.toIndentedString(this.minOccupancy)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    nonSmoking: ").append(this.toIndentedString(this.nonSmoking)).append("\n");
        sb.append("    bedroomConfigurationList: ").append(this.toIndentedString(this.bedroomConfigurationList)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    maxAdultOccupancy: ").append(this.toIndentedString(this.maxAdultOccupancy)).append("\n");
        sb.append("    maxChildOccupancy: ").append(this.toIndentedString(this.maxChildOccupancy)).append("\n");
        sb.append("    bathroomCount: ").append(this.toIndentedString(this.bathroomCount)).append("\n");
        sb.append("    livingRoomCount: ").append(this.toIndentedString(this.livingRoomCount)).append("\n");
        sb.append("    maxRollaways: ").append(this.toIndentedString(this.maxRollaways)).append("\n");
        sb.append("    roomCategory: ").append(this.toIndentedString(this.roomCategory)).append("\n");
        sb.append("    floor: ").append(this.toIndentedString(this.floor)).append("\n");
        sb.append("    roomLocationCode: ").append(this.toIndentedString(this.roomLocationCode)).append("\n");
        sb.append("    roomViewCode: ").append(this.toIndentedString(this.roomViewCode)).append("\n");
        sb.append("    composite: ").append(this.toIndentedString(this.composite)).append("\n");
        sb.append("    compositeCount: ").append(this.toIndentedString(this.compositeCount)).append("\n");
        sb.append("    roomClassificationCode: ").append(this.toIndentedString(this.roomClassificationCode)).append("\n");
        sb.append("    roomArchitectureCode: ").append(this.toIndentedString(this.roomArchitectureCode)).append("\n");
        sb.append("    roomGender: ").append(this.toIndentedString((Object)this.roomGender)).append("\n");
        sb.append("    sharedRoomInd: ").append(this.toIndentedString(this.sharedRoomInd)).append("\n");
        sb.append("    maxCribs: ").append(this.toIndentedString(this.maxCribs)).append("\n");
        sb.append("    amenities: ").append(this.toIndentedString(this.amenities)).append("\n");
        sb.append("    includedAdultOccupancy: ").append(this.toIndentedString(this.includedAdultOccupancy)).append("\n");
        sb.append("    includedChildOccupancy: ").append(this.toIndentedString(this.includedChildOccupancy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricePointEnum {
        HALF("HALF"),
        ONE("ONE"),
        ONE_HALF("ONE_HALF"),
        TWO("TWO"),
        TWO_HALF("TWO_HALF"),
        THREE("THREE"),
        THREE_HALF("THREE_HALF"),
        FOUR("FOUR"),
        FOUR_HALF("FOUR_HALF"),
        FIVE("FIVE");

        private String value;

        private PricePointEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricePointEnum fromValue(String value) {
            for (PricePointEnum b : PricePointEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RoomGenderEnum {
        MALE("Male"),
        FEMALE("Female"),
        MALEANDFEMALE("MaleAndFemale"),
        UNKNOWN("Unknown");

        private String value;

        private RoomGenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoomGenderEnum fromValue(String value) {
            for (RoomGenderEnum b : RoomGenderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypeEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

