package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.BookingViewAffiliate;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.KeyValuePairAffiliate;
import travel.wink.sdk.affiliate.model.PageBookingViewAffiliate;
import travel.wink.sdk.affiliate.model.ShowSellerUrl400Response;
import travel.wink.sdk.affiliate.model.StateAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-06T14:57:33.926770564+07:00[Asia/Bangkok]")
public class BookingsApi {
    private ApiClient apiClient;

    public BookingsApi() {
        this(new ApiClient());
    }

    @Autowired
    public BookingsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Booking
     * Show a booking record by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking for company identifier
     * @param bookingIdentifier Show booking with booking identifier
     * @param winkVersion The winkVersion parameter
     * @return BookingViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingForEngineRequestCreation(String companyIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingForEngine", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showBookingForEngine", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewAffiliate> localVarReturnType = new ParameterizedTypeReference<BookingViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booking
     * Show a booking record by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking for company identifier
     * @param bookingIdentifier Show booking with booking identifier
     * @param winkVersion The winkVersion parameter
     * @return BookingViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingViewAffiliate> showBookingForEngine(String companyIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewAffiliate> localVarReturnType = new ParameterizedTypeReference<BookingViewAffiliate>() {};
        return showBookingForEngineRequestCreation(companyIdentifier, bookingIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Booking
     * Show a booking record by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking for company identifier
     * @param bookingIdentifier Show booking with booking identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingViewAffiliate>> showBookingForEngineWithHttpInfo(String companyIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewAffiliate> localVarReturnType = new ParameterizedTypeReference<BookingViewAffiliate>() {};
        return showBookingForEngineRequestCreation(companyIdentifier, bookingIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Booking
     * Show a booking record by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking for company identifier
     * @param bookingIdentifier Show booking with booking identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingForEngineWithResponseSpec(String companyIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        return showBookingForEngineRequestCreation(companyIdentifier, bookingIdentifier, winkVersion);
    }
    /**
     * Show Bookings
     * Show bookings for the affiliate company that helped create those booking.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show bookings for company identifier
     * @param stateAffiliate The stateAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingsForCompanyRequestCreation(String companyIdentifier, StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = stateAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingsForCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'stateAffiliate' is set
        if (stateAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateAffiliate' when calling showBookingsForCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageBookingViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageBookingViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/booking/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Bookings
     * Show bookings for the affiliate company that helped create those booking.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show bookings for company identifier
     * @param stateAffiliate The stateAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageBookingViewAffiliate> showBookingsForCompany(String companyIdentifier, StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageBookingViewAffiliate>() {};
        return showBookingsForCompanyRequestCreation(companyIdentifier, stateAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Bookings
     * Show bookings for the affiliate company that helped create those booking.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show bookings for company identifier
     * @param stateAffiliate The stateAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageBookingViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageBookingViewAffiliate>> showBookingsForCompanyWithHttpInfo(String companyIdentifier, StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageBookingViewAffiliate>() {};
        return showBookingsForCompanyRequestCreation(companyIdentifier, stateAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Bookings
     * Show bookings for the affiliate company that helped create those booking.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show bookings for company identifier
     * @param stateAffiliate The stateAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingsForCompanyWithResponseSpec(String companyIdentifier, StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        return showBookingsForCompanyRequestCreation(companyIdentifier, stateAffiliate, winkVersion);
    }
    /**
     * Show Booked Applications
     * Show a list of unique applications that were responsible for creating bookings through this affiliate sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique applications for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showUniqueApplicationsRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUniqueApplications", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/booking/engine/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booked Applications
     * Show a list of unique applications that were responsible for creating bookings through this affiliate sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique applications for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairAffiliate> showUniqueApplications(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showUniqueApplicationsRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Booked Applications
     * Show a list of unique applications that were responsible for creating bookings through this affiliate sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique applications for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showUniqueApplicationsWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showUniqueApplicationsRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Booked Applications
     * Show a list of unique applications that were responsible for creating bookings through this affiliate sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique applications for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showUniqueApplicationsWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showUniqueApplicationsRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Show Booked Customizations
     * Show a list of unique customizations that were responsible for creating bookings through this affiliate sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique customizations for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showUniqueEngineConfigurationsRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUniqueEngineConfigurations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/booking/engine/configuration/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booked Customizations
     * Show a list of unique customizations that were responsible for creating bookings through this affiliate sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique customizations for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairAffiliate> showUniqueEngineConfigurations(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showUniqueEngineConfigurationsRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Booked Customizations
     * Show a list of unique customizations that were responsible for creating bookings through this affiliate sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique customizations for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showUniqueEngineConfigurationsWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showUniqueEngineConfigurationsRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Booked Customizations
     * Show a list of unique customizations that were responsible for creating bookings through this affiliate sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique customizations for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showUniqueEngineConfigurationsWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showUniqueEngineConfigurationsRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Show Booked Hotels
     * Show a list of unique hotels that were responsible for creating bookings through this affiliate sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique hotels for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showUniqueHotelsRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUniqueHotels", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/booking/hotel/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booked Hotels
     * Show a list of unique hotels that were responsible for creating bookings through this affiliate sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique hotels for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairAffiliate> showUniqueHotels(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showUniqueHotelsRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Booked Hotels
     * Show a list of unique hotels that were responsible for creating bookings through this affiliate sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique hotels for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showUniqueHotelsWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showUniqueHotelsRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Booked Hotels
     * Show a list of unique hotels that were responsible for creating bookings through this affiliate sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique hotels for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showUniqueHotelsWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showUniqueHotelsRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Show Booked Master Rates
     * Show a list of unique master rates that created a booking.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique master rates for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showUniqueMasterRatesRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUniqueMasterRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/booking/roomrate/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booked Master Rates
     * Show a list of unique master rates that created a booking.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique master rates for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairAffiliate> showUniqueMasterRates(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showUniqueMasterRatesRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Booked Master Rates
     * Show a list of unique master rates that created a booking.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique master rates for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showUniqueMasterRatesWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showUniqueMasterRatesRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Booked Master Rates
     * Show a list of unique master rates that created a booking.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unique master rates for booking made with the help of company identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showUniqueMasterRatesWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showUniqueMasterRatesRequestCreation(companyIdentifier, winkVersion);
    }
}
