/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 25.1.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.affiliate.model.AggregateDescriptorAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Descriptors to group result sets by.
 */
@JsonPropertyOrder({
  GroupDescriptorAffiliate.JSON_PROPERTY_FIELD,
  GroupDescriptorAffiliate.JSON_PROPERTY_DIR,
  GroupDescriptorAffiliate.JSON_PROPERTY_AGGREGATES
})
@JsonTypeName("GroupDescriptor_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-06T14:57:33.926770564+07:00[Asia/Bangkok]")
public class GroupDescriptorAffiliate {
  public static final String JSON_PROPERTY_FIELD = "field";
  private String field;

  /**
   * Group sort direction
   */
  public enum DirEnum {
    ASC("asc"),
    
    DESC("desc");

    private String value;

    DirEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DirEnum fromValue(String value) {
      for (DirEnum b : DirEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DIR = "dir";
  private DirEnum dir;

  public static final String JSON_PROPERTY_AGGREGATES = "aggregates";
  private List<AggregateDescriptorAffiliate> aggregates = new ArrayList<>();

  public GroupDescriptorAffiliate() {
  }

  public GroupDescriptorAffiliate field(String field) {
    
    this.field = field;
    return this;
  }

   /**
   * Field to group data set on
   * @return field
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getField() {
    return field;
  }


  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setField(String field) {
    this.field = field;
  }


  public GroupDescriptorAffiliate dir(DirEnum dir) {
    
    this.dir = dir;
    return this;
  }

   /**
   * Group sort direction
   * @return dir
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DIR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DirEnum getDir() {
    return dir;
  }


  @JsonProperty(JSON_PROPERTY_DIR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDir(DirEnum dir) {
    this.dir = dir;
  }


  public GroupDescriptorAffiliate aggregates(List<AggregateDescriptorAffiliate> aggregates) {
    
    this.aggregates = aggregates;
    return this;
  }

  public GroupDescriptorAffiliate addAggregatesItem(AggregateDescriptorAffiliate aggregatesItem) {
    if (this.aggregates == null) {
      this.aggregates = new ArrayList<>();
    }
    this.aggregates.add(aggregatesItem);
    return this;
  }

   /**
   * Primitive aggregate data points
   * @return aggregates
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_AGGREGATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AggregateDescriptorAffiliate> getAggregates() {
    return aggregates;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregates(List<AggregateDescriptorAffiliate> aggregates) {
    this.aggregates = aggregates;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GroupDescriptorAffiliate groupDescriptorAffiliate = (GroupDescriptorAffiliate) o;
    return Objects.equals(this.field, groupDescriptorAffiliate.field) &&
        Objects.equals(this.dir, groupDescriptorAffiliate.dir) &&
        Objects.equals(this.aggregates, groupDescriptorAffiliate.aggregates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(field, dir, aggregates);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GroupDescriptorAffiliate {\n");
    sb.append("    field: ").append(toIndentedString(field)).append("\n");
    sb.append("    dir: ").append(toIndentedString(dir)).append("\n");
    sb.append("    aggregates: ").append(toIndentedString(aggregates)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

