/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 25.2.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * BeneficiaryAffiliate
 */
@JsonPropertyOrder({
  BeneficiaryAffiliate.JSON_PROPERTY_ACCOUNT_IDENTIFIER,
  BeneficiaryAffiliate.JSON_PROPERTY_TYPE,
  BeneficiaryAffiliate.JSON_PROPERTY_SOURCE_CURRENCY,
  BeneficiaryAffiliate.JSON_PROPERTY_DISPLAY_CURRENCY,
  BeneficiaryAffiliate.JSON_PROPERTY_SUPPLIER_CURRENCY,
  BeneficiaryAffiliate.JSON_PROPERTY_INTERNAL_CURRENCY,
  BeneficiaryAffiliate.JSON_PROPERTY_CAPTURE_CURRENCY,
  BeneficiaryAffiliate.JSON_PROPERTY_SOURCE_AMOUNT,
  BeneficiaryAffiliate.JSON_PROPERTY_DISPLAY_AMOUNT,
  BeneficiaryAffiliate.JSON_PROPERTY_SUPPLIER_AMOUNT,
  BeneficiaryAffiliate.JSON_PROPERTY_INTERNAL_AMOUNT,
  BeneficiaryAffiliate.JSON_PROPERTY_CAPTURE_AMOUNT,
  BeneficiaryAffiliate.JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER,
  BeneficiaryAffiliate.JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER,
  BeneficiaryAffiliate.JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER,
  BeneficiaryAffiliate.JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER,
  BeneficiaryAffiliate.JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER,
  BeneficiaryAffiliate.JSON_PROPERTY_NET_SOURCE_AMOUNT,
  BeneficiaryAffiliate.JSON_PROPERTY_NET_DISPLAY_AMOUNT,
  BeneficiaryAffiliate.JSON_PROPERTY_NET_SUPPLIER_AMOUNT,
  BeneficiaryAffiliate.JSON_PROPERTY_NET_INTERNAL_AMOUNT,
  BeneficiaryAffiliate.JSON_PROPERTY_NET_CAPTURE_AMOUNT
})
@JsonTypeName("Beneficiary_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-12T17:35:50.971542917+07:00[Asia/Bangkok]")
public class BeneficiaryAffiliate {
  public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
  private UUID accountIdentifier;

  /**
   * The type of beneficiary payment.
   */
  public enum TypeEnum {
    COMMISSION("COMMISSION"),
    
    PLATFORM_FEE("PLATFORM_FEE"),
    
    SALE("SALE"),
    
    TRIP_PAY("TRIP_PAY");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
  private String sourceCurrency;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  private String displayCurrency;

  public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
  private String supplierCurrency;

  public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
  private String internalCurrency;

  public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
  private String captureCurrency;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
  private Double sourceAmount;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
  private Double displayAmount;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
  private Double supplierAmount;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
  private Double internalAmount;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
  private Double captureAmount;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER = "sourceAmountRefundModifier";
  private Double sourceAmountRefundModifier;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER = "displayAmountRefundModifier";
  private Double displayAmountRefundModifier;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER = "supplierAmountRefundModifier";
  private Double supplierAmountRefundModifier;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER = "internalAmountRefundModifier";
  private Double internalAmountRefundModifier;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER = "captureAmountRefundModifier";
  private Double captureAmountRefundModifier;

  public static final String JSON_PROPERTY_NET_SOURCE_AMOUNT = "netSourceAmount";
  private Double netSourceAmount;

  public static final String JSON_PROPERTY_NET_DISPLAY_AMOUNT = "netDisplayAmount";
  private Double netDisplayAmount;

  public static final String JSON_PROPERTY_NET_SUPPLIER_AMOUNT = "netSupplierAmount";
  private Double netSupplierAmount;

  public static final String JSON_PROPERTY_NET_INTERNAL_AMOUNT = "netInternalAmount";
  private Double netInternalAmount;

  public static final String JSON_PROPERTY_NET_CAPTURE_AMOUNT = "netCaptureAmount";
  private Double netCaptureAmount;

  public BeneficiaryAffiliate() {
  }

  public BeneficiaryAffiliate accountIdentifier(UUID accountIdentifier) {
    
    this.accountIdentifier = accountIdentifier;
    return this;
  }

   /**
   * accountIdentifier of beneficiary from payment
   * @return accountIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getAccountIdentifier() {
    return accountIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountIdentifier(UUID accountIdentifier) {
    this.accountIdentifier = accountIdentifier;
  }


  public BeneficiaryAffiliate type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of beneficiary payment.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public BeneficiaryAffiliate sourceCurrency(String sourceCurrency) {
    
    this.sourceCurrency = sourceCurrency;
    return this;
  }

   /**
   * The source currency
   * @return sourceCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceCurrency() {
    return sourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceCurrency(String sourceCurrency) {
    this.sourceCurrency = sourceCurrency;
  }


  public BeneficiaryAffiliate displayCurrency(String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

   /**
   * The display currency
   * @return displayCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayCurrency(String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }


  public BeneficiaryAffiliate supplierCurrency(String supplierCurrency) {
    
    this.supplierCurrency = supplierCurrency;
    return this;
  }

   /**
   * The supplier currency
   * @return supplierCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierCurrency() {
    return supplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierCurrency(String supplierCurrency) {
    this.supplierCurrency = supplierCurrency;
  }


  public BeneficiaryAffiliate internalCurrency(String internalCurrency) {
    
    this.internalCurrency = internalCurrency;
    return this;
  }

   /**
   * The internal currency
   * @return internalCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInternalCurrency() {
    return internalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalCurrency(String internalCurrency) {
    this.internalCurrency = internalCurrency;
  }


  public BeneficiaryAffiliate captureCurrency(String captureCurrency) {
    
    this.captureCurrency = captureCurrency;
    return this;
  }

   /**
   * The capture currency
   * @return captureCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCaptureCurrency() {
    return captureCurrency;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCaptureCurrency(String captureCurrency) {
    this.captureCurrency = captureCurrency;
  }


  public BeneficiaryAffiliate sourceAmount(Double sourceAmount) {
    
    this.sourceAmount = sourceAmount;
    return this;
  }

   /**
   * The total initial price as quoted in the original TripPay contract.
   * minimum: 0
   * @return sourceAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getSourceAmount() {
    return sourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceAmount(Double sourceAmount) {
    this.sourceAmount = sourceAmount;
  }


  public BeneficiaryAffiliate displayAmount(Double displayAmount) {
    
    this.displayAmount = displayAmount;
    return this;
  }

   /**
   * The total display price.
   * minimum: 0
   * @return displayAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getDisplayAmount() {
    return displayAmount;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayAmount(Double displayAmount) {
    this.displayAmount = displayAmount;
  }


  public BeneficiaryAffiliate supplierAmount(Double supplierAmount) {
    
    this.supplierAmount = supplierAmount;
    return this;
  }

   /**
   * The total supplier price.
   * minimum: 0
   * @return supplierAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getSupplierAmount() {
    return supplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierAmount(Double supplierAmount) {
    this.supplierAmount = supplierAmount;
  }


  public BeneficiaryAffiliate internalAmount(Double internalAmount) {
    
    this.internalAmount = internalAmount;
    return this;
  }

   /**
   * Get internalAmount
   * minimum: 0
   * @return internalAmount
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalAmount() {
    return internalAmount;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAmount(Double internalAmount) {
    this.internalAmount = internalAmount;
  }


  public BeneficiaryAffiliate captureAmount(Double captureAmount) {
    
    this.captureAmount = captureAmount;
    return this;
  }

   /**
   * The total capture price.
   * minimum: 0
   * @return captureAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getCaptureAmount() {
    return captureAmount;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCaptureAmount(Double captureAmount) {
    this.captureAmount = captureAmount;
  }


  public BeneficiaryAffiliate sourceAmountRefundModifier(Double sourceAmountRefundModifier) {
    
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
    return this;
  }

   /**
   * The source amount still due after a partial refund occurs.
   * minimum: 0
   * @return sourceAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceAmountRefundModifier() {
    return sourceAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAmountRefundModifier(Double sourceAmountRefundModifier) {
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
  }


  public BeneficiaryAffiliate displayAmountRefundModifier(Double displayAmountRefundModifier) {
    
    this.displayAmountRefundModifier = displayAmountRefundModifier;
    return this;
  }

   /**
   * The display amount still due after a partial refund occurs.
   * minimum: 0
   * @return displayAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getDisplayAmountRefundModifier() {
    return displayAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayAmountRefundModifier(Double displayAmountRefundModifier) {
    this.displayAmountRefundModifier = displayAmountRefundModifier;
  }


  public BeneficiaryAffiliate supplierAmountRefundModifier(Double supplierAmountRefundModifier) {
    
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
    return this;
  }

   /**
   * The supplier amount still due after a partial refund occurs.
   * minimum: 0
   * @return supplierAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSupplierAmountRefundModifier() {
    return supplierAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierAmountRefundModifier(Double supplierAmountRefundModifier) {
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
  }


  public BeneficiaryAffiliate internalAmountRefundModifier(Double internalAmountRefundModifier) {
    
    this.internalAmountRefundModifier = internalAmountRefundModifier;
    return this;
  }

   /**
   * The internal amount still due after a partial refund occurs.
   * minimum: 0
   * @return internalAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalAmountRefundModifier() {
    return internalAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAmountRefundModifier(Double internalAmountRefundModifier) {
    this.internalAmountRefundModifier = internalAmountRefundModifier;
  }


  public BeneficiaryAffiliate captureAmountRefundModifier(Double captureAmountRefundModifier) {
    
    this.captureAmountRefundModifier = captureAmountRefundModifier;
    return this;
  }

   /**
   * The capture amount still due after a partial refund occurs.
   * minimum: 0
   * @return captureAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getCaptureAmountRefundModifier() {
    return captureAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureAmountRefundModifier(Double captureAmountRefundModifier) {
    this.captureAmountRefundModifier = captureAmountRefundModifier;
  }


  public BeneficiaryAffiliate netSourceAmount(Double netSourceAmount) {
    
    this.netSourceAmount = netSourceAmount;
    return this;
  }

   /**
   * The total initial price as quoted in the original TripPay contract.
   * minimum: 0
   * @return netSourceAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getNetSourceAmount() {
    return netSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetSourceAmount(Double netSourceAmount) {
    this.netSourceAmount = netSourceAmount;
  }


  public BeneficiaryAffiliate netDisplayAmount(Double netDisplayAmount) {
    
    this.netDisplayAmount = netDisplayAmount;
    return this;
  }

   /**
   * The total display price.
   * minimum: 0
   * @return netDisplayAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getNetDisplayAmount() {
    return netDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetDisplayAmount(Double netDisplayAmount) {
    this.netDisplayAmount = netDisplayAmount;
  }


  public BeneficiaryAffiliate netSupplierAmount(Double netSupplierAmount) {
    
    this.netSupplierAmount = netSupplierAmount;
    return this;
  }

   /**
   * The total supplier price.
   * minimum: 0
   * @return netSupplierAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getNetSupplierAmount() {
    return netSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetSupplierAmount(Double netSupplierAmount) {
    this.netSupplierAmount = netSupplierAmount;
  }


  public BeneficiaryAffiliate netInternalAmount(Double netInternalAmount) {
    
    this.netInternalAmount = netInternalAmount;
    return this;
  }

   /**
   * Get netInternalAmount
   * minimum: 0
   * @return netInternalAmount
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getNetInternalAmount() {
    return netInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetInternalAmount(Double netInternalAmount) {
    this.netInternalAmount = netInternalAmount;
  }


  public BeneficiaryAffiliate netCaptureAmount(Double netCaptureAmount) {
    
    this.netCaptureAmount = netCaptureAmount;
    return this;
  }

   /**
   * The total capture price.
   * minimum: 0
   * @return netCaptureAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getNetCaptureAmount() {
    return netCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetCaptureAmount(Double netCaptureAmount) {
    this.netCaptureAmount = netCaptureAmount;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BeneficiaryAffiliate beneficiaryAffiliate = (BeneficiaryAffiliate) o;
    return Objects.equals(this.accountIdentifier, beneficiaryAffiliate.accountIdentifier) &&
        Objects.equals(this.type, beneficiaryAffiliate.type) &&
        Objects.equals(this.sourceCurrency, beneficiaryAffiliate.sourceCurrency) &&
        Objects.equals(this.displayCurrency, beneficiaryAffiliate.displayCurrency) &&
        Objects.equals(this.supplierCurrency, beneficiaryAffiliate.supplierCurrency) &&
        Objects.equals(this.internalCurrency, beneficiaryAffiliate.internalCurrency) &&
        Objects.equals(this.captureCurrency, beneficiaryAffiliate.captureCurrency) &&
        Objects.equals(this.sourceAmount, beneficiaryAffiliate.sourceAmount) &&
        Objects.equals(this.displayAmount, beneficiaryAffiliate.displayAmount) &&
        Objects.equals(this.supplierAmount, beneficiaryAffiliate.supplierAmount) &&
        Objects.equals(this.internalAmount, beneficiaryAffiliate.internalAmount) &&
        Objects.equals(this.captureAmount, beneficiaryAffiliate.captureAmount) &&
        Objects.equals(this.sourceAmountRefundModifier, beneficiaryAffiliate.sourceAmountRefundModifier) &&
        Objects.equals(this.displayAmountRefundModifier, beneficiaryAffiliate.displayAmountRefundModifier) &&
        Objects.equals(this.supplierAmountRefundModifier, beneficiaryAffiliate.supplierAmountRefundModifier) &&
        Objects.equals(this.internalAmountRefundModifier, beneficiaryAffiliate.internalAmountRefundModifier) &&
        Objects.equals(this.captureAmountRefundModifier, beneficiaryAffiliate.captureAmountRefundModifier) &&
        Objects.equals(this.netSourceAmount, beneficiaryAffiliate.netSourceAmount) &&
        Objects.equals(this.netDisplayAmount, beneficiaryAffiliate.netDisplayAmount) &&
        Objects.equals(this.netSupplierAmount, beneficiaryAffiliate.netSupplierAmount) &&
        Objects.equals(this.netInternalAmount, beneficiaryAffiliate.netInternalAmount) &&
        Objects.equals(this.netCaptureAmount, beneficiaryAffiliate.netCaptureAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountIdentifier, type, sourceCurrency, displayCurrency, supplierCurrency, internalCurrency, captureCurrency, sourceAmount, displayAmount, supplierAmount, internalAmount, captureAmount, sourceAmountRefundModifier, displayAmountRefundModifier, supplierAmountRefundModifier, internalAmountRefundModifier, captureAmountRefundModifier, netSourceAmount, netDisplayAmount, netSupplierAmount, netInternalAmount, netCaptureAmount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BeneficiaryAffiliate {\n");
    sb.append("    accountIdentifier: ").append(toIndentedString(accountIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    sourceCurrency: ").append(toIndentedString(sourceCurrency)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    supplierCurrency: ").append(toIndentedString(supplierCurrency)).append("\n");
    sb.append("    internalCurrency: ").append(toIndentedString(internalCurrency)).append("\n");
    sb.append("    captureCurrency: ").append(toIndentedString(captureCurrency)).append("\n");
    sb.append("    sourceAmount: ").append(toIndentedString(sourceAmount)).append("\n");
    sb.append("    displayAmount: ").append(toIndentedString(displayAmount)).append("\n");
    sb.append("    supplierAmount: ").append(toIndentedString(supplierAmount)).append("\n");
    sb.append("    internalAmount: ").append(toIndentedString(internalAmount)).append("\n");
    sb.append("    captureAmount: ").append(toIndentedString(captureAmount)).append("\n");
    sb.append("    sourceAmountRefundModifier: ").append(toIndentedString(sourceAmountRefundModifier)).append("\n");
    sb.append("    displayAmountRefundModifier: ").append(toIndentedString(displayAmountRefundModifier)).append("\n");
    sb.append("    supplierAmountRefundModifier: ").append(toIndentedString(supplierAmountRefundModifier)).append("\n");
    sb.append("    internalAmountRefundModifier: ").append(toIndentedString(internalAmountRefundModifier)).append("\n");
    sb.append("    captureAmountRefundModifier: ").append(toIndentedString(captureAmountRefundModifier)).append("\n");
    sb.append("    netSourceAmount: ").append(toIndentedString(netSourceAmount)).append("\n");
    sb.append("    netDisplayAmount: ").append(toIndentedString(netDisplayAmount)).append("\n");
    sb.append("    netSupplierAmount: ").append(toIndentedString(netSupplierAmount)).append("\n");
    sb.append("    netInternalAmount: ").append(toIndentedString(netInternalAmount)).append("\n");
    sb.append("    netCaptureAmount: ").append(toIndentedString(netCaptureAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

