package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.RemoveEntryResponse;
import travel.wink.sdk.affiliate.model.SalesChannelRelationshipRequestView;
import travel.wink.sdk.affiliate.model.SalesChannelRelationshipRequestViewAffiliate;
import travel.wink.sdk.affiliate.model.ShowSupplierUrl400Response;
import travel.wink.sdk.affiliate.model.UpsertSalesChannelRelationshipRequestRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-05-12T18:08:19.345230203+07:00[Asia/Bangkok]")
public class HotelRelationshipRequestsApi {
    private ApiClient apiClient;

    public HotelRelationshipRequestsApi() {
        this(new ApiClient());
    }

    @Autowired
    public HotelRelationshipRequestsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create hotel request
     * Create a new hotel request.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create hotel request and associate it with this company identifier
     * @param upsertSalesChannelRelationshipRequestRequest The upsertSalesChannelRelationshipRequestRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return SalesChannelRelationshipRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createPropertyRequestRequestCreation(String companyIdentifier, UpsertSalesChannelRelationshipRequestRequest upsertSalesChannelRelationshipRequestRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSalesChannelRelationshipRequestRequest;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createPropertyRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSalesChannelRelationshipRequestRequest' is set
        if (upsertSalesChannelRelationshipRequestRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSalesChannelRelationshipRequestRequest' when calling createPropertyRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/sales/request", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create hotel request
     * Create a new hotel request.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create hotel request and associate it with this company identifier
     * @param upsertSalesChannelRelationshipRequestRequest The upsertSalesChannelRelationshipRequestRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return SalesChannelRelationshipRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SalesChannelRelationshipRequestView> createPropertyRequest(String companyIdentifier, UpsertSalesChannelRelationshipRequestRequest upsertSalesChannelRelationshipRequestRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>() {};
        return createPropertyRequestRequestCreation(companyIdentifier, upsertSalesChannelRelationshipRequestRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create hotel request
     * Create a new hotel request.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create hotel request and associate it with this company identifier
     * @param upsertSalesChannelRelationshipRequestRequest The upsertSalesChannelRelationshipRequestRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SalesChannelRelationshipRequestView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SalesChannelRelationshipRequestView>> createPropertyRequestWithHttpInfo(String companyIdentifier, UpsertSalesChannelRelationshipRequestRequest upsertSalesChannelRelationshipRequestRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>() {};
        return createPropertyRequestRequestCreation(companyIdentifier, upsertSalesChannelRelationshipRequestRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create hotel request
     * Create a new hotel request.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create hotel request and associate it with this company identifier
     * @param upsertSalesChannelRelationshipRequestRequest The upsertSalesChannelRelationshipRequestRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createPropertyRequestWithResponseSpec(String companyIdentifier, UpsertSalesChannelRelationshipRequestRequest upsertSalesChannelRelationshipRequestRequest, String winkVersion) throws WebClientResponseException {
        return createPropertyRequestRequestCreation(companyIdentifier, upsertSalesChannelRelationshipRequestRequest, winkVersion);
    }
    /**
     * Reject hotel request
     * Delete a hotel request
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove hotel request owned by this company identifier
     * @param salesChannelRequestIdentifier Remove hotel request with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removePropertyRequestRequestCreation(String companyIdentifier, String salesChannelRequestIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removePropertyRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'salesChannelRequestIdentifier' is set
        if (salesChannelRequestIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelRequestIdentifier' when calling removePropertyRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("salesChannelRequestIdentifier", salesChannelRequestIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/sales/request/{salesChannelRequestIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Reject hotel request
     * Delete a hotel request
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove hotel request owned by this company identifier
     * @param salesChannelRequestIdentifier Remove hotel request with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removePropertyRequest(String companyIdentifier, String salesChannelRequestIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removePropertyRequestRequestCreation(companyIdentifier, salesChannelRequestIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Reject hotel request
     * Delete a hotel request
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove hotel request owned by this company identifier
     * @param salesChannelRequestIdentifier Remove hotel request with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponse>> removePropertyRequestWithHttpInfo(String companyIdentifier, String salesChannelRequestIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removePropertyRequestRequestCreation(companyIdentifier, salesChannelRequestIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Reject hotel request
     * Delete a hotel request
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove hotel request owned by this company identifier
     * @param salesChannelRequestIdentifier Remove hotel request with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removePropertyRequestWithResponseSpec(String companyIdentifier, String salesChannelRequestIdentifier, String winkVersion) throws WebClientResponseException {
        return removePropertyRequestRequestCreation(companyIdentifier, salesChannelRequestIdentifier, winkVersion);
    }
    /**
     * Show hotel request
     * Retrieve a specific hotel request based on a companyId and a supplierId.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show hotel request for this company identifier
     * @param supplierIdentifier Show hotel request for this supplier identifier
     * @param winkVersion The winkVersion parameter
     * @return SalesChannelRelationshipRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyRequestRequestCreation(String companyIdentifier, String supplierIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showPropertyRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'supplierIdentifier' is set
        if (supplierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierIdentifier' when calling showPropertyRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("supplierIdentifier", supplierIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/sales/request/supplier/{supplierIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show hotel request
     * Retrieve a specific hotel request based on a companyId and a supplierId.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show hotel request for this company identifier
     * @param supplierIdentifier Show hotel request for this supplier identifier
     * @param winkVersion The winkVersion parameter
     * @return SalesChannelRelationshipRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SalesChannelRelationshipRequestView> showPropertyRequest(String companyIdentifier, String supplierIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>() {};
        return showPropertyRequestRequestCreation(companyIdentifier, supplierIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show hotel request
     * Retrieve a specific hotel request based on a companyId and a supplierId.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show hotel request for this company identifier
     * @param supplierIdentifier Show hotel request for this supplier identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SalesChannelRelationshipRequestView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SalesChannelRelationshipRequestView>> showPropertyRequestWithHttpInfo(String companyIdentifier, String supplierIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>() {};
        return showPropertyRequestRequestCreation(companyIdentifier, supplierIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show hotel request
     * Retrieve a specific hotel request based on a companyId and a supplierId.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show hotel request for this company identifier
     * @param supplierIdentifier Show hotel request for this supplier identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyRequestWithResponseSpec(String companyIdentifier, String supplierIdentifier, String winkVersion) throws WebClientResponseException {
        return showPropertyRequestRequestCreation(companyIdentifier, supplierIdentifier, winkVersion);
    }
    /**
     * Show hotel requests
     * Retrieve list of all hotel requests for this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show all hotel requests for this company identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SalesChannelRelationshipRequestViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyRequestsRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showPropertyRequests", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SalesChannelRelationshipRequestViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/sales/request/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show hotel requests
     * Retrieve list of all hotel requests for this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show all hotel requests for this company identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SalesChannelRelationshipRequestViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SalesChannelRelationshipRequestViewAffiliate> showPropertyRequests(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewAffiliate>() {};
        return showPropertyRequestsRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show hotel requests
     * Retrieve list of all hotel requests for this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show all hotel requests for this company identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;SalesChannelRelationshipRequestViewAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<SalesChannelRelationshipRequestViewAffiliate>>> showPropertyRequestsWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewAffiliate>() {};
        return showPropertyRequestsRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show hotel requests
     * Retrieve list of all hotel requests for this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show all hotel requests for this company identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyRequestsWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showPropertyRequestsRequestCreation(companyIdentifier, winkVersion);
    }
}
