/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 25.4.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import travel.wink.sdk.affiliate.model.MoneysAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * In case of LODGING, include daily rates
 */
@JsonPropertyOrder({
  DailyRateAffiliate.JSON_PROPERTY_DATE,
  DailyRateAffiliate.JSON_PROPERTY_PRICE,
  DailyRateAffiliate.JSON_PROPERTY_DISPLAY_PRICE,
  DailyRateAffiliate.JSON_PROPERTY_SUPPLIER_PRICE,
  DailyRateAffiliate.JSON_PROPERTY_INTERNAL_PRICE,
  DailyRateAffiliate.JSON_PROPERTY_CAPTURE_PRICE
})
@JsonTypeName("DailyRate_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-05-12T18:08:19.345230203+07:00[Asia/Bangkok]")
public class DailyRateAffiliate {
  public static final String JSON_PROPERTY_DATE = "date";
  private LocalDate date;

  public static final String JSON_PROPERTY_PRICE = "price";
  private MoneysAffiliate price;

  public static final String JSON_PROPERTY_DISPLAY_PRICE = "displayPrice";
  private MoneysAffiliate displayPrice;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE = "supplierPrice";
  private MoneysAffiliate supplierPrice;

  public static final String JSON_PROPERTY_INTERNAL_PRICE = "internalPrice";
  private MoneysAffiliate internalPrice;

  public static final String JSON_PROPERTY_CAPTURE_PRICE = "capturePrice";
  private MoneysAffiliate capturePrice;

  public DailyRateAffiliate() {
  }

  public DailyRateAffiliate date(LocalDate date) {
    
    this.date = date;
    return this;
  }

   /**
   * The date this rate is applicable for.
   * @return date
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDate(LocalDate date) {
    this.date = date;
  }


  public DailyRateAffiliate price(MoneysAffiliate price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysAffiliate getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(MoneysAffiliate price) {
    this.price = price;
  }


  public DailyRateAffiliate displayPrice(MoneysAffiliate displayPrice) {
    
    this.displayPrice = displayPrice;
    return this;
  }

   /**
   * Get displayPrice
   * @return displayPrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysAffiliate getDisplayPrice() {
    return displayPrice;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayPrice(MoneysAffiliate displayPrice) {
    this.displayPrice = displayPrice;
  }


  public DailyRateAffiliate supplierPrice(MoneysAffiliate supplierPrice) {
    
    this.supplierPrice = supplierPrice;
    return this;
  }

   /**
   * Get supplierPrice
   * @return supplierPrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysAffiliate getSupplierPrice() {
    return supplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierPrice(MoneysAffiliate supplierPrice) {
    this.supplierPrice = supplierPrice;
  }


  public DailyRateAffiliate internalPrice(MoneysAffiliate internalPrice) {
    
    this.internalPrice = internalPrice;
    return this;
  }

   /**
   * Get internalPrice
   * @return internalPrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysAffiliate getInternalPrice() {
    return internalPrice;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalPrice(MoneysAffiliate internalPrice) {
    this.internalPrice = internalPrice;
  }


  public DailyRateAffiliate capturePrice(MoneysAffiliate capturePrice) {
    
    this.capturePrice = capturePrice;
    return this;
  }

   /**
   * Get capturePrice
   * @return capturePrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysAffiliate getCapturePrice() {
    return capturePrice;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCapturePrice(MoneysAffiliate capturePrice) {
    this.capturePrice = capturePrice;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DailyRateAffiliate dailyRateAffiliate = (DailyRateAffiliate) o;
    return Objects.equals(this.date, dailyRateAffiliate.date) &&
        Objects.equals(this.price, dailyRateAffiliate.price) &&
        Objects.equals(this.displayPrice, dailyRateAffiliate.displayPrice) &&
        Objects.equals(this.supplierPrice, dailyRateAffiliate.supplierPrice) &&
        Objects.equals(this.internalPrice, dailyRateAffiliate.internalPrice) &&
        Objects.equals(this.capturePrice, dailyRateAffiliate.capturePrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(date, price, displayPrice, supplierPrice, internalPrice, capturePrice);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DailyRateAffiliate {\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    displayPrice: ").append(toIndentedString(displayPrice)).append("\n");
    sb.append("    supplierPrice: ").append(toIndentedString(supplierPrice)).append("\n");
    sb.append("    internalPrice: ").append(toIndentedString(internalPrice)).append("\n");
    sb.append("    capturePrice: ").append(toIndentedString(capturePrice)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

