/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 25.4.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.sdk.affiliate.model.CountryAffiliate;
import travel.wink.sdk.affiliate.model.GeoJsonPointAffiliate;
import travel.wink.sdk.affiliate.model.SubCountryAffiliate;
import travel.wink.sdk.affiliate.model.SubSubCountryAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * GeoNames have been created at [https://geonames.org](https://geonames.org) and contain geographical destinations we use as geoname data to associate travel inventory with a location.
 */
@JsonPropertyOrder({
  GeoNameAffiliate.JSON_PROPERTY_GEO_NAME_ID,
  GeoNameAffiliate.JSON_PROPERTY_TYPE,
  GeoNameAffiliate.JSON_PROPERTY_NAME,
  GeoNameAffiliate.JSON_PROPERTY_URL_NAME,
  GeoNameAffiliate.JSON_PROPERTY_ASCII_NAME,
  GeoNameAffiliate.JSON_PROPERTY_LOCATION,
  GeoNameAffiliate.JSON_PROPERTY_FEATURE_CODE,
  GeoNameAffiliate.JSON_PROPERTY_COUNTRY_CODE,
  GeoNameAffiliate.JSON_PROPERTY_TIMEZONE,
  GeoNameAffiliate.JSON_PROPERTY_COUNTRY,
  GeoNameAffiliate.JSON_PROPERTY_SUB_COUNTRY,
  GeoNameAffiliate.JSON_PROPERTY_SUB_SUB_COUNTRY
})
@JsonTypeName("GeoName_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-05-12T18:08:19.345230203+07:00[Asia/Bangkok]")
public class GeoNameAffiliate {
  public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
  private String geoNameId;

  /**
   * GeoName type
   */
  public enum TypeEnum {
    CITY("CITY"),
    
    ISLAND("ISLAND"),
    
    OTHER("OTHER");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_ASCII_NAME = "asciiName";
  private String asciiName;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointAffiliate location;

  public static final String JSON_PROPERTY_FEATURE_CODE = "featureCode";
  private String featureCode;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  private String timezone;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private CountryAffiliate country;

  public static final String JSON_PROPERTY_SUB_COUNTRY = "subCountry";
  private SubCountryAffiliate subCountry;

  public static final String JSON_PROPERTY_SUB_SUB_COUNTRY = "subSubCountry";
  private SubSubCountryAffiliate subSubCountry;

  public GeoNameAffiliate() {
  }

  public GeoNameAffiliate geoNameId(String geoNameId) {
    
    this.geoNameId = geoNameId;
    return this;
  }

   /**
   * GeoName identifier
   * @return geoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGeoNameId() {
    return geoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeoNameId(String geoNameId) {
    this.geoNameId = geoNameId;
  }


  public GeoNameAffiliate type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * GeoName type
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public GeoNameAffiliate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of city
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public GeoNameAffiliate urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Url name
   * @return urlName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public GeoNameAffiliate asciiName(String asciiName) {
    
    this.asciiName = asciiName;
    return this;
  }

   /**
   * Ascii name of city
   * @return asciiName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ASCII_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAsciiName() {
    return asciiName;
  }


  @JsonProperty(JSON_PROPERTY_ASCII_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAsciiName(String asciiName) {
    this.asciiName = asciiName;
  }


  public GeoNameAffiliate location(GeoJsonPointAffiliate location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPointAffiliate getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(GeoJsonPointAffiliate location) {
    this.location = location;
  }


  public GeoNameAffiliate featureCode(String featureCode) {
    
    this.featureCode = featureCode;
    return this;
  }

   /**
   * Get featureCode
   * @return featureCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FEATURE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFeatureCode() {
    return featureCode;
  }


  @JsonProperty(JSON_PROPERTY_FEATURE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeatureCode(String featureCode) {
    this.featureCode = featureCode;
  }


  public GeoNameAffiliate countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Get countryCode
   * @return countryCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public GeoNameAffiliate timezone(String timezone) {
    
    this.timezone = timezone;
    return this;
  }

   /**
   * Timezone
   * @return timezone
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  public GeoNameAffiliate country(CountryAffiliate country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CountryAffiliate getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(CountryAffiliate country) {
    this.country = country;
  }


  public GeoNameAffiliate subCountry(SubCountryAffiliate subCountry) {
    
    this.subCountry = subCountry;
    return this;
  }

   /**
   * Get subCountry
   * @return subCountry
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubCountryAffiliate getSubCountry() {
    return subCountry;
  }


  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubCountry(SubCountryAffiliate subCountry) {
    this.subCountry = subCountry;
  }


  public GeoNameAffiliate subSubCountry(SubSubCountryAffiliate subSubCountry) {
    
    this.subSubCountry = subSubCountry;
    return this;
  }

   /**
   * Get subSubCountry
   * @return subSubCountry
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubSubCountryAffiliate getSubSubCountry() {
    return subSubCountry;
  }


  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubSubCountry(SubSubCountryAffiliate subSubCountry) {
    this.subSubCountry = subSubCountry;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoNameAffiliate geoNameAffiliate = (GeoNameAffiliate) o;
    return Objects.equals(this.geoNameId, geoNameAffiliate.geoNameId) &&
        Objects.equals(this.type, geoNameAffiliate.type) &&
        Objects.equals(this.name, geoNameAffiliate.name) &&
        Objects.equals(this.urlName, geoNameAffiliate.urlName) &&
        Objects.equals(this.asciiName, geoNameAffiliate.asciiName) &&
        Objects.equals(this.location, geoNameAffiliate.location) &&
        Objects.equals(this.featureCode, geoNameAffiliate.featureCode) &&
        Objects.equals(this.countryCode, geoNameAffiliate.countryCode) &&
        Objects.equals(this.timezone, geoNameAffiliate.timezone) &&
        Objects.equals(this.country, geoNameAffiliate.country) &&
        Objects.equals(this.subCountry, geoNameAffiliate.subCountry) &&
        Objects.equals(this.subSubCountry, geoNameAffiliate.subSubCountry);
  }

  @Override
  public int hashCode() {
    return Objects.hash(geoNameId, type, name, urlName, asciiName, location, featureCode, countryCode, timezone, country, subCountry, subSubCountry);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoNameAffiliate {\n");
    sb.append("    geoNameId: ").append(toIndentedString(geoNameId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    asciiName: ").append(toIndentedString(asciiName)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    featureCode: ").append(toIndentedString(featureCode)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    subCountry: ").append(toIndentedString(subCountry)).append("\n");
    sb.append("    subSubCountry: ").append(toIndentedString(subSubCountry)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

