/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.AdvancedMapConfigurationViewAffiliate;
import travel.wink.sdk.affiliate.model.InventoryMapMarkerAffiliate;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.UpsertAdvancedMapConfigurationRequestAffiliate;

public class MapsApi {
    private ApiClient apiClient;

    public MapsApi() {
        this(new ApiClient());
    }

    @Autowired
    public MapsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createAdvancedMapConfigurationRequestCreation(String companyIdentifier, UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertAdvancedMapConfigurationRequestAffiliate postBody = upsertAdvancedMapConfigurationRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAdvancedMapConfigurationRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAdvancedMapConfigurationRequestAffiliate' when calling createAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/map", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AdvancedMapConfigurationViewAffiliate> createAdvancedMapConfiguration(String companyIdentifier, UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(){};
        return this.createAdvancedMapConfigurationRequestCreation(companyIdentifier, upsertAdvancedMapConfigurationRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationViewAffiliate>> createAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(){};
        return this.createAdvancedMapConfigurationRequestCreation(companyIdentifier, upsertAdvancedMapConfigurationRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAdvancedMapConfigurationWithResponseSpec(String companyIdentifier, UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createAdvancedMapConfigurationRequestCreation(companyIdentifier, upsertAdvancedMapConfigurationRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeAdvancedMapConfigurationRequestCreation(String companyIdentifier, String mapIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling removeAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("mapIdentifier", mapIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/map/{mapIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseAffiliate> removeAdvancedMapConfiguration(String companyIdentifier, String mapIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(){};
        return this.removeAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, String mapIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(){};
        return this.removeAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeAdvancedMapConfigurationWithResponseSpec(String companyIdentifier, String mapIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showAdvancedMapConfigurationRequestCreation(String companyIdentifier, String mapIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling showAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("mapIdentifier", mapIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/map/{mapIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AdvancedMapConfigurationViewAffiliate> showAdvancedMapConfiguration(String companyIdentifier, String mapIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(){};
        return this.showAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationViewAffiliate>> showAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, String mapIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(){};
        return this.showAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAdvancedMapConfigurationWithResponseSpec(String companyIdentifier, String mapIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showAdvancedMapConfigurationMapMarkerRequestCreation(String companyIdentifier, String channelInventoryIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfigurationMapMarker", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (channelInventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'channelInventoryIdentifier' when calling showAdvancedMapConfigurationMapMarker", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("channelInventoryIdentifier", channelInventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/map/marker/{channelInventoryIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryMapMarkerAffiliate> showAdvancedMapConfigurationMapMarker(String companyIdentifier, String channelInventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(){};
        return this.showAdvancedMapConfigurationMapMarkerRequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryMapMarkerAffiliate>> showAdvancedMapConfigurationMapMarkerWithHttpInfo(String companyIdentifier, String channelInventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(){};
        return this.showAdvancedMapConfigurationMapMarkerRequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAdvancedMapConfigurationMapMarkerWithResponseSpec(String companyIdentifier, String channelInventoryIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showAdvancedMapConfigurationMapMarkerRequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showAdvancedMapConfigurationMapMarkersRequestCreation(String companyIdentifier, String listIdentifier, String listType, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfigurationMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showAdvancedMapConfigurationMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listType == null) {
            throw new WebClientResponseException("Missing the required parameter 'listType' when calling showAdvancedMapConfigurationMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("listType", listType);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/map/markers/{listType}/{listIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InventoryMapMarkerAffiliate> showAdvancedMapConfigurationMapMarkers(String companyIdentifier, String listIdentifier, String listType, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(){};
        return this.showAdvancedMapConfigurationMapMarkersRequestCreation(companyIdentifier, listIdentifier, listType, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventoryMapMarkerAffiliate>>> showAdvancedMapConfigurationMapMarkersWithHttpInfo(String companyIdentifier, String listIdentifier, String listType, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(){};
        return this.showAdvancedMapConfigurationMapMarkersRequestCreation(companyIdentifier, listIdentifier, listType, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAdvancedMapConfigurationMapMarkersWithResponseSpec(String companyIdentifier, String listIdentifier, String listType, String winkVersion) throws WebClientResponseException {
        return this.showAdvancedMapConfigurationMapMarkersRequestCreation(companyIdentifier, listIdentifier, listType, winkVersion);
    }

    private WebClient.ResponseSpec showAdvancedMapConfigurationsRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfigurations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/map", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<AdvancedMapConfigurationViewAffiliate> showAdvancedMapConfigurations(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(){};
        return this.showAdvancedMapConfigurationsRequestCreation(companyIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<AdvancedMapConfigurationViewAffiliate>>> showAdvancedMapConfigurationsWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(){};
        return this.showAdvancedMapConfigurationsRequestCreation(companyIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAdvancedMapConfigurationsWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showAdvancedMapConfigurationsRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec updateAdvancedMapConfigurationRequestCreation(String companyIdentifier, String mapIdentifier, UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertAdvancedMapConfigurationRequestAffiliate postBody = upsertAdvancedMapConfigurationRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling updateAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAdvancedMapConfigurationRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAdvancedMapConfigurationRequestAffiliate' when calling updateAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("mapIdentifier", mapIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/map/{mapIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AdvancedMapConfigurationViewAffiliate> updateAdvancedMapConfiguration(String companyIdentifier, String mapIdentifier, UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(){};
        return this.updateAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, upsertAdvancedMapConfigurationRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationViewAffiliate>> updateAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, String mapIdentifier, UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(){};
        return this.updateAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, upsertAdvancedMapConfigurationRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAdvancedMapConfigurationWithResponseSpec(String companyIdentifier, String mapIdentifier, UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, upsertAdvancedMapConfigurationRequestAffiliate, winkVersion);
    }
}

