/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "ownerIdentifier", "ownerName", "ownerType", "name", "redirectUris", "clientId"})
public class Application {
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    private UUID ownerIdentifier;
    public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
    private String ownerName;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    private OwnerTypeEnum ownerType;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_REDIRECT_URIS = "redirectUris";
    private List<String> redirectUris = new ArrayList<String>();
    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    private String clientId;

    public Application id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(UUID id) {
        this.id = id;
    }

    public Application ownerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public Application ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public Application ownerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    public Application name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Application redirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public Application addRedirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<String>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="redirectUris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    @JsonProperty(value="redirectUris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public Application clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Application application = (Application)o;
        return Objects.equals(this.id, application.id) && Objects.equals(this.ownerIdentifier, application.ownerIdentifier) && Objects.equals(this.ownerName, application.ownerName) && Objects.equals((Object)this.ownerType, (Object)application.ownerType) && Objects.equals(this.name, application.name) && Objects.equals(this.redirectUris, application.redirectUris) && Objects.equals(this.clientId, application.clientId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.ownerIdentifier, this.ownerName, this.ownerType, this.name, this.redirectUris, this.clientId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Application {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OwnerTypeEnum {
        USER("USER"),
        COMPANY("COMPANY"),
        ACCOUNT("ACCOUNT");

        private String value;

        private OwnerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OwnerTypeEnum fromValue(String value) {
            for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

