package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.Application;
import travel.wink.sdk.affiliate.model.CreateApplicationResponse;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.RemoveEntryResponse;
import travel.wink.sdk.affiliate.model.RevokeClientIdResponse;
import travel.wink.sdk.affiliate.model.ShowSupplierUrl400Response;
import travel.wink.sdk.affiliate.model.UpdateApplicationResponse;
import travel.wink.sdk.affiliate.model.UpsertApplicationRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-06-04T14:48:41.264668983+07:00[Asia/Bangkok]")
public class ApplicationApi {
    private ApiClient apiClient;

    public ApplicationApi() {
        this(new ApiClient());
    }

    @Autowired
    public ApplicationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Application
     * Create a new application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>201</b> - Created
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CreateApplicationResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createApplicationRequestCreation(UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertApplicationRequest;
        // verify the required parameter 'upsertApplicationRequest' is set
        if (upsertApplicationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertApplicationRequest' when calling createApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CreateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<CreateApplicationResponse>() {};
        return apiClient.invokeAPI("/api/application", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Application
     * Create a new application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>201</b> - Created
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CreateApplicationResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CreateApplicationResponse> createApplication(UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CreateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<CreateApplicationResponse>() {};
        return createApplicationRequestCreation(upsertApplicationRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Application
     * Create a new application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>201</b> - Created
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CreateApplicationResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CreateApplicationResponse>> createApplicationWithHttpInfo(UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CreateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<CreateApplicationResponse>() {};
        return createApplicationRequestCreation(upsertApplicationRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Application
     * Create a new application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>201</b> - Created
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createApplicationWithResponseSpec(UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        return createApplicationRequestCreation(upsertApplicationRequest, winkVersion);
    }
    /**
     * Delete Application
     * Remove a specific application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec deleteApplicationRequestCreation(String id, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling deleteApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/application/{id}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Application
     * Remove a specific application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> deleteApplication(String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return deleteApplicationRequestCreation(id, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Application
     * Remove a specific application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponse>> deleteApplicationWithHttpInfo(String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return deleteApplicationRequestCreation(id, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Application
     * Remove a specific application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec deleteApplicationWithResponseSpec(String id, String winkVersion) throws WebClientResponseException {
        return deleteApplicationRequestCreation(id, winkVersion);
    }
    /**
     * Show Application
     * Show a specific application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return Application
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadApplicationRequestCreation(String id, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>() {};
        return apiClient.invokeAPI("/api/application/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Application
     * Show a specific application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return Application
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Application> loadApplication(String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>() {};
        return loadApplicationRequestCreation(id, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Application
     * Show a specific application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Application&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Application>> loadApplicationWithHttpInfo(String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>() {};
        return loadApplicationRequestCreation(id, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Application
     * Show a specific application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadApplicationWithResponseSpec(String id, String winkVersion) throws WebClientResponseException {
        return loadApplicationRequestCreation(id, winkVersion);
    }
    /**
     * Revoke Application Credentials
     * Refreshes the clientId and secretKey properties.
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return RevokeClientIdResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec revokeApplicationRequestCreation(String id, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling revokeApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RevokeClientIdResponse> localVarReturnType = new ParameterizedTypeReference<RevokeClientIdResponse>() {};
        return apiClient.invokeAPI("/api/application/{id}/revoke", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Revoke Application Credentials
     * Refreshes the clientId and secretKey properties.
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return RevokeClientIdResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RevokeClientIdResponse> revokeApplication(String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RevokeClientIdResponse> localVarReturnType = new ParameterizedTypeReference<RevokeClientIdResponse>() {};
        return revokeApplicationRequestCreation(id, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Revoke Application Credentials
     * Refreshes the clientId and secretKey properties.
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RevokeClientIdResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RevokeClientIdResponse>> revokeApplicationWithHttpInfo(String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RevokeClientIdResponse> localVarReturnType = new ParameterizedTypeReference<RevokeClientIdResponse>() {};
        return revokeApplicationRequestCreation(id, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Revoke Application Credentials
     * Refreshes the clientId and secretKey properties.
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec revokeApplicationWithResponseSpec(String id, String winkVersion) throws WebClientResponseException {
        return revokeApplicationRequestCreation(id, winkVersion);
    }
    /**
     * Show Applications
     * List all applications owned by creating entity
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;Application&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showApplicationsRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>() {};
        return apiClient.invokeAPI("/api/application/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Applications
     * List all applications owned by creating entity
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;Application&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Application> showApplications(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>() {};
        return showApplicationsRequestCreation(winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Applications
     * List all applications owned by creating entity
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;Application&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Application>>> showApplicationsWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>() {};
        return showApplicationsRequestCreation(winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Applications
     * List all applications owned by creating entity
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showApplicationsWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return showApplicationsRequestCreation(winkVersion);
    }
    /**
     * Update Application
     * Update an existing application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UpdateApplicationResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateApplicationRequestCreation(String id, UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertApplicationRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertApplicationRequest' is set
        if (upsertApplicationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertApplicationRequest' when calling updateApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpdateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<UpdateApplicationResponse>() {};
        return apiClient.invokeAPI("/api/application/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Application
     * Update an existing application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UpdateApplicationResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpdateApplicationResponse> updateApplication(String id, UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<UpdateApplicationResponse>() {};
        return updateApplicationRequestCreation(id, upsertApplicationRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Application
     * Update an existing application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UpdateApplicationResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpdateApplicationResponse>> updateApplicationWithHttpInfo(String id, UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<UpdateApplicationResponse>() {};
        return updateApplicationRequestCreation(id, upsertApplicationRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Application
     * Update an existing application
     * <p><b>503</b> - Service Unavailable
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateApplicationWithResponseSpec(String id, UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        return updateApplicationRequestCreation(id, upsertApplicationRequest, winkVersion);
    }
}
