/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 25.6.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.AddressAffiliate;
import travel.wink.sdk.affiliate.model.BookingAncillaryAffiliate;
import travel.wink.sdk.affiliate.model.BookingContractAffiliate;
import travel.wink.sdk.affiliate.model.BookingUserAffiliate;
import travel.wink.sdk.affiliate.model.CommissionableEntryAffiliate;
import travel.wink.sdk.affiliate.model.ContactAffiliate;
import travel.wink.sdk.affiliate.model.CustomMonetaryAmount;
import travel.wink.sdk.affiliate.model.EngineConfigurationBookingReportAffiliate;
import travel.wink.sdk.affiliate.model.HotelOnMapAffiliate;
import travel.wink.sdk.affiliate.model.ReportingAncillaryAffiliate;
import travel.wink.sdk.affiliate.model.ReportingDailyRateAffiliate;
import travel.wink.sdk.affiliate.model.ReportingExtraChargeAffiliate;
import travel.wink.sdk.affiliate.model.ReviewAffiliate;
import travel.wink.sdk.affiliate.model.RoomStayAffiliate;
import travel.wink.sdk.affiliate.model.SocialAffiliate;
import travel.wink.sdk.affiliate.model.UserSessionAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Booking data object
 */
@JsonPropertyOrder({
  BookingAffiliate.JSON_PROPERTY_TEST,
  BookingAffiliate.JSON_PROPERTY_DATE,
  BookingAffiliate.JSON_PROPERTY_GROUP_IDENTIFIER,
  BookingAffiliate.JSON_PROPERTY_IDENTIFIER,
  BookingAffiliate.JSON_PROPERTY_ENGINE_CONFIGURATION,
  BookingAffiliate.JSON_PROPERTY_BOOKING_CODE,
  BookingAffiliate.JSON_PROPERTY_USER,
  BookingAffiliate.JSON_PROPERTY_USER_SESSION,
  BookingAffiliate.JSON_PROPERTY_SERVER_URL,
  BookingAffiliate.JSON_PROPERTY_CONTACT_INFO,
  BookingAffiliate.JSON_PROPERTY_ADDRESS,
  BookingAffiliate.JSON_PROPERTY_SOCIALS,
  BookingAffiliate.JSON_PROPERTY_REVIEW,
  BookingAffiliate.JSON_PROPERTY_EMAIL_HEADER_LOGO_URL,
  BookingAffiliate.JSON_PROPERTY_LOGO_IDENTIFIER,
  BookingAffiliate.JSON_PROPERTY_HOTEL,
  BookingAffiliate.JSON_PROPERTY_ROOM_STAY,
  BookingAffiliate.JSON_PROPERTY_SPECIAL_REQUESTS,
  BookingAffiliate.JSON_PROPERTY_COMMENT,
  BookingAffiliate.JSON_PROPERTY_EARLY_CHECK_IN_CHARGE,
  BookingAffiliate.JSON_PROPERTY_LATE_CHECK_OUT_CHARGE,
  BookingAffiliate.JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT,
  BookingAffiliate.JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT,
  BookingAffiliate.JSON_PROPERTY_HOTEL_IMAGE_URL,
  BookingAffiliate.JSON_PROPERTY_ROOM_IMAGE_URL,
  BookingAffiliate.JSON_PROPERTY_COMMISSION_LIST,
  BookingAffiliate.JSON_PROPERTY_ANCILLARY_LIST,
  BookingAffiliate.JSON_PROPERTY_BOOKING_CONTRACT,
  BookingAffiliate.JSON_PROPERTY_STATUS,
  BookingAffiliate.JSON_PROPERTY_HAS_BREAKFAST,
  BookingAffiliate.JSON_PROPERTY_HAS_BRUNCH,
  BookingAffiliate.JSON_PROPERTY_HAS_LUNCH,
  BookingAffiliate.JSON_PROPERTY_HAS_DINNER,
  BookingAffiliate.JSON_PROPERTY_HAS_ALL_INCLUSIVE,
  BookingAffiliate.JSON_PROPERTY_HAS_ALL_INCLUSIVE_PLUS_ALCOHOL,
  BookingAffiliate.JSON_PROPERTY_HAS_ADD_ONS,
  BookingAffiliate.JSON_PROPERTY_REPORTING_EXTRA_CHARGE_LIST,
  BookingAffiliate.JSON_PROPERTY_FULL_ADDRESS,
  BookingAffiliate.JSON_PROPERTY_RATE_SOURCE,
  BookingAffiliate.JSON_PROPERTY_HAS_ROOM_TYPE_ANCILLARIES,
  BookingAffiliate.JSON_PROPERTY_HAS_FOOD,
  BookingAffiliate.JSON_PROPERTY_HAS_RESTAURANTS,
  BookingAffiliate.JSON_PROPERTY_HAS_MEETING_ROOMS,
  BookingAffiliate.JSON_PROPERTY_HAS_SPAS,
  BookingAffiliate.JSON_PROPERTY_HAS_ACTIVITIES,
  BookingAffiliate.JSON_PROPERTY_HAS_ATTRACTIONS,
  BookingAffiliate.JSON_PROPERTY_HAS_PLACES,
  BookingAffiliate.JSON_PROPERTY_REPORTING_DAILY_RATE_LIST,
  BookingAffiliate.JSON_PROPERTY_REPORTING_ANCILLARY_LIST,
  BookingAffiliate.JSON_PROPERTY_MEETING_ROOMS,
  BookingAffiliate.JSON_PROPERTY_RESTAURANTS,
  BookingAffiliate.JSON_PROPERTY_SPAS,
  BookingAffiliate.JSON_PROPERTY_ACTIVITIES,
  BookingAffiliate.JSON_PROPERTY_ATTRACTIONS,
  BookingAffiliate.JSON_PROPERTY_PLACES,
  BookingAffiliate.JSON_PROPERTY_ROOM_TYPE_ANCILLARIES,
  BookingAffiliate.JSON_PROPERTY_ADD_ONS
})
@JsonTypeName("Booking_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-06-04T14:48:41.264668983+07:00[Asia/Bangkok]")
public class BookingAffiliate {
  public static final String JSON_PROPERTY_TEST = "test";
  private Boolean test = false;

  public static final String JSON_PROPERTY_DATE = "date";
  private java.time.LocalDateTime date;

  public static final String JSON_PROPERTY_GROUP_IDENTIFIER = "groupIdentifier";
  private UUID groupIdentifier;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_ENGINE_CONFIGURATION = "engineConfiguration";
  private EngineConfigurationBookingReportAffiliate engineConfiguration;

  public static final String JSON_PROPERTY_BOOKING_CODE = "bookingCode";
  private String bookingCode;

  public static final String JSON_PROPERTY_USER = "user";
  private BookingUserAffiliate user;

  public static final String JSON_PROPERTY_USER_SESSION = "userSession";
  private UserSessionAffiliate userSession;

  public static final String JSON_PROPERTY_SERVER_URL = "serverUrl";
  private String serverUrl;

  public static final String JSON_PROPERTY_CONTACT_INFO = "contactInfo";
  private ContactAffiliate contactInfo;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressAffiliate address;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<SocialAffiliate> socials = new ArrayList<>();

  public static final String JSON_PROPERTY_REVIEW = "review";
  private ReviewAffiliate review;

  public static final String JSON_PROPERTY_EMAIL_HEADER_LOGO_URL = "emailHeaderLogoUrl";
  private String emailHeaderLogoUrl;

  public static final String JSON_PROPERTY_LOGO_IDENTIFIER = "logoIdentifier";
  private String logoIdentifier;

  public static final String JSON_PROPERTY_HOTEL = "hotel";
  private HotelOnMapAffiliate hotel;

  public static final String JSON_PROPERTY_ROOM_STAY = "roomStay";
  private RoomStayAffiliate roomStay;

  public static final String JSON_PROPERTY_SPECIAL_REQUESTS = "specialRequests";
  private String specialRequests;

  public static final String JSON_PROPERTY_COMMENT = "comment";
  private String comment;

  public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE = "earlyCheckInCharge";
  private CustomMonetaryAmount earlyCheckInCharge;

  public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE = "lateCheckOutCharge";
  private CustomMonetaryAmount lateCheckOutCharge;

  public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT = "earlyCheckInChargePercent";
  private Float earlyCheckInChargePercent;

  public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT = "lateCheckOutChargePercent";
  private Float lateCheckOutChargePercent;

  public static final String JSON_PROPERTY_HOTEL_IMAGE_URL = "hotelImageUrl";
  private String hotelImageUrl;

  public static final String JSON_PROPERTY_ROOM_IMAGE_URL = "roomImageUrl";
  private String roomImageUrl;

  public static final String JSON_PROPERTY_COMMISSION_LIST = "commissionList";
  private List<CommissionableEntryAffiliate> commissionList = new ArrayList<>();

  public static final String JSON_PROPERTY_ANCILLARY_LIST = "ancillaryList";
  private List<BookingAncillaryAffiliate> ancillaryList = new ArrayList<>();

  public static final String JSON_PROPERTY_BOOKING_CONTRACT = "bookingContract";
  private BookingContractAffiliate bookingContract;

  /**
   * Convenience data point to show which status the booking currently has.
   */
  public enum StatusEnum {
    CANCELLED_BY_HOTEL("CANCELLED_BY_HOTEL"),
    
    CANCELLED_BY_GUEST("CANCELLED_BY_GUEST"),
    
    CANCELLED_BY_ADMIN("CANCELLED_BY_ADMIN"),
    
    CANCELLED_BY_SALES_CHANNEL("CANCELLED_BY_SALES_CHANNEL"),
    
    PAST("PAST"),
    
    CANCELLED_BY_ACQUIRER("CANCELLED_BY_ACQUIRER"),
    
    ACTIVE("ACTIVE");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_HAS_BREAKFAST = "hasBreakfast";
  private Boolean hasBreakfast;

  public static final String JSON_PROPERTY_HAS_BRUNCH = "hasBrunch";
  private Boolean hasBrunch;

  public static final String JSON_PROPERTY_HAS_LUNCH = "hasLunch";
  private Boolean hasLunch;

  public static final String JSON_PROPERTY_HAS_DINNER = "hasDinner";
  private Boolean hasDinner;

  public static final String JSON_PROPERTY_HAS_ALL_INCLUSIVE = "hasAllInclusive";
  private Boolean hasAllInclusive;

  public static final String JSON_PROPERTY_HAS_ALL_INCLUSIVE_PLUS_ALCOHOL = "hasAllInclusivePlusAlcohol";
  private Boolean hasAllInclusivePlusAlcohol;

  public static final String JSON_PROPERTY_HAS_ADD_ONS = "hasAddOns";
  private Boolean hasAddOns;

  public static final String JSON_PROPERTY_REPORTING_EXTRA_CHARGE_LIST = "reportingExtraChargeList";
  private List<ReportingExtraChargeAffiliate> reportingExtraChargeList = new ArrayList<>();

  public static final String JSON_PROPERTY_FULL_ADDRESS = "fullAddress";
  private String fullAddress;

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  private String rateSource;

  public static final String JSON_PROPERTY_HAS_ROOM_TYPE_ANCILLARIES = "hasRoomTypeAncillaries";
  private Boolean hasRoomTypeAncillaries;

  public static final String JSON_PROPERTY_HAS_FOOD = "hasFood";
  private Boolean hasFood;

  public static final String JSON_PROPERTY_HAS_RESTAURANTS = "hasRestaurants";
  private Boolean hasRestaurants;

  public static final String JSON_PROPERTY_HAS_MEETING_ROOMS = "hasMeetingRooms";
  private Boolean hasMeetingRooms;

  public static final String JSON_PROPERTY_HAS_SPAS = "hasSpas";
  private Boolean hasSpas;

  public static final String JSON_PROPERTY_HAS_ACTIVITIES = "hasActivities";
  private Boolean hasActivities;

  public static final String JSON_PROPERTY_HAS_ATTRACTIONS = "hasAttractions";
  private Boolean hasAttractions;

  public static final String JSON_PROPERTY_HAS_PLACES = "hasPlaces";
  private Boolean hasPlaces;

  public static final String JSON_PROPERTY_REPORTING_DAILY_RATE_LIST = "reportingDailyRateList";
  private List<ReportingDailyRateAffiliate> reportingDailyRateList = new ArrayList<>();

  public static final String JSON_PROPERTY_REPORTING_ANCILLARY_LIST = "reportingAncillaryList";
  private List<ReportingAncillaryAffiliate> reportingAncillaryList = new ArrayList<>();

  public static final String JSON_PROPERTY_MEETING_ROOMS = "meetingRooms";
  private List<BookingAncillaryAffiliate> meetingRooms = new ArrayList<>();

  public static final String JSON_PROPERTY_RESTAURANTS = "restaurants";
  private List<BookingAncillaryAffiliate> restaurants = new ArrayList<>();

  public static final String JSON_PROPERTY_SPAS = "spas";
  private List<BookingAncillaryAffiliate> spas = new ArrayList<>();

  public static final String JSON_PROPERTY_ACTIVITIES = "activities";
  private List<BookingAncillaryAffiliate> activities = new ArrayList<>();

  public static final String JSON_PROPERTY_ATTRACTIONS = "attractions";
  private List<BookingAncillaryAffiliate> attractions = new ArrayList<>();

  public static final String JSON_PROPERTY_PLACES = "places";
  private List<BookingAncillaryAffiliate> places = new ArrayList<>();

  public static final String JSON_PROPERTY_ROOM_TYPE_ANCILLARIES = "roomTypeAncillaries";
  private List<BookingAncillaryAffiliate> roomTypeAncillaries = new ArrayList<>();

  public static final String JSON_PROPERTY_ADD_ONS = "addOns";
  private List<BookingAncillaryAffiliate> addOns = new ArrayList<>();

  public BookingAffiliate() {
  }

  public BookingAffiliate test(Boolean test) {
    
    this.test = test;
    return this;
  }

   /**
   * Whether this was a test booking by the property than can safely be deleted again
   * @return test
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TEST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getTest() {
    return test;
  }


  @JsonProperty(JSON_PROPERTY_TEST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTest(Boolean test) {
    this.test = test;
  }


  public BookingAffiliate date(java.time.LocalDateTime date) {
    
    this.date = date;
    return this;
  }

   /**
   * Date and time the booking was made.
   * @return date
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDate(java.time.LocalDateTime date) {
    this.date = date;
  }


  public BookingAffiliate groupIdentifier(UUID groupIdentifier) {
    
    this.groupIdentifier = groupIdentifier;
    return this;
  }

   /**
   * Unique record identifier for the collection of bookings that were made at the same time.
   * @return groupIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_GROUP_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getGroupIdentifier() {
    return groupIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGroupIdentifier(UUID groupIdentifier) {
    this.groupIdentifier = groupIdentifier;
  }


  public BookingAffiliate identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public BookingAffiliate engineConfiguration(EngineConfigurationBookingReportAffiliate engineConfiguration) {
    
    this.engineConfiguration = engineConfiguration;
    return this;
  }

   /**
   * Get engineConfiguration
   * @return engineConfiguration
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public EngineConfigurationBookingReportAffiliate getEngineConfiguration() {
    return engineConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEngineConfiguration(EngineConfigurationBookingReportAffiliate engineConfiguration) {
    this.engineConfiguration = engineConfiguration;
  }


  public BookingAffiliate bookingCode(String bookingCode) {
    
    this.bookingCode = bookingCode;
    return this;
  }

   /**
   * Unique user-friendly booking geoname. This code should be used when corresponding with travelers.
   * @return bookingCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBookingCode() {
    return bookingCode;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookingCode(String bookingCode) {
    this.bookingCode = bookingCode;
  }


  public BookingAffiliate user(BookingUserAffiliate user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserAffiliate getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(BookingUserAffiliate user) {
    this.user = user;
  }


  public BookingAffiliate userSession(UserSessionAffiliate userSession) {
    
    this.userSession = userSession;
    return this;
  }

   /**
   * Get userSession
   * @return userSession
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UserSessionAffiliate getUserSession() {
    return userSession;
  }


  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserSession(UserSessionAffiliate userSession) {
    this.userSession = userSession;
  }


  public BookingAffiliate serverUrl(String serverUrl) {
    
    this.serverUrl = serverUrl;
    return this;
  }

   /**
   * The URL the booking occurred
   * @return serverUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SERVER_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getServerUrl() {
    return serverUrl;
  }


  @JsonProperty(JSON_PROPERTY_SERVER_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setServerUrl(String serverUrl) {
    this.serverUrl = serverUrl;
  }


  public BookingAffiliate contactInfo(ContactAffiliate contactInfo) {
    
    this.contactInfo = contactInfo;
    return this;
  }

   /**
   * Get contactInfo
   * @return contactInfo
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ContactAffiliate getContactInfo() {
    return contactInfo;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContactInfo(ContactAffiliate contactInfo) {
    this.contactInfo = contactInfo;
  }


  public BookingAffiliate address(AddressAffiliate address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AddressAffiliate getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(AddressAffiliate address) {
    this.address = address;
  }


  public BookingAffiliate socials(List<SocialAffiliate> socials) {
    
    this.socials = socials;
    return this;
  }

  public BookingAffiliate addSocialsItem(SocialAffiliate socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * List of all social network account property has for the traveler to get in touch.
   * @return socials
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SocialAffiliate> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<SocialAffiliate> socials) {
    this.socials = socials;
  }


  public BookingAffiliate review(ReviewAffiliate review) {
    
    this.review = review;
    return this;
  }

   /**
   * Get review
   * @return review
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ReviewAffiliate getReview() {
    return review;
  }


  @JsonProperty(JSON_PROPERTY_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReview(ReviewAffiliate review) {
    this.review = review;
  }


  public BookingAffiliate emailHeaderLogoUrl(String emailHeaderLogoUrl) {
    
    this.emailHeaderLogoUrl = emailHeaderLogoUrl;
    return this;
  }

   /**
   * Full url of the image logo optimized for emails
   * @return emailHeaderLogoUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_EMAIL_HEADER_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmailHeaderLogoUrl() {
    return emailHeaderLogoUrl;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL_HEADER_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmailHeaderLogoUrl(String emailHeaderLogoUrl) {
    this.emailHeaderLogoUrl = emailHeaderLogoUrl;
  }


  public BookingAffiliate logoIdentifier(String logoIdentifier) {
    
    this.logoIdentifier = logoIdentifier;
    return this;
  }

   /**
   * Logo cloudinary identifier for potential reuse
   * @return logoIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOGO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLogoIdentifier() {
    return logoIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_LOGO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogoIdentifier(String logoIdentifier) {
    this.logoIdentifier = logoIdentifier;
  }


  public BookingAffiliate hotel(HotelOnMapAffiliate hotel) {
    
    this.hotel = hotel;
    return this;
  }

   /**
   * Get hotel
   * @return hotel
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public HotelOnMapAffiliate getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotel(HotelOnMapAffiliate hotel) {
    this.hotel = hotel;
  }


  public BookingAffiliate roomStay(RoomStayAffiliate roomStay) {
    
    this.roomStay = roomStay;
    return this;
  }

   /**
   * Get roomStay
   * @return roomStay
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_STAY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RoomStayAffiliate getRoomStay() {
    return roomStay;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_STAY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomStay(RoomStayAffiliate roomStay) {
    this.roomStay = roomStay;
  }


  public BookingAffiliate specialRequests(String specialRequests) {
    
    this.specialRequests = specialRequests;
    return this;
  }

   /**
   * Free text where the traveler can add a message to the property.
   * @return specialRequests
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSpecialRequests() {
    return specialRequests;
  }


  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpecialRequests(String specialRequests) {
    this.specialRequests = specialRequests;
  }


  public BookingAffiliate comment(String comment) {
    
    this.comment = comment;
    return this;
  }

   /**
   * Internal comment field the payment can add and make available to channel manager partners.
   * @return comment
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getComment() {
    return comment;
  }


  @JsonProperty(JSON_PROPERTY_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setComment(String comment) {
    this.comment = comment;
  }


  public BookingAffiliate earlyCheckInCharge(CustomMonetaryAmount earlyCheckInCharge) {
    
    this.earlyCheckInCharge = earlyCheckInCharge;
    return this;
  }

   /**
   * Get earlyCheckInCharge
   * @return earlyCheckInCharge
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getEarlyCheckInCharge() {
    return earlyCheckInCharge;
  }


  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEarlyCheckInCharge(CustomMonetaryAmount earlyCheckInCharge) {
    this.earlyCheckInCharge = earlyCheckInCharge;
  }


  public BookingAffiliate lateCheckOutCharge(CustomMonetaryAmount lateCheckOutCharge) {
    
    this.lateCheckOutCharge = lateCheckOutCharge;
    return this;
  }

   /**
   * Get lateCheckOutCharge
   * @return lateCheckOutCharge
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getLateCheckOutCharge() {
    return lateCheckOutCharge;
  }


  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLateCheckOutCharge(CustomMonetaryAmount lateCheckOutCharge) {
    this.lateCheckOutCharge = lateCheckOutCharge;
  }


  public BookingAffiliate earlyCheckInChargePercent(Float earlyCheckInChargePercent) {
    
    this.earlyCheckInChargePercent = earlyCheckInChargePercent;
    return this;
  }

   /**
   * Early check-in charge calculated in percent of first room night price.
   * @return earlyCheckInChargePercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getEarlyCheckInChargePercent() {
    return earlyCheckInChargePercent;
  }


  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEarlyCheckInChargePercent(Float earlyCheckInChargePercent) {
    this.earlyCheckInChargePercent = earlyCheckInChargePercent;
  }


  public BookingAffiliate lateCheckOutChargePercent(Float lateCheckOutChargePercent) {
    
    this.lateCheckOutChargePercent = lateCheckOutChargePercent;
    return this;
  }

   /**
   * Early check-in charge calculated in percent of first room night price.
   * @return lateCheckOutChargePercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLateCheckOutChargePercent() {
    return lateCheckOutChargePercent;
  }


  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLateCheckOutChargePercent(Float lateCheckOutChargePercent) {
    this.lateCheckOutChargePercent = lateCheckOutChargePercent;
  }


  public BookingAffiliate hotelImageUrl(String hotelImageUrl) {
    
    this.hotelImageUrl = hotelImageUrl;
    return this;
  }

   /**
   * Absolute URL of hotel image that can be used as-is
   * @return hotelImageUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_HOTEL_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHotelImageUrl() {
    return hotelImageUrl;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelImageUrl(String hotelImageUrl) {
    this.hotelImageUrl = hotelImageUrl;
  }


  public BookingAffiliate roomImageUrl(String roomImageUrl) {
    
    this.roomImageUrl = roomImageUrl;
    return this;
  }

   /**
   * Absolute URL of room image that can be used as-is
   * @return roomImageUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomImageUrl() {
    return roomImageUrl;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomImageUrl(String roomImageUrl) {
    this.roomImageUrl = roomImageUrl;
  }


  public BookingAffiliate commissionList(List<CommissionableEntryAffiliate> commissionList) {
    
    this.commissionList = commissionList;
    return this;
  }

  public BookingAffiliate addCommissionListItem(CommissionableEntryAffiliate commissionListItem) {
    if (this.commissionList == null) {
      this.commissionList = new ArrayList<>();
    }
    this.commissionList.add(commissionListItem);
    return this;
  }

   /**
   * List of all travel inventory entries that are due a commission to the affiliate.
   * @return commissionList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CommissionableEntryAffiliate> getCommissionList() {
    return commissionList;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionList(List<CommissionableEntryAffiliate> commissionList) {
    this.commissionList = commissionList;
  }


  public BookingAffiliate ancillaryList(List<BookingAncillaryAffiliate> ancillaryList) {
    
    this.ancillaryList = ancillaryList;
    return this;
  }

  public BookingAffiliate addAncillaryListItem(BookingAncillaryAffiliate ancillaryListItem) {
    if (this.ancillaryList == null) {
      this.ancillaryList = new ArrayList<>();
    }
    this.ancillaryList.add(ancillaryListItem);
    return this;
  }

   /**
   * Get ancillaryList
   * @return ancillaryList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ANCILLARY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillaryAffiliate> getAncillaryList() {
    return ancillaryList;
  }


  @JsonProperty(JSON_PROPERTY_ANCILLARY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAncillaryList(List<BookingAncillaryAffiliate> ancillaryList) {
    this.ancillaryList = ancillaryList;
  }


  public BookingAffiliate bookingContract(BookingContractAffiliate bookingContract) {
    
    this.bookingContract = bookingContract;
    return this;
  }

   /**
   * Get bookingContract
   * @return bookingContract
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingContractAffiliate getBookingContract() {
    return bookingContract;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookingContract(BookingContractAffiliate bookingContract) {
    this.bookingContract = bookingContract;
  }


  public BookingAffiliate status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Convenience data point to show which status the booking currently has.
   * @return status
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public BookingAffiliate hasBreakfast(Boolean hasBreakfast) {
    
    this.hasBreakfast = hasBreakfast;
    return this;
  }

   /**
   * Convenience data point to get to breakfast quickly.
   * @return hasBreakfast
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasBreakfast() {
    return hasBreakfast;
  }


  @JsonProperty(JSON_PROPERTY_HAS_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasBreakfast(Boolean hasBreakfast) {
    this.hasBreakfast = hasBreakfast;
  }


  public BookingAffiliate hasBrunch(Boolean hasBrunch) {
    
    this.hasBrunch = hasBrunch;
    return this;
  }

   /**
   * Convenience data point to get to brunch quickly.
   * @return hasBrunch
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasBrunch() {
    return hasBrunch;
  }


  @JsonProperty(JSON_PROPERTY_HAS_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasBrunch(Boolean hasBrunch) {
    this.hasBrunch = hasBrunch;
  }


  public BookingAffiliate hasLunch(Boolean hasLunch) {
    
    this.hasLunch = hasLunch;
    return this;
  }

   /**
   * Convenience data point to get to lunch quickly.
   * @return hasLunch
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_LUNCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasLunch() {
    return hasLunch;
  }


  @JsonProperty(JSON_PROPERTY_HAS_LUNCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasLunch(Boolean hasLunch) {
    this.hasLunch = hasLunch;
  }


  public BookingAffiliate hasDinner(Boolean hasDinner) {
    
    this.hasDinner = hasDinner;
    return this;
  }

   /**
   * Convenience data point to get to dinner quickly.
   * @return hasDinner
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_DINNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasDinner() {
    return hasDinner;
  }


  @JsonProperty(JSON_PROPERTY_HAS_DINNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasDinner(Boolean hasDinner) {
    this.hasDinner = hasDinner;
  }


  public BookingAffiliate hasAllInclusive(Boolean hasAllInclusive) {
    
    this.hasAllInclusive = hasAllInclusive;
    return this;
  }

   /**
   * Convenience data point to get to all-inclusive quickly.
   * @return hasAllInclusive
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ALL_INCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasAllInclusive() {
    return hasAllInclusive;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ALL_INCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasAllInclusive(Boolean hasAllInclusive) {
    this.hasAllInclusive = hasAllInclusive;
  }


  public BookingAffiliate hasAllInclusivePlusAlcohol(Boolean hasAllInclusivePlusAlcohol) {
    
    this.hasAllInclusivePlusAlcohol = hasAllInclusivePlusAlcohol;
    return this;
  }

   /**
   * Convenience data point to get to all-inclusive with alcohol quickly.
   * @return hasAllInclusivePlusAlcohol
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ALL_INCLUSIVE_PLUS_ALCOHOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasAllInclusivePlusAlcohol() {
    return hasAllInclusivePlusAlcohol;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ALL_INCLUSIVE_PLUS_ALCOHOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasAllInclusivePlusAlcohol(Boolean hasAllInclusivePlusAlcohol) {
    this.hasAllInclusivePlusAlcohol = hasAllInclusivePlusAlcohol;
  }


  public BookingAffiliate hasAddOns(Boolean hasAddOns) {
    
    this.hasAddOns = hasAddOns;
    return this;
  }

   /**
   * Convenience data point to check if any add-on offers are in this booking.
   * @return hasAddOns
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasAddOns() {
    return hasAddOns;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasAddOns(Boolean hasAddOns) {
    this.hasAddOns = hasAddOns;
  }


  public BookingAffiliate reportingExtraChargeList(List<ReportingExtraChargeAffiliate> reportingExtraChargeList) {
    
    this.reportingExtraChargeList = reportingExtraChargeList;
    return this;
  }

  public BookingAffiliate addReportingExtraChargeListItem(ReportingExtraChargeAffiliate reportingExtraChargeListItem) {
    if (this.reportingExtraChargeList == null) {
      this.reportingExtraChargeList = new ArrayList<>();
    }
    this.reportingExtraChargeList.add(reportingExtraChargeListItem);
    return this;
  }

   /**
   * Get reportingExtraChargeList
   * @return reportingExtraChargeList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REPORTING_EXTRA_CHARGE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ReportingExtraChargeAffiliate> getReportingExtraChargeList() {
    return reportingExtraChargeList;
  }


  @JsonProperty(JSON_PROPERTY_REPORTING_EXTRA_CHARGE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReportingExtraChargeList(List<ReportingExtraChargeAffiliate> reportingExtraChargeList) {
    this.reportingExtraChargeList = reportingExtraChargeList;
  }


  public BookingAffiliate fullAddress(String fullAddress) {
    
    this.fullAddress = fullAddress;
    return this;
  }

   /**
   * Convenience data point to return the full hotel address.
   * @return fullAddress
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FULL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullAddress() {
    return fullAddress;
  }


  @JsonProperty(JSON_PROPERTY_FULL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullAddress(String fullAddress) {
    this.fullAddress = fullAddress;
  }


  public BookingAffiliate rateSource(String rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

   /**
   * Rate origin. This is usually the property channel manager.
   * @return rateSource
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(String rateSource) {
    this.rateSource = rateSource;
  }


  public BookingAffiliate hasRoomTypeAncillaries(Boolean hasRoomTypeAncillaries) {
    
    this.hasRoomTypeAncillaries = hasRoomTypeAncillaries;
    return this;
  }

   /**
   * Convenience data point to check if any room type ancillaries are in this booking.
   * @return hasRoomTypeAncillaries
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasRoomTypeAncillaries() {
    return hasRoomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasRoomTypeAncillaries(Boolean hasRoomTypeAncillaries) {
    this.hasRoomTypeAncillaries = hasRoomTypeAncillaries;
  }


  public BookingAffiliate hasFood(Boolean hasFood) {
    
    this.hasFood = hasFood;
    return this;
  }

   /**
   * Convenience data point to check if any food is included in this booking.
   * @return hasFood
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_FOOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasFood() {
    return hasFood;
  }


  @JsonProperty(JSON_PROPERTY_HAS_FOOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasFood(Boolean hasFood) {
    this.hasFood = hasFood;
  }


  public BookingAffiliate hasRestaurants(Boolean hasRestaurants) {
    
    this.hasRestaurants = hasRestaurants;
    return this;
  }

   /**
   * Convenience data point to check if any restaurant reservations are included in this booking.
   * @return hasRestaurants
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasRestaurants() {
    return hasRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_HAS_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasRestaurants(Boolean hasRestaurants) {
    this.hasRestaurants = hasRestaurants;
  }


  public BookingAffiliate hasMeetingRooms(Boolean hasMeetingRooms) {
    
    this.hasMeetingRooms = hasMeetingRooms;
    return this;
  }

   /**
   * Convenience data point to check if any meeting room reservations are included in this booking.
   * @return hasMeetingRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasMeetingRooms() {
    return hasMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_HAS_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasMeetingRooms(Boolean hasMeetingRooms) {
    this.hasMeetingRooms = hasMeetingRooms;
  }


  public BookingAffiliate hasSpas(Boolean hasSpas) {
    
    this.hasSpas = hasSpas;
    return this;
  }

   /**
   * Convenience data point to check if any spa reservations are included in this booking.
   * @return hasSpas
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasSpas() {
    return hasSpas;
  }


  @JsonProperty(JSON_PROPERTY_HAS_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasSpas(Boolean hasSpas) {
    this.hasSpas = hasSpas;
  }


  public BookingAffiliate hasActivities(Boolean hasActivities) {
    
    this.hasActivities = hasActivities;
    return this;
  }

   /**
   * Convenience data point to check if any activity reservations are included in this booking.
   * @return hasActivities
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasActivities() {
    return hasActivities;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasActivities(Boolean hasActivities) {
    this.hasActivities = hasActivities;
  }


  public BookingAffiliate hasAttractions(Boolean hasAttractions) {
    
    this.hasAttractions = hasAttractions;
    return this;
  }

   /**
   * Convenience data point to check if any attractions reservations are included in this booking.
   * @return hasAttractions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasAttractions() {
    return hasAttractions;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasAttractions(Boolean hasAttractions) {
    this.hasAttractions = hasAttractions;
  }


  public BookingAffiliate hasPlaces(Boolean hasPlaces) {
    
    this.hasPlaces = hasPlaces;
    return this;
  }

   /**
   * Convenience data point to check if any place reservations are included in this booking.
   * @return hasPlaces
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPlaces() {
    return hasPlaces;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPlaces(Boolean hasPlaces) {
    this.hasPlaces = hasPlaces;
  }


  public BookingAffiliate reportingDailyRateList(List<ReportingDailyRateAffiliate> reportingDailyRateList) {
    
    this.reportingDailyRateList = reportingDailyRateList;
    return this;
  }

  public BookingAffiliate addReportingDailyRateListItem(ReportingDailyRateAffiliate reportingDailyRateListItem) {
    if (this.reportingDailyRateList == null) {
      this.reportingDailyRateList = new ArrayList<>();
    }
    this.reportingDailyRateList.add(reportingDailyRateListItem);
    return this;
  }

   /**
   * Get reportingDailyRateList
   * @return reportingDailyRateList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REPORTING_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ReportingDailyRateAffiliate> getReportingDailyRateList() {
    return reportingDailyRateList;
  }


  @JsonProperty(JSON_PROPERTY_REPORTING_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReportingDailyRateList(List<ReportingDailyRateAffiliate> reportingDailyRateList) {
    this.reportingDailyRateList = reportingDailyRateList;
  }


  public BookingAffiliate reportingAncillaryList(List<ReportingAncillaryAffiliate> reportingAncillaryList) {
    
    this.reportingAncillaryList = reportingAncillaryList;
    return this;
  }

  public BookingAffiliate addReportingAncillaryListItem(ReportingAncillaryAffiliate reportingAncillaryListItem) {
    if (this.reportingAncillaryList == null) {
      this.reportingAncillaryList = new ArrayList<>();
    }
    this.reportingAncillaryList.add(reportingAncillaryListItem);
    return this;
  }

   /**
   * Get reportingAncillaryList
   * @return reportingAncillaryList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REPORTING_ANCILLARY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ReportingAncillaryAffiliate> getReportingAncillaryList() {
    return reportingAncillaryList;
  }


  @JsonProperty(JSON_PROPERTY_REPORTING_ANCILLARY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReportingAncillaryList(List<ReportingAncillaryAffiliate> reportingAncillaryList) {
    this.reportingAncillaryList = reportingAncillaryList;
  }


  public BookingAffiliate meetingRooms(List<BookingAncillaryAffiliate> meetingRooms) {
    
    this.meetingRooms = meetingRooms;
    return this;
  }

  public BookingAffiliate addMeetingRoomsItem(BookingAncillaryAffiliate meetingRoomsItem) {
    if (this.meetingRooms == null) {
      this.meetingRooms = new ArrayList<>();
    }
    this.meetingRooms.add(meetingRoomsItem);
    return this;
  }

   /**
   * Meeting room reservation records.
   * @return meetingRooms
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillaryAffiliate> getMeetingRooms() {
    return meetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRooms(List<BookingAncillaryAffiliate> meetingRooms) {
    this.meetingRooms = meetingRooms;
  }


  public BookingAffiliate restaurants(List<BookingAncillaryAffiliate> restaurants) {
    
    this.restaurants = restaurants;
    return this;
  }

  public BookingAffiliate addRestaurantsItem(BookingAncillaryAffiliate restaurantsItem) {
    if (this.restaurants == null) {
      this.restaurants = new ArrayList<>();
    }
    this.restaurants.add(restaurantsItem);
    return this;
  }

   /**
   * Restaurant reservation records.
   * @return restaurants
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillaryAffiliate> getRestaurants() {
    return restaurants;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurants(List<BookingAncillaryAffiliate> restaurants) {
    this.restaurants = restaurants;
  }


  public BookingAffiliate spas(List<BookingAncillaryAffiliate> spas) {
    
    this.spas = spas;
    return this;
  }

  public BookingAffiliate addSpasItem(BookingAncillaryAffiliate spasItem) {
    if (this.spas == null) {
      this.spas = new ArrayList<>();
    }
    this.spas.add(spasItem);
    return this;
  }

   /**
   * Spa reservation records.
   * @return spas
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillaryAffiliate> getSpas() {
    return spas;
  }


  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpas(List<BookingAncillaryAffiliate> spas) {
    this.spas = spas;
  }


  public BookingAffiliate activities(List<BookingAncillaryAffiliate> activities) {
    
    this.activities = activities;
    return this;
  }

  public BookingAffiliate addActivitiesItem(BookingAncillaryAffiliate activitiesItem) {
    if (this.activities == null) {
      this.activities = new ArrayList<>();
    }
    this.activities.add(activitiesItem);
    return this;
  }

   /**
   * Activity reservation records.
   * @return activities
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillaryAffiliate> getActivities() {
    return activities;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActivities(List<BookingAncillaryAffiliate> activities) {
    this.activities = activities;
  }


  public BookingAffiliate attractions(List<BookingAncillaryAffiliate> attractions) {
    
    this.attractions = attractions;
    return this;
  }

  public BookingAffiliate addAttractionsItem(BookingAncillaryAffiliate attractionsItem) {
    if (this.attractions == null) {
      this.attractions = new ArrayList<>();
    }
    this.attractions.add(attractionsItem);
    return this;
  }

   /**
   * Attraction reservation records.
   * @return attractions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillaryAffiliate> getAttractions() {
    return attractions;
  }


  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttractions(List<BookingAncillaryAffiliate> attractions) {
    this.attractions = attractions;
  }


  public BookingAffiliate places(List<BookingAncillaryAffiliate> places) {
    
    this.places = places;
    return this;
  }

  public BookingAffiliate addPlacesItem(BookingAncillaryAffiliate placesItem) {
    if (this.places == null) {
      this.places = new ArrayList<>();
    }
    this.places.add(placesItem);
    return this;
  }

   /**
   * Place reservation records.
   * @return places
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillaryAffiliate> getPlaces() {
    return places;
  }


  @JsonProperty(JSON_PROPERTY_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlaces(List<BookingAncillaryAffiliate> places) {
    this.places = places;
  }


  public BookingAffiliate roomTypeAncillaries(List<BookingAncillaryAffiliate> roomTypeAncillaries) {
    
    this.roomTypeAncillaries = roomTypeAncillaries;
    return this;
  }

  public BookingAffiliate addRoomTypeAncillariesItem(BookingAncillaryAffiliate roomTypeAncillariesItem) {
    if (this.roomTypeAncillaries == null) {
      this.roomTypeAncillaries = new ArrayList<>();
    }
    this.roomTypeAncillaries.add(roomTypeAncillariesItem);
    return this;
  }

   /**
   * Room type ancillary records.
   * @return roomTypeAncillaries
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillaryAffiliate> getRoomTypeAncillaries() {
    return roomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomTypeAncillaries(List<BookingAncillaryAffiliate> roomTypeAncillaries) {
    this.roomTypeAncillaries = roomTypeAncillaries;
  }


  public BookingAffiliate addOns(List<BookingAncillaryAffiliate> addOns) {
    
    this.addOns = addOns;
    return this;
  }

  public BookingAffiliate addAddOnsItem(BookingAncillaryAffiliate addOnsItem) {
    if (this.addOns == null) {
      this.addOns = new ArrayList<>();
    }
    this.addOns.add(addOnsItem);
    return this;
  }

   /**
   * Add-on records.
   * @return addOns
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillaryAffiliate> getAddOns() {
    return addOns;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOns(List<BookingAncillaryAffiliate> addOns) {
    this.addOns = addOns;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingAffiliate bookingAffiliate = (BookingAffiliate) o;
    return Objects.equals(this.test, bookingAffiliate.test) &&
        Objects.equals(this.date, bookingAffiliate.date) &&
        Objects.equals(this.groupIdentifier, bookingAffiliate.groupIdentifier) &&
        Objects.equals(this.identifier, bookingAffiliate.identifier) &&
        Objects.equals(this.engineConfiguration, bookingAffiliate.engineConfiguration) &&
        Objects.equals(this.bookingCode, bookingAffiliate.bookingCode) &&
        Objects.equals(this.user, bookingAffiliate.user) &&
        Objects.equals(this.userSession, bookingAffiliate.userSession) &&
        Objects.equals(this.serverUrl, bookingAffiliate.serverUrl) &&
        Objects.equals(this.contactInfo, bookingAffiliate.contactInfo) &&
        Objects.equals(this.address, bookingAffiliate.address) &&
        Objects.equals(this.socials, bookingAffiliate.socials) &&
        Objects.equals(this.review, bookingAffiliate.review) &&
        Objects.equals(this.emailHeaderLogoUrl, bookingAffiliate.emailHeaderLogoUrl) &&
        Objects.equals(this.logoIdentifier, bookingAffiliate.logoIdentifier) &&
        Objects.equals(this.hotel, bookingAffiliate.hotel) &&
        Objects.equals(this.roomStay, bookingAffiliate.roomStay) &&
        Objects.equals(this.specialRequests, bookingAffiliate.specialRequests) &&
        Objects.equals(this.comment, bookingAffiliate.comment) &&
        Objects.equals(this.earlyCheckInCharge, bookingAffiliate.earlyCheckInCharge) &&
        Objects.equals(this.lateCheckOutCharge, bookingAffiliate.lateCheckOutCharge) &&
        Objects.equals(this.earlyCheckInChargePercent, bookingAffiliate.earlyCheckInChargePercent) &&
        Objects.equals(this.lateCheckOutChargePercent, bookingAffiliate.lateCheckOutChargePercent) &&
        Objects.equals(this.hotelImageUrl, bookingAffiliate.hotelImageUrl) &&
        Objects.equals(this.roomImageUrl, bookingAffiliate.roomImageUrl) &&
        Objects.equals(this.commissionList, bookingAffiliate.commissionList) &&
        Objects.equals(this.ancillaryList, bookingAffiliate.ancillaryList) &&
        Objects.equals(this.bookingContract, bookingAffiliate.bookingContract) &&
        Objects.equals(this.status, bookingAffiliate.status) &&
        Objects.equals(this.hasBreakfast, bookingAffiliate.hasBreakfast) &&
        Objects.equals(this.hasBrunch, bookingAffiliate.hasBrunch) &&
        Objects.equals(this.hasLunch, bookingAffiliate.hasLunch) &&
        Objects.equals(this.hasDinner, bookingAffiliate.hasDinner) &&
        Objects.equals(this.hasAllInclusive, bookingAffiliate.hasAllInclusive) &&
        Objects.equals(this.hasAllInclusivePlusAlcohol, bookingAffiliate.hasAllInclusivePlusAlcohol) &&
        Objects.equals(this.hasAddOns, bookingAffiliate.hasAddOns) &&
        Objects.equals(this.reportingExtraChargeList, bookingAffiliate.reportingExtraChargeList) &&
        Objects.equals(this.fullAddress, bookingAffiliate.fullAddress) &&
        Objects.equals(this.rateSource, bookingAffiliate.rateSource) &&
        Objects.equals(this.hasRoomTypeAncillaries, bookingAffiliate.hasRoomTypeAncillaries) &&
        Objects.equals(this.hasFood, bookingAffiliate.hasFood) &&
        Objects.equals(this.hasRestaurants, bookingAffiliate.hasRestaurants) &&
        Objects.equals(this.hasMeetingRooms, bookingAffiliate.hasMeetingRooms) &&
        Objects.equals(this.hasSpas, bookingAffiliate.hasSpas) &&
        Objects.equals(this.hasActivities, bookingAffiliate.hasActivities) &&
        Objects.equals(this.hasAttractions, bookingAffiliate.hasAttractions) &&
        Objects.equals(this.hasPlaces, bookingAffiliate.hasPlaces) &&
        Objects.equals(this.reportingDailyRateList, bookingAffiliate.reportingDailyRateList) &&
        Objects.equals(this.reportingAncillaryList, bookingAffiliate.reportingAncillaryList) &&
        Objects.equals(this.meetingRooms, bookingAffiliate.meetingRooms) &&
        Objects.equals(this.restaurants, bookingAffiliate.restaurants) &&
        Objects.equals(this.spas, bookingAffiliate.spas) &&
        Objects.equals(this.activities, bookingAffiliate.activities) &&
        Objects.equals(this.attractions, bookingAffiliate.attractions) &&
        Objects.equals(this.places, bookingAffiliate.places) &&
        Objects.equals(this.roomTypeAncillaries, bookingAffiliate.roomTypeAncillaries) &&
        Objects.equals(this.addOns, bookingAffiliate.addOns);
  }

  @Override
  public int hashCode() {
    return Objects.hash(test, date, groupIdentifier, identifier, engineConfiguration, bookingCode, user, userSession, serverUrl, contactInfo, address, socials, review, emailHeaderLogoUrl, logoIdentifier, hotel, roomStay, specialRequests, comment, earlyCheckInCharge, lateCheckOutCharge, earlyCheckInChargePercent, lateCheckOutChargePercent, hotelImageUrl, roomImageUrl, commissionList, ancillaryList, bookingContract, status, hasBreakfast, hasBrunch, hasLunch, hasDinner, hasAllInclusive, hasAllInclusivePlusAlcohol, hasAddOns, reportingExtraChargeList, fullAddress, rateSource, hasRoomTypeAncillaries, hasFood, hasRestaurants, hasMeetingRooms, hasSpas, hasActivities, hasAttractions, hasPlaces, reportingDailyRateList, reportingAncillaryList, meetingRooms, restaurants, spas, activities, attractions, places, roomTypeAncillaries, addOns);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingAffiliate {\n");
    sb.append("    test: ").append(toIndentedString(test)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    groupIdentifier: ").append(toIndentedString(groupIdentifier)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    engineConfiguration: ").append(toIndentedString(engineConfiguration)).append("\n");
    sb.append("    bookingCode: ").append(toIndentedString(bookingCode)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    userSession: ").append(toIndentedString(userSession)).append("\n");
    sb.append("    serverUrl: ").append(toIndentedString(serverUrl)).append("\n");
    sb.append("    contactInfo: ").append(toIndentedString(contactInfo)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    review: ").append(toIndentedString(review)).append("\n");
    sb.append("    emailHeaderLogoUrl: ").append(toIndentedString(emailHeaderLogoUrl)).append("\n");
    sb.append("    logoIdentifier: ").append(toIndentedString(logoIdentifier)).append("\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("    roomStay: ").append(toIndentedString(roomStay)).append("\n");
    sb.append("    specialRequests: ").append(toIndentedString(specialRequests)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    earlyCheckInCharge: ").append(toIndentedString(earlyCheckInCharge)).append("\n");
    sb.append("    lateCheckOutCharge: ").append(toIndentedString(lateCheckOutCharge)).append("\n");
    sb.append("    earlyCheckInChargePercent: ").append(toIndentedString(earlyCheckInChargePercent)).append("\n");
    sb.append("    lateCheckOutChargePercent: ").append(toIndentedString(lateCheckOutChargePercent)).append("\n");
    sb.append("    hotelImageUrl: ").append(toIndentedString(hotelImageUrl)).append("\n");
    sb.append("    roomImageUrl: ").append(toIndentedString(roomImageUrl)).append("\n");
    sb.append("    commissionList: ").append(toIndentedString(commissionList)).append("\n");
    sb.append("    ancillaryList: ").append(toIndentedString(ancillaryList)).append("\n");
    sb.append("    bookingContract: ").append(toIndentedString(bookingContract)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    hasBreakfast: ").append(toIndentedString(hasBreakfast)).append("\n");
    sb.append("    hasBrunch: ").append(toIndentedString(hasBrunch)).append("\n");
    sb.append("    hasLunch: ").append(toIndentedString(hasLunch)).append("\n");
    sb.append("    hasDinner: ").append(toIndentedString(hasDinner)).append("\n");
    sb.append("    hasAllInclusive: ").append(toIndentedString(hasAllInclusive)).append("\n");
    sb.append("    hasAllInclusivePlusAlcohol: ").append(toIndentedString(hasAllInclusivePlusAlcohol)).append("\n");
    sb.append("    hasAddOns: ").append(toIndentedString(hasAddOns)).append("\n");
    sb.append("    reportingExtraChargeList: ").append(toIndentedString(reportingExtraChargeList)).append("\n");
    sb.append("    fullAddress: ").append(toIndentedString(fullAddress)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("    hasRoomTypeAncillaries: ").append(toIndentedString(hasRoomTypeAncillaries)).append("\n");
    sb.append("    hasFood: ").append(toIndentedString(hasFood)).append("\n");
    sb.append("    hasRestaurants: ").append(toIndentedString(hasRestaurants)).append("\n");
    sb.append("    hasMeetingRooms: ").append(toIndentedString(hasMeetingRooms)).append("\n");
    sb.append("    hasSpas: ").append(toIndentedString(hasSpas)).append("\n");
    sb.append("    hasActivities: ").append(toIndentedString(hasActivities)).append("\n");
    sb.append("    hasAttractions: ").append(toIndentedString(hasAttractions)).append("\n");
    sb.append("    hasPlaces: ").append(toIndentedString(hasPlaces)).append("\n");
    sb.append("    reportingDailyRateList: ").append(toIndentedString(reportingDailyRateList)).append("\n");
    sb.append("    reportingAncillaryList: ").append(toIndentedString(reportingAncillaryList)).append("\n");
    sb.append("    meetingRooms: ").append(toIndentedString(meetingRooms)).append("\n");
    sb.append("    restaurants: ").append(toIndentedString(restaurants)).append("\n");
    sb.append("    spas: ").append(toIndentedString(spas)).append("\n");
    sb.append("    activities: ").append(toIndentedString(activities)).append("\n");
    sb.append("    attractions: ").append(toIndentedString(attractions)).append("\n");
    sb.append("    places: ").append(toIndentedString(places)).append("\n");
    sb.append("    roomTypeAncillaries: ").append(toIndentedString(roomTypeAncillaries)).append("\n");
    sb.append("    addOns: ").append(toIndentedString(addOns)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

