/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 25.6.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import travel.wink.sdk.affiliate.model.AddressAffiliate;
import travel.wink.sdk.affiliate.model.CustomerTaxIdAffiliate;
import travel.wink.sdk.affiliate.model.DiscountAffiliate;
import travel.wink.sdk.affiliate.model.InvoiceLineItemCollectionAffiliate;
import travel.wink.sdk.affiliate.model.ShippingDetailsAffiliate;
import travel.wink.sdk.affiliate.model.StatusTransitionsAffiliate;
import travel.wink.sdk.affiliate.model.TaxRateAffiliate;
import travel.wink.sdk.affiliate.model.ThresholdReasonAffiliate;
import travel.wink.sdk.affiliate.model.TotalTaxAmountAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * InvoiceAffiliate
 */
@JsonPropertyOrder({
  InvoiceAffiliate.JSON_PROPERTY_ACCOUNT_COUNTRY,
  InvoiceAffiliate.JSON_PROPERTY_ACCOUNT_NAME,
  InvoiceAffiliate.JSON_PROPERTY_AMOUNT_DUE,
  InvoiceAffiliate.JSON_PROPERTY_AMOUNT_PAID,
  InvoiceAffiliate.JSON_PROPERTY_AMOUNT_REMAINING,
  InvoiceAffiliate.JSON_PROPERTY_APPLICATION_FEE_AMOUNT,
  InvoiceAffiliate.JSON_PROPERTY_ATTEMPT_COUNT,
  InvoiceAffiliate.JSON_PROPERTY_ATTEMPTED,
  InvoiceAffiliate.JSON_PROPERTY_AUTO_ADVANCE,
  InvoiceAffiliate.JSON_PROPERTY_BILLING,
  InvoiceAffiliate.JSON_PROPERTY_BILLING_REASON,
  InvoiceAffiliate.JSON_PROPERTY_COLLECTION_METHOD,
  InvoiceAffiliate.JSON_PROPERTY_CREATED,
  InvoiceAffiliate.JSON_PROPERTY_CURRENCY,
  InvoiceAffiliate.JSON_PROPERTY_CUSTOMER_ADDRESS,
  InvoiceAffiliate.JSON_PROPERTY_CUSTOMER_EMAIL,
  InvoiceAffiliate.JSON_PROPERTY_CUSTOMER_NAME,
  InvoiceAffiliate.JSON_PROPERTY_CUSTOMER_PHONE,
  InvoiceAffiliate.JSON_PROPERTY_CUSTOMER_SHIPPING,
  InvoiceAffiliate.JSON_PROPERTY_CUSTOMER_TAX_EXEMPT,
  InvoiceAffiliate.JSON_PROPERTY_CUSTOMER_TAX_IDS,
  InvoiceAffiliate.JSON_PROPERTY_DEFAULT_TAX_RATES,
  InvoiceAffiliate.JSON_PROPERTY_DELETED,
  InvoiceAffiliate.JSON_PROPERTY_DESCRIPTION,
  InvoiceAffiliate.JSON_PROPERTY_DISCOUNT,
  InvoiceAffiliate.JSON_PROPERTY_DUE_DATE,
  InvoiceAffiliate.JSON_PROPERTY_ENDING_BALANCE,
  InvoiceAffiliate.JSON_PROPERTY_FOOTER,
  InvoiceAffiliate.JSON_PROPERTY_HOSTED_INVOICE_URL,
  InvoiceAffiliate.JSON_PROPERTY_ID,
  InvoiceAffiliate.JSON_PROPERTY_INVOICE_PDF,
  InvoiceAffiliate.JSON_PROPERTY_LINES,
  InvoiceAffiliate.JSON_PROPERTY_LIVEMODE,
  InvoiceAffiliate.JSON_PROPERTY_METADATA,
  InvoiceAffiliate.JSON_PROPERTY_NEXT_PAYMENT_ATTEMPT,
  InvoiceAffiliate.JSON_PROPERTY_NUMBER,
  InvoiceAffiliate.JSON_PROPERTY_OBJECT,
  InvoiceAffiliate.JSON_PROPERTY_PAID,
  InvoiceAffiliate.JSON_PROPERTY_PERIOD_END,
  InvoiceAffiliate.JSON_PROPERTY_PERIOD_START,
  InvoiceAffiliate.JSON_PROPERTY_POST_PAYMENT_CREDIT_NOTES_AMOUNT,
  InvoiceAffiliate.JSON_PROPERTY_PRE_PAYMENT_CREDIT_NOTES_AMOUNT,
  InvoiceAffiliate.JSON_PROPERTY_RECEIPT_NUMBER,
  InvoiceAffiliate.JSON_PROPERTY_STARTING_BALANCE,
  InvoiceAffiliate.JSON_PROPERTY_STATEMENT_DESCRIPTOR,
  InvoiceAffiliate.JSON_PROPERTY_STATUS,
  InvoiceAffiliate.JSON_PROPERTY_STATUS_TRANSITIONS,
  InvoiceAffiliate.JSON_PROPERTY_SUBSCRIPTION_PRORATION_DATE,
  InvoiceAffiliate.JSON_PROPERTY_SUBTOTAL,
  InvoiceAffiliate.JSON_PROPERTY_TAX,
  InvoiceAffiliate.JSON_PROPERTY_THRESHOLD_REASON,
  InvoiceAffiliate.JSON_PROPERTY_TOTAL,
  InvoiceAffiliate.JSON_PROPERTY_TOTAL_TAX_AMOUNTS,
  InvoiceAffiliate.JSON_PROPERTY_TRANSFER_DATA,
  InvoiceAffiliate.JSON_PROPERTY_WEBHOOKS_DELIVERED_AT
})
@JsonTypeName("Invoice_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-06-06T15:45:36.063243408+07:00[Asia/Bangkok]")
public class InvoiceAffiliate {
  public static final String JSON_PROPERTY_ACCOUNT_COUNTRY = "accountCountry";
  private String accountCountry;

  public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
  private String accountName;

  public static final String JSON_PROPERTY_AMOUNT_DUE = "amountDue";
  private Long amountDue;

  public static final String JSON_PROPERTY_AMOUNT_PAID = "amountPaid";
  private Long amountPaid;

  public static final String JSON_PROPERTY_AMOUNT_REMAINING = "amountRemaining";
  private Long amountRemaining;

  public static final String JSON_PROPERTY_APPLICATION_FEE_AMOUNT = "applicationFeeAmount";
  private Long applicationFeeAmount;

  public static final String JSON_PROPERTY_ATTEMPT_COUNT = "attemptCount";
  private Long attemptCount;

  public static final String JSON_PROPERTY_ATTEMPTED = "attempted";
  private Boolean attempted;

  public static final String JSON_PROPERTY_AUTO_ADVANCE = "autoAdvance";
  private Boolean autoAdvance;

  public static final String JSON_PROPERTY_BILLING = "billing";
  private String billing;

  public static final String JSON_PROPERTY_BILLING_REASON = "billingReason";
  private String billingReason;

  public static final String JSON_PROPERTY_COLLECTION_METHOD = "collectionMethod";
  private String collectionMethod;

  public static final String JSON_PROPERTY_CREATED = "created";
  private Long created;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_CUSTOMER_ADDRESS = "customerAddress";
  private AddressAffiliate customerAddress;

  public static final String JSON_PROPERTY_CUSTOMER_EMAIL = "customerEmail";
  private String customerEmail;

  public static final String JSON_PROPERTY_CUSTOMER_NAME = "customerName";
  private String customerName;

  public static final String JSON_PROPERTY_CUSTOMER_PHONE = "customerPhone";
  private String customerPhone;

  public static final String JSON_PROPERTY_CUSTOMER_SHIPPING = "customerShipping";
  private ShippingDetailsAffiliate customerShipping;

  public static final String JSON_PROPERTY_CUSTOMER_TAX_EXEMPT = "customerTaxExempt";
  private String customerTaxExempt;

  public static final String JSON_PROPERTY_CUSTOMER_TAX_IDS = "customerTaxIds";
  private List<CustomerTaxIdAffiliate> customerTaxIds = new ArrayList<>();

  public static final String JSON_PROPERTY_DEFAULT_TAX_RATES = "defaultTaxRates";
  private List<TaxRateAffiliate> defaultTaxRates = new ArrayList<>();

  public static final String JSON_PROPERTY_DELETED = "deleted";
  private Boolean deleted;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISCOUNT = "discount";
  private DiscountAffiliate discount;

  public static final String JSON_PROPERTY_DUE_DATE = "dueDate";
  private Long dueDate;

  public static final String JSON_PROPERTY_ENDING_BALANCE = "endingBalance";
  private Long endingBalance;

  public static final String JSON_PROPERTY_FOOTER = "footer";
  private String footer;

  public static final String JSON_PROPERTY_HOSTED_INVOICE_URL = "hostedInvoiceUrl";
  private String hostedInvoiceUrl;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_INVOICE_PDF = "invoicePdf";
  private String invoicePdf;

  public static final String JSON_PROPERTY_LINES = "lines";
  private InvoiceLineItemCollectionAffiliate lines;

  public static final String JSON_PROPERTY_LIVEMODE = "livemode";
  private Boolean livemode;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = new HashMap<>();

  public static final String JSON_PROPERTY_NEXT_PAYMENT_ATTEMPT = "nextPaymentAttempt";
  private Long nextPaymentAttempt;

  public static final String JSON_PROPERTY_NUMBER = "number";
  private String number;

  public static final String JSON_PROPERTY_OBJECT = "object";
  private String _object;

  public static final String JSON_PROPERTY_PAID = "paid";
  private Boolean paid;

  public static final String JSON_PROPERTY_PERIOD_END = "periodEnd";
  private Long periodEnd;

  public static final String JSON_PROPERTY_PERIOD_START = "periodStart";
  private Long periodStart;

  public static final String JSON_PROPERTY_POST_PAYMENT_CREDIT_NOTES_AMOUNT = "postPaymentCreditNotesAmount";
  private Long postPaymentCreditNotesAmount;

  public static final String JSON_PROPERTY_PRE_PAYMENT_CREDIT_NOTES_AMOUNT = "prePaymentCreditNotesAmount";
  private Long prePaymentCreditNotesAmount;

  public static final String JSON_PROPERTY_RECEIPT_NUMBER = "receiptNumber";
  private String receiptNumber;

  public static final String JSON_PROPERTY_STARTING_BALANCE = "startingBalance";
  private Long startingBalance;

  public static final String JSON_PROPERTY_STATEMENT_DESCRIPTOR = "statementDescriptor";
  private String statementDescriptor;

  public static final String JSON_PROPERTY_STATUS = "status";
  private String status;

  public static final String JSON_PROPERTY_STATUS_TRANSITIONS = "statusTransitions";
  private StatusTransitionsAffiliate statusTransitions;

  public static final String JSON_PROPERTY_SUBSCRIPTION_PRORATION_DATE = "subscriptionProrationDate";
  private Long subscriptionProrationDate;

  public static final String JSON_PROPERTY_SUBTOTAL = "subtotal";
  private Long subtotal;

  public static final String JSON_PROPERTY_TAX = "tax";
  private Long tax;

  public static final String JSON_PROPERTY_THRESHOLD_REASON = "thresholdReason";
  private ThresholdReasonAffiliate thresholdReason;

  public static final String JSON_PROPERTY_TOTAL = "total";
  private Long total;

  public static final String JSON_PROPERTY_TOTAL_TAX_AMOUNTS = "totalTaxAmounts";
  private List<TotalTaxAmountAffiliate> totalTaxAmounts = new ArrayList<>();

  public static final String JSON_PROPERTY_TRANSFER_DATA = "transferData";
  private Object transferData;

  public static final String JSON_PROPERTY_WEBHOOKS_DELIVERED_AT = "webhooksDeliveredAt";
  private Long webhooksDeliveredAt;

  public InvoiceAffiliate() {
  }

  public InvoiceAffiliate accountCountry(String accountCountry) {
    
    this.accountCountry = accountCountry;
    return this;
  }

   /**
   * Get accountCountry
   * @return accountCountry
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACCOUNT_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountCountry() {
    return accountCountry;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountCountry(String accountCountry) {
    this.accountCountry = accountCountry;
  }


  public InvoiceAffiliate accountName(String accountName) {
    
    this.accountName = accountName;
    return this;
  }

   /**
   * Get accountName
   * @return accountName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountName() {
    return accountName;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountName(String accountName) {
    this.accountName = accountName;
  }


  public InvoiceAffiliate amountDue(Long amountDue) {
    
    this.amountDue = amountDue;
    return this;
  }

   /**
   * Get amountDue
   * @return amountDue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAmountDue() {
    return amountDue;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmountDue(Long amountDue) {
    this.amountDue = amountDue;
  }


  public InvoiceAffiliate amountPaid(Long amountPaid) {
    
    this.amountPaid = amountPaid;
    return this;
  }

   /**
   * Get amountPaid
   * @return amountPaid
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMOUNT_PAID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAmountPaid() {
    return amountPaid;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_PAID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmountPaid(Long amountPaid) {
    this.amountPaid = amountPaid;
  }


  public InvoiceAffiliate amountRemaining(Long amountRemaining) {
    
    this.amountRemaining = amountRemaining;
    return this;
  }

   /**
   * Get amountRemaining
   * @return amountRemaining
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMOUNT_REMAINING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAmountRemaining() {
    return amountRemaining;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_REMAINING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmountRemaining(Long amountRemaining) {
    this.amountRemaining = amountRemaining;
  }


  public InvoiceAffiliate applicationFeeAmount(Long applicationFeeAmount) {
    
    this.applicationFeeAmount = applicationFeeAmount;
    return this;
  }

   /**
   * Get applicationFeeAmount
   * @return applicationFeeAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_APPLICATION_FEE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getApplicationFeeAmount() {
    return applicationFeeAmount;
  }


  @JsonProperty(JSON_PROPERTY_APPLICATION_FEE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicationFeeAmount(Long applicationFeeAmount) {
    this.applicationFeeAmount = applicationFeeAmount;
  }


  public InvoiceAffiliate attemptCount(Long attemptCount) {
    
    this.attemptCount = attemptCount;
    return this;
  }

   /**
   * Get attemptCount
   * @return attemptCount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ATTEMPT_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAttemptCount() {
    return attemptCount;
  }


  @JsonProperty(JSON_PROPERTY_ATTEMPT_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttemptCount(Long attemptCount) {
    this.attemptCount = attemptCount;
  }


  public InvoiceAffiliate attempted(Boolean attempted) {
    
    this.attempted = attempted;
    return this;
  }

   /**
   * Get attempted
   * @return attempted
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ATTEMPTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAttempted() {
    return attempted;
  }


  @JsonProperty(JSON_PROPERTY_ATTEMPTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttempted(Boolean attempted) {
    this.attempted = attempted;
  }


  public InvoiceAffiliate autoAdvance(Boolean autoAdvance) {
    
    this.autoAdvance = autoAdvance;
    return this;
  }

   /**
   * Get autoAdvance
   * @return autoAdvance
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AUTO_ADVANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAutoAdvance() {
    return autoAdvance;
  }


  @JsonProperty(JSON_PROPERTY_AUTO_ADVANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAutoAdvance(Boolean autoAdvance) {
    this.autoAdvance = autoAdvance;
  }


  public InvoiceAffiliate billing(String billing) {
    
    this.billing = billing;
    return this;
  }

   /**
   * Get billing
   * @return billing
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BILLING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBilling() {
    return billing;
  }


  @JsonProperty(JSON_PROPERTY_BILLING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBilling(String billing) {
    this.billing = billing;
  }


  public InvoiceAffiliate billingReason(String billingReason) {
    
    this.billingReason = billingReason;
    return this;
  }

   /**
   * Get billingReason
   * @return billingReason
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BILLING_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBillingReason() {
    return billingReason;
  }


  @JsonProperty(JSON_PROPERTY_BILLING_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingReason(String billingReason) {
    this.billingReason = billingReason;
  }


  public InvoiceAffiliate collectionMethod(String collectionMethod) {
    
    this.collectionMethod = collectionMethod;
    return this;
  }

   /**
   * Get collectionMethod
   * @return collectionMethod
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COLLECTION_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCollectionMethod() {
    return collectionMethod;
  }


  @JsonProperty(JSON_PROPERTY_COLLECTION_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCollectionMethod(String collectionMethod) {
    this.collectionMethod = collectionMethod;
  }


  public InvoiceAffiliate created(Long created) {
    
    this.created = created;
    return this;
  }

   /**
   * Get created
   * @return created
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreated(Long created) {
    this.created = created;
  }


  public InvoiceAffiliate currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public InvoiceAffiliate customerAddress(AddressAffiliate customerAddress) {
    
    this.customerAddress = customerAddress;
    return this;
  }

   /**
   * Get customerAddress
   * @return customerAddress
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CUSTOMER_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AddressAffiliate getCustomerAddress() {
    return customerAddress;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerAddress(AddressAffiliate customerAddress) {
    this.customerAddress = customerAddress;
  }


  public InvoiceAffiliate customerEmail(String customerEmail) {
    
    this.customerEmail = customerEmail;
    return this;
  }

   /**
   * Get customerEmail
   * @return customerEmail
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CUSTOMER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerEmail() {
    return customerEmail;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerEmail(String customerEmail) {
    this.customerEmail = customerEmail;
  }


  public InvoiceAffiliate customerName(String customerName) {
    
    this.customerName = customerName;
    return this;
  }

   /**
   * Get customerName
   * @return customerName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CUSTOMER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerName() {
    return customerName;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }


  public InvoiceAffiliate customerPhone(String customerPhone) {
    
    this.customerPhone = customerPhone;
    return this;
  }

   /**
   * Get customerPhone
   * @return customerPhone
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CUSTOMER_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerPhone() {
    return customerPhone;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerPhone(String customerPhone) {
    this.customerPhone = customerPhone;
  }


  public InvoiceAffiliate customerShipping(ShippingDetailsAffiliate customerShipping) {
    
    this.customerShipping = customerShipping;
    return this;
  }

   /**
   * Get customerShipping
   * @return customerShipping
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CUSTOMER_SHIPPING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ShippingDetailsAffiliate getCustomerShipping() {
    return customerShipping;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_SHIPPING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerShipping(ShippingDetailsAffiliate customerShipping) {
    this.customerShipping = customerShipping;
  }


  public InvoiceAffiliate customerTaxExempt(String customerTaxExempt) {
    
    this.customerTaxExempt = customerTaxExempt;
    return this;
  }

   /**
   * Get customerTaxExempt
   * @return customerTaxExempt
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CUSTOMER_TAX_EXEMPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerTaxExempt() {
    return customerTaxExempt;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_TAX_EXEMPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerTaxExempt(String customerTaxExempt) {
    this.customerTaxExempt = customerTaxExempt;
  }


  public InvoiceAffiliate customerTaxIds(List<CustomerTaxIdAffiliate> customerTaxIds) {
    
    this.customerTaxIds = customerTaxIds;
    return this;
  }

  public InvoiceAffiliate addCustomerTaxIdsItem(CustomerTaxIdAffiliate customerTaxIdsItem) {
    if (this.customerTaxIds == null) {
      this.customerTaxIds = new ArrayList<>();
    }
    this.customerTaxIds.add(customerTaxIdsItem);
    return this;
  }

   /**
   * Get customerTaxIds
   * @return customerTaxIds
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CUSTOMER_TAX_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CustomerTaxIdAffiliate> getCustomerTaxIds() {
    return customerTaxIds;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_TAX_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerTaxIds(List<CustomerTaxIdAffiliate> customerTaxIds) {
    this.customerTaxIds = customerTaxIds;
  }


  public InvoiceAffiliate defaultTaxRates(List<TaxRateAffiliate> defaultTaxRates) {
    
    this.defaultTaxRates = defaultTaxRates;
    return this;
  }

  public InvoiceAffiliate addDefaultTaxRatesItem(TaxRateAffiliate defaultTaxRatesItem) {
    if (this.defaultTaxRates == null) {
      this.defaultTaxRates = new ArrayList<>();
    }
    this.defaultTaxRates.add(defaultTaxRatesItem);
    return this;
  }

   /**
   * Get defaultTaxRates
   * @return defaultTaxRates
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DEFAULT_TAX_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TaxRateAffiliate> getDefaultTaxRates() {
    return defaultTaxRates;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_TAX_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultTaxRates(List<TaxRateAffiliate> defaultTaxRates) {
    this.defaultTaxRates = defaultTaxRates;
  }


  public InvoiceAffiliate deleted(Boolean deleted) {
    
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeleted() {
    return deleted;
  }


  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }


  public InvoiceAffiliate description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public InvoiceAffiliate discount(DiscountAffiliate discount) {
    
    this.discount = discount;
    return this;
  }

   /**
   * Get discount
   * @return discount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DiscountAffiliate getDiscount() {
    return discount;
  }


  @JsonProperty(JSON_PROPERTY_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiscount(DiscountAffiliate discount) {
    this.discount = discount;
  }


  public InvoiceAffiliate dueDate(Long dueDate) {
    
    this.dueDate = dueDate;
    return this;
  }

   /**
   * Get dueDate
   * @return dueDate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDueDate() {
    return dueDate;
  }


  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDueDate(Long dueDate) {
    this.dueDate = dueDate;
  }


  public InvoiceAffiliate endingBalance(Long endingBalance) {
    
    this.endingBalance = endingBalance;
    return this;
  }

   /**
   * Get endingBalance
   * @return endingBalance
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ENDING_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getEndingBalance() {
    return endingBalance;
  }


  @JsonProperty(JSON_PROPERTY_ENDING_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndingBalance(Long endingBalance) {
    this.endingBalance = endingBalance;
  }


  public InvoiceAffiliate footer(String footer) {
    
    this.footer = footer;
    return this;
  }

   /**
   * Get footer
   * @return footer
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FOOTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFooter() {
    return footer;
  }


  @JsonProperty(JSON_PROPERTY_FOOTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFooter(String footer) {
    this.footer = footer;
  }


  public InvoiceAffiliate hostedInvoiceUrl(String hostedInvoiceUrl) {
    
    this.hostedInvoiceUrl = hostedInvoiceUrl;
    return this;
  }

   /**
   * Get hostedInvoiceUrl
   * @return hostedInvoiceUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOSTED_INVOICE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHostedInvoiceUrl() {
    return hostedInvoiceUrl;
  }


  @JsonProperty(JSON_PROPERTY_HOSTED_INVOICE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHostedInvoiceUrl(String hostedInvoiceUrl) {
    this.hostedInvoiceUrl = hostedInvoiceUrl;
  }


  public InvoiceAffiliate id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public InvoiceAffiliate invoicePdf(String invoicePdf) {
    
    this.invoicePdf = invoicePdf;
    return this;
  }

   /**
   * Get invoicePdf
   * @return invoicePdf
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INVOICE_PDF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInvoicePdf() {
    return invoicePdf;
  }


  @JsonProperty(JSON_PROPERTY_INVOICE_PDF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvoicePdf(String invoicePdf) {
    this.invoicePdf = invoicePdf;
  }


  public InvoiceAffiliate lines(InvoiceLineItemCollectionAffiliate lines) {
    
    this.lines = lines;
    return this;
  }

   /**
   * Get lines
   * @return lines
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LINES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InvoiceLineItemCollectionAffiliate getLines() {
    return lines;
  }


  @JsonProperty(JSON_PROPERTY_LINES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLines(InvoiceLineItemCollectionAffiliate lines) {
    this.lines = lines;
  }


  public InvoiceAffiliate livemode(Boolean livemode) {
    
    this.livemode = livemode;
    return this;
  }

   /**
   * Get livemode
   * @return livemode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLivemode() {
    return livemode;
  }


  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLivemode(Boolean livemode) {
    this.livemode = livemode;
  }


  public InvoiceAffiliate metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public InvoiceAffiliate putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public InvoiceAffiliate nextPaymentAttempt(Long nextPaymentAttempt) {
    
    this.nextPaymentAttempt = nextPaymentAttempt;
    return this;
  }

   /**
   * Get nextPaymentAttempt
   * @return nextPaymentAttempt
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NEXT_PAYMENT_ATTEMPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getNextPaymentAttempt() {
    return nextPaymentAttempt;
  }


  @JsonProperty(JSON_PROPERTY_NEXT_PAYMENT_ATTEMPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNextPaymentAttempt(Long nextPaymentAttempt) {
    this.nextPaymentAttempt = nextPaymentAttempt;
  }


  public InvoiceAffiliate number(String number) {
    
    this.number = number;
    return this;
  }

   /**
   * Get number
   * @return number
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNumber() {
    return number;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumber(String number) {
    this.number = number;
  }


  public InvoiceAffiliate _object(String _object) {
    
    this._object = _object;
    return this;
  }

   /**
   * Get _object
   * @return _object
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObject() {
    return _object;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObject(String _object) {
    this._object = _object;
  }


  public InvoiceAffiliate paid(Boolean paid) {
    
    this.paid = paid;
    return this;
  }

   /**
   * Get paid
   * @return paid
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PAID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPaid() {
    return paid;
  }


  @JsonProperty(JSON_PROPERTY_PAID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaid(Boolean paid) {
    this.paid = paid;
  }


  public InvoiceAffiliate periodEnd(Long periodEnd) {
    
    this.periodEnd = periodEnd;
    return this;
  }

   /**
   * Get periodEnd
   * @return periodEnd
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERIOD_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPeriodEnd() {
    return periodEnd;
  }


  @JsonProperty(JSON_PROPERTY_PERIOD_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPeriodEnd(Long periodEnd) {
    this.periodEnd = periodEnd;
  }


  public InvoiceAffiliate periodStart(Long periodStart) {
    
    this.periodStart = periodStart;
    return this;
  }

   /**
   * Get periodStart
   * @return periodStart
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERIOD_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPeriodStart() {
    return periodStart;
  }


  @JsonProperty(JSON_PROPERTY_PERIOD_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPeriodStart(Long periodStart) {
    this.periodStart = periodStart;
  }


  public InvoiceAffiliate postPaymentCreditNotesAmount(Long postPaymentCreditNotesAmount) {
    
    this.postPaymentCreditNotesAmount = postPaymentCreditNotesAmount;
    return this;
  }

   /**
   * Get postPaymentCreditNotesAmount
   * @return postPaymentCreditNotesAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POST_PAYMENT_CREDIT_NOTES_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPostPaymentCreditNotesAmount() {
    return postPaymentCreditNotesAmount;
  }


  @JsonProperty(JSON_PROPERTY_POST_PAYMENT_CREDIT_NOTES_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostPaymentCreditNotesAmount(Long postPaymentCreditNotesAmount) {
    this.postPaymentCreditNotesAmount = postPaymentCreditNotesAmount;
  }


  public InvoiceAffiliate prePaymentCreditNotesAmount(Long prePaymentCreditNotesAmount) {
    
    this.prePaymentCreditNotesAmount = prePaymentCreditNotesAmount;
    return this;
  }

   /**
   * Get prePaymentCreditNotesAmount
   * @return prePaymentCreditNotesAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRE_PAYMENT_CREDIT_NOTES_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPrePaymentCreditNotesAmount() {
    return prePaymentCreditNotesAmount;
  }


  @JsonProperty(JSON_PROPERTY_PRE_PAYMENT_CREDIT_NOTES_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrePaymentCreditNotesAmount(Long prePaymentCreditNotesAmount) {
    this.prePaymentCreditNotesAmount = prePaymentCreditNotesAmount;
  }


  public InvoiceAffiliate receiptNumber(String receiptNumber) {
    
    this.receiptNumber = receiptNumber;
    return this;
  }

   /**
   * Get receiptNumber
   * @return receiptNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RECEIPT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReceiptNumber() {
    return receiptNumber;
  }


  @JsonProperty(JSON_PROPERTY_RECEIPT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReceiptNumber(String receiptNumber) {
    this.receiptNumber = receiptNumber;
  }


  public InvoiceAffiliate startingBalance(Long startingBalance) {
    
    this.startingBalance = startingBalance;
    return this;
  }

   /**
   * Get startingBalance
   * @return startingBalance
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STARTING_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getStartingBalance() {
    return startingBalance;
  }


  @JsonProperty(JSON_PROPERTY_STARTING_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartingBalance(Long startingBalance) {
    this.startingBalance = startingBalance;
  }


  public InvoiceAffiliate statementDescriptor(String statementDescriptor) {
    
    this.statementDescriptor = statementDescriptor;
    return this;
  }

   /**
   * Get statementDescriptor
   * @return statementDescriptor
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATEMENT_DESCRIPTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStatementDescriptor() {
    return statementDescriptor;
  }


  @JsonProperty(JSON_PROPERTY_STATEMENT_DESCRIPTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatementDescriptor(String statementDescriptor) {
    this.statementDescriptor = statementDescriptor;
  }


  public InvoiceAffiliate status(String status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(String status) {
    this.status = status;
  }


  public InvoiceAffiliate statusTransitions(StatusTransitionsAffiliate statusTransitions) {
    
    this.statusTransitions = statusTransitions;
    return this;
  }

   /**
   * Get statusTransitions
   * @return statusTransitions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_STATUS_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusTransitionsAffiliate getStatusTransitions() {
    return statusTransitions;
  }


  @JsonProperty(JSON_PROPERTY_STATUS_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatusTransitions(StatusTransitionsAffiliate statusTransitions) {
    this.statusTransitions = statusTransitions;
  }


  public InvoiceAffiliate subscriptionProrationDate(Long subscriptionProrationDate) {
    
    this.subscriptionProrationDate = subscriptionProrationDate;
    return this;
  }

   /**
   * Get subscriptionProrationDate
   * @return subscriptionProrationDate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_PRORATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSubscriptionProrationDate() {
    return subscriptionProrationDate;
  }


  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_PRORATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubscriptionProrationDate(Long subscriptionProrationDate) {
    this.subscriptionProrationDate = subscriptionProrationDate;
  }


  public InvoiceAffiliate subtotal(Long subtotal) {
    
    this.subtotal = subtotal;
    return this;
  }

   /**
   * Get subtotal
   * @return subtotal
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUBTOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSubtotal() {
    return subtotal;
  }


  @JsonProperty(JSON_PROPERTY_SUBTOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubtotal(Long subtotal) {
    this.subtotal = subtotal;
  }


  public InvoiceAffiliate tax(Long tax) {
    
    this.tax = tax;
    return this;
  }

   /**
   * Get tax
   * @return tax
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTax() {
    return tax;
  }


  @JsonProperty(JSON_PROPERTY_TAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTax(Long tax) {
    this.tax = tax;
  }


  public InvoiceAffiliate thresholdReason(ThresholdReasonAffiliate thresholdReason) {
    
    this.thresholdReason = thresholdReason;
    return this;
  }

   /**
   * Get thresholdReason
   * @return thresholdReason
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_THRESHOLD_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ThresholdReasonAffiliate getThresholdReason() {
    return thresholdReason;
  }


  @JsonProperty(JSON_PROPERTY_THRESHOLD_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThresholdReason(ThresholdReasonAffiliate thresholdReason) {
    this.thresholdReason = thresholdReason;
  }


  public InvoiceAffiliate total(Long total) {
    
    this.total = total;
    return this;
  }

   /**
   * Get total
   * @return total
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTotal() {
    return total;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotal(Long total) {
    this.total = total;
  }


  public InvoiceAffiliate totalTaxAmounts(List<TotalTaxAmountAffiliate> totalTaxAmounts) {
    
    this.totalTaxAmounts = totalTaxAmounts;
    return this;
  }

  public InvoiceAffiliate addTotalTaxAmountsItem(TotalTaxAmountAffiliate totalTaxAmountsItem) {
    if (this.totalTaxAmounts == null) {
      this.totalTaxAmounts = new ArrayList<>();
    }
    this.totalTaxAmounts.add(totalTaxAmountsItem);
    return this;
  }

   /**
   * Get totalTaxAmounts
   * @return totalTaxAmounts
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TAX_AMOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TotalTaxAmountAffiliate> getTotalTaxAmounts() {
    return totalTaxAmounts;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TAX_AMOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTaxAmounts(List<TotalTaxAmountAffiliate> totalTaxAmounts) {
    this.totalTaxAmounts = totalTaxAmounts;
  }


  public InvoiceAffiliate transferData(Object transferData) {
    
    this.transferData = transferData;
    return this;
  }

   /**
   * Get transferData
   * @return transferData
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TRANSFER_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getTransferData() {
    return transferData;
  }


  @JsonProperty(JSON_PROPERTY_TRANSFER_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransferData(Object transferData) {
    this.transferData = transferData;
  }


  public InvoiceAffiliate webhooksDeliveredAt(Long webhooksDeliveredAt) {
    
    this.webhooksDeliveredAt = webhooksDeliveredAt;
    return this;
  }

   /**
   * Get webhooksDeliveredAt
   * @return webhooksDeliveredAt
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WEBHOOKS_DELIVERED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getWebhooksDeliveredAt() {
    return webhooksDeliveredAt;
  }


  @JsonProperty(JSON_PROPERTY_WEBHOOKS_DELIVERED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebhooksDeliveredAt(Long webhooksDeliveredAt) {
    this.webhooksDeliveredAt = webhooksDeliveredAt;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceAffiliate invoiceAffiliate = (InvoiceAffiliate) o;
    return Objects.equals(this.accountCountry, invoiceAffiliate.accountCountry) &&
        Objects.equals(this.accountName, invoiceAffiliate.accountName) &&
        Objects.equals(this.amountDue, invoiceAffiliate.amountDue) &&
        Objects.equals(this.amountPaid, invoiceAffiliate.amountPaid) &&
        Objects.equals(this.amountRemaining, invoiceAffiliate.amountRemaining) &&
        Objects.equals(this.applicationFeeAmount, invoiceAffiliate.applicationFeeAmount) &&
        Objects.equals(this.attemptCount, invoiceAffiliate.attemptCount) &&
        Objects.equals(this.attempted, invoiceAffiliate.attempted) &&
        Objects.equals(this.autoAdvance, invoiceAffiliate.autoAdvance) &&
        Objects.equals(this.billing, invoiceAffiliate.billing) &&
        Objects.equals(this.billingReason, invoiceAffiliate.billingReason) &&
        Objects.equals(this.collectionMethod, invoiceAffiliate.collectionMethod) &&
        Objects.equals(this.created, invoiceAffiliate.created) &&
        Objects.equals(this.currency, invoiceAffiliate.currency) &&
        Objects.equals(this.customerAddress, invoiceAffiliate.customerAddress) &&
        Objects.equals(this.customerEmail, invoiceAffiliate.customerEmail) &&
        Objects.equals(this.customerName, invoiceAffiliate.customerName) &&
        Objects.equals(this.customerPhone, invoiceAffiliate.customerPhone) &&
        Objects.equals(this.customerShipping, invoiceAffiliate.customerShipping) &&
        Objects.equals(this.customerTaxExempt, invoiceAffiliate.customerTaxExempt) &&
        Objects.equals(this.customerTaxIds, invoiceAffiliate.customerTaxIds) &&
        Objects.equals(this.defaultTaxRates, invoiceAffiliate.defaultTaxRates) &&
        Objects.equals(this.deleted, invoiceAffiliate.deleted) &&
        Objects.equals(this.description, invoiceAffiliate.description) &&
        Objects.equals(this.discount, invoiceAffiliate.discount) &&
        Objects.equals(this.dueDate, invoiceAffiliate.dueDate) &&
        Objects.equals(this.endingBalance, invoiceAffiliate.endingBalance) &&
        Objects.equals(this.footer, invoiceAffiliate.footer) &&
        Objects.equals(this.hostedInvoiceUrl, invoiceAffiliate.hostedInvoiceUrl) &&
        Objects.equals(this.id, invoiceAffiliate.id) &&
        Objects.equals(this.invoicePdf, invoiceAffiliate.invoicePdf) &&
        Objects.equals(this.lines, invoiceAffiliate.lines) &&
        Objects.equals(this.livemode, invoiceAffiliate.livemode) &&
        Objects.equals(this.metadata, invoiceAffiliate.metadata) &&
        Objects.equals(this.nextPaymentAttempt, invoiceAffiliate.nextPaymentAttempt) &&
        Objects.equals(this.number, invoiceAffiliate.number) &&
        Objects.equals(this._object, invoiceAffiliate._object) &&
        Objects.equals(this.paid, invoiceAffiliate.paid) &&
        Objects.equals(this.periodEnd, invoiceAffiliate.periodEnd) &&
        Objects.equals(this.periodStart, invoiceAffiliate.periodStart) &&
        Objects.equals(this.postPaymentCreditNotesAmount, invoiceAffiliate.postPaymentCreditNotesAmount) &&
        Objects.equals(this.prePaymentCreditNotesAmount, invoiceAffiliate.prePaymentCreditNotesAmount) &&
        Objects.equals(this.receiptNumber, invoiceAffiliate.receiptNumber) &&
        Objects.equals(this.startingBalance, invoiceAffiliate.startingBalance) &&
        Objects.equals(this.statementDescriptor, invoiceAffiliate.statementDescriptor) &&
        Objects.equals(this.status, invoiceAffiliate.status) &&
        Objects.equals(this.statusTransitions, invoiceAffiliate.statusTransitions) &&
        Objects.equals(this.subscriptionProrationDate, invoiceAffiliate.subscriptionProrationDate) &&
        Objects.equals(this.subtotal, invoiceAffiliate.subtotal) &&
        Objects.equals(this.tax, invoiceAffiliate.tax) &&
        Objects.equals(this.thresholdReason, invoiceAffiliate.thresholdReason) &&
        Objects.equals(this.total, invoiceAffiliate.total) &&
        Objects.equals(this.totalTaxAmounts, invoiceAffiliate.totalTaxAmounts) &&
        Objects.equals(this.transferData, invoiceAffiliate.transferData) &&
        Objects.equals(this.webhooksDeliveredAt, invoiceAffiliate.webhooksDeliveredAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountCountry, accountName, amountDue, amountPaid, amountRemaining, applicationFeeAmount, attemptCount, attempted, autoAdvance, billing, billingReason, collectionMethod, created, currency, customerAddress, customerEmail, customerName, customerPhone, customerShipping, customerTaxExempt, customerTaxIds, defaultTaxRates, deleted, description, discount, dueDate, endingBalance, footer, hostedInvoiceUrl, id, invoicePdf, lines, livemode, metadata, nextPaymentAttempt, number, _object, paid, periodEnd, periodStart, postPaymentCreditNotesAmount, prePaymentCreditNotesAmount, receiptNumber, startingBalance, statementDescriptor, status, statusTransitions, subscriptionProrationDate, subtotal, tax, thresholdReason, total, totalTaxAmounts, transferData, webhooksDeliveredAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceAffiliate {\n");
    sb.append("    accountCountry: ").append(toIndentedString(accountCountry)).append("\n");
    sb.append("    accountName: ").append(toIndentedString(accountName)).append("\n");
    sb.append("    amountDue: ").append(toIndentedString(amountDue)).append("\n");
    sb.append("    amountPaid: ").append(toIndentedString(amountPaid)).append("\n");
    sb.append("    amountRemaining: ").append(toIndentedString(amountRemaining)).append("\n");
    sb.append("    applicationFeeAmount: ").append(toIndentedString(applicationFeeAmount)).append("\n");
    sb.append("    attemptCount: ").append(toIndentedString(attemptCount)).append("\n");
    sb.append("    attempted: ").append(toIndentedString(attempted)).append("\n");
    sb.append("    autoAdvance: ").append(toIndentedString(autoAdvance)).append("\n");
    sb.append("    billing: ").append(toIndentedString(billing)).append("\n");
    sb.append("    billingReason: ").append(toIndentedString(billingReason)).append("\n");
    sb.append("    collectionMethod: ").append(toIndentedString(collectionMethod)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    customerAddress: ").append(toIndentedString(customerAddress)).append("\n");
    sb.append("    customerEmail: ").append(toIndentedString(customerEmail)).append("\n");
    sb.append("    customerName: ").append(toIndentedString(customerName)).append("\n");
    sb.append("    customerPhone: ").append(toIndentedString(customerPhone)).append("\n");
    sb.append("    customerShipping: ").append(toIndentedString(customerShipping)).append("\n");
    sb.append("    customerTaxExempt: ").append(toIndentedString(customerTaxExempt)).append("\n");
    sb.append("    customerTaxIds: ").append(toIndentedString(customerTaxIds)).append("\n");
    sb.append("    defaultTaxRates: ").append(toIndentedString(defaultTaxRates)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    discount: ").append(toIndentedString(discount)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    endingBalance: ").append(toIndentedString(endingBalance)).append("\n");
    sb.append("    footer: ").append(toIndentedString(footer)).append("\n");
    sb.append("    hostedInvoiceUrl: ").append(toIndentedString(hostedInvoiceUrl)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    invoicePdf: ").append(toIndentedString(invoicePdf)).append("\n");
    sb.append("    lines: ").append(toIndentedString(lines)).append("\n");
    sb.append("    livemode: ").append(toIndentedString(livemode)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    nextPaymentAttempt: ").append(toIndentedString(nextPaymentAttempt)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    _object: ").append(toIndentedString(_object)).append("\n");
    sb.append("    paid: ").append(toIndentedString(paid)).append("\n");
    sb.append("    periodEnd: ").append(toIndentedString(periodEnd)).append("\n");
    sb.append("    periodStart: ").append(toIndentedString(periodStart)).append("\n");
    sb.append("    postPaymentCreditNotesAmount: ").append(toIndentedString(postPaymentCreditNotesAmount)).append("\n");
    sb.append("    prePaymentCreditNotesAmount: ").append(toIndentedString(prePaymentCreditNotesAmount)).append("\n");
    sb.append("    receiptNumber: ").append(toIndentedString(receiptNumber)).append("\n");
    sb.append("    startingBalance: ").append(toIndentedString(startingBalance)).append("\n");
    sb.append("    statementDescriptor: ").append(toIndentedString(statementDescriptor)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusTransitions: ").append(toIndentedString(statusTransitions)).append("\n");
    sb.append("    subscriptionProrationDate: ").append(toIndentedString(subscriptionProrationDate)).append("\n");
    sb.append("    subtotal: ").append(toIndentedString(subtotal)).append("\n");
    sb.append("    tax: ").append(toIndentedString(tax)).append("\n");
    sb.append("    thresholdReason: ").append(toIndentedString(thresholdReason)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    totalTaxAmounts: ").append(toIndentedString(totalTaxAmounts)).append("\n");
    sb.append("    transferData: ").append(toIndentedString(transferData)).append("\n");
    sb.append("    webhooksDeliveredAt: ").append(toIndentedString(webhooksDeliveredAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

