/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 25.6.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.SimpleDescriptionAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Seller URL
 */
@JsonPropertyOrder({
  SellerUrlAffiliate.JSON_PROPERTY_IDENTIFIER,
  SellerUrlAffiliate.JSON_PROPERTY_SELLER_IDENTIFIER,
  SellerUrlAffiliate.JSON_PROPERTY_SELLER_URL_NAME,
  SellerUrlAffiliate.JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER,
  SellerUrlAffiliate.JSON_PROPERTY_DESCRIPTIONS,
  SellerUrlAffiliate.JSON_PROPERTY_KEYWORDS,
  SellerUrlAffiliate.JSON_PROPERTY_UNIQUE_ID,
  SellerUrlAffiliate.JSON_PROPERTY_TWITTER_ACCOUNT,
  SellerUrlAffiliate.JSON_PROPERTY_FACEBOOK_APP_ID,
  SellerUrlAffiliate.JSON_PROPERTY_THEME,
  SellerUrlAffiliate.JSON_PROPERTY_STATUS,
  SellerUrlAffiliate.JSON_PROPERTY_INVENTORY_TYPE,
  SellerUrlAffiliate.JSON_PROPERTY_CHANNEL_INVENTORY_TYPE,
  SellerUrlAffiliate.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  SellerUrlAffiliate.JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER,
  SellerUrlAffiliate.JSON_PROPERTY_TRANSACTIONAL_ITEM_IDENTIFIER,
  SellerUrlAffiliate.JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS,
  SellerUrlAffiliate.JSON_PROPERTY_ANIMATE,
  SellerUrlAffiliate.JSON_PROPERTY_ANIMATE_DELAY
})
@JsonTypeName("SellerUrl_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-06-06T15:45:36.063243408+07:00[Asia/Bangkok]")
public class SellerUrlAffiliate {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_SELLER_IDENTIFIER = "sellerIdentifier";
  private UUID sellerIdentifier;

  public static final String JSON_PROPERTY_SELLER_URL_NAME = "sellerUrlName";
  private String sellerUrlName;

  public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
  private UUID engineConfigurationIdentifier;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionAffiliate> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_KEYWORDS = "keywords";
  private List<String> keywords = new ArrayList<>();

  public static final String JSON_PROPERTY_UNIQUE_ID = "uniqueId";
  private String uniqueId;

  public static final String JSON_PROPERTY_TWITTER_ACCOUNT = "twitterAccount";
  private String twitterAccount;

  public static final String JSON_PROPERTY_FACEBOOK_APP_ID = "facebookAppId";
  private String facebookAppId;

  /**
   * Url theme controls the look and feel of the ad banner.
   */
  public enum ThemeEnum {
    THEME_1("THEME_1");

    private String value;

    ThemeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ThemeEnum fromValue(String value) {
      for (ThemeEnum b : ThemeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_THEME = "theme";
  private ThemeEnum theme;

  /**
   * Url sell status
   */
  public enum StatusEnum {
    ACTIVE("ACTIVE"),
    
    INACTIVE("INACTIVE"),
    
    REMOVED("REMOVED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  /**
   * Inventory type
   */
  public enum InventoryTypeEnum {
    HOTEL("HOTEL"),
    
    GUEST_ROOM("GUEST_ROOM"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ADD_ON("ADD_ON"),
    
    ATTRACTION("ATTRACTION"),
    
    ACTIVITY("ACTIVITY"),
    
    PLACE("PLACE");

    private String value;

    InventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryTypeEnum fromValue(String value) {
      for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
  private InventoryTypeEnum inventoryType;

  /**
   * Channel inventory type is a subset of inventory type in that it does not include the &#x60;HOTEL&#x60; type. THe way it works is, as a seller you might want to sell a guest room but instead of showing the price of that guest room, you would like to display the best room type price for the property.
   */
  public enum ChannelInventoryTypeEnum {
    GUEST_ROOM("GUEST_ROOM"),
    
    ADD_ON("ADD_ON"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE"),
    
    ACTIVITY("ACTIVITY");

    private String value;

    ChannelInventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChannelInventoryTypeEnum fromValue(String value) {
      for (ChannelInventoryTypeEnum b : ChannelInventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_TYPE = "channelInventoryType";
  private ChannelInventoryTypeEnum channelInventoryType;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private String supplierIdentifier;

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
  private String channelInventoryIdentifier;

  public static final String JSON_PROPERTY_TRANSACTIONAL_ITEM_IDENTIFIER = "transactionalItemIdentifier";
  private String transactionalItemIdentifier;

  public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS = "multimediaIdentifiers";
  private List<String> multimediaIdentifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_ANIMATE = "animate";
  private Boolean animate = false;

  public static final String JSON_PROPERTY_ANIMATE_DELAY = "animateDelay";
  private Integer animateDelay = -1;

  public SellerUrlAffiliate() {
  }

  public SellerUrlAffiliate identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public SellerUrlAffiliate sellerIdentifier(UUID sellerIdentifier) {
    
    this.sellerIdentifier = sellerIdentifier;
    return this;
  }

   /**
   * Company identifier
   * @return sellerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SELLER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSellerIdentifier() {
    return sellerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SELLER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSellerIdentifier(UUID sellerIdentifier) {
    this.sellerIdentifier = sellerIdentifier;
  }


  public SellerUrlAffiliate sellerUrlName(String sellerUrlName) {
    
    this.sellerUrlName = sellerUrlName;
    return this;
  }

   /**
   * Descriptive name of this url for seller use only
   * @return sellerUrlName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SELLER_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSellerUrlName() {
    return sellerUrlName;
  }


  @JsonProperty(JSON_PROPERTY_SELLER_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSellerUrlName(String sellerUrlName) {
    this.sellerUrlName = sellerUrlName;
  }


  public SellerUrlAffiliate engineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    return this;
  }

   /**
   * Customization identifier
   * @return engineConfigurationIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getEngineConfigurationIdentifier() {
    return engineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEngineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
  }


  public SellerUrlAffiliate descriptions(List<SimpleDescriptionAffiliate> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public SellerUrlAffiliate addDescriptionsItem(SimpleDescriptionAffiliate descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized link descriptions
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionAffiliate> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionAffiliate> descriptions) {
    this.descriptions = descriptions;
  }


  public SellerUrlAffiliate keywords(List<String> keywords) {
    
    this.keywords = keywords;
    return this;
  }

  public SellerUrlAffiliate addKeywordsItem(String keywordsItem) {
    this.keywords.add(keywordsItem);
    return this;
  }

   /**
   * Keywords
   * @return keywords
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getKeywords() {
    return keywords;
  }


  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setKeywords(List<String> keywords) {
    this.keywords = keywords;
  }


  public SellerUrlAffiliate uniqueId(String uniqueId) {
    
    this.uniqueId = uniqueId;
    return this;
  }

   /**
   * Unique link id
   * @return uniqueId
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_UNIQUE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUniqueId() {
    return uniqueId;
  }


  @JsonProperty(JSON_PROPERTY_UNIQUE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUniqueId(String uniqueId) {
    this.uniqueId = uniqueId;
  }


  public SellerUrlAffiliate twitterAccount(String twitterAccount) {
    
    this.twitterAccount = twitterAccount;
    return this;
  }

   /**
   * Twitter account is used with OpenGraph data
   * @return twitterAccount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TWITTER_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTwitterAccount() {
    return twitterAccount;
  }


  @JsonProperty(JSON_PROPERTY_TWITTER_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTwitterAccount(String twitterAccount) {
    this.twitterAccount = twitterAccount;
  }


  public SellerUrlAffiliate facebookAppId(String facebookAppId) {
    
    this.facebookAppId = facebookAppId;
    return this;
  }

   /**
   * Facebook APP ID is used with OpenGraph data
   * @return facebookAppId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FACEBOOK_APP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFacebookAppId() {
    return facebookAppId;
  }


  @JsonProperty(JSON_PROPERTY_FACEBOOK_APP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFacebookAppId(String facebookAppId) {
    this.facebookAppId = facebookAppId;
  }


  public SellerUrlAffiliate theme(ThemeEnum theme) {
    
    this.theme = theme;
    return this;
  }

   /**
   * Url theme controls the look and feel of the ad banner.
   * @return theme
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_THEME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ThemeEnum getTheme() {
    return theme;
  }


  @JsonProperty(JSON_PROPERTY_THEME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTheme(ThemeEnum theme) {
    this.theme = theme;
  }


  public SellerUrlAffiliate status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Url sell status
   * @return status
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public SellerUrlAffiliate inventoryType(InventoryTypeEnum inventoryType) {
    
    this.inventoryType = inventoryType;
    return this;
  }

   /**
   * Inventory type
   * @return inventoryType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InventoryTypeEnum getInventoryType() {
    return inventoryType;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryType(InventoryTypeEnum inventoryType) {
    this.inventoryType = inventoryType;
  }


  public SellerUrlAffiliate channelInventoryType(ChannelInventoryTypeEnum channelInventoryType) {
    
    this.channelInventoryType = channelInventoryType;
    return this;
  }

   /**
   * Channel inventory type is a subset of inventory type in that it does not include the &#x60;HOTEL&#x60; type. THe way it works is, as a seller you might want to sell a guest room but instead of showing the price of that guest room, you would like to display the best room type price for the property.
   * @return channelInventoryType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ChannelInventoryTypeEnum getChannelInventoryType() {
    return channelInventoryType;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannelInventoryType(ChannelInventoryTypeEnum channelInventoryType) {
    this.channelInventoryType = channelInventoryType;
  }


  public SellerUrlAffiliate supplierIdentifier(String supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * The entity supplying the inventory. Usually a hotel.
   * @return supplierIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(String supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public SellerUrlAffiliate channelInventoryIdentifier(String channelInventoryIdentifier) {
    
    this.channelInventoryIdentifier = channelInventoryIdentifier;
    return this;
  }

   /**
   * Selected inventory record
   * @return channelInventoryIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getChannelInventoryIdentifier() {
    return channelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannelInventoryIdentifier(String channelInventoryIdentifier) {
    this.channelInventoryIdentifier = channelInventoryIdentifier;
  }


  public SellerUrlAffiliate transactionalItemIdentifier(String transactionalItemIdentifier) {
    
    this.transactionalItemIdentifier = transactionalItemIdentifier;
    return this;
  }

   /**
   * The transactional item to retrieve pricing for. If left empty, will find the cheapest priced item.
   * @return transactionalItemIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TRANSACTIONAL_ITEM_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTransactionalItemIdentifier() {
    return transactionalItemIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTIONAL_ITEM_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTransactionalItemIdentifier(String transactionalItemIdentifier) {
    this.transactionalItemIdentifier = transactionalItemIdentifier;
  }


  public SellerUrlAffiliate multimediaIdentifiers(List<String> multimediaIdentifiers) {
    
    this.multimediaIdentifiers = multimediaIdentifiers;
    return this;
  }

  public SellerUrlAffiliate addMultimediaIdentifiersItem(String multimediaIdentifiersItem) {
    this.multimediaIdentifiers.add(multimediaIdentifiersItem);
    return this;
  }

   /**
   * Cloudinary identifiers
   * @return multimediaIdentifiers
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getMultimediaIdentifiers() {
    return multimediaIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimediaIdentifiers(List<String> multimediaIdentifiers) {
    this.multimediaIdentifiers = multimediaIdentifiers;
  }


  public SellerUrlAffiliate animate(Boolean animate) {
    
    this.animate = animate;
    return this;
  }

   /**
   * Create an animated gif instead of a list of images
   * @return animate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAnimate() {
    return animate;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimate(Boolean animate) {
    this.animate = animate;
  }


  public SellerUrlAffiliate animateDelay(Integer animateDelay) {
    
    this.animateDelay = animateDelay;
    return this;
  }

   /**
   * Animation delay in milliseconds
   * @return animateDelay
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAnimateDelay() {
    return animateDelay;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimateDelay(Integer animateDelay) {
    this.animateDelay = animateDelay;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SellerUrlAffiliate sellerUrlAffiliate = (SellerUrlAffiliate) o;
    return Objects.equals(this.identifier, sellerUrlAffiliate.identifier) &&
        Objects.equals(this.sellerIdentifier, sellerUrlAffiliate.sellerIdentifier) &&
        Objects.equals(this.sellerUrlName, sellerUrlAffiliate.sellerUrlName) &&
        Objects.equals(this.engineConfigurationIdentifier, sellerUrlAffiliate.engineConfigurationIdentifier) &&
        Objects.equals(this.descriptions, sellerUrlAffiliate.descriptions) &&
        Objects.equals(this.keywords, sellerUrlAffiliate.keywords) &&
        Objects.equals(this.uniqueId, sellerUrlAffiliate.uniqueId) &&
        Objects.equals(this.twitterAccount, sellerUrlAffiliate.twitterAccount) &&
        Objects.equals(this.facebookAppId, sellerUrlAffiliate.facebookAppId) &&
        Objects.equals(this.theme, sellerUrlAffiliate.theme) &&
        Objects.equals(this.status, sellerUrlAffiliate.status) &&
        Objects.equals(this.inventoryType, sellerUrlAffiliate.inventoryType) &&
        Objects.equals(this.channelInventoryType, sellerUrlAffiliate.channelInventoryType) &&
        Objects.equals(this.supplierIdentifier, sellerUrlAffiliate.supplierIdentifier) &&
        Objects.equals(this.channelInventoryIdentifier, sellerUrlAffiliate.channelInventoryIdentifier) &&
        Objects.equals(this.transactionalItemIdentifier, sellerUrlAffiliate.transactionalItemIdentifier) &&
        Objects.equals(this.multimediaIdentifiers, sellerUrlAffiliate.multimediaIdentifiers) &&
        Objects.equals(this.animate, sellerUrlAffiliate.animate) &&
        Objects.equals(this.animateDelay, sellerUrlAffiliate.animateDelay);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, sellerIdentifier, sellerUrlName, engineConfigurationIdentifier, descriptions, keywords, uniqueId, twitterAccount, facebookAppId, theme, status, inventoryType, channelInventoryType, supplierIdentifier, channelInventoryIdentifier, transactionalItemIdentifier, multimediaIdentifiers, animate, animateDelay);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SellerUrlAffiliate {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    sellerIdentifier: ").append(toIndentedString(sellerIdentifier)).append("\n");
    sb.append("    sellerUrlName: ").append(toIndentedString(sellerUrlName)).append("\n");
    sb.append("    engineConfigurationIdentifier: ").append(toIndentedString(engineConfigurationIdentifier)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    uniqueId: ").append(toIndentedString(uniqueId)).append("\n");
    sb.append("    twitterAccount: ").append(toIndentedString(twitterAccount)).append("\n");
    sb.append("    facebookAppId: ").append(toIndentedString(facebookAppId)).append("\n");
    sb.append("    theme: ").append(toIndentedString(theme)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    inventoryType: ").append(toIndentedString(inventoryType)).append("\n");
    sb.append("    channelInventoryType: ").append(toIndentedString(channelInventoryType)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    channelInventoryIdentifier: ").append(toIndentedString(channelInventoryIdentifier)).append("\n");
    sb.append("    transactionalItemIdentifier: ").append(toIndentedString(transactionalItemIdentifier)).append("\n");
    sb.append("    multimediaIdentifiers: ").append(toIndentedString(multimediaIdentifiers)).append("\n");
    sb.append("    animate: ").append(toIndentedString(animate)).append("\n");
    sb.append("    animateDelay: ").append(toIndentedString(animateDelay)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

