/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.HotelOnMapViewAffiliate;
import travel.wink.sdk.affiliate.model.KeyValuePairAffiliate;
import travel.wink.sdk.affiliate.model.PageHotelOnMapViewAffiliate;
import travel.wink.sdk.affiliate.model.StateAffiliate;

public class SupplierApi {
    private ApiClient apiClient;

    public SupplierApi() {
        this(new ApiClient());
    }

    @Autowired
    public SupplierApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec browseSuppliersRequestCreation(String companyIdentifier, StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        StateAffiliate postBody = stateAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling browseSuppliers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (stateAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateAffiliate' when calling browseSuppliers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelOnMapViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageHotelOnMapViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/sales/supplier/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelOnMapViewAffiliate> browseSuppliers(String companyIdentifier, StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelOnMapViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageHotelOnMapViewAffiliate>(){};
        return this.browseSuppliersRequestCreation(companyIdentifier, stateAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelOnMapViewAffiliate>> browseSuppliersWithHttpInfo(String companyIdentifier, StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelOnMapViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageHotelOnMapViewAffiliate>(){};
        return this.browseSuppliersRequestCreation(companyIdentifier, stateAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec browseSuppliersWithResponseSpec(String companyIdentifier, StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        return this.browseSuppliersRequestCreation(companyIdentifier, stateAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec showSupplierRequestCreation(String companyIdentifier, String supplierIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (supplierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierIdentifier' when calling showSupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("supplierIdentifier", supplierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelOnMapViewAffiliate> localVarReturnType = new ParameterizedTypeReference<HotelOnMapViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/sales/supplier/{supplierIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelOnMapViewAffiliate> showSupplier(String companyIdentifier, String supplierIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelOnMapViewAffiliate> localVarReturnType = new ParameterizedTypeReference<HotelOnMapViewAffiliate>(){};
        return this.showSupplierRequestCreation(companyIdentifier, supplierIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelOnMapViewAffiliate>> showSupplierWithHttpInfo(String companyIdentifier, String supplierIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelOnMapViewAffiliate> localVarReturnType = new ParameterizedTypeReference<HotelOnMapViewAffiliate>(){};
        return this.showSupplierRequestCreation(companyIdentifier, supplierIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSupplierWithResponseSpec(String companyIdentifier, String supplierIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showSupplierRequestCreation(companyIdentifier, supplierIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showUniqueCityListRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUniqueCityList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/sales/supplier/city/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairAffiliate> showUniqueCityList(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(){};
        return this.showUniqueCityListRequestCreation(companyIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showUniqueCityListWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(){};
        return this.showUniqueCityListRequestCreation(companyIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showUniqueCityListWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showUniqueCityListRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showUniqueCountryListRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUniqueCountryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/sales/supplier/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairAffiliate> showUniqueCountryList(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(){};
        return this.showUniqueCountryListRequestCreation(companyIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showUniqueCountryListWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(){};
        return this.showUniqueCountryListRequestCreation(companyIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showUniqueCountryListWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showUniqueCountryListRequestCreation(companyIdentifier, winkVersion);
    }
}

