/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 26.1.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.affiliate.model.CustomMonetaryAmount;
import travel.wink.sdk.affiliate.model.LocalizedDescriptionAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * What the guest is paying extra for
 */
@JsonPropertyOrder({
  RatePlanLevelFeeAffiliate.JSON_PROPERTY_DESCRIPTIONS,
  RatePlanLevelFeeAffiliate.JSON_PROPERTY_FIXED_AMOUNT,
  RatePlanLevelFeeAffiliate.JSON_PROPERTY_TYPE
})
@JsonTypeName("RatePlanLevelFee_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-06-13T15:16:55.494669683+07:00[Asia/Bangkok]")
public class RatePlanLevelFeeAffiliate {
  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<LocalizedDescriptionAffiliate> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_FIXED_AMOUNT = "fixedAmount";
  private CustomMonetaryAmount fixedAmount;

  /**
   * Rate plan fee type
   */
  public enum TypeEnum {
    DAY("PER_DAY"),
    
    STAY("PER_STAY"),
    
    PERSON_PER_DAY("PER_PERSON_PER_DAY"),
    
    PERSON_PER_STAY("PER_PERSON_PER_STAY");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public RatePlanLevelFeeAffiliate() {
  }

  public RatePlanLevelFeeAffiliate descriptions(List<LocalizedDescriptionAffiliate> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public RatePlanLevelFeeAffiliate addDescriptionsItem(LocalizedDescriptionAffiliate descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * List of localized descriptions for this fee.
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<LocalizedDescriptionAffiliate> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<LocalizedDescriptionAffiliate> descriptions) {
    this.descriptions = descriptions;
  }


  public RatePlanLevelFeeAffiliate fixedAmount(CustomMonetaryAmount fixedAmount) {
    
    this.fixedAmount = fixedAmount;
    return this;
  }

   /**
   * Get fixedAmount
   * @return fixedAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_FIXED_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getFixedAmount() {
    return fixedAmount;
  }


  @JsonProperty(JSON_PROPERTY_FIXED_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFixedAmount(CustomMonetaryAmount fixedAmount) {
    this.fixedAmount = fixedAmount;
  }


  public RatePlanLevelFeeAffiliate type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Rate plan fee type
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RatePlanLevelFeeAffiliate ratePlanLevelFeeAffiliate = (RatePlanLevelFeeAffiliate) o;
    return Objects.equals(this.descriptions, ratePlanLevelFeeAffiliate.descriptions) &&
        Objects.equals(this.fixedAmount, ratePlanLevelFeeAffiliate.fixedAmount) &&
        Objects.equals(this.type, ratePlanLevelFeeAffiliate.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(descriptions, fixedAmount, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RatePlanLevelFeeAffiliate {\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    fixedAmount: ").append(toIndentedString(fixedAmount)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

