/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.AddStaticSellerListItemRequestAffiliate;
import travel.wink.sdk.affiliate.model.AddStaticSellerListSupplierRequestAffiliate;
import travel.wink.sdk.affiliate.model.BooleanResponseAffiliate;
import travel.wink.sdk.affiliate.model.CopyMoveStaticSellerListItemRequestAffiliate;
import travel.wink.sdk.affiliate.model.CreateStaticSellerListAndAddItemRequestAffiliate;
import travel.wink.sdk.affiliate.model.DynamicSellerListViewAffiliate;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.SellerInventoryListViewAffiliate;
import travel.wink.sdk.affiliate.model.SellerInventoryRankedListViewAffiliate;
import travel.wink.sdk.affiliate.model.SortStaticSellerListItemsRequestAffiliate;
import travel.wink.sdk.affiliate.model.StaticSellerListAffiliate;
import travel.wink.sdk.affiliate.model.StaticSellerListItemViewAffiliate;
import travel.wink.sdk.affiliate.model.StaticSellerListWrapperAffiliate;
import travel.wink.sdk.affiliate.model.UpsertSellerInventoryListRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertSellerInventoryRankedListRequestAffiliate;

public class InventoryGridsApi {
    private ApiClient apiClient;

    public InventoryGridsApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryGridsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec addInventoryToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequestAffiliate addStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        AddStaticSellerListItemRequestAffiliate postBody = addStaticSellerListItemRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addStaticSellerListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'addStaticSellerListItemRequestAffiliate' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListItemViewAffiliate> addInventoryToCuratedList(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequestAffiliate addStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(){};
        return this.addInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> addInventoryToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequestAffiliate addStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(){};
        return this.addInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec addInventoryToCuratedListWithResponseSpec(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequestAffiliate addStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.addInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec addSupplierToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, AddStaticSellerListSupplierRequestAffiliate addStaticSellerListSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        AddStaticSellerListSupplierRequestAffiliate postBody = addStaticSellerListSupplierRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling addSupplierToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling addSupplierToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addStaticSellerListSupplierRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'addStaticSellerListSupplierRequestAffiliate' when calling addSupplierToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item/supplier", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListItemViewAffiliate> addSupplierToCuratedList(String companyIdentifier, String listIdentifier, AddStaticSellerListSupplierRequestAffiliate addStaticSellerListSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(){};
        return this.addSupplierToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListSupplierRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> addSupplierToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, AddStaticSellerListSupplierRequestAffiliate addStaticSellerListSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(){};
        return this.addSupplierToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListSupplierRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec addSupplierToCuratedListWithResponseSpec(String companyIdentifier, String listIdentifier, AddStaticSellerListSupplierRequestAffiliate addStaticSellerListSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.addSupplierToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListSupplierRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec copyInventoryToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        CopyMoveStaticSellerListItemRequestAffiliate postBody = copyMoveStaticSellerListItemRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (copyMoveStaticSellerListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticSellerListItemRequestAffiliate' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListItemViewAffiliate> copyInventoryToCuratedList(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(){};
        return this.copyInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> copyInventoryToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(){};
        return this.copyInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec copyInventoryToCuratedListWithResponseSpec(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.copyInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createCuratedListRequestCreation(String companyIdentifier, CreateStaticSellerListAndAddItemRequestAffiliate createStaticSellerListAndAddItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        CreateStaticSellerListAndAddItemRequestAffiliate postBody = createStaticSellerListAndAddItemRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (createStaticSellerListAndAddItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStaticSellerListAndAddItemRequestAffiliate' when calling createCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListWrapperAffiliate> createCuratedList(String companyIdentifier, CreateStaticSellerListAndAddItemRequestAffiliate createStaticSellerListAndAddItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(){};
        return this.createCuratedListRequestCreation(companyIdentifier, createStaticSellerListAndAddItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListWrapperAffiliate>> createCuratedListWithHttpInfo(String companyIdentifier, CreateStaticSellerListAndAddItemRequestAffiliate createStaticSellerListAndAddItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(){};
        return this.createCuratedListRequestCreation(companyIdentifier, createStaticSellerListAndAddItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createCuratedListWithResponseSpec(String companyIdentifier, CreateStaticSellerListAndAddItemRequestAffiliate createStaticSellerListAndAddItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createCuratedListRequestCreation(companyIdentifier, createStaticSellerListAndAddItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSellerInventoryListRequestCreation(String companyIdentifier, UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSellerInventoryListRequestAffiliate postBody = upsertSellerInventoryListRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSellerInventoryListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerInventoryListRequestAffiliate' when calling createSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryListViewAffiliate> createSellerInventoryList(String companyIdentifier, UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(){};
        return this.createSellerInventoryListRequestCreation(companyIdentifier, upsertSellerInventoryListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListViewAffiliate>> createSellerInventoryListWithHttpInfo(String companyIdentifier, UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(){};
        return this.createSellerInventoryListRequestCreation(companyIdentifier, upsertSellerInventoryListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSellerInventoryListWithResponseSpec(String companyIdentifier, UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSellerInventoryListRequestCreation(companyIdentifier, upsertSellerInventoryListRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSellerInventoryRankedListRequestCreation(String companyIdentifier, UpsertSellerInventoryRankedListRequestAffiliate upsertSellerInventoryRankedListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSellerInventoryRankedListRequestAffiliate postBody = upsertSellerInventoryRankedListRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSellerInventoryRankedListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerInventoryRankedListRequestAffiliate' when calling createSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryRankedListViewAffiliate> createSellerInventoryRankedList(String companyIdentifier, UpsertSellerInventoryRankedListRequestAffiliate upsertSellerInventoryRankedListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>(){};
        return this.createSellerInventoryRankedListRequestCreation(companyIdentifier, upsertSellerInventoryRankedListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRankedListViewAffiliate>> createSellerInventoryRankedListWithHttpInfo(String companyIdentifier, UpsertSellerInventoryRankedListRequestAffiliate upsertSellerInventoryRankedListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>(){};
        return this.createSellerInventoryRankedListRequestCreation(companyIdentifier, upsertSellerInventoryRankedListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSellerInventoryRankedListWithResponseSpec(String companyIdentifier, UpsertSellerInventoryRankedListRequestAffiliate upsertSellerInventoryRankedListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSellerInventoryRankedListRequestCreation(companyIdentifier, upsertSellerInventoryRankedListRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec moveInventoryToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        CopyMoveStaticSellerListItemRequestAffiliate postBody = copyMoveStaticSellerListItemRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (copyMoveStaticSellerListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticSellerListItemRequestAffiliate' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListItemViewAffiliate> moveInventoryToCuratedList(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(){};
        return this.moveInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> moveInventoryToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(){};
        return this.moveInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec moveInventoryToCuratedListWithResponseSpec(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.moveInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseAffiliate> removeCuratedList(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(){};
        return this.removeCuratedListRequestCreation(companyIdentifier, listIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(){};
        return this.removeCuratedListRequestCreation(companyIdentifier, listIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeCuratedListWithResponseSpec(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeCuratedListRequestCreation(companyIdentifier, listIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec removeInventoryFromCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String itemIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseAffiliate> removeInventoryFromCuratedList(String companyIdentifier, String listIdentifier, String itemIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(){};
        return this.removeInventoryFromCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeInventoryFromCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String itemIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(){};
        return this.removeInventoryFromCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeInventoryFromCuratedListWithResponseSpec(String companyIdentifier, String listIdentifier, String itemIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeInventoryFromCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec removeSellerInventoryListRequestCreation(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/{listIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseAffiliate> removeSellerInventoryList(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(){};
        return this.removeSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeSellerInventoryListWithHttpInfo(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(){};
        return this.removeSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSellerInventoryListWithResponseSpec(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec removeSellerInventoryRankedListRequestCreation(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/{listIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseAffiliate> removeSellerInventoryRankedList(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(){};
        return this.removeSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeSellerInventoryRankedListWithHttpInfo(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(){};
        return this.removeSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSellerInventoryRankedListWithResponseSpec(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showCuratedListsRequestCreation(String companyIdentifier, Boolean withItems, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCuratedLists", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "withItems", withItems));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<StaticSellerListWrapperAffiliate> showCuratedLists(String companyIdentifier, Boolean withItems, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(){};
        return this.showCuratedListsRequestCreation(companyIdentifier, withItems, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<StaticSellerListWrapperAffiliate>>> showCuratedListsWithHttpInfo(String companyIdentifier, Boolean withItems, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(){};
        return this.showCuratedListsRequestCreation(companyIdentifier, withItems, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCuratedListsWithResponseSpec(String companyIdentifier, Boolean withItems, String winkVersion) throws WebClientResponseException {
        return this.showCuratedListsRequestCreation(companyIdentifier, withItems, winkVersion);
    }

    private WebClient.ResponseSpec showSavedSearchesRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSavedSearches", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<DynamicSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/dynamic/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<DynamicSellerListViewAffiliate> showSavedSearches(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListViewAffiliate>(){};
        return this.showSavedSearchesRequestCreation(companyIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<DynamicSellerListViewAffiliate>>> showSavedSearchesWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListViewAffiliate>(){};
        return this.showSavedSearchesRequestCreation(companyIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSavedSearchesWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showSavedSearchesRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showSellerInventoryListRequestCreation(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/{listIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryListViewAffiliate> showSellerInventoryList(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(){};
        return this.showSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListViewAffiliate>> showSellerInventoryListWithHttpInfo(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(){};
        return this.showSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryListWithResponseSpec(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showSellerInventoryListsRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryLists", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SellerInventoryListViewAffiliate> showSellerInventoryLists(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(){};
        return this.showSellerInventoryListsRequestCreation(companyIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellerInventoryListViewAffiliate>>> showSellerInventoryListsWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(){};
        return this.showSellerInventoryListsRequestCreation(companyIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryListsWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showSellerInventoryListsRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showSellerInventoryRankedListRequestCreation(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/{listIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryRankedListViewAffiliate> showSellerInventoryRankedList(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>(){};
        return this.showSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRankedListViewAffiliate>> showSellerInventoryRankedListWithHttpInfo(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>(){};
        return this.showSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryRankedListWithResponseSpec(String companyIdentifier, String listIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showSellerInventoryRankedListsRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryRankedLists", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SellerInventoryRankedListViewAffiliate> showSellerInventoryRankedLists(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>(){};
        return this.showSellerInventoryRankedListsRequestCreation(companyIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellerInventoryRankedListViewAffiliate>>> showSellerInventoryRankedListsWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>(){};
        return this.showSellerInventoryRankedListsRequestCreation(companyIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryRankedListsWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showSellerInventoryRankedListsRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec sortCuratedListItemsRequestCreation(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequestAffiliate sortStaticSellerListItemsRequestAffiliate, String winkVersion) throws WebClientResponseException {
        SortStaticSellerListItemsRequestAffiliate postBody = sortStaticSellerListItemsRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sortStaticSellerListItemsRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'sortStaticSellerListItemsRequestAffiliate' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/sort", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseAffiliate> sortCuratedListItems(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequestAffiliate sortStaticSellerListItemsRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(){};
        return this.sortCuratedListItemsRequestCreation(companyIdentifier, listIdentifier, sortStaticSellerListItemsRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseAffiliate>> sortCuratedListItemsWithHttpInfo(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequestAffiliate sortStaticSellerListItemsRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(){};
        return this.sortCuratedListItemsRequestCreation(companyIdentifier, listIdentifier, sortStaticSellerListItemsRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec sortCuratedListItemsWithResponseSpec(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequestAffiliate sortStaticSellerListItemsRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.sortCuratedListItemsRequestCreation(companyIdentifier, listIdentifier, sortStaticSellerListItemsRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateCuratedListRequestCreation(String companyIdentifier, String listIdentifier, StaticSellerListAffiliate staticSellerListAffiliate, String winkVersion) throws WebClientResponseException {
        StaticSellerListAffiliate postBody = staticSellerListAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (staticSellerListAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'staticSellerListAffiliate' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListWrapperAffiliate> updateCuratedList(String companyIdentifier, String listIdentifier, StaticSellerListAffiliate staticSellerListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(){};
        return this.updateCuratedListRequestCreation(companyIdentifier, listIdentifier, staticSellerListAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListWrapperAffiliate>> updateCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, StaticSellerListAffiliate staticSellerListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(){};
        return this.updateCuratedListRequestCreation(companyIdentifier, listIdentifier, staticSellerListAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCuratedListWithResponseSpec(String companyIdentifier, String listIdentifier, StaticSellerListAffiliate staticSellerListAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateCuratedListRequestCreation(companyIdentifier, listIdentifier, staticSellerListAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateSellerInventoryListRequestCreation(String companyIdentifier, String listIdentifier, UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSellerInventoryListRequestAffiliate postBody = upsertSellerInventoryListRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSellerInventoryListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerInventoryListRequestAffiliate' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/{listIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryListViewAffiliate> updateSellerInventoryList(String companyIdentifier, String listIdentifier, UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(){};
        return this.updateSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, upsertSellerInventoryListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListViewAffiliate>> updateSellerInventoryListWithHttpInfo(String companyIdentifier, String listIdentifier, UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(){};
        return this.updateSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, upsertSellerInventoryListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSellerInventoryListWithResponseSpec(String companyIdentifier, String listIdentifier, UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, upsertSellerInventoryListRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateSellerInventoryRankedListRequestCreation(String companyIdentifier, String listIdentifier, UpsertSellerInventoryRankedListRequestAffiliate upsertSellerInventoryRankedListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSellerInventoryRankedListRequestAffiliate postBody = upsertSellerInventoryRankedListRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSellerInventoryRankedListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerInventoryRankedListRequestAffiliate' when calling updateSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/{listIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryRankedListViewAffiliate> updateSellerInventoryRankedList(String companyIdentifier, String listIdentifier, UpsertSellerInventoryRankedListRequestAffiliate upsertSellerInventoryRankedListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>(){};
        return this.updateSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, upsertSellerInventoryRankedListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRankedListViewAffiliate>> updateSellerInventoryRankedListWithHttpInfo(String companyIdentifier, String listIdentifier, UpsertSellerInventoryRankedListRequestAffiliate upsertSellerInventoryRankedListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListViewAffiliate>(){};
        return this.updateSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, upsertSellerInventoryRankedListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSellerInventoryRankedListWithResponseSpec(String companyIdentifier, String listIdentifier, UpsertSellerInventoryRankedListRequestAffiliate upsertSellerInventoryRankedListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, upsertSellerInventoryRankedListRequestAffiliate, winkVersion);
    }
}

