package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.HotelOnMapViewAffiliate;
import travel.wink.sdk.affiliate.model.KeyValuePairAffiliate;
import travel.wink.sdk.affiliate.model.PageHotelOnMapViewAffiliate;
import travel.wink.sdk.affiliate.model.ShowSupplierUrl400Response;
import travel.wink.sdk.affiliate.model.StateAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-07-31T09:09:41.857644722+07:00[Asia/Bangkok]")
public class SupplierApi {
    private ApiClient apiClient;

    public SupplierApi() {
        this(new ApiClient());
    }

    @Autowired
    public SupplierApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show suppliers
     * Retrieve page of suppliers.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param stateAffiliate The stateAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return PageHotelOnMapViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec browseSuppliersRequestCreation(String companyIdentifier, StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = stateAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling browseSuppliers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'stateAffiliate' is set
        if (stateAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateAffiliate' when calling browseSuppliers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelOnMapViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageHotelOnMapViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/sales/supplier/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show suppliers
     * Retrieve page of suppliers.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param stateAffiliate The stateAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return PageHotelOnMapViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelOnMapViewAffiliate> browseSuppliers(String companyIdentifier, StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelOnMapViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageHotelOnMapViewAffiliate>() {};
        return browseSuppliersRequestCreation(companyIdentifier, stateAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show suppliers
     * Retrieve page of suppliers.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param stateAffiliate The stateAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageHotelOnMapViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelOnMapViewAffiliate>> browseSuppliersWithHttpInfo(String companyIdentifier, StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelOnMapViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageHotelOnMapViewAffiliate>() {};
        return browseSuppliersRequestCreation(companyIdentifier, stateAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show suppliers
     * Retrieve page of suppliers.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param stateAffiliate The stateAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec browseSuppliersWithResponseSpec(String companyIdentifier, StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        return browseSuppliersRequestCreation(companyIdentifier, stateAffiliate, winkVersion);
    }
    /**
     * Latest Inventory
     * Retrieves a list of latest available inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse suppliers on behalf of this owner identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;HotelOnMapViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLatestSupplierRequestCreation(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showLatestSupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelOnMapViewAffiliate> localVarReturnType = new ParameterizedTypeReference<HotelOnMapViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/sales/supplier/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Latest Inventory
     * Retrieves a list of latest available inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse suppliers on behalf of this owner identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;HotelOnMapViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<HotelOnMapViewAffiliate> showLatestSupplier(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelOnMapViewAffiliate> localVarReturnType = new ParameterizedTypeReference<HotelOnMapViewAffiliate>() {};
        return showLatestSupplierRequestCreation(companyIdentifier, page, size, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Latest Inventory
     * Retrieves a list of latest available inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse suppliers on behalf of this owner identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;HotelOnMapViewAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<HotelOnMapViewAffiliate>>> showLatestSupplierWithHttpInfo(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelOnMapViewAffiliate> localVarReturnType = new ParameterizedTypeReference<HotelOnMapViewAffiliate>() {};
        return showLatestSupplierRequestCreation(companyIdentifier, page, size, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Latest Inventory
     * Retrieves a list of latest available inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse suppliers on behalf of this owner identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showLatestSupplierWithResponseSpec(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        return showLatestSupplierRequestCreation(companyIdentifier, page, size, winkVersion);
    }
    /**
     * Show supplier
     * Retrieve supplier information specified by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param supplierIdentifier The supplierIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelOnMapViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSupplierRequestCreation(String companyIdentifier, String supplierIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'supplierIdentifier' is set
        if (supplierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierIdentifier' when calling showSupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("supplierIdentifier", supplierIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelOnMapViewAffiliate> localVarReturnType = new ParameterizedTypeReference<HotelOnMapViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/sales/supplier/{supplierIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show supplier
     * Retrieve supplier information specified by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param supplierIdentifier The supplierIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelOnMapViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelOnMapViewAffiliate> showSupplier(String companyIdentifier, String supplierIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelOnMapViewAffiliate> localVarReturnType = new ParameterizedTypeReference<HotelOnMapViewAffiliate>() {};
        return showSupplierRequestCreation(companyIdentifier, supplierIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show supplier
     * Retrieve supplier information specified by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param supplierIdentifier The supplierIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelOnMapViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelOnMapViewAffiliate>> showSupplierWithHttpInfo(String companyIdentifier, String supplierIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelOnMapViewAffiliate> localVarReturnType = new ParameterizedTypeReference<HotelOnMapViewAffiliate>() {};
        return showSupplierRequestCreation(companyIdentifier, supplierIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show supplier
     * Retrieve supplier information specified by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param supplierIdentifier The supplierIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSupplierWithResponseSpec(String companyIdentifier, String supplierIdentifier, String winkVersion) throws WebClientResponseException {
        return showSupplierRequestCreation(companyIdentifier, supplierIdentifier, winkVersion);
    }
    /**
     * Show unique supplier cities
     * Retrieve a list of unique cities where suppliers live
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showUniqueCityListRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUniqueCityList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/sales/supplier/city/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show unique supplier cities
     * Retrieve a list of unique cities where suppliers live
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairAffiliate> showUniqueCityList(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showUniqueCityListRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show unique supplier cities
     * Retrieve a list of unique cities where suppliers live
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showUniqueCityListWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showUniqueCityListRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show unique supplier cities
     * Retrieve a list of unique cities where suppliers live
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showUniqueCityListWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showUniqueCityListRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Show unique supplier countries
     * Retrieve a list of unique countries where suppliers live
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showUniqueCountryListRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUniqueCountryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/sales/supplier/country/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show unique supplier countries
     * Retrieve a list of unique countries where suppliers live
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairAffiliate> showUniqueCountryList(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showUniqueCountryListRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show unique supplier countries
     * Retrieve a list of unique countries where suppliers live
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showUniqueCountryListWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showUniqueCountryListRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show unique supplier countries
     * Retrieve a list of unique countries where suppliers live
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showUniqueCountryListWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showUniqueCountryListRequestCreation(companyIdentifier, winkVersion);
    }
}
