/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.0.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SupplierContractItemPolicyAffiliate
 */
@JsonPropertyOrder({
  SupplierContractItemPolicyAffiliate.JSON_PROPERTY_REFUNDABLE,
  SupplierContractItemPolicyAffiliate.JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE,
  SupplierContractItemPolicyAffiliate.JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE,
  SupplierContractItemPolicyAffiliate.JSON_PROPERTY_NO_SHOW_CHARGE,
  SupplierContractItemPolicyAffiliate.JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE,
  SupplierContractItemPolicyAffiliate.JSON_PROPERTY_NON_REFUNDABLE_DEADLINE,
  SupplierContractItemPolicyAffiliate.JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE,
  SupplierContractItemPolicyAffiliate.JSON_PROPERTY_EXTERNAL_IDENTIFIER,
  SupplierContractItemPolicyAffiliate.JSON_PROPERTY_FULLY_REFUNDABLE,
  SupplierContractItemPolicyAffiliate.JSON_PROPERTY_PARTIALLY_REFUNDABLE
})
@JsonTypeName("SupplierContractItemPolicy_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-07-31T09:09:41.857644722+07:00[Asia/Bangkok]")
public class SupplierContractItemPolicyAffiliate {
  public static final String JSON_PROPERTY_REFUNDABLE = "refundable";
  private Boolean refundable;

  /**
   * When the cancellation policy is refundable, this flag can be set and indicates there is more rules involved than just a no-questions-asked refundable.
   */
  public enum AdvanceCancellationFreeOfChargeEnum {
    UNTIL_EIGHTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL("UNTIL_EIGHTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL"),
    
    UNTIL_FOURTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL("UNTIL_FOURTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL"),
    
    ONE_DAY_BEFORE_ARRIVAL("ONE_DAY_BEFORE_ARRIVAL"),
    
    TWO_DAYS_BEFORE_ARRIVAL("TWO_DAYS_BEFORE_ARRIVAL"),
    
    THREE_DAYS_BEFORE_ARRIVAL("THREE_DAYS_BEFORE_ARRIVAL"),
    
    FIVE_DAYS_BEFORE_ARRIVAL("FIVE_DAYS_BEFORE_ARRIVAL"),
    
    SEVEN_DAYS_BEFORE_ARRIVAL("SEVEN_DAYS_BEFORE_ARRIVAL"),
    
    FOURTEEN_DAYS_BEFORE_ARRIVAL("FOURTEEN_DAYS_BEFORE_ARRIVAL"),
    
    TWENTYONE_DAYS_BEFORE_ARRIVAL("TWENTYONE_DAYS_BEFORE_ARRIVAL"),
    
    THIRTY_DAYS_BEFORE_ARRIVAL("THIRTY_DAYS_BEFORE_ARRIVAL"),
    
    FOURTY_TWO_DAYS_BEFORE_ARRIVAL("FOURTY_TWO_DAYS_BEFORE_ARRIVAL"),
    
    SIXTY_DAYS_BEFORE_ARRIVAL("SIXTY_DAYS_BEFORE_ARRIVAL");

    private String value;

    AdvanceCancellationFreeOfChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AdvanceCancellationFreeOfChargeEnum fromValue(String value) {
      for (AdvanceCancellationFreeOfChargeEnum b : AdvanceCancellationFreeOfChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE = "advanceCancellationFreeOfCharge";
  private AdvanceCancellationFreeOfChargeEnum advanceCancellationFreeOfCharge;

  /**
   * If advanceCancellationFreeOfCharge rules is not honored, this property explains what the guest will be charged.
   */
  public enum RefundableCancellationChargeEnum {
    FIRST_NIGHT("FIRST_NIGHT"),
    
    THIRTY_PERCENT("THIRTY_PERCENT"),
    
    FIFTY_PERCENT("FIFTY_PERCENT"),
    
    SIXTY_PERCENT("SIXTY_PERCENT"),
    
    SEVENTY_PERCENT("SEVENTY_PERCENT"),
    
    NINENTY_PERCENT("NINENTY_PERCENT"),
    
    ONE_HUNDRED_PERCENT("ONE_HUNDRED_PERCENT");

    private String value;

    RefundableCancellationChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RefundableCancellationChargeEnum fromValue(String value) {
      for (RefundableCancellationChargeEnum b : RefundableCancellationChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE = "refundableCancellationCharge";
  private RefundableCancellationChargeEnum refundableCancellationCharge;

  /**
   * In case the &#39;Refundable cancellation charge&#39; is set, a different no show charge can be applied.
   */
  public enum NoShowChargeEnum {
    SAME_AS_CANCELLATION_FEE("SAME_AS_CANCELLATION_FEE"),
    
    ONE_HUNDRED_PERCENT_OF_TOTAL_CHARGE("ONE_HUNDRED_PERCENT_OF_TOTAL_CHARGE");

    private String value;

    NoShowChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NoShowChargeEnum fromValue(String value) {
      for (NoShowChargeEnum b : NoShowChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NO_SHOW_CHARGE = "noShowCharge";
  private NoShowChargeEnum noShowCharge;

  /**
   * When the cancellation policy is non-refundable, this flag can be set and indicates there is more rules involved to calculate what the guest will owe in case of a cancellation.
   */
  public enum NonRefundableCancellationChargeEnum {
    FIRST_NIGHT("FIRST_NIGHT"),
    
    TEN_PERCENT("TEN_PERCENT"),
    
    THIRTY_PERCENT("THIRTY_PERCENT"),
    
    FIFTY_PERCENT("FIFTY_PERCENT"),
    
    SEVENTY_PERCENT("SEVENTY_PERCENT");

    private String value;

    NonRefundableCancellationChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NonRefundableCancellationChargeEnum fromValue(String value) {
      for (NonRefundableCancellationChargeEnum b : NonRefundableCancellationChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE = "nonRefundableCancellationCharge";
  private NonRefundableCancellationChargeEnum nonRefundableCancellationCharge;

  /**
   * The non-refundable charge might can have a deadline. If that deadline passes, the guest might be charged more.
   */
  public enum NonRefundableDeadlineEnum {
    ONE_DAY_BEFORE_ARRIVAL("ONE_DAY_BEFORE_ARRIVAL"),
    
    TWO_DAYS_BEFORE_ARRIVAL("TWO_DAYS_BEFORE_ARRIVAL"),
    
    THREE_DAYS_BEFORE_ARRIVAL("THREE_DAYS_BEFORE_ARRIVAL"),
    
    FIVE_DAYS_BEFORE_ARRIVAL("FIVE_DAYS_BEFORE_ARRIVAL"),
    
    SEVEN_DAYS_BEFORE_ARRIVAL("SEVEN_DAYS_BEFORE_ARRIVAL"),
    
    FOURTEEN_DAYS_BEFORE_ARRIVAL("FOURTEEN_DAYS_BEFORE_ARRIVAL"),
    
    TWENTYONE_DAYS_BEFORE_ARRIVAL("TWENTYONE_DAYS_BEFORE_ARRIVAL"),
    
    THIRTY_DAYS_BEFORE_ARRIVAL("THIRTY_DAYS_BEFORE_ARRIVAL"),
    
    FOURTY_TWO_DAYS_BEFORE_ARRIVAL("FOURTY_TWO_DAYS_BEFORE_ARRIVAL"),
    
    SIXTY_DAYS_BEFORE_ARRIVAL("SIXTY_DAYS_BEFORE_ARRIVAL");

    private String value;

    NonRefundableDeadlineEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NonRefundableDeadlineEnum fromValue(String value) {
      for (NonRefundableDeadlineEnum b : NonRefundableDeadlineEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NON_REFUNDABLE_DEADLINE = "nonRefundableDeadline";
  private NonRefundableDeadlineEnum nonRefundableDeadline;

  /**
   * If the guest does not honor the non-refundable deadline rule, this charge dictates what she owes after the deadline passes.
   */
  public enum NonRefundableAfterDeadlineCancellationChargeEnum {
    FIRST_NIGHT("FIRST_NIGHT"),
    
    TEN_PERCENT("TEN_PERCENT"),
    
    THIRTY_PERCENT("THIRTY_PERCENT"),
    
    FIFTY_PERCENT("FIFTY_PERCENT"),
    
    SEVENTY_PERCENT("SEVENTY_PERCENT"),
    
    ONE_HUNDRED_PERCENT("ONE_HUNDRED_PERCENT");

    private String value;

    NonRefundableAfterDeadlineCancellationChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NonRefundableAfterDeadlineCancellationChargeEnum fromValue(String value) {
      for (NonRefundableAfterDeadlineCancellationChargeEnum b : NonRefundableAfterDeadlineCancellationChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE = "nonRefundableAfterDeadlineCancellationCharge";
  private NonRefundableAfterDeadlineCancellationChargeEnum nonRefundableAfterDeadlineCancellationCharge;

  public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
  private String externalIdentifier;

  public static final String JSON_PROPERTY_FULLY_REFUNDABLE = "fullyRefundable";
  private Boolean fullyRefundable;

  public static final String JSON_PROPERTY_PARTIALLY_REFUNDABLE = "partiallyRefundable";
  private Boolean partiallyRefundable;

  public SupplierContractItemPolicyAffiliate() {
  }

  public SupplierContractItemPolicyAffiliate refundable(Boolean refundable) {
    
    this.refundable = refundable;
    return this;
  }

   /**
   * Whether this booking is refundable or not.
   * @return refundable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REFUNDABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getRefundable() {
    return refundable;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRefundable(Boolean refundable) {
    this.refundable = refundable;
  }


  public SupplierContractItemPolicyAffiliate advanceCancellationFreeOfCharge(AdvanceCancellationFreeOfChargeEnum advanceCancellationFreeOfCharge) {
    
    this.advanceCancellationFreeOfCharge = advanceCancellationFreeOfCharge;
    return this;
  }

   /**
   * When the cancellation policy is refundable, this flag can be set and indicates there is more rules involved than just a no-questions-asked refundable.
   * @return advanceCancellationFreeOfCharge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdvanceCancellationFreeOfChargeEnum getAdvanceCancellationFreeOfCharge() {
    return advanceCancellationFreeOfCharge;
  }


  @JsonProperty(JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdvanceCancellationFreeOfCharge(AdvanceCancellationFreeOfChargeEnum advanceCancellationFreeOfCharge) {
    this.advanceCancellationFreeOfCharge = advanceCancellationFreeOfCharge;
  }


  public SupplierContractItemPolicyAffiliate refundableCancellationCharge(RefundableCancellationChargeEnum refundableCancellationCharge) {
    
    this.refundableCancellationCharge = refundableCancellationCharge;
    return this;
  }

   /**
   * If advanceCancellationFreeOfCharge rules is not honored, this property explains what the guest will be charged.
   * @return refundableCancellationCharge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RefundableCancellationChargeEnum getRefundableCancellationCharge() {
    return refundableCancellationCharge;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundableCancellationCharge(RefundableCancellationChargeEnum refundableCancellationCharge) {
    this.refundableCancellationCharge = refundableCancellationCharge;
  }


  public SupplierContractItemPolicyAffiliate noShowCharge(NoShowChargeEnum noShowCharge) {
    
    this.noShowCharge = noShowCharge;
    return this;
  }

   /**
   * In case the &#39;Refundable cancellation charge&#39; is set, a different no show charge can be applied.
   * @return noShowCharge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NO_SHOW_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NoShowChargeEnum getNoShowCharge() {
    return noShowCharge;
  }


  @JsonProperty(JSON_PROPERTY_NO_SHOW_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNoShowCharge(NoShowChargeEnum noShowCharge) {
    this.noShowCharge = noShowCharge;
  }


  public SupplierContractItemPolicyAffiliate nonRefundableCancellationCharge(NonRefundableCancellationChargeEnum nonRefundableCancellationCharge) {
    
    this.nonRefundableCancellationCharge = nonRefundableCancellationCharge;
    return this;
  }

   /**
   * When the cancellation policy is non-refundable, this flag can be set and indicates there is more rules involved to calculate what the guest will owe in case of a cancellation.
   * @return nonRefundableCancellationCharge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NonRefundableCancellationChargeEnum getNonRefundableCancellationCharge() {
    return nonRefundableCancellationCharge;
  }


  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonRefundableCancellationCharge(NonRefundableCancellationChargeEnum nonRefundableCancellationCharge) {
    this.nonRefundableCancellationCharge = nonRefundableCancellationCharge;
  }


  public SupplierContractItemPolicyAffiliate nonRefundableDeadline(NonRefundableDeadlineEnum nonRefundableDeadline) {
    
    this.nonRefundableDeadline = nonRefundableDeadline;
    return this;
  }

   /**
   * The non-refundable charge might can have a deadline. If that deadline passes, the guest might be charged more.
   * @return nonRefundableDeadline
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NonRefundableDeadlineEnum getNonRefundableDeadline() {
    return nonRefundableDeadline;
  }


  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonRefundableDeadline(NonRefundableDeadlineEnum nonRefundableDeadline) {
    this.nonRefundableDeadline = nonRefundableDeadline;
  }


  public SupplierContractItemPolicyAffiliate nonRefundableAfterDeadlineCancellationCharge(NonRefundableAfterDeadlineCancellationChargeEnum nonRefundableAfterDeadlineCancellationCharge) {
    
    this.nonRefundableAfterDeadlineCancellationCharge = nonRefundableAfterDeadlineCancellationCharge;
    return this;
  }

   /**
   * If the guest does not honor the non-refundable deadline rule, this charge dictates what she owes after the deadline passes.
   * @return nonRefundableAfterDeadlineCancellationCharge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NonRefundableAfterDeadlineCancellationChargeEnum getNonRefundableAfterDeadlineCancellationCharge() {
    return nonRefundableAfterDeadlineCancellationCharge;
  }


  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonRefundableAfterDeadlineCancellationCharge(NonRefundableAfterDeadlineCancellationChargeEnum nonRefundableAfterDeadlineCancellationCharge) {
    this.nonRefundableAfterDeadlineCancellationCharge = nonRefundableAfterDeadlineCancellationCharge;
  }


  public SupplierContractItemPolicyAffiliate externalIdentifier(String externalIdentifier) {
    
    this.externalIdentifier = externalIdentifier;
    return this;
  }

   /**
   * Optional geoname externalIdentifier to remote policy.
   * @return externalIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalIdentifier() {
    return externalIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalIdentifier(String externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
  }


  public SupplierContractItemPolicyAffiliate fullyRefundable(Boolean fullyRefundable) {
    
    this.fullyRefundable = fullyRefundable;
    return this;
  }

   /**
   * Get fullyRefundable
   * @return fullyRefundable
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FULLY_REFUNDABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFullyRefundable() {
    return fullyRefundable;
  }


  @JsonProperty(JSON_PROPERTY_FULLY_REFUNDABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullyRefundable(Boolean fullyRefundable) {
    this.fullyRefundable = fullyRefundable;
  }


  public SupplierContractItemPolicyAffiliate partiallyRefundable(Boolean partiallyRefundable) {
    
    this.partiallyRefundable = partiallyRefundable;
    return this;
  }

   /**
   * Get partiallyRefundable
   * @return partiallyRefundable
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PARTIALLY_REFUNDABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPartiallyRefundable() {
    return partiallyRefundable;
  }


  @JsonProperty(JSON_PROPERTY_PARTIALLY_REFUNDABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartiallyRefundable(Boolean partiallyRefundable) {
    this.partiallyRefundable = partiallyRefundable;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SupplierContractItemPolicyAffiliate supplierContractItemPolicyAffiliate = (SupplierContractItemPolicyAffiliate) o;
    return Objects.equals(this.refundable, supplierContractItemPolicyAffiliate.refundable) &&
        Objects.equals(this.advanceCancellationFreeOfCharge, supplierContractItemPolicyAffiliate.advanceCancellationFreeOfCharge) &&
        Objects.equals(this.refundableCancellationCharge, supplierContractItemPolicyAffiliate.refundableCancellationCharge) &&
        Objects.equals(this.noShowCharge, supplierContractItemPolicyAffiliate.noShowCharge) &&
        Objects.equals(this.nonRefundableCancellationCharge, supplierContractItemPolicyAffiliate.nonRefundableCancellationCharge) &&
        Objects.equals(this.nonRefundableDeadline, supplierContractItemPolicyAffiliate.nonRefundableDeadline) &&
        Objects.equals(this.nonRefundableAfterDeadlineCancellationCharge, supplierContractItemPolicyAffiliate.nonRefundableAfterDeadlineCancellationCharge) &&
        Objects.equals(this.externalIdentifier, supplierContractItemPolicyAffiliate.externalIdentifier) &&
        Objects.equals(this.fullyRefundable, supplierContractItemPolicyAffiliate.fullyRefundable) &&
        Objects.equals(this.partiallyRefundable, supplierContractItemPolicyAffiliate.partiallyRefundable);
  }

  @Override
  public int hashCode() {
    return Objects.hash(refundable, advanceCancellationFreeOfCharge, refundableCancellationCharge, noShowCharge, nonRefundableCancellationCharge, nonRefundableDeadline, nonRefundableAfterDeadlineCancellationCharge, externalIdentifier, fullyRefundable, partiallyRefundable);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SupplierContractItemPolicyAffiliate {\n");
    sb.append("    refundable: ").append(toIndentedString(refundable)).append("\n");
    sb.append("    advanceCancellationFreeOfCharge: ").append(toIndentedString(advanceCancellationFreeOfCharge)).append("\n");
    sb.append("    refundableCancellationCharge: ").append(toIndentedString(refundableCancellationCharge)).append("\n");
    sb.append("    noShowCharge: ").append(toIndentedString(noShowCharge)).append("\n");
    sb.append("    nonRefundableCancellationCharge: ").append(toIndentedString(nonRefundableCancellationCharge)).append("\n");
    sb.append("    nonRefundableDeadline: ").append(toIndentedString(nonRefundableDeadline)).append("\n");
    sb.append("    nonRefundableAfterDeadlineCancellationCharge: ").append(toIndentedString(nonRefundableAfterDeadlineCancellationCharge)).append("\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("    fullyRefundable: ").append(toIndentedString(fullyRefundable)).append("\n");
    sb.append("    partiallyRefundable: ").append(toIndentedString(partiallyRefundable)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

