package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.CountryAffiliate;
import travel.wink.sdk.affiliate.model.DynamicSellerListRequestAffiliate;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.GeoNameAffiliate;
import travel.wink.sdk.affiliate.model.InventorySupplierAffiliate;
import travel.wink.sdk.affiliate.model.InventoryViewAffiliate;
import travel.wink.sdk.affiliate.model.PageInventorySupplierAffiliate;
import travel.wink.sdk.affiliate.model.PageInventoryViewAffiliate;
import travel.wink.sdk.affiliate.model.ShowSupplierUrl400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-09-09T12:27:05.024580956+07:00[Asia/Bangkok]")
public class DiscoverApi {
    private ApiClient apiClient;

    public DiscoverApi() {
        this(new ApiClient());
    }

    @Autowired
    public DiscoverApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Inventory Supplier Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List cities for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;GeoNameAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCitiesForInventoryRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCitiesForInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/supplier/city/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory Supplier Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List cities for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;GeoNameAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<GeoNameAffiliate> showCitiesForInventory(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>() {};
        return showCitiesForInventoryRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Inventory Supplier Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List cities for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;GeoNameAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<GeoNameAffiliate>>> showCitiesForInventoryWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>() {};
        return showCitiesForInventoryRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Inventory Supplier Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List cities for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCitiesForInventoryWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showCitiesForInventoryRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Show Inventory Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List cities for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;GeoNameAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCitiesForInventory1RequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCitiesForInventory1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/city/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List cities for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;GeoNameAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<GeoNameAffiliate> showCitiesForInventory1(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>() {};
        return showCitiesForInventory1RequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Inventory Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List cities for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;GeoNameAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<GeoNameAffiliate>>> showCitiesForInventory1WithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>() {};
        return showCitiesForInventory1RequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Inventory Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List cities for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCitiesForInventory1WithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showCitiesForInventory1RequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Show Inventory Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List countries for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;CountryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCountriesForInventoryRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCountriesForInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/country/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List countries for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;CountryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<CountryAffiliate> showCountriesForInventory(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>() {};
        return showCountriesForInventoryRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Inventory Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List countries for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;CountryAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<CountryAffiliate>>> showCountriesForInventoryWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>() {};
        return showCountriesForInventoryRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Inventory Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List countries for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCountriesForInventoryWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showCountriesForInventoryRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Show Inventory Supplier Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List countries for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;CountryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCountriesForInventorySupplierRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCountriesForInventorySupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/supplier/country/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory Supplier Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List countries for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;CountryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<CountryAffiliate> showCountriesForInventorySupplier(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>() {};
        return showCountriesForInventorySupplierRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Inventory Supplier Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List countries for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;CountryAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<CountryAffiliate>>> showCountriesForInventorySupplierWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>() {};
        return showCountriesForInventorySupplierRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Inventory Supplier Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List countries for inventory on behalf of this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCountriesForInventorySupplierWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showCountriesForInventorySupplierRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Inventory Search
     * Retrieves a paginated result set of inventory based on the search criteria of the caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory on behalf of this owner identifier.
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return PageInventoryViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showDynamicSellerInventoryRequestCreation(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = dynamicSellerListRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'dynamicSellerListRequestAffiliate' is set
        if (dynamicSellerListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicSellerListRequestAffiliate' when calling showDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Inventory Search
     * Retrieves a paginated result set of inventory based on the search criteria of the caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory on behalf of this owner identifier.
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return PageInventoryViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageInventoryViewAffiliate> showDynamicSellerInventory(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>() {};
        return showDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Inventory Search
     * Retrieves a paginated result set of inventory based on the search criteria of the caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory on behalf of this owner identifier.
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageInventoryViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageInventoryViewAffiliate>> showDynamicSellerInventoryWithHttpInfo(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>() {};
        return showDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Inventory Search
     * Retrieves a paginated result set of inventory based on the search criteria of the caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory on behalf of this owner identifier.
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showDynamicSellerInventoryWithResponseSpec(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return showDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequestAffiliate, winkVersion);
    }
    /**
     * Inventory Search by List
     * Retrieves a paginated result set based on the given list identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier on behalf of this owner identifier.
     * @param dynamicListIdentifier Browse inventory supplier on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return PageInventorySupplierAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showDynamicSellerInventoryByIdRequestCreation(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showDynamicSellerInventoryById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'dynamicListIdentifier' is set
        if (dynamicListIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicListIdentifier' when calling showDynamicSellerInventoryById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("dynamicListIdentifier", dynamicListIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/supplier/grid/{dynamicListIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Inventory Search by List
     * Retrieves a paginated result set based on the given list identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier on behalf of this owner identifier.
     * @param dynamicListIdentifier Browse inventory supplier on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return PageInventorySupplierAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageInventorySupplierAffiliate> showDynamicSellerInventoryById(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>() {};
        return showDynamicSellerInventoryByIdRequestCreation(companyIdentifier, dynamicListIdentifier, page, size, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Inventory Search by List
     * Retrieves a paginated result set based on the given list identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier on behalf of this owner identifier.
     * @param dynamicListIdentifier Browse inventory supplier on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageInventorySupplierAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageInventorySupplierAffiliate>> showDynamicSellerInventoryByIdWithHttpInfo(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>() {};
        return showDynamicSellerInventoryByIdRequestCreation(companyIdentifier, dynamicListIdentifier, page, size, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Inventory Search by List
     * Retrieves a paginated result set based on the given list identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier on behalf of this owner identifier.
     * @param dynamicListIdentifier Browse inventory supplier on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showDynamicSellerInventoryByIdWithResponseSpec(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        return showDynamicSellerInventoryByIdRequestCreation(companyIdentifier, dynamicListIdentifier, page, size, winkVersion);
    }
    /**
     * Inventory Search by List
     * Retrieves a paginated result set based on the given list identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory on behalf of this owner identifier.
     * @param dynamicListIdentifier Browse inventory on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return PageInventoryViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showDynamicSellerInventoryById1RequestCreation(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showDynamicSellerInventoryById1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'dynamicListIdentifier' is set
        if (dynamicListIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicListIdentifier' when calling showDynamicSellerInventoryById1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("dynamicListIdentifier", dynamicListIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/grid/{dynamicListIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Inventory Search by List
     * Retrieves a paginated result set based on the given list identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory on behalf of this owner identifier.
     * @param dynamicListIdentifier Browse inventory on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return PageInventoryViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageInventoryViewAffiliate> showDynamicSellerInventoryById1(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>() {};
        return showDynamicSellerInventoryById1RequestCreation(companyIdentifier, dynamicListIdentifier, page, size, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Inventory Search by List
     * Retrieves a paginated result set based on the given list identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory on behalf of this owner identifier.
     * @param dynamicListIdentifier Browse inventory on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageInventoryViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageInventoryViewAffiliate>> showDynamicSellerInventoryById1WithHttpInfo(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>() {};
        return showDynamicSellerInventoryById1RequestCreation(companyIdentifier, dynamicListIdentifier, page, size, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Inventory Search by List
     * Retrieves a paginated result set based on the given list identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory on behalf of this owner identifier.
     * @param dynamicListIdentifier Browse inventory on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showDynamicSellerInventoryById1WithResponseSpec(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        return showDynamicSellerInventoryById1RequestCreation(companyIdentifier, dynamicListIdentifier, page, size, winkVersion);
    }
    /**
     * Show Inventory Supplier
     * Retrieves a list of latest available inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier on behalf of this owner identifier.
     * @param supplierIdentifier Browse inventory supplier on behalf of this supplier identifier.
     * @param salesChannelIdentifier Browse inventory supplier on behalf of this sales channel identifier.
     * @param winkVersion The winkVersion parameter
     * @return InventorySupplierAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showInventorySupplierRequestCreation(String companyIdentifier, String supplierIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showInventorySupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'supplierIdentifier' is set
        if (supplierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierIdentifier' when calling showInventorySupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'salesChannelIdentifier' is set
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling showInventorySupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("supplierIdentifier", supplierIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/supplier/{supplierIdentifier}/sales-channel/{salesChannelIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory Supplier
     * Retrieves a list of latest available inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier on behalf of this owner identifier.
     * @param supplierIdentifier Browse inventory supplier on behalf of this supplier identifier.
     * @param salesChannelIdentifier Browse inventory supplier on behalf of this sales channel identifier.
     * @param winkVersion The winkVersion parameter
     * @return InventorySupplierAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventorySupplierAffiliate> showInventorySupplier(String companyIdentifier, String supplierIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>() {};
        return showInventorySupplierRequestCreation(companyIdentifier, supplierIdentifier, salesChannelIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Inventory Supplier
     * Retrieves a list of latest available inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier on behalf of this owner identifier.
     * @param supplierIdentifier Browse inventory supplier on behalf of this supplier identifier.
     * @param salesChannelIdentifier Browse inventory supplier on behalf of this sales channel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;InventorySupplierAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<InventorySupplierAffiliate>> showInventorySupplierWithHttpInfo(String companyIdentifier, String supplierIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>() {};
        return showInventorySupplierRequestCreation(companyIdentifier, supplierIdentifier, salesChannelIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Inventory Supplier
     * Retrieves a list of latest available inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier on behalf of this owner identifier.
     * @param supplierIdentifier Browse inventory supplier on behalf of this supplier identifier.
     * @param salesChannelIdentifier Browse inventory supplier on behalf of this sales channel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showInventorySupplierWithResponseSpec(String companyIdentifier, String supplierIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        return showInventorySupplierRequestCreation(companyIdentifier, supplierIdentifier, salesChannelIdentifier, winkVersion);
    }
    /**
     * Latest Inventory
     * Retrieves a list of latest available inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory on behalf of this owner identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;InventoryViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLatestInventoryRequestCreation(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showLatestInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Latest Inventory
     * Retrieves a list of latest available inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory on behalf of this owner identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;InventoryViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<InventoryViewAffiliate> showLatestInventory(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryViewAffiliate>() {};
        return showLatestInventoryRequestCreation(companyIdentifier, page, size, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Latest Inventory
     * Retrieves a list of latest available inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory on behalf of this owner identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;InventoryViewAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<InventoryViewAffiliate>>> showLatestInventoryWithHttpInfo(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryViewAffiliate>() {};
        return showLatestInventoryRequestCreation(companyIdentifier, page, size, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Latest Inventory
     * Retrieves a list of latest available inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory on behalf of this owner identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showLatestInventoryWithResponseSpec(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        return showLatestInventoryRequestCreation(companyIdentifier, page, size, winkVersion);
    }
    /**
     * Latest Inventory Suppliers
     * Retrieves a list of latest available inventory suppliers.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier on behalf of this owner identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;InventorySupplierAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLatestInventorySupplierListRequestCreation(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showLatestInventorySupplierList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/supplier/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Latest Inventory Suppliers
     * Retrieves a list of latest available inventory suppliers.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier on behalf of this owner identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;InventorySupplierAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<InventorySupplierAffiliate> showLatestInventorySupplierList(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>() {};
        return showLatestInventorySupplierListRequestCreation(companyIdentifier, page, size, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Latest Inventory Suppliers
     * Retrieves a list of latest available inventory suppliers.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier on behalf of this owner identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;InventorySupplierAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<InventorySupplierAffiliate>>> showLatestInventorySupplierListWithHttpInfo(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>() {};
        return showLatestInventorySupplierListRequestCreation(companyIdentifier, page, size, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Latest Inventory Suppliers
     * Retrieves a list of latest available inventory suppliers.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier on behalf of this owner identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showLatestInventorySupplierListWithResponseSpec(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        return showLatestInventorySupplierListRequestCreation(companyIdentifier, page, size, winkVersion);
    }
    /**
     * Inventory Supplier Search
     * Retrieves a paginated result set of suppliers of inventory based on the search criteria of the caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier suppliers on behalf of this owner identifier.
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return PageInventorySupplierAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSuppliersForDynamicSellerInventoryRequestCreation(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = dynamicSellerListRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSuppliersForDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'dynamicSellerListRequestAffiliate' is set
        if (dynamicSellerListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicSellerListRequestAffiliate' when calling showSuppliersForDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/supplier/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Inventory Supplier Search
     * Retrieves a paginated result set of suppliers of inventory based on the search criteria of the caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier suppliers on behalf of this owner identifier.
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return PageInventorySupplierAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageInventorySupplierAffiliate> showSuppliersForDynamicSellerInventory(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>() {};
        return showSuppliersForDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Inventory Supplier Search
     * Retrieves a paginated result set of suppliers of inventory based on the search criteria of the caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier suppliers on behalf of this owner identifier.
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageInventorySupplierAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageInventorySupplierAffiliate>> showSuppliersForDynamicSellerInventoryWithHttpInfo(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>() {};
        return showSuppliersForDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Inventory Supplier Search
     * Retrieves a paginated result set of suppliers of inventory based on the search criteria of the caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory supplier suppliers on behalf of this owner identifier.
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSuppliersForDynamicSellerInventoryWithResponseSpec(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return showSuppliersForDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequestAffiliate, winkVersion);
    }
}
