/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.10.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.AddressAffiliate;
import travel.wink.sdk.affiliate.model.GeoJsonPointAffiliate;
import travel.wink.sdk.affiliate.model.HotelOnMapAffiliate;
import travel.wink.sdk.affiliate.model.SalesChannelAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Channel inventory
 */
@JsonPropertyOrder({
  InventoryAffiliate.JSON_PROPERTY_IDENTIFIER,
  InventoryAffiliate.JSON_PROPERTY_SALES_CHANNEL,
  InventoryAffiliate.JSON_PROPERTY_INVENTORY_TYPE,
  InventoryAffiliate.JSON_PROPERTY_INVENTORY_IDENTIFIER,
  InventoryAffiliate.JSON_PROPERTY_INVENTORY_NAME,
  InventoryAffiliate.JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH,
  InventoryAffiliate.JSON_PROPERTY_ENABLED,
  InventoryAffiliate.JSON_PROPERTY_IMAGE_IDENTIFIER,
  InventoryAffiliate.JSON_PROPERTY_PRICE_POINT,
  InventoryAffiliate.JSON_PROPERTY_LOCATION,
  InventoryAffiliate.JSON_PROPERTY_ADDRESS,
  InventoryAffiliate.JSON_PROPERTY_QUANTITY,
  InventoryAffiliate.JSON_PROPERTY_COMMISSIONABLE,
  InventoryAffiliate.JSON_PROPERTY_BOOKABLE,
  InventoryAffiliate.JSON_PROPERTY_HOTEL
})
@JsonTypeName("Inventory_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-09-09T12:27:05.024580956+07:00[Asia/Bangkok]")
public class InventoryAffiliate {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_SALES_CHANNEL = "salesChannel";
  private SalesChannelAffiliate salesChannel;

  /**
   * Inventory type
   */
  public enum InventoryTypeEnum {
    GUEST_ROOM("GUEST_ROOM"),
    
    ADD_ON("ADD_ON"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE"),
    
    ACTIVITY("ACTIVITY");

    private String value;

    InventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryTypeEnum fromValue(String value) {
      for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
  private InventoryTypeEnum inventoryType;

  public static final String JSON_PROPERTY_INVENTORY_IDENTIFIER = "inventoryIdentifier";
  private UUID inventoryIdentifier;

  public static final String JSON_PROPERTY_INVENTORY_NAME = "inventoryName";
  private String inventoryName;

  public static final String JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH = "inventoryNameInEnglish";
  private String inventoryNameInEnglish;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  /**
   * Level of expensiveness.
   */
  public enum PricePointEnum {
    HALF("HALF"),
    
    ONE("ONE"),
    
    ONE_HALF("ONE_HALF"),
    
    TWO("TWO"),
    
    TWO_HALF("TWO_HALF"),
    
    THREE("THREE"),
    
    THREE_HALF("THREE_HALF"),
    
    FOUR("FOUR"),
    
    FOUR_HALF("FOUR_HALF"),
    
    FIVE("FIVE");

    private String value;

    PricePointEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricePointEnum fromValue(String value) {
      for (PricePointEnum b : PricePointEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
  private PricePointEnum pricePoint = PricePointEnum.THREE;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointAffiliate location;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressAffiliate address;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity = 0;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable = false;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_HOTEL = "hotel";
  private HotelOnMapAffiliate hotel;

  public InventoryAffiliate() {
  }

  public InventoryAffiliate identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Inventory identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public InventoryAffiliate salesChannel(SalesChannelAffiliate salesChannel) {
    
    this.salesChannel = salesChannel;
    return this;
  }

   /**
   * Get salesChannel
   * @return salesChannel
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SalesChannelAffiliate getSalesChannel() {
    return salesChannel;
  }


  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSalesChannel(SalesChannelAffiliate salesChannel) {
    this.salesChannel = salesChannel;
  }


  public InventoryAffiliate inventoryType(InventoryTypeEnum inventoryType) {
    
    this.inventoryType = inventoryType;
    return this;
  }

   /**
   * Inventory type
   * @return inventoryType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InventoryTypeEnum getInventoryType() {
    return inventoryType;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryType(InventoryTypeEnum inventoryType) {
    this.inventoryType = inventoryType;
  }


  public InventoryAffiliate inventoryIdentifier(UUID inventoryIdentifier) {
    
    this.inventoryIdentifier = inventoryIdentifier;
    return this;
  }

   /**
   * Inventory type identifier
   * @return inventoryIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getInventoryIdentifier() {
    return inventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryIdentifier(UUID inventoryIdentifier) {
    this.inventoryIdentifier = inventoryIdentifier;
  }


  public InventoryAffiliate inventoryName(String inventoryName) {
    
    this.inventoryName = inventoryName;
    return this;
  }

   /**
   * Name of inventory as hotel is seeing it
   * @return inventoryName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInventoryName() {
    return inventoryName;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryName(String inventoryName) {
    this.inventoryName = inventoryName;
  }


  public InventoryAffiliate inventoryNameInEnglish(String inventoryNameInEnglish) {
    
    this.inventoryNameInEnglish = inventoryNameInEnglish;
    return this;
  }

   /**
   * Name of inventory as traveler is seeing it
   * @return inventoryNameInEnglish
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInventoryNameInEnglish() {
    return inventoryNameInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryNameInEnglish(String inventoryNameInEnglish) {
    this.inventoryNameInEnglish = inventoryNameInEnglish;
  }


  public InventoryAffiliate enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether this inventory is enabled or not
   * @return enabled
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public InventoryAffiliate imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Main image of inventory
   * @return imageIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public InventoryAffiliate pricePoint(PricePointEnum pricePoint) {
    
    this.pricePoint = pricePoint;
    return this;
  }

   /**
   * Level of expensiveness.
   * @return pricePoint
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricePointEnum getPricePoint() {
    return pricePoint;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricePoint(PricePointEnum pricePoint) {
    this.pricePoint = pricePoint;
  }


  public InventoryAffiliate location(GeoJsonPointAffiliate location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointAffiliate getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPointAffiliate location) {
    this.location = location;
  }


  public InventoryAffiliate address(AddressAffiliate address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AddressAffiliate getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(AddressAffiliate address) {
    this.address = address;
  }


  public InventoryAffiliate quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * quantity
   * @return quantity
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public InventoryAffiliate commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Whether this is commissionable or not
   * @return commissionable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public InventoryAffiliate bookable(Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

   /**
   * Whether inventory can be booked
   * @return bookable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookable(Boolean bookable) {
    this.bookable = bookable;
  }


  public InventoryAffiliate hotel(HotelOnMapAffiliate hotel) {
    
    this.hotel = hotel;
    return this;
  }

   /**
   * Get hotel
   * @return hotel
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public HotelOnMapAffiliate getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotel(HotelOnMapAffiliate hotel) {
    this.hotel = hotel;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InventoryAffiliate inventoryAffiliate = (InventoryAffiliate) o;
    return Objects.equals(this.identifier, inventoryAffiliate.identifier) &&
        Objects.equals(this.salesChannel, inventoryAffiliate.salesChannel) &&
        Objects.equals(this.inventoryType, inventoryAffiliate.inventoryType) &&
        Objects.equals(this.inventoryIdentifier, inventoryAffiliate.inventoryIdentifier) &&
        Objects.equals(this.inventoryName, inventoryAffiliate.inventoryName) &&
        Objects.equals(this.inventoryNameInEnglish, inventoryAffiliate.inventoryNameInEnglish) &&
        Objects.equals(this.enabled, inventoryAffiliate.enabled) &&
        Objects.equals(this.imageIdentifier, inventoryAffiliate.imageIdentifier) &&
        Objects.equals(this.pricePoint, inventoryAffiliate.pricePoint) &&
        Objects.equals(this.location, inventoryAffiliate.location) &&
        Objects.equals(this.address, inventoryAffiliate.address) &&
        Objects.equals(this.quantity, inventoryAffiliate.quantity) &&
        Objects.equals(this.commissionable, inventoryAffiliate.commissionable) &&
        Objects.equals(this.bookable, inventoryAffiliate.bookable) &&
        Objects.equals(this.hotel, inventoryAffiliate.hotel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, salesChannel, inventoryType, inventoryIdentifier, inventoryName, inventoryNameInEnglish, enabled, imageIdentifier, pricePoint, location, address, quantity, commissionable, bookable, hotel);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InventoryAffiliate {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    salesChannel: ").append(toIndentedString(salesChannel)).append("\n");
    sb.append("    inventoryType: ").append(toIndentedString(inventoryType)).append("\n");
    sb.append("    inventoryIdentifier: ").append(toIndentedString(inventoryIdentifier)).append("\n");
    sb.append("    inventoryName: ").append(toIndentedString(inventoryName)).append("\n");
    sb.append("    inventoryNameInEnglish: ").append(toIndentedString(inventoryNameInEnglish)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    pricePoint: ").append(toIndentedString(pricePoint)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

